/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class UnsafeAvailChecker {
    private static final String CLASS_NAME = "sun.misc.Unsafe";
    private static final Log LOG = LogFactory.getLog(UnsafeAvailChecker.class);
    private static boolean avail = false;
    private static boolean unaligned = false;

    public static boolean isAvailable() {
        return avail;
    }

    public static boolean unaligned() {
        return unaligned;
    }

    private UnsafeAvailChecker() {
    }

    static {
        avail = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    Class<?> clazz = Class.forName(UnsafeAvailChecker.CLASS_NAME);
                    Field f = clazz.getDeclaredField("theUnsafe");
                    f.setAccessible(true);
                    return f.get(null) != null;
                }
                catch (Throwable e) {
                    LOG.warn((Object)"sun.misc.Unsafe is not available/accessible", e);
                    return false;
                }
            }
        });
        if (avail) {
            String arch = System.getProperty("os.arch");
            if ("ppc64".equals(arch) || "ppc64le".equals(arch)) {
                unaligned = true;
            } else {
                try {
                    Class<?> clazz = Class.forName("java.nio.Bits");
                    Method m = clazz.getDeclaredMethod("unaligned", new Class[0]);
                    m.setAccessible(true);
                    unaligned = (Boolean)m.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    LOG.warn((Object)"java.nio.Bits#unaligned() check failed.Unsafe based read/write of primitive types won't be used", (Throwable)e);
                }
            }
        }
    }
}

