/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.org.apache.commons.cli.BasicParser;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLineParser;
import org.apache.hbase.thirdparty.org.apache.commons.cli.DefaultParser;
import org.apache.hbase.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.hbase.thirdparty.org.apache.commons.cli.MissingOptionException;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Option;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Options;
import org.apache.hbase.thirdparty.org.apache.commons.cli.ParseException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class AbstractHBaseTool
implements Tool,
Configurable {
    protected static final int EXIT_SUCCESS = 0;
    protected static final int EXIT_FAILURE = 1;
    public static final String SHORT_HELP_OPTION = "h";
    public static final String LONG_HELP_OPTION = "help";
    private static final Option HELP_OPTION = new Option("h", "help", false, "Prints help for this tool.");
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHBaseTool.class);
    protected final Options options = new Options();
    protected Configuration conf = null;
    protected String[] cmdLineArgs = null;
    private HashMap<Option, Integer> optionsOrder = new HashMap();
    private int optionsCount = 0;

    protected abstract void addOptions();

    protected abstract void processOptions(CommandLine var1);

    protected abstract int doWork() throws Exception;

    protected void processOldArgs(List<String> args) {
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public int run(String[] args) throws IOException {
        int ret;
        CommandLine cmd;
        this.cmdLineArgs = args;
        if (this.conf == null) {
            LOG.error("Tool configuration is not initialized");
            throw new NullPointerException("conf");
        }
        ArrayList<String> argsList = new ArrayList<String>(args.length);
        for (String arg : args) {
            argsList.add(arg);
        }
        this.processOldArgs(argsList);
        try {
            this.addOptions();
            if (this.isHelpCommand(args)) {
                this.printUsage();
                return 0;
            }
            String[] remainingArgs = new String[argsList.size()];
            argsList.toArray(remainingArgs);
            cmd = this.newParser().parse(this.options, remainingArgs);
        }
        catch (MissingOptionException e) {
            LOG.error(e.getMessage());
            LOG.error("Use -h or --help for usage instructions.");
            return 1;
        }
        catch (ParseException e) {
            LOG.error("Error when parsing command-line arguments", (Throwable)e);
            LOG.error("Use -h or --help for usage instructions.");
            return 1;
        }
        this.processOptions(cmd);
        try {
            ret = this.doWork();
        }
        catch (Exception e) {
            LOG.error("Error running command-line tool", (Throwable)e);
            return 1;
        }
        return ret;
    }

    protected CommandLineParser newParser() {
        return new DefaultParser();
    }

    private boolean isHelpCommand(String[] args) throws ParseException {
        Options helpOption = new Options().addOption(HELP_OPTION);
        CommandLine cl = new DefaultParser().parse(helpOption, args, true);
        return cl.getOptions().length != 0;
    }

    protected CommandLine parseArgs(String[] args) throws ParseException {
        this.options.addOption(SHORT_HELP_OPTION, LONG_HELP_OPTION, false, "Show usage");
        this.addOptions();
        BasicParser parser = new BasicParser();
        return parser.parse(this.options, args);
    }

    protected void printUsage() {
        this.printUsage("hbase " + this.getClass().getName() + " <options>", "Options:", "");
    }

    protected void printUsage(String usageStr, String usageHeader, String usageFooter) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(120);
        helpFormatter.setOptionComparator((Comparator)new OptionsOrderComparator());
        helpFormatter.printHelp(usageStr, usageHeader, this.options, usageFooter);
    }

    protected void addOption(Option option) {
        this.options.addOption(option);
        this.optionsOrder.put(option, this.optionsCount++);
    }

    protected void addRequiredOption(Option option) {
        option.setRequired(true);
        this.addOption(option);
    }

    protected void addRequiredOptWithArg(String opt, String description) {
        Option option = new Option(opt, true, description);
        option.setRequired(true);
        this.addOption(option);
    }

    protected void addRequiredOptWithArg(String shortOpt, String longOpt, String description) {
        Option option = new Option(shortOpt, longOpt, true, description);
        option.setRequired(true);
        this.addOption(option);
    }

    protected void addOptNoArg(String opt, String description) {
        this.addOption(new Option(opt, false, description));
    }

    protected void addOptNoArg(String shortOpt, String longOpt, String description) {
        this.addOption(new Option(shortOpt, longOpt, false, description));
    }

    protected void addOptWithArg(String opt, String description) {
        this.addOption(new Option(opt, true, description));
    }

    protected void addOptWithArg(String shortOpt, String longOpt, String description) {
        this.addOption(new Option(shortOpt, longOpt, true, description));
    }

    public int getOptionAsInt(CommandLine cmd, String opt, int defaultValue) {
        if (cmd.hasOption(opt)) {
            return Integer.parseInt(cmd.getOptionValue(opt));
        }
        return defaultValue;
    }

    public long getOptionAsLong(CommandLine cmd, String opt, int defaultValue) {
        if (cmd.hasOption(opt)) {
            return Long.parseLong(cmd.getOptionValue(opt));
        }
        return defaultValue;
    }

    public double getOptionAsDouble(CommandLine cmd, String opt, double defaultValue) {
        if (cmd.hasOption(opt)) {
            return Double.parseDouble(cmd.getOptionValue(opt));
        }
        return defaultValue;
    }

    public static long parseLong(String s, long minValue, long maxValue) {
        long l = Long.parseLong(s);
        if (l < minValue || l > maxValue) {
            throw new IllegalArgumentException("The value " + l + " is out of range [" + minValue + ", " + maxValue + "]");
        }
        return l;
    }

    public static int parseInt(String s, int minValue, int maxValue) {
        return (int)AbstractHBaseTool.parseLong(s, minValue, maxValue);
    }

    protected void doStaticMain(String[] args) {
        int ret;
        try {
            ret = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)this, (String[])args);
        }
        catch (Exception ex) {
            LOG.error("Error running command-line tool", (Throwable)ex);
            ret = 1;
        }
        System.exit(ret);
    }

    private class OptionsOrderComparator
    implements Comparator<Option> {
        private OptionsOrderComparator() {
        }

        @Override
        public int compare(Option o1, Option o2) {
            return (Integer)AbstractHBaseTool.this.optionsOrder.get(o1) - (Integer)AbstractHBaseTool.this.optionsOrder.get(o2);
        }
    }
}

