/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.InnerStoreCellComparator;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.encoding.IndexBlockEncoding;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class HFileContext
implements HeapSize,
Cloneable {
    public static final long FIXED_OVERHEAD = ClassSize.estimateBase(HFileContext.class, false);
    private static final int DEFAULT_BYTES_PER_CHECKSUM = 16384;
    private boolean usesHBaseChecksum = true;
    private boolean includesMvcc = true;
    private boolean includesTags;
    private Compression.Algorithm compressAlgo = Compression.Algorithm.NONE;
    private boolean compressTags;
    private ChecksumType checksumType = ChecksumType.getDefaultChecksumType();
    private int bytesPerChecksum = 16384;
    private int blockSize = 65536;
    private DataBlockEncoding encoding = DataBlockEncoding.NONE;
    private IndexBlockEncoding indexBlockEncoding = IndexBlockEncoding.NONE;
    private Encryption.Context cryptoContext = Encryption.Context.NONE;
    private long fileCreateTime;
    private String hfileName;
    private byte[] columnFamily;
    private byte[] tableName;
    private CellComparator cellComparator;

    public HFileContext() {
    }

    public HFileContext(HFileContext context) {
        this.usesHBaseChecksum = context.usesHBaseChecksum;
        this.includesMvcc = context.includesMvcc;
        this.includesTags = context.includesTags;
        this.compressAlgo = context.compressAlgo;
        this.compressTags = context.compressTags;
        this.checksumType = context.checksumType;
        this.bytesPerChecksum = context.bytesPerChecksum;
        this.blockSize = context.blockSize;
        this.encoding = context.encoding;
        this.cryptoContext = context.cryptoContext;
        this.fileCreateTime = context.fileCreateTime;
        this.hfileName = context.hfileName;
        this.columnFamily = context.columnFamily;
        this.tableName = context.tableName;
        this.cellComparator = context.cellComparator;
        this.indexBlockEncoding = context.indexBlockEncoding;
    }

    HFileContext(boolean useHBaseChecksum, boolean includesMvcc, boolean includesTags, Compression.Algorithm compressAlgo, boolean compressTags, ChecksumType checksumType, int bytesPerChecksum, int blockSize, DataBlockEncoding encoding, Encryption.Context cryptoContext, long fileCreateTime, String hfileName, byte[] columnFamily, byte[] tableName, CellComparator cellComparator, IndexBlockEncoding indexBlockEncoding) {
        this.usesHBaseChecksum = useHBaseChecksum;
        this.includesMvcc = includesMvcc;
        this.includesTags = includesTags;
        this.compressAlgo = compressAlgo;
        this.compressTags = compressTags;
        this.checksumType = checksumType;
        this.bytesPerChecksum = bytesPerChecksum;
        this.blockSize = blockSize;
        if (encoding != null) {
            this.encoding = encoding;
        }
        if (indexBlockEncoding != null) {
            this.indexBlockEncoding = indexBlockEncoding;
        }
        this.cryptoContext = cryptoContext;
        this.fileCreateTime = fileCreateTime;
        this.hfileName = hfileName;
        this.columnFamily = columnFamily;
        this.tableName = tableName;
        this.cellComparator = cellComparator != null ? cellComparator : (this.tableName != null ? InnerStoreCellComparator.getInnerStoreCellComparator(this.tableName) : InnerStoreCellComparator.INNER_STORE_COMPARATOR);
    }

    public boolean isCompressedOrEncrypted() {
        Compression.Algorithm compressAlgo = this.getCompression();
        boolean compressed = compressAlgo != null && compressAlgo != Compression.Algorithm.NONE;
        Encryption.Context cryptoContext = this.getEncryptionContext();
        boolean encrypted = cryptoContext != null && cryptoContext != Encryption.Context.NONE;
        return compressed || encrypted;
    }

    public Compression.Algorithm getCompression() {
        return this.compressAlgo;
    }

    public boolean isUseHBaseChecksum() {
        return this.usesHBaseChecksum;
    }

    public boolean isIncludesMvcc() {
        return this.includesMvcc;
    }

    public void setIncludesMvcc(boolean includesMvcc) {
        this.includesMvcc = includesMvcc;
    }

    public boolean isIncludesTags() {
        return this.includesTags;
    }

    public void setIncludesTags(boolean includesTags) {
        this.includesTags = includesTags;
    }

    public void setFileCreateTime(long fileCreateTime) {
        this.fileCreateTime = fileCreateTime;
    }

    public boolean isCompressTags() {
        return this.compressTags;
    }

    public void setCompressTags(boolean compressTags) {
        this.compressTags = compressTags;
    }

    public ChecksumType getChecksumType() {
        return this.checksumType;
    }

    public int getBytesPerChecksum() {
        return this.bytesPerChecksum;
    }

    public int getBlocksize() {
        return this.blockSize;
    }

    public long getFileCreateTime() {
        return this.fileCreateTime;
    }

    public DataBlockEncoding getDataBlockEncoding() {
        return this.encoding;
    }

    public IndexBlockEncoding getIndexBlockEncoding() {
        return this.indexBlockEncoding;
    }

    public Encryption.Context getEncryptionContext() {
        return this.cryptoContext;
    }

    public void setEncryptionContext(Encryption.Context cryptoContext) {
        this.cryptoContext = cryptoContext;
    }

    public String getHFileName() {
        return this.hfileName;
    }

    public byte[] getColumnFamily() {
        return this.columnFamily;
    }

    public byte[] getTableName() {
        return this.tableName;
    }

    public CellComparator getCellComparator() {
        return this.cellComparator;
    }

    @Override
    public long heapSize() {
        long size = FIXED_OVERHEAD;
        if (this.hfileName != null) {
            size += (long)(ClassSize.STRING + this.hfileName.length());
        }
        if (this.columnFamily != null) {
            size += ClassSize.sizeOfByteArray(this.columnFamily.length);
        }
        if (this.tableName != null) {
            size += ClassSize.sizeOfByteArray(this.tableName.length);
        }
        return size;
    }

    public HFileContext clone() {
        try {
            return (HFileContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append("usesHBaseChecksum=");
        sb.append(this.usesHBaseChecksum);
        sb.append(", checksumType=");
        sb.append((Object)this.checksumType);
        sb.append(", bytesPerChecksum=");
        sb.append(this.bytesPerChecksum);
        sb.append(", blocksize=");
        sb.append(this.blockSize);
        sb.append(", encoding=");
        sb.append((Object)this.encoding);
        sb.append(", indexBlockEncoding=");
        sb.append((Object)this.indexBlockEncoding);
        sb.append(", includesMvcc=");
        sb.append(this.includesMvcc);
        sb.append(", includesTags=");
        sb.append(this.includesTags);
        sb.append(", compressAlgo=");
        sb.append((Object)this.compressAlgo);
        sb.append(", compressTags=");
        sb.append(this.compressTags);
        sb.append(", cryptoContext=[");
        sb.append(this.cryptoContext);
        sb.append("]");
        if (this.hfileName != null) {
            sb.append(", name=");
            sb.append(this.hfileName);
        }
        if (this.tableName != null) {
            sb.append(", tableName=");
            sb.append(Bytes.toStringBinary(this.tableName));
        }
        if (this.columnFamily != null) {
            sb.append(", columnFamily=");
            sb.append(Bytes.toStringBinary(this.columnFamily));
        }
        sb.append(", cellComparator=");
        sb.append(this.cellComparator);
        sb.append("]");
        return sb.toString();
    }
}

