/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.ByteBufferCell;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ExtendedCell;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MapReduceCell
extends ByteBufferCell
implements ExtendedCell {
    private final Cell cell;

    public MapReduceCell(Cell cell) {
        this.cell = cell;
    }

    public byte[] getRowArray() {
        return this.cell.getRowArray();
    }

    public int getRowOffset() {
        return this.cell.getRowOffset();
    }

    public short getRowLength() {
        return this.cell.getRowLength();
    }

    public byte[] getFamilyArray() {
        return this.cell.getFamilyArray();
    }

    public int getFamilyOffset() {
        return this.cell.getFamilyOffset();
    }

    public byte getFamilyLength() {
        return this.cell.getFamilyLength();
    }

    public byte[] getQualifierArray() {
        return this.cell.getQualifierArray();
    }

    public int getQualifierOffset() {
        return this.cell.getQualifierOffset();
    }

    public int getQualifierLength() {
        return this.cell.getQualifierLength();
    }

    public long getTimestamp() {
        return this.cell.getTimestamp();
    }

    public byte getTypeByte() {
        return this.cell.getTypeByte();
    }

    public long getSequenceId() {
        return this.cell.getSequenceId();
    }

    public byte[] getValueArray() {
        return this.cell.getValueArray();
    }

    public int getValueOffset() {
        return this.cell.getValueOffset();
    }

    public int getValueLength() {
        return this.cell.getValueLength();
    }

    public byte[] getTagsArray() {
        return this.cell.getTagsArray();
    }

    public int getTagsOffset() {
        return this.cell.getTagsOffset();
    }

    public int getTagsLength() {
        return this.cell.getTagsLength();
    }

    public ByteBuffer getRowByteBuffer() {
        if (this.cell instanceof ByteBufferCell) {
            return ((ByteBufferCell)this.cell).getRowByteBuffer();
        }
        return ByteBuffer.wrap(CellUtil.cloneRow((Cell)this.cell));
    }

    public int getRowPosition() {
        if (this.cell instanceof ByteBufferCell) {
            return ((ByteBufferCell)this.cell).getRowPosition();
        }
        return 0;
    }

    public ByteBuffer getFamilyByteBuffer() {
        if (this.cell instanceof ByteBufferCell) {
            return ((ByteBufferCell)this.cell).getFamilyByteBuffer();
        }
        return ByteBuffer.wrap(CellUtil.cloneFamily((Cell)this.cell));
    }

    public int getFamilyPosition() {
        if (this.cell instanceof ByteBufferCell) {
            return ((ByteBufferCell)this.cell).getFamilyPosition();
        }
        return 0;
    }

    public ByteBuffer getQualifierByteBuffer() {
        if (this.cell instanceof ByteBufferCell) {
            return ((ByteBufferCell)this.cell).getQualifierByteBuffer();
        }
        return ByteBuffer.wrap(CellUtil.cloneQualifier((Cell)this.cell));
    }

    public int getQualifierPosition() {
        if (this.cell instanceof ByteBufferCell) {
            return ((ByteBufferCell)this.cell).getQualifierPosition();
        }
        return 0;
    }

    public ByteBuffer getValueByteBuffer() {
        if (this.cell instanceof ByteBufferCell) {
            return ((ByteBufferCell)this.cell).getValueByteBuffer();
        }
        return ByteBuffer.wrap(CellUtil.cloneValue((Cell)this.cell));
    }

    public int getValuePosition() {
        if (this.cell instanceof ByteBufferCell) {
            return ((ByteBufferCell)this.cell).getValuePosition();
        }
        return 0;
    }

    public ByteBuffer getTagsByteBuffer() {
        if (this.cell instanceof ByteBufferCell) {
            return ((ByteBufferCell)this.cell).getTagsByteBuffer();
        }
        return ByteBuffer.wrap(CellUtil.cloneTags((Cell)this.cell));
    }

    public int getTagsPosition() {
        if (this.cell instanceof ByteBufferCell) {
            return ((ByteBufferCell)this.cell).getTagsPosition();
        }
        return 0;
    }

    public String toString() {
        return this.cell.toString();
    }

    public void setSequenceId(long seqId) throws IOException {
        PrivateCellUtil.setSequenceId((Cell)this.cell, (long)seqId);
    }

    public void setTimestamp(long ts) throws IOException {
        PrivateCellUtil.setTimestamp((Cell)this.cell, (long)ts);
    }

    public void setTimestamp(byte[] ts, int tsOffset) throws IOException {
        PrivateCellUtil.setTimestamp((Cell)this.cell, (byte[])ts, (int)tsOffset);
    }

    public long heapSize() {
        return PrivateCellUtil.estimatedHeapSizeOf((Cell)this.cell);
    }

    public int write(OutputStream out, boolean withTags) throws IOException {
        return PrivateCellUtil.writeCell((Cell)this.cell, (OutputStream)out, (boolean)withTags);
    }

    public int getSerializedSize(boolean withTags) {
        return PrivateCellUtil.estimatedSerializedSizeOf((Cell)this.cell) - 4;
    }

    public void write(ByteBuffer buf, int offset) {
        PrivateCellUtil.writeCellToBuffer((Cell)this.cell, (ByteBuffer)buf, (int)offset);
    }

    public ExtendedCell deepClone() {
        try {
            return (ExtendedCell)PrivateCellUtil.deepClone((Cell)this.cell);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

