/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.AbstractHFileWriter;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CorruptHFileException;
import org.apache.hadoop.hbase.io.hfile.FixedFileTrailer;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileBlockIndex;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFilePrettyPrinter;
import org.apache.hadoop.hbase.io.hfile.HFileReaderV2;
import org.apache.hadoop.hbase.io.hfile.HFileReaderV3;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.io.hfile.HFileWriterV2;
import org.apache.hadoop.hbase.io.hfile.HFileWriterV3;
import org.apache.hadoop.hbase.io.hfile.InlineBlockWriter;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.HFileProtos;
import org.apache.hadoop.hbase.util.BloomFilterWriter;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.io.Writable;

@InterfaceAudience.Private
public class HFile {
    static final Log LOG = LogFactory.getLog(HFile.class);
    public static final int MAXIMUM_KEY_LENGTH = Integer.MAX_VALUE;
    public static final Compression.Algorithm DEFAULT_COMPRESSION_ALGORITHM = Compression.Algorithm.NONE;
    public static final int MIN_FORMAT_VERSION = 2;
    public static final int MAX_FORMAT_VERSION = 3;
    public static final int MIN_FORMAT_VERSION_WITH_TAGS = 3;
    public static final String DEFAULT_COMPRESSION = DEFAULT_COMPRESSION_ALGORITHM.getName();
    public static final String BLOOM_FILTER_DATA_KEY = "BLOOM_FILTER_DATA";
    public static final int MIN_NUM_HFILE_PATH_LEVELS = 5;
    public static final int DEFAULT_BYTES_PER_CHECKSUM = 16384;
    public static final ChecksumType DEFAULT_CHECKSUM_TYPE = ChecksumType.CRC32;
    static final AtomicLong checksumFailures = new AtomicLong();
    public static final AtomicLong dataBlockReadCnt = new AtomicLong(0L);
    public static final String FORMAT_VERSION_KEY = "hfile.format.version";

    public static final long getChecksumFailuresCount() {
        return checksumFailures.getAndSet(0L);
    }

    public static int getFormatVersion(Configuration conf) {
        int version = conf.getInt(FORMAT_VERSION_KEY, 3);
        HFile.checkFormatVersion(version);
        return version;
    }

    public static final WriterFactory getWriterFactoryNoCache(Configuration conf) {
        Configuration tempConf = new Configuration(conf);
        tempConf.setFloat("hfile.block.cache.size", 0.0f);
        return HFile.getWriterFactory(conf, new CacheConfig(tempConf));
    }

    public static final WriterFactory getWriterFactory(Configuration conf, CacheConfig cacheConf) {
        int version = HFile.getFormatVersion(conf);
        switch (version) {
            case 2: {
                return new HFileWriterV2.WriterFactoryV2(conf, cacheConf);
            }
            case 3: {
                return new HFileWriterV3.WriterFactoryV3(conf, cacheConf);
            }
        }
        throw new IllegalArgumentException("Cannot create writer for HFile format version " + version);
    }

    private static Reader pickReaderVersion(Path path, FSDataInputStreamWrapper fsdis, long size, CacheConfig cacheConf, HFileSystem hfs, Configuration conf) throws IOException {
        FixedFileTrailer trailer = null;
        try {
            boolean isHBaseChecksum = fsdis.shouldUseHBaseChecksum();
            assert (!isHBaseChecksum);
            trailer = FixedFileTrailer.readFromStream(fsdis.getStream(isHBaseChecksum), size);
            switch (trailer.getMajorVersion()) {
                case 2: {
                    return new HFileReaderV2(path, trailer, fsdis, size, cacheConf, hfs, conf);
                }
                case 3: {
                    return new HFileReaderV3(path, trailer, fsdis, size, cacheConf, hfs, conf);
                }
            }
            throw new IllegalArgumentException("Invalid HFile version " + trailer.getMajorVersion());
        }
        catch (Throwable t) {
            try {
                fsdis.close();
            }
            catch (Throwable t2) {
                LOG.warn((Object)"Error closing fsdis FSDataInputStreamWrapper", t2);
            }
            throw new CorruptHFileException("Problem reading HFile Trailer from file " + path, t);
        }
    }

    public static Reader createReader(FileSystem fs, Path path, FSDataInputStreamWrapper fsdis, long size, CacheConfig cacheConf, Configuration conf) throws IOException {
        HFileSystem hfs = null;
        hfs = !(fs instanceof HFileSystem) ? new HFileSystem(fs) : (HFileSystem)fs;
        return HFile.pickReaderVersion(path, fsdis, size, cacheConf, hfs, conf);
    }

    public static Reader createReader(FileSystem fs, Path path, CacheConfig cacheConf, Configuration conf) throws IOException {
        Preconditions.checkNotNull((Object)cacheConf, (Object)"Cannot create Reader with null CacheConf");
        FSDataInputStreamWrapper stream = new FSDataInputStreamWrapper(fs, path);
        return HFile.pickReaderVersion(path, stream, fs.getFileStatus(path).getLen(), cacheConf, stream.getHfs(), conf);
    }

    static Reader createReaderFromStream(Path path, FSDataInputStream fsdis, long size, CacheConfig cacheConf, Configuration conf) throws IOException {
        FSDataInputStreamWrapper wrapper = new FSDataInputStreamWrapper(fsdis);
        return HFile.pickReaderVersion(path, wrapper, size, cacheConf, null, conf);
    }

    public static boolean isHFileFormat(FileSystem fs, Path path) throws IOException {
        return HFile.isHFileFormat(fs, fs.getFileStatus(path));
    }

    public static boolean isHFileFormat(FileSystem fs, FileStatus fileStatus) throws IOException {
        Path path = fileStatus.getPath();
        long size = fileStatus.getLen();
        FSDataInputStreamWrapper fsdis = new FSDataInputStreamWrapper(fs, path);
        try {
            boolean isHBaseChecksum = fsdis.shouldUseHBaseChecksum();
            assert (!isHBaseChecksum);
            FixedFileTrailer.readFromStream(fsdis.getStream(isHBaseChecksum), size);
            boolean bl = true;
            return bl;
        }
        catch (IllegalArgumentException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            try {
                fsdis.close();
            }
            catch (Throwable t) {
                LOG.warn((Object)("Error closing fsdis FSDataInputStreamWrapper: " + path), t);
            }
        }
    }

    public static boolean isReservedFileInfoKey(byte[] key) {
        return Bytes.startsWith((byte[])key, (byte[])FileInfo.RESERVED_PREFIX_BYTES);
    }

    public static String[] getSupportedCompressionAlgorithms() {
        return Compression.getSupportedAlgorithms();
    }

    static int longToInt(long l) {
        return (int)(l & 0xFFFFFFFFL);
    }

    static List<Path> getStoreFiles(FileSystem fs, Path regionDir) throws IOException {
        FileStatus[] familyDirs;
        ArrayList<Path> res = new ArrayList<Path>();
        FSUtils.DirFilter dirFilter = new FSUtils.DirFilter(fs);
        for (FileStatus dir : familyDirs = fs.listStatus(regionDir, (PathFilter)dirFilter)) {
            FileStatus[] files;
            for (FileStatus file : files = fs.listStatus(dir.getPath())) {
                if (file.isDirectory()) continue;
                res.add(file.getPath());
            }
        }
        return res;
    }

    public static void checkFormatVersion(int version) throws IllegalArgumentException {
        if (version < 2 || version > 3) {
            throw new IllegalArgumentException("Invalid HFile version: " + version + " (expected to be " + "between " + 2 + " and " + 3 + ")");
        }
    }

    public static void main(String[] args) throws Exception {
        HFilePrettyPrinter.main(args);
    }

    public static class FileInfo
    implements SortedMap<byte[], byte[]> {
        static final String RESERVED_PREFIX = "hfile.";
        static final byte[] RESERVED_PREFIX_BYTES = Bytes.toBytes((String)"hfile.");
        static final byte[] LASTKEY = Bytes.toBytes((String)"hfile.LASTKEY");
        static final byte[] AVG_KEY_LEN = Bytes.toBytes((String)"hfile.AVG_KEY_LEN");
        static final byte[] AVG_VALUE_LEN = Bytes.toBytes((String)"hfile.AVG_VALUE_LEN");
        static final byte[] COMPARATOR = Bytes.toBytes((String)"hfile.COMPARATOR");
        static final byte[] TAGS_COMPRESSED = Bytes.toBytes((String)"hfile.TAGS_COMPRESSED");
        public static final byte[] MAX_TAGS_LEN = Bytes.toBytes((String)"hfile.MAX_TAGS_LEN");
        private final SortedMap<byte[], byte[]> map = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);

        public FileInfo append(byte[] k, byte[] v, boolean checkPrefix) throws IOException {
            if (k == null || v == null) {
                throw new NullPointerException("Key nor value may be null");
            }
            if (checkPrefix && HFile.isReservedFileInfoKey(k)) {
                throw new IOException("Keys with a hfile. are reserved");
            }
            this.put(k, v);
            return this;
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Comparator<? super byte[]> comparator() {
            return this.map.comparator();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public Set<Map.Entry<byte[], byte[]>> entrySet() {
            return this.map.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            return this.map.equals(o);
        }

        @Override
        public byte[] firstKey() {
            return this.map.firstKey();
        }

        @Override
        public byte[] get(Object key) {
            return (byte[])this.map.get(key);
        }

        @Override
        public int hashCode() {
            return this.map.hashCode();
        }

        @Override
        public SortedMap<byte[], byte[]> headMap(byte[] toKey) {
            return this.map.headMap(toKey);
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public Set<byte[]> keySet() {
            return this.map.keySet();
        }

        @Override
        public byte[] lastKey() {
            return this.map.lastKey();
        }

        @Override
        public byte[] put(byte[] key, byte[] value) {
            return this.map.put(key, value);
        }

        @Override
        public void putAll(Map<? extends byte[], ? extends byte[]> m) {
            this.map.putAll(m);
        }

        @Override
        public byte[] remove(Object key) {
            return (byte[])this.map.remove(key);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public SortedMap<byte[], byte[]> subMap(byte[] fromKey, byte[] toKey) {
            return this.map.subMap(fromKey, toKey);
        }

        @Override
        public SortedMap<byte[], byte[]> tailMap(byte[] fromKey) {
            return this.map.tailMap(fromKey);
        }

        @Override
        public Collection<byte[]> values() {
            return this.map.values();
        }

        void write(DataOutputStream out) throws IOException {
            HFileProtos.FileInfoProto.Builder builder = HFileProtos.FileInfoProto.newBuilder();
            for (Map.Entry<byte[], byte[]> e : this.map.entrySet()) {
                HBaseProtos.BytesBytesPair.Builder bbpBuilder = HBaseProtos.BytesBytesPair.newBuilder();
                bbpBuilder.setFirst(ByteStringer.wrap((byte[])e.getKey()));
                bbpBuilder.setSecond(ByteStringer.wrap((byte[])e.getValue()));
                builder.addMapEntry(bbpBuilder.build());
            }
            out.write(ProtobufUtil.PB_MAGIC);
            builder.build().writeDelimitedTo((OutputStream)out);
        }

        void read(DataInputStream in) throws IOException {
            int read;
            int pblen = ProtobufUtil.lengthOfPBMagic();
            byte[] pbuf = new byte[pblen];
            if (in.markSupported()) {
                in.mark(pblen);
            }
            if ((read = in.read(pbuf)) != pblen) {
                throw new IOException("read=" + read + ", wanted=" + pblen);
            }
            if (ProtobufUtil.isPBMagicPrefix((byte[])pbuf)) {
                this.parsePB(HFileProtos.FileInfoProto.parseDelimitedFrom((InputStream)in));
            } else if (in.markSupported()) {
                in.reset();
                this.parseWritable(in);
            } else {
                ByteArrayInputStream bais = new ByteArrayInputStream(pbuf);
                SequenceInputStream sis = new SequenceInputStream(bais, in);
                this.parseWritable(new DataInputStream(sis));
            }
        }

        void parseWritable(DataInputStream in) throws IOException {
            this.map.clear();
            int entries = in.readInt();
            for (int i = 0; i < entries; ++i) {
                byte[] key = Bytes.readByteArray((DataInput)in);
                in.readByte();
                byte[] value = Bytes.readByteArray((DataInput)in);
                this.map.put(key, value);
            }
        }

        void parsePB(HFileProtos.FileInfoProto fip) {
            this.map.clear();
            for (HBaseProtos.BytesBytesPair pair : fip.getMapEntryList()) {
                this.map.put(pair.getFirst().toByteArray(), pair.getSecond().toByteArray());
            }
        }
    }

    public static interface Reader
    extends Closeable,
    CachingBlockReader {
        public String getName();

        public KeyValue.KVComparator getComparator();

        public HFileScanner getScanner(boolean var1, boolean var2, boolean var3);

        public ByteBuffer getMetaBlock(String var1, boolean var2) throws IOException;

        public Map<byte[], byte[]> loadFileInfo() throws IOException;

        public byte[] getLastKey();

        public byte[] midkey() throws IOException;

        public long length();

        public long getEntries();

        public byte[] getFirstKey();

        public long indexSize();

        public byte[] getFirstRowKey();

        public byte[] getLastRowKey();

        public FixedFileTrailer getTrailer();

        public HFileBlockIndex.BlockIndexReader getDataBlockIndexReader();

        public HFileScanner getScanner(boolean var1, boolean var2);

        public Compression.Algorithm getCompressionAlgorithm();

        public DataInput getGeneralBloomFilterMetadata() throws IOException;

        public DataInput getDeleteBloomFilterMetadata() throws IOException;

        public Path getPath();

        public void close(boolean var1) throws IOException;

        public DataBlockEncoding getDataBlockEncoding();

        public boolean hasMVCCInfo();

        public HFileContext getFileContext();
    }

    public static interface CachingBlockReader {
        public HFileBlock readBlock(long var1, long var3, boolean var5, boolean var6, boolean var7, boolean var8, BlockType var9, DataBlockEncoding var10) throws IOException;
    }

    public static abstract class WriterFactory {
        protected final Configuration conf;
        protected final CacheConfig cacheConf;
        protected FileSystem fs;
        protected Path path;
        protected FSDataOutputStream ostream;
        protected KeyValue.KVComparator comparator = KeyValue.COMPARATOR;
        protected InetSocketAddress[] favoredNodes;
        private HFileContext fileContext;

        WriterFactory(Configuration conf, CacheConfig cacheConf) {
            this.conf = conf;
            this.cacheConf = cacheConf;
        }

        public WriterFactory withPath(FileSystem fs, Path path) {
            Preconditions.checkNotNull((Object)fs);
            Preconditions.checkNotNull((Object)path);
            this.fs = fs;
            this.path = path;
            return this;
        }

        public WriterFactory withOutputStream(FSDataOutputStream ostream) {
            Preconditions.checkNotNull((Object)ostream);
            this.ostream = ostream;
            return this;
        }

        public WriterFactory withComparator(KeyValue.KVComparator comparator) {
            Preconditions.checkNotNull((Object)comparator);
            this.comparator = comparator;
            return this;
        }

        public WriterFactory withFavoredNodes(InetSocketAddress[] favoredNodes) {
            this.favoredNodes = favoredNodes;
            return this;
        }

        public WriterFactory withFileContext(HFileContext fileContext) {
            this.fileContext = fileContext;
            return this;
        }

        public Writer create() throws IOException {
            if ((this.path != null ? 1 : 0) + (this.ostream != null ? 1 : 0) != 1) {
                throw new AssertionError((Object)"Please specify exactly one of filesystem/path or path");
            }
            if (this.path != null) {
                this.ostream = AbstractHFileWriter.createOutputStream(this.conf, this.fs, this.path, this.favoredNodes);
            }
            return this.createWriter(this.fs, this.path, this.ostream, this.comparator, this.fileContext);
        }

        protected abstract Writer createWriter(FileSystem var1, Path var2, FSDataOutputStream var3, KeyValue.KVComparator var4, HFileContext var5) throws IOException;
    }

    public static interface Writer
    extends Closeable {
        public void appendFileInfo(byte[] var1, byte[] var2) throws IOException;

        public void append(Cell var1) throws IOException;

        public Path getPath();

        public void addInlineBlockWriter(InlineBlockWriter var1);

        public void appendMetaBlock(String var1, Writable var2);

        public void addGeneralBloomFilter(BloomFilterWriter var1);

        public void addDeleteFamilyBloomFilter(BloomFilterWriter var1) throws IOException;

        public HFileContext getFileContext();
    }
}

