/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.SequenceId;
import org.apache.hadoop.hbase.util.ClassSize;

@InterfaceAudience.Private
public class MultiVersionConsistencyControl {
    private static final long NO_WRITE_NUMBER = 0L;
    private volatile long memstoreRead = 0L;
    private final Object readWaiters = new Object();
    private final LinkedList<WriteEntry> writeQueue = new LinkedList();
    public static final long FIXED_SIZE = ClassSize.align((int)(ClassSize.OBJECT + 16 + 2 * ClassSize.REFERENCE));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(long startPoint) {
        LinkedList<WriteEntry> linkedList = this.writeQueue;
        synchronized (linkedList) {
            this.writeQueue.clear();
            this.memstoreRead = startPoint;
        }
    }

    WriteEntry beginMemstoreInsert() {
        return this.beginMemstoreInsertWithSeqNum(0L);
    }

    public static long getPreAssignedWriteNumber(AtomicLong sequenceId) {
        return sequenceId.incrementAndGet() + 1000000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteEntry beginMemstoreInsertWithSeqNum(long curSeqNum) {
        WriteEntry e = new WriteEntry(curSeqNum);
        LinkedList<WriteEntry> linkedList = this.writeQueue;
        synchronized (linkedList) {
            this.writeQueue.add(e);
            return e;
        }
    }

    public void completeMemstoreInsertWithSeqNum(WriteEntry e, SequenceId seqId) throws IOException {
        if (e == null) {
            return;
        }
        if (seqId != null) {
            e.setWriteNumber(seqId.getSequenceId());
        } else {
            e.setWriteNumber(0L);
        }
        this.waitForPreviousTransactionsComplete(e);
    }

    public void completeMemstoreInsert(WriteEntry e) {
        this.waitForPreviousTransactionsComplete(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean advanceMemstore(WriteEntry e) {
        long nextReadValue = -1L;
        Object object = this.writeQueue;
        synchronized (object) {
            WriteEntry queueFirst;
            e.markCompleted();
            while (!this.writeQueue.isEmpty() && (queueFirst = this.writeQueue.getFirst()).isCompleted()) {
                nextReadValue = Math.max(nextReadValue, queueFirst.getWriteNumber());
                this.writeQueue.removeFirst();
            }
            if (nextReadValue > this.memstoreRead) {
                this.memstoreRead = nextReadValue;
            }
            this.writeQueue.notifyAll();
        }
        if (nextReadValue > 0L) {
            object = this.readWaiters;
            synchronized (object) {
                this.readWaiters.notifyAll();
            }
        }
        return this.memstoreRead >= e.getWriteNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void advanceMemstoreReadPointIfNeeded(long seqNum) {
        LinkedList<WriteEntry> linkedList = this.writeQueue;
        synchronized (linkedList) {
            if (this.memstoreRead < seqNum) {
                this.memstoreRead = seqNum;
            }
        }
    }

    public void waitForPreviousTransactionsComplete() {
        WriteEntry w = this.beginMemstoreInsert();
        this.waitForPreviousTransactionsComplete(w);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForPreviousTransactionsComplete(WriteEntry waitedEntry) {
        boolean interrupted = false;
        WriteEntry w = waitedEntry;
        try {
            WriteEntry firstEntry = null;
            do {
                LinkedList<WriteEntry> linkedList = this.writeQueue;
                synchronized (linkedList) {
                    if (this.writeQueue.isEmpty()) {
                        break;
                    }
                    firstEntry = this.writeQueue.getFirst();
                    if (firstEntry == w) {
                        break;
                    }
                    try {
                        this.writeQueue.wait(0L);
                    }
                    catch (InterruptedException ie) {
                        interrupted = true;
                        break;
                    }
                }
            } while (firstEntry != null);
        }
        finally {
            if (w != null) {
                this.advanceMemstore(w);
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public long memstoreReadPoint() {
        return this.memstoreRead;
    }

    public static class WriteEntry {
        private long writeNumber;
        private volatile boolean completed = false;

        WriteEntry(long writeNumber) {
            this.writeNumber = writeNumber;
        }

        void markCompleted() {
            this.completed = true;
        }

        boolean isCompleted() {
            return this.completed;
        }

        long getWriteNumber() {
            return this.writeNumber;
        }

        void setWriteNumber(long val) {
            this.writeNumber = val;
        }
    }
}

