/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.coordination.BaseCoordinatedStateManager;
import org.apache.hadoop.hbase.coordination.RegionMergeCoordination;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RegionServerCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.SplitTransaction;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ConfigUtil;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class RegionMergeTransaction {
    private static final Log LOG = LogFactory.getLog(RegionMergeTransaction.class);
    private HRegionInfo mergedRegionInfo;
    private final HRegion region_a;
    private final HRegion region_b;
    private final Path mergesdir;
    private final boolean forcible;
    private boolean useCoordinationForAssignment;
    private final List<JournalEntry> journal = new ArrayList<JournalEntry>();
    private static IOException closedByOtherException = new IOException("Failed to close region: already closed by another thread");
    private RegionServerCoprocessorHost rsCoprocessorHost = null;
    private RegionMergeCoordination.RegionMergeDetails rmd;

    public RegionMergeTransaction(HRegion a, HRegion b, boolean forcible) {
        if (a.getRegionInfo().compareTo(b.getRegionInfo()) <= 0) {
            this.region_a = a;
            this.region_b = b;
        } else {
            this.region_a = b;
            this.region_b = a;
        }
        this.forcible = forcible;
        this.mergesdir = this.region_a.getRegionFileSystem().getMergesDir();
    }

    public boolean prepare(RegionServerServices services) {
        if (!this.region_a.getTableDesc().getTableName().equals((Object)this.region_b.getTableDesc().getTableName())) {
            LOG.info((Object)("Can't merge regions " + this.region_a + "," + this.region_b + " because they do not belong to the same table"));
            return false;
        }
        if (this.region_a.getRegionInfo().equals((Object)this.region_b.getRegionInfo())) {
            LOG.info((Object)("Can't merge the same region " + this.region_a));
            return false;
        }
        if (!this.forcible && !HRegionInfo.areAdjacent((HRegionInfo)this.region_a.getRegionInfo(), (HRegionInfo)this.region_b.getRegionInfo())) {
            String msg = "Skip merging " + this.region_a.getRegionNameAsString() + " and " + this.region_b.getRegionNameAsString() + ", because they are not adjacent.";
            LOG.info((Object)msg);
            return false;
        }
        if (!this.region_a.isMergeable() || !this.region_b.isMergeable()) {
            return false;
        }
        try {
            boolean regionAHasMergeQualifier = this.hasMergeQualifierInMeta(services, this.region_a.getRegionName());
            if (regionAHasMergeQualifier || this.hasMergeQualifierInMeta(services, this.region_b.getRegionName())) {
                LOG.debug((Object)("Region " + (regionAHasMergeQualifier ? this.region_a.getRegionNameAsString() : this.region_b.getRegionNameAsString()) + " is not mergeable because it has merge qualifier in META"));
                return false;
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed judging whether merge transaction is available for " + this.region_a.getRegionNameAsString() + " and " + this.region_b.getRegionNameAsString()), (Throwable)e);
            return false;
        }
        this.mergedRegionInfo = RegionMergeTransaction.getMergedRegionInfo(this.region_a.getRegionInfo(), this.region_b.getRegionInfo());
        return true;
    }

    public HRegion execute(Server server, RegionServerServices services) throws IOException {
        boolean bl = this.useCoordinationForAssignment = server == null ? true : ConfigUtil.useZKForAssignment(server.getConfiguration());
        if (this.rmd == null) {
            RegionMergeCoordination.RegionMergeDetails regionMergeDetails = this.rmd = server != null && server.getCoordinatedStateManager() != null ? ((BaseCoordinatedStateManager)server.getCoordinatedStateManager()).getRegionMergeCoordination().getDefaultDetails() : null;
        }
        if (this.rsCoprocessorHost == null) {
            this.rsCoprocessorHost = server != null ? ((HRegionServer)server).getRegionServerCoprocessorHost() : null;
        }
        HRegion mergedRegion = this.createMergedRegion(server, services);
        if (this.rsCoprocessorHost != null) {
            this.rsCoprocessorHost.postMergeCommit(this.region_a, this.region_b, mergedRegion);
        }
        return this.stepsAfterPONR(server, services, mergedRegion);
    }

    public HRegion stepsAfterPONR(Server server, RegionServerServices services, HRegion mergedRegion) throws IOException {
        this.openMergedRegion(server, services, mergedRegion);
        if (this.useCoordination(server)) {
            ((BaseCoordinatedStateManager)server.getCoordinatedStateManager()).getRegionMergeCoordination().completeRegionMergeTransaction(services, this.mergedRegionInfo, this.region_a, this.region_b, this.rmd, mergedRegion);
        }
        if (this.rsCoprocessorHost != null) {
            this.rsCoprocessorHost.postMerge(this.region_a, this.region_b, mergedRegion);
        }
        return mergedRegion;
    }

    HRegion createMergedRegion(Server server, RegionServerServices services) throws IOException {
        LOG.info((Object)("Starting merge of " + this.region_a + " and " + this.region_b.getRegionNameAsString() + ", forcible=" + this.forcible));
        if (server != null && server.isStopped() || services != null && services.isStopping()) {
            throw new IOException("Server is stopped or stopping");
        }
        if (this.rsCoprocessorHost != null && this.rsCoprocessorHost.preMerge(this.region_a, this.region_b)) {
            throw new IOException("Coprocessor bypassing regions " + this.region_a + " " + this.region_b + " merge.");
        }
        boolean testing = server == null ? true : server.getConfiguration().getBoolean("hbase.testing.nocluster", false);
        HRegion mergedRegion = this.stepsBeforePONR(server, services, testing);
        ArrayList<Mutation> metaEntries = new ArrayList<Mutation>();
        if (this.rsCoprocessorHost != null) {
            if (this.rsCoprocessorHost.preMergeCommit(this.region_a, this.region_b, metaEntries)) {
                throw new IOException("Coprocessor bypassing regions " + this.region_a + " " + this.region_b + " merge.");
            }
            try {
                for (Mutation p : metaEntries) {
                    HRegionInfo.parseRegionName((byte[])p.getRow());
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Row key of mutation from coprocessor is not parsable as region name.Mutations from coprocessor should only be for hbase:meta table.", (Throwable)e);
                throw e;
            }
        }
        this.journal.add(JournalEntry.PONR);
        if (!testing && this.useCoordinationForAssignment) {
            if (metaEntries.isEmpty()) {
                MetaTableAccessor.mergeRegions((Connection)server.getConnection(), (HRegionInfo)mergedRegion.getRegionInfo(), (HRegionInfo)this.region_a.getRegionInfo(), (HRegionInfo)this.region_b.getRegionInfo(), (ServerName)server.getServerName());
            } else {
                this.mergeRegionsAndPutMetaEntries((HConnection)server.getConnection(), mergedRegion.getRegionInfo(), this.region_a.getRegionInfo(), this.region_b.getRegionInfo(), server.getServerName(), metaEntries);
            }
        } else if (services != null && !this.useCoordinationForAssignment && !services.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.MERGE_PONR, this.mergedRegionInfo, this.region_a.getRegionInfo(), this.region_b.getRegionInfo())) {
            throw new IOException("Failed to notify master that merge passed PONR: " + this.region_a.getRegionInfo().getRegionNameAsString() + " and " + this.region_b.getRegionInfo().getRegionNameAsString());
        }
        return mergedRegion;
    }

    private void mergeRegionsAndPutMetaEntries(HConnection hConnection, HRegionInfo mergedRegion, HRegionInfo regionA, HRegionInfo regionB, ServerName serverName, List<Mutation> metaEntries) throws IOException {
        this.prepareMutationsForMerge(mergedRegion, regionA, regionB, serverName, metaEntries);
        MetaTableAccessor.mutateMetaTable((Connection)hConnection, metaEntries);
    }

    public void prepareMutationsForMerge(HRegionInfo mergedRegion, HRegionInfo regionA, HRegionInfo regionB, ServerName serverName, List<Mutation> mutations) throws IOException {
        HRegionInfo copyOfMerged = new HRegionInfo(mergedRegion);
        Put putOfMerged = MetaTableAccessor.makePutFromRegionInfo((HRegionInfo)copyOfMerged);
        putOfMerged.add(HConstants.CATALOG_FAMILY, HConstants.MERGEA_QUALIFIER, regionA.toByteArray());
        putOfMerged.add(HConstants.CATALOG_FAMILY, HConstants.MERGEB_QUALIFIER, regionB.toByteArray());
        mutations.add((Mutation)putOfMerged);
        Delete deleteA = MetaTableAccessor.makeDeleteFromRegionInfo((HRegionInfo)regionA);
        Delete deleteB = MetaTableAccessor.makeDeleteFromRegionInfo((HRegionInfo)regionB);
        mutations.add((Mutation)deleteA);
        mutations.add((Mutation)deleteB);
        this.addLocation(putOfMerged, serverName, 1L);
    }

    public Put addLocation(Put p, ServerName sn, long openSeqNum) {
        p.add(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)sn.getHostAndPort()));
        p.add(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER, Bytes.toBytes((long)sn.getStartcode()));
        p.add(HConstants.CATALOG_FAMILY, HConstants.SEQNUM_QUALIFIER, Bytes.toBytes((long)openSeqNum));
        return p;
    }

    public HRegion stepsBeforePONR(Server server, RegionServerServices services, boolean testing) throws IOException {
        if (this.rmd == null) {
            RegionMergeCoordination.RegionMergeDetails regionMergeDetails = this.rmd = server != null && server.getCoordinatedStateManager() != null ? ((BaseCoordinatedStateManager)server.getCoordinatedStateManager()).getRegionMergeCoordination().getDefaultDetails() : null;
        }
        if (this.useCoordination(server)) {
            try {
                ((BaseCoordinatedStateManager)server.getCoordinatedStateManager()).getRegionMergeCoordination().startRegionMergeTransaction(this.mergedRegionInfo, server.getServerName(), this.region_a.getRegionInfo(), this.region_b.getRegionInfo());
            }
            catch (IOException e) {
                throw new IOException("Failed to start region merge transaction for " + this.mergedRegionInfo.getRegionNameAsString(), e);
            }
        } else if (services != null && !this.useCoordinationForAssignment && !services.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.READY_TO_MERGE, this.mergedRegionInfo, this.region_a.getRegionInfo(), this.region_b.getRegionInfo())) {
            throw new IOException("Failed to get ok from master to merge " + this.region_a.getRegionInfo().getRegionNameAsString() + " and " + this.region_b.getRegionInfo().getRegionNameAsString());
        }
        this.journal.add(JournalEntry.SET_MERGING);
        if (this.useCoordination(server)) {
            ((BaseCoordinatedStateManager)server.getCoordinatedStateManager()).getRegionMergeCoordination().waitForRegionMergeTransaction(services, this.mergedRegionInfo, this.region_a, this.region_b, this.rmd);
        }
        this.region_a.getRegionFileSystem().createMergesDir();
        this.journal.add(JournalEntry.CREATED_MERGE_DIR);
        Map<byte[], List<StoreFile>> hstoreFilesOfRegionA = this.closeAndOfflineRegion(services, this.region_a, true, testing);
        Map<byte[], List<StoreFile>> hstoreFilesOfRegionB = this.closeAndOfflineRegion(services, this.region_b, false, testing);
        assert (hstoreFilesOfRegionA != null && hstoreFilesOfRegionB != null);
        this.mergeStoreFiles(hstoreFilesOfRegionA, hstoreFilesOfRegionB);
        if (this.useCoordination(server)) {
            try {
                ((BaseCoordinatedStateManager)server.getCoordinatedStateManager()).getRegionMergeCoordination().confirmRegionMergeTransaction(this.mergedRegionInfo, this.region_a.getRegionInfo(), this.region_b.getRegionInfo(), server.getServerName(), this.rmd);
            }
            catch (IOException e) {
                throw new IOException("Failed setting MERGING on " + this.mergedRegionInfo.getRegionNameAsString(), e);
            }
        }
        this.journal.add(JournalEntry.STARTED_MERGED_REGION_CREATION);
        HRegion mergedRegion = this.createMergedRegionFromMerges(this.region_a, this.region_b, this.mergedRegionInfo);
        return mergedRegion;
    }

    HRegion createMergedRegionFromMerges(HRegion a, HRegion b, HRegionInfo mergedRegion) throws IOException {
        return a.createMergedRegionFromMerges(mergedRegion, b);
    }

    private Map<byte[], List<StoreFile>> closeAndOfflineRegion(RegionServerServices services, HRegion region, boolean isRegionA, boolean testing) throws IOException {
        Map<byte[], List<StoreFile>> hstoreFilesToMerge = null;
        Exception exceptionToThrow = null;
        try {
            hstoreFilesToMerge = region.close(false);
        }
        catch (Exception e) {
            exceptionToThrow = e;
        }
        if (exceptionToThrow == null && hstoreFilesToMerge == null) {
            exceptionToThrow = closedByOtherException;
        }
        if (exceptionToThrow != closedByOtherException) {
            this.journal.add(isRegionA ? JournalEntry.CLOSED_REGION_A : JournalEntry.CLOSED_REGION_B);
        }
        if (exceptionToThrow != null) {
            if (exceptionToThrow instanceof IOException) {
                throw (IOException)exceptionToThrow;
            }
            throw new IOException(exceptionToThrow);
        }
        if (!testing) {
            services.removeFromOnlineRegions(region, null);
        }
        this.journal.add(isRegionA ? JournalEntry.OFFLINED_REGION_A : JournalEntry.OFFLINED_REGION_B);
        return hstoreFilesToMerge;
    }

    public static HRegionInfo getMergedRegionInfo(HRegionInfo a, HRegionInfo b) {
        long rid = EnvironmentEdgeManager.currentTime();
        if (rid < a.getRegionId() || rid < b.getRegionId()) {
            LOG.warn((Object)("Clock skew; merging regions id are " + a.getRegionId() + " and " + b.getRegionId() + ", but current time here is " + rid));
            rid = Math.max(a.getRegionId(), b.getRegionId()) + 1L;
        }
        byte[] startKey = null;
        byte[] endKey = null;
        startKey = a.compareTo(b) <= 0 ? a.getStartKey() : b.getStartKey();
        endKey = Bytes.equals((byte[])a.getEndKey(), (byte[])HConstants.EMPTY_BYTE_ARRAY) || !Bytes.equals((byte[])b.getEndKey(), (byte[])HConstants.EMPTY_BYTE_ARRAY) && Bytes.compareTo((byte[])a.getEndKey(), (byte[])b.getEndKey()) > 0 ? a.getEndKey() : b.getEndKey();
        HRegionInfo mergedRegionInfo = new HRegionInfo(a.getTable(), startKey, endKey, false, rid);
        return mergedRegionInfo;
    }

    void openMergedRegion(Server server, RegionServerServices services, HRegion merged) throws IOException {
        boolean stopping;
        boolean stopped = server != null && server.isStopped();
        boolean bl = stopping = services != null && services.isStopping();
        if (stopped || stopping) {
            LOG.info((Object)("Not opening merged region  " + merged.getRegionNameAsString() + " because stopping=" + stopping + ", stopped=" + stopped));
            return;
        }
        HRegionInfo hri = merged.getRegionInfo();
        SplitTransaction.LoggingProgressable reporter = server == null ? null : new SplitTransaction.LoggingProgressable(hri, server.getConfiguration().getLong("hbase.regionserver.regionmerge.open.log.interval", 10000L));
        merged.openHRegion(reporter);
        if (services != null) {
            try {
                if (this.useCoordinationForAssignment) {
                    services.postOpenDeployTasks(merged);
                } else if (!services.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.MERGED, this.mergedRegionInfo, this.region_a.getRegionInfo(), this.region_b.getRegionInfo())) {
                    throw new IOException("Failed to report merged region to master: " + this.mergedRegionInfo.getShortNameToLog());
                }
                services.addToOnlineRegions(merged);
            }
            catch (KeeperException ke) {
                throw new IOException(ke);
            }
        }
    }

    private void mergeStoreFiles(Map<byte[], List<StoreFile>> hstoreFilesOfRegionA, Map<byte[], List<StoreFile>> hstoreFilesOfRegionB) throws IOException {
        HRegionFileSystem fs_a = this.region_a.getRegionFileSystem();
        for (Map.Entry<byte[], List<StoreFile>> entry : hstoreFilesOfRegionA.entrySet()) {
            String familyName = Bytes.toString((byte[])entry.getKey());
            for (StoreFile storeFile : entry.getValue()) {
                fs_a.mergeStoreFile(this.mergedRegionInfo, familyName, storeFile, this.mergesdir);
            }
        }
        HRegionFileSystem fs_b = this.region_b.getRegionFileSystem();
        for (Map.Entry<byte[], List<StoreFile>> entry : hstoreFilesOfRegionB.entrySet()) {
            String familyName = Bytes.toString((byte[])entry.getKey());
            for (StoreFile storeFile : entry.getValue()) {
                fs_b.mergeStoreFile(this.mergedRegionInfo, familyName, storeFile, this.mergesdir);
            }
        }
    }

    public boolean rollback(Server server, RegionServerServices services) throws IOException {
        assert (this.mergedRegionInfo != null);
        if (this.rsCoprocessorHost != null) {
            this.rsCoprocessorHost.preRollBackMerge(this.region_a, this.region_b);
        }
        boolean result = true;
        ListIterator<JournalEntry> iterator = this.journal.listIterator(this.journal.size());
        block14: while (iterator.hasPrevious()) {
            JournalEntry je = iterator.previous();
            switch (je) {
                case SET_MERGING: {
                    if (this.useCoordination(server)) {
                        ((BaseCoordinatedStateManager)server.getCoordinatedStateManager()).getRegionMergeCoordination().clean(this.mergedRegionInfo);
                        continue block14;
                    }
                    if (services == null || this.useCoordinationForAssignment || services.reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode.MERGE_REVERTED, this.mergedRegionInfo, this.region_a.getRegionInfo(), this.region_b.getRegionInfo())) continue block14;
                    return false;
                }
                case CREATED_MERGE_DIR: {
                    this.region_a.writestate.writesEnabled = true;
                    this.region_b.writestate.writesEnabled = true;
                    this.region_a.getRegionFileSystem().cleanupMergesDir();
                    continue block14;
                }
                case CLOSED_REGION_A: {
                    try {
                        this.region_a.initialize();
                        continue block14;
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Failed rollbacking CLOSED_REGION_A of region " + this.region_a.getRegionNameAsString()), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                case OFFLINED_REGION_A: {
                    if (services == null) continue block14;
                    services.addToOnlineRegions(this.region_a);
                    continue block14;
                }
                case CLOSED_REGION_B: {
                    try {
                        this.region_b.initialize();
                        continue block14;
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Failed rollbacking CLOSED_REGION_A of region " + this.region_b.getRegionNameAsString()), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                case OFFLINED_REGION_B: {
                    if (services == null) continue block14;
                    services.addToOnlineRegions(this.region_b);
                    continue block14;
                }
                case STARTED_MERGED_REGION_CREATION: {
                    this.region_a.getRegionFileSystem().cleanupMergedRegion(this.mergedRegionInfo);
                    continue block14;
                }
                case PONR: {
                    return false;
                }
            }
            throw new RuntimeException("Unhandled journal entry: " + (Object)((Object)je));
        }
        if (this.rsCoprocessorHost != null) {
            this.rsCoprocessorHost.postRollBackMerge(this.region_a, this.region_b);
        }
        return result;
    }

    HRegionInfo getMergedRegionInfo() {
        return this.mergedRegionInfo;
    }

    Path getMergesDir() {
        return this.mergesdir;
    }

    private boolean useCoordination(Server server) {
        return server != null && this.useCoordinationForAssignment && server.getCoordinatedStateManager() != null;
    }

    boolean hasMergeQualifierInMeta(RegionServerServices services, byte[] regionName) throws IOException {
        if (services == null) {
            return false;
        }
        Pair mergeRegions = MetaTableAccessor.getRegionsFromMergeQualifier((Connection)services.getConnection(), (byte[])regionName);
        return mergeRegions != null && (mergeRegions.getFirst() != null || mergeRegions.getSecond() != null);
    }

    static enum JournalEntry {
        SET_MERGING,
        CREATED_MERGE_DIR,
        CLOSED_REGION_A,
        OFFLINED_REGION_A,
        CLOSED_REGION_B,
        OFFLINED_REGION_B,
        STARTED_MERGED_REGION_CREATION,
        PONR;

    }
}

