/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ReversedKeyValueHeap;

@InterfaceAudience.Private
class ReversedRegionScannerImpl
extends HRegion.RegionScannerImpl {
    ReversedRegionScannerImpl(Scan scan, List<KeyValueScanner> additionalScanners, HRegion region) throws IOException {
        HRegion hRegion = region;
        hRegion.getClass();
        super(scan, additionalScanners, region);
    }

    @Override
    protected void initializeKVHeap(List<KeyValueScanner> scanners, List<KeyValueScanner> joinedScanners, HRegion region) throws IOException {
        this.storeHeap = new ReversedKeyValueHeap(scanners, region.getComparator());
        if (!joinedScanners.isEmpty()) {
            this.joinedHeap = new ReversedKeyValueHeap(joinedScanners, region.getComparator());
        }
    }

    @Override
    protected boolean isStopRow(byte[] currentRow, int offset, short length) {
        return currentRow == null || this.stopRow != null && this.region.getComparator().compareRows(this.stopRow, 0, this.stopRow.length, currentRow, offset, (int)length) >= this.isScan;
    }

    @Override
    protected boolean nextRow(byte[] currentRow, int offset, short length) throws IOException {
        assert (this.joinedContinuationRow == null) : "Trying to go to next row during joinedHeap read.";
        byte[] row = new byte[length];
        System.arraycopy(currentRow, offset, row, 0, length);
        this.storeHeap.seekToPreviousRow((Cell)KeyValueUtil.createFirstOnRow((byte[])row));
        this.resetFilters();
        if (this.region.getCoprocessorHost() != null) {
            return this.region.getCoprocessorHost().postScannerFilterRow(this, currentRow, offset, length);
        }
        return true;
    }
}

