/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.Encryptor;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.SecureWALCellCodec;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.EncryptionTest;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class SecureProtobufLogWriter
extends ProtobufLogWriter {
    private static final Log LOG = LogFactory.getLog(SecureProtobufLogWriter.class);
    private static final String DEFAULT_CIPHER = "AES";
    private Encryptor encryptor = null;

    @Override
    protected WALProtos.WALHeader buildWALHeader(Configuration conf, WALProtos.WALHeader.Builder builder) throws IOException {
        builder.setWriterClsName(SecureProtobufLogWriter.class.getSimpleName());
        if (conf.getBoolean("hbase.regionserver.wal.encryption", false)) {
            EncryptionTest.testKeyProvider(conf);
            EncryptionTest.testCipherProvider(conf);
            String cipherName = conf.get("hbase.crypto.wal.algorithm", DEFAULT_CIPHER);
            Cipher cipher = Encryption.getCipher((Configuration)conf, (String)cipherName);
            if (cipher == null) {
                throw new RuntimeException("Cipher '" + cipherName + "' is not available");
            }
            SecureRandom rng = new SecureRandom();
            byte[] keyBytes = new byte[cipher.getKeyLength()];
            rng.nextBytes(keyBytes);
            SecretKeySpec key = new SecretKeySpec(keyBytes, cipher.getName());
            builder.setEncryptionKey(ByteStringer.wrap((byte[])EncryptionUtil.wrapKey((Configuration)conf, (String)conf.get("hbase.crypto.wal.key.name", conf.get("hbase.crypto.master.key.name", User.getCurrent().getShortName())), (Key)key)));
            this.encryptor = cipher.getEncryptor();
            this.encryptor.setKey((Key)key);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Initialized secure protobuf WAL: cipher=" + cipher.getName()));
            }
        }
        builder.setCellCodecClsName(SecureWALCellCodec.class.getName());
        return super.buildWALHeader(conf, builder);
    }

    @Override
    protected void initAfterHeader(boolean doCompress) throws IOException {
        if (this.conf.getBoolean("hbase.regionserver.wal.encryption", false) && this.encryptor != null) {
            WALCellCodec codec = SecureWALCellCodec.getCodec(this.conf, this.encryptor);
            this.cellEncoder = codec.getEncoder((OutputStream)this.output);
            this.compressionContext = null;
        } else {
            super.initAfterHeader(doCompress);
        }
    }
}

