// Autogenerated Jamon implementation
// /Volumes/hbase-1.1.1RC0/hbase/hbase-server/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/MasterStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 32, 1
import java.util.*;
// 33, 1
import org.apache.hadoop.util.StringUtils;
// 34, 1
import org.apache.hadoop.hbase.util.Bytes;
// 35, 1
import org.apache.hadoop.hbase.util.JvmVersion;
// 36, 1
import org.apache.hadoop.hbase.util.FSUtils;
// 37, 1
import org.apache.hadoop.hbase.master.HMaster;
// 38, 1
import org.apache.hadoop.hbase.master.AssignmentManager;
// 39, 1
import org.apache.hadoop.hbase.master.ServerManager;
// 40, 1
import org.apache.hadoop.hbase.HConstants;
// 41, 1
import org.apache.hadoop.hbase.NamespaceDescriptor;
// 42, 1
import org.apache.hadoop.hbase.ServerLoad;
// 43, 1
import org.apache.hadoop.hbase.ServerName;
// 44, 1
import org.apache.hadoop.hbase.client.Admin;
// 45, 1
import org.apache.hadoop.hbase.client.HConnectionManager;
// 46, 1
import org.apache.hadoop.hbase.HRegionInfo;
// 47, 1
import org.apache.hadoop.hbase.master.RegionState;
// 48, 1
import org.apache.hadoop.hbase.HTableDescriptor;
// 49, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 50, 1
import org.apache.hadoop.hbase.TableName;
// 51, 1
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos.SnapshotDescription;
// 52, 1
import org.apache.hadoop.hbase.master.DeadServer;
// 53, 1
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
// 54, 1
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
// 55, 1
import org.apache.hadoop.hbase.security.access.AccessControlLists;

public class MasterStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.Intf

{
  private final HMaster master;
  private final String format;
  private final Set<ServerName> deadServers;
  private final String filter;
  private final ServerName metaLocation;
  private final Map<String,Integer> frags;
  private final ServerManager serverManager;
  private final List<ServerName> servers;
  private final AssignmentManager assignmentManager;
  private final boolean catalogJanitorEnabled;
  // 67, 1
  
  public String formatZKString() {
    StringBuilder quorums = new StringBuilder();
    String zkQuorum = master.getZooKeeper().getQuorum();

    if (null == zkQuorum) {
      return quorums.toString();
    }

    String[] zks = zkQuorum.split(",");

    if (zks.length == 0) {
      return quorums.toString();
    }

    for(int i = 0; i < zks.length; ++i) {
      quorums.append(zks[i].trim());

      if (i != (zks.length - 1)) {
        quorums.append("<br/>");
      }
    }

    return quorums.toString();
  }

  protected static org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    if(! p_implData.getDeadServers__IsNotDefault())
    {
      p_implData.setDeadServers(null);
    }
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    if(! p_implData.getMetaLocation__IsNotDefault())
    {
      p_implData.setMetaLocation(null);
    }
    if(! p_implData.getFrags__IsNotDefault())
    {
      p_implData.setFrags(null);
    }
    if(! p_implData.getServerManager__IsNotDefault())
    {
      p_implData.setServerManager(null);
    }
    if(! p_implData.getServers__IsNotDefault())
    {
      p_implData.setServers(null);
    }
    if(! p_implData.getAssignmentManager__IsNotDefault())
    {
      p_implData.setAssignmentManager(null);
    }
    if(! p_implData.getCatalogJanitorEnabled__IsNotDefault())
    {
      p_implData.setCatalogJanitorEnabled(true);
    }
    return p_implData;
  }
  public MasterStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    format = p_implData.getFormat();
    deadServers = p_implData.getDeadServers();
    filter = p_implData.getFilter();
    metaLocation = p_implData.getMetaLocation();
    frags = p_implData.getFrags();
    serverManager = p_implData.getServerManager();
    servers = p_implData.getServers();
    assignmentManager = p_implData.getAssignmentManager();
    catalogJanitorEnabled = p_implData.getCatalogJanitorEnabled();
  }
  
  public void renderNoFlush(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 58, 1
    if (format.equals("json") )
    {
      // 58, 30
      jamonWriter.write("\n  ");
      // 59, 3
      {
        org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_0 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_0.setFormat("json" );
        __jamon__var_0.setFilter(filter);
        __jamon__var_0.renderNoFlush(jamonWriter);
      }
      // 59, 68
      jamonWriter.write("\n  ");
      // 60, 3
      return; 
    }
    // 61, 7
    jamonWriter.write("\n");
    // 62, 1
    
ServerManager serverManager = master.getServerManager();
AssignmentManager assignmentManager = master.getAssignmentManager();

    // 94, 1
    jamonWriter.write("<!--[if IE]>\n<!DOCTYPE html>\n<![endif]-->\n<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <title>Master: ");
    // 101, 20
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
    // 101, 62
    jamonWriter.write("</title>\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">\n    <meta name=\"description\" content=\"\">\n    <link href=\"/static/css/bootstrap.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/bootstrap-theme.min.css\" rel=\"stylesheet\">\n    <link href=\"/static/css/hbase.css\" rel=\"stylesheet\">\n  </head>\n\n  <body>\n\n    <div class=\"navbar  navbar-fixed-top navbar-default\">\n        <div class=\"container\">\n            <div class=\"navbar-header\">\n                <button type=\"button\" class=\"navbar-toggle\" data-toggle=\"collapse\" data-target=\".navbar-collapse\">\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                    <span class=\"icon-bar\"></span>\n                </button>\n                <a class=\"navbar-brand\" href=\"/master-status\"><img src=\"/static/hbase_logo_small.png\" alt=\"HBase Logo\"/></a>\n            </div>\n            <div class=\"collapse navbar-collapse\">\n                <ul class=\"nav navbar-nav\">\n                <li class=\"active\"><a href=\"/\">Home</a></li>\n                <li><a href=\"/tablesDetailed.jsp\">Table Details</a></li>\n                <li><a href=\"/logs/\">Local Logs</a></li>\n                <li><a href=\"/logLevel\">Log Level</a></li>\n                <li><a href=\"/dump\">Debug Dump</a></li>\n                <li><a href=\"/jmx\">Metrics Dump</a></li>\n                ");
    // 129, 17
    if (HBaseConfiguration.isShowConfInServlet())
    {
      // 129, 64
      jamonWriter.write("\n                <li><a href=\"/conf\">HBase Configuration</a></li>\n                ");
    }
    // 131, 23
    jamonWriter.write("\n               </ul>\n            </div><!--/.nav-collapse -->\n        </div>\n    </div>\n\n    <div class=\"container\">\n\t");
    // 138, 2
    if (master.isActiveMaster() )
    {
      // 138, 33
      jamonWriter.write("\n        <div class=\"row inner_header\">\n            <div class=\"page-header\">\n                <h1>Master <small>");
      // 141, 35
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
      // 141, 77
      jamonWriter.write(" </small></h1>\n            </div>\n        </div>\n\n        <div class=\"row\">\n        <!-- Various warnings that cluster admins should be aware of -->\n        ");
      // 147, 9
      if (JvmVersion.isBadJvmVersion() )
      {
        // 147, 45
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Your current JVM version ");
        // 149, 36
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(System.getProperty("java.version")), jamonWriter);
        // 149, 76
        jamonWriter.write(" is known to be\n          unstable with HBase. Please see the\n          <a href=\"http://wiki.apache.org/hadoop/Hbase/Troubleshooting#A18\">HBase wiki</a>\n          for details.\n          </div>\n        ");
      }
      // 154, 15
      jamonWriter.write("\n        ");
      // 155, 9
      if (master.isInitialized() && !catalogJanitorEnabled )
      {
        // 155, 65
        jamonWriter.write("\n          <div class=\"alert alert-error\">\n          Please note that your cluster is running with the CatalogJanitor disabled. It can be\n          re-enabled from the hbase shell by running the command 'catalogjanitor_switch true'\n          </div>\n        ");
      }
      // 160, 15
      jamonWriter.write("\n        ");
      // 161, 9
      if (!master.isBalancerOn() )
      {
        // 161, 39
        jamonWriter.write("\n          <div class=\"alert alert-warning\">\n            The Load Balancer is not enabled which will eventually cause performance degradation\n            in HBase as Regions will not be distributed across all RegionServers. The balancer\n            is only expected to be disabled during rolling upgrade scenarios.\n          </div>\n        ");
      }
      // 167, 15
      jamonWriter.write("\n\n        <section>\n            <h2>Region Servers</h2>\n            ");
      // 171, 13
      {
        org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl __jamon__var_1 = new org.apache.hadoop.hbase.tmpl.master.RegionServerListTmpl(this.getTemplateManager());
        __jamon__var_1.setServers(servers );
        __jamon__var_1.renderNoFlush(jamonWriter, master);
      }
      // 171, 74
      jamonWriter.write("\n\n            ");
      // 173, 13
      if ((deadServers != null) )
      {
        // 173, 42
        jamonWriter.write("\n                ");
        // 174, 17
        {
          // 174, 17
          __jamon_innerUnit__deadRegionServers(jamonWriter);
        }
        // 174, 40
        jamonWriter.write("\n            ");
      }
      // 175, 19
      jamonWriter.write("\n        </section>\n        <section>\n            ");
      // 178, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_2 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_2.renderNoFlush(jamonWriter, master );
      }
      // 178, 58
      jamonWriter.write("\n        </section>\n        <section>\n            <h2>Tables</h2>\n            <div class=\"tabbable\">\n                <ul class=\"nav nav-pills\">\n                    <li class=\"active\">\n                        <a href=\"#tab_userTables\" data-toggle=\"tab\">User Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_catalogTables\" data-toggle=\"tab\">System Tables</a>\n                    </li>\n                    <li class=\"\">\n                        <a href=\"#tab_userSnapshots\" data-toggle=\"tab\">Snapshots</a>\n                    </li>\n                </ul>\n                <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n                    <div class=\"tab-pane active\" id=\"tab_userTables\">\n                        ");
      // 196, 25
      if ((metaLocation != null) )
      {
        // 196, 55
        jamonWriter.write("\n                            ");
        // 197, 29
        {
          // 197, 29
          __jamon_innerUnit__userTables(jamonWriter);
        }
        // 197, 45
        jamonWriter.write("\n                        ");
      }
      // 198, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_catalogTables\">\n                        ");
      // 201, 25
      if ((metaLocation != null) )
      {
        // 201, 55
        jamonWriter.write("\n                            ");
        // 202, 29
        {
          // 202, 29
          __jamon_innerUnit__catalogTables(jamonWriter);
        }
        // 202, 48
        jamonWriter.write("\n                        ");
      }
      // 203, 31
      jamonWriter.write("\n                    </div>\n                    <div class=\"tab-pane\" id=\"tab_userSnapshots\">\n                        ");
      // 206, 25
      {
        // 206, 25
        __jamon_innerUnit__userSnapshots(jamonWriter);
      }
      // 206, 44
      jamonWriter.write("\n                    </div>\n                </div>\n            </div>\n        </section>\n        ");
      // 211, 9
      if (master.getAssignmentManager() != null )
      {
        // 211, 54
        jamonWriter.write("\n        ");
        // 212, 9
        {
          org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl __jamon__var_3 = new org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl(this.getTemplateManager());
          __jamon__var_3.renderNoFlush(jamonWriter, master.getAssignmentManager());
        }
        // 212, 90
        jamonWriter.write("\n        ");
      }
      // 213, 15
      jamonWriter.write("\n\t");
    }
    // 214, 2
    else
    {
      // 214, 9
      jamonWriter.write("\n        <section>\n            ");
      // 216, 13
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_4 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_4.renderNoFlush(jamonWriter, master );
      }
      // 216, 58
      jamonWriter.write("\n        </section>\n\t");
    }
    // 218, 8
    jamonWriter.write("    \n\n\n        <section>\n            ");
    // 222, 13
    {
      org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_5 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
      __jamon__var_5.setFilter(filter );
      __jamon__var_5.renderNoFlush(jamonWriter);
    }
    // 222, 61
    jamonWriter.write("\n        </section>\n\n        <section>\n            <h2>Software Attributes</h2>\n            <table id=\"attributes_table\" class=\"table table-striped\">\n                <tr>\n                    <th>Attribute Name</th>\n                    <th>Value</th>\n                    <th>Description</th>\n                </tr>\n                <tr>\n                    <td>HBase Version</td>\n                    <td>");
    // 235, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getVersion()), jamonWriter);
    // 235, 84
    jamonWriter.write(", revision=");
    // 235, 95
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getRevision()), jamonWriter);
    // 235, 155
    jamonWriter.write("</td><td>HBase version and revision</td>\n                </tr>\n                <tr>\n                    <td>HBase Compiled</td>\n                    <td>");
    // 239, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getDate()), jamonWriter);
    // 239, 81
    jamonWriter.write(", ");
    // 239, 83
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getUser()), jamonWriter);
    // 239, 139
    jamonWriter.write("</td>\n                    <td>When HBase version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>HBase Source Checksum</td>\n                    <td>");
    // 244, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 244, 88
    jamonWriter.write("</td>\n                    <td>HBase source MD5 checksum</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Version</td>\n                    <td>");
    // 249, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getVersion()), jamonWriter);
    // 249, 78
    jamonWriter.write(", revision=");
    // 249, 89
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getRevision()), jamonWriter);
    // 249, 143
    jamonWriter.write("</td>\n                    <td>Hadoop version and revision</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Compiled</td>\n                    <td>");
    // 254, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getDate()), jamonWriter);
    // 254, 75
    jamonWriter.write(", ");
    // 254, 77
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getUser()), jamonWriter);
    // 254, 127
    jamonWriter.write("</td>\n                    <td>When Hadoop version was compiled and by whom</td>\n                </tr>\n                <tr>\n                    <td>Hadoop Source Checksum</td>\n                    <td>");
    // 259, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getSrcChecksum()), jamonWriter);
    // 259, 82
    jamonWriter.write("</td>\n                    <td>Hadoop source MD5 checksum</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Client Version</td>\n                    <td>");
    // 264, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getVersion()), jamonWriter);
    // 264, 72
    jamonWriter.write(", revision=");
    // 264, 83
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getRevision()), jamonWriter);
    // 264, 131
    jamonWriter.write("</td>\n                    <td>ZooKeeper client version and revision</td>\n                </tr>\n                <tr>\n                    <td>ZooKeeper Client Compiled</td>\n                    <td>");
    // 269, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.zookeeper.Version.getBuildDate()), jamonWriter);
    // 269, 74
    jamonWriter.write("</td>\n                    <td>When ZooKeeper client version was compiled</td>\n                </tr>\n                <tr>\n                    <td>Zookeeper Quorum</td>\n                    <td> ");
    // 275, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(formatZKString()), jamonWriter);
    // 275, 48
    jamonWriter.write(" </td>\n                    <td>Addresses of all registered ZK servers. For more, see <a href=\"/zk.jsp\">zk dump</a>.</td>\n                </tr>\n                <tr>\n                    <td>Zookeeper Base Path</td>\n                    <td> ");
    // 280, 26
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getZooKeeper().getBaseZNode()), jamonWriter);
    // 280, 68
    jamonWriter.write("</td>\n                    <td>Root node of this cluster in ZK.</td>\n                </tr>\n                <tr>\n                    <td>HBase Root Directory</td>\n                    <td>");
    // 285, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(FSUtils.getRootDir(master.getConfiguration()).toString()), jamonWriter);
    // 285, 87
    jamonWriter.write("</td>\n                    <td>Location of HBase home directory</td>\n                </tr>\n                <tr>\n                    <td>HMaster Start Time</td>\n                    <td>");
    // 290, 25
    org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterStartTime())), jamonWriter);
    // 290, 68
    jamonWriter.write("</td>\n                    <td>Date stamp of when this HMaster was started</td>\n                </tr>\n                ");
    // 293, 17
    if (master.isActiveMaster() )
    {
      // 293, 48
      jamonWriter.write("\n\t                <tr>\n\t                    <td>HMaster Active Time</td>\n\t                    <td>");
      // 296, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterActiveTime())), jamonWriter);
      // 296, 70
      jamonWriter.write("</td>\n\t                    <td>Date stamp of when this HMaster became active</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>HBase Cluster ID</td>\n\t                    <td>");
      // 301, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getClusterId() != null ? master.getClusterId() : "Not set"), jamonWriter);
      // 301, 97
      jamonWriter.write("</td>\n\t                    <td>Unique identifier generated for each HBase cluster</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>Load average</td>\n\t                    <td>");
      // 306, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerManager() == null ? "0.00" :
	                      StringUtils.limitDecimalTo2(master.getServerManager().getAverageLoad())), jamonWriter);
      // 307, 98
      jamonWriter.write("</td>\n\t                    <td>Average number of regions per regionserver. Naive computation.</td>\n\t                </tr>\n\t                ");
      // 310, 18
      if (frags != null )
      {
        // 310, 39
        jamonWriter.write("\n\t                <tr>\n\t                    <td>Fragmentation</td>\n\t                    <td>");
        // 313, 26
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get("-TOTAL-") != null ? frags.get("-TOTAL-").intValue() + "%" : "n/a"), jamonWriter);
        // 313, 108
        jamonWriter.write("</td>\n\t                    <td>Overall fragmentation of all tables, including hbase:meta</td>\n\t                </tr>\n\t                ");
      }
      // 316, 24
      jamonWriter.write("\n\t                <tr>\n\t                    <td>Coprocessors</td>\n\t                    <td>");
      // 319, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getMasterCoprocessorHost() == null ? "[]" :
	                      java.util.Arrays.toString(master.getMasterCoprocessors())), jamonWriter);
      // 320, 84
      jamonWriter.write("</td>\n\t                    <td>Coprocessors currently loaded by the master</td>\n\t                </tr>\n\t                <tr>\n\t                    <td>LoadBalancer</td>\n\t                    <td>");
      // 325, 26
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(master.getLoadBalancerClassName()), jamonWriter);
      // 325, 65
      jamonWriter.write("</td>\n\t                    <td>LoadBalancer to be used in the Master</td>\n\t                </tr>\n                ");
    }
    // 328, 23
    jamonWriter.write("\n            </table>\n        </section>\n        </div>\n    </div> <!-- /container -->\n\n    <script src=\"/static/js/jquery.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/bootstrap.min.js\" type=\"text/javascript\"></script>\n    <script src=\"/static/js/tab.js\" type=\"text/javascript\"></script>\n  </body>\n</html>\n\n");
  }
  
  
  // 443, 1
  private void __jamon_innerUnit__userSnapshots(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 444, 1
    
   List<SnapshotDescription> snapshots = null;
   try (Admin admin = master.getConnection().getAdmin()) {
     snapshots = master.isInitialized() ? admin.listSnapshots() : null;
   }

    // 450, 1
    if ((snapshots != null && snapshots.size() > 0))
    {
      // 450, 51
      jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Snapshot Name</th>\n        <th>Table</th>\n        <th>Creation Time</th>\n    </tr>\n    ");
      // 457, 5
      for (SnapshotDescription snapshotDesc : snapshots)
      {
        // 457, 57
        jamonWriter.write("\n    ");
        // 458, 5
        
        TableName snapshotTable = TableName.valueOf(snapshotDesc.getTable());
    
        // 461, 5
        jamonWriter.write("<tr>\n        <td><a href=\"snapshot.jsp?name=");
        // 462, 40
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
        // 462, 68
        jamonWriter.write("\">");
        // 462, 70
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
        // 462, 98
        jamonWriter.write("</a> </td>\n        <td><a href=\"table.jsp?name=");
        // 463, 37
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotTable.getNameAsString()), jamonWriter);
        // 463, 74
        jamonWriter.write("\">");
        // 463, 76
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshotTable.getNameAsString()), jamonWriter);
        // 463, 113
        jamonWriter.write("</a>\n        </td>\n        <td>");
        // 465, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(new Date(snapshotDesc.getCreationTime())), jamonWriter);
        // 465, 59
        jamonWriter.write("</td>\n    </tr>\n    ");
      }
      // 467, 12
      jamonWriter.write("\n    <p>");
      // 468, 8
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(snapshots.size()), jamonWriter);
      // 468, 30
      jamonWriter.write(" snapshot(s) in set.</p>\n</table>\n");
    }
    // 470, 7
    jamonWriter.write("\n");
  }
  
  
  // 340, 1
  private void __jamon_innerUnit__catalogTables(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 341, 1
    
 HTableDescriptor[] sysTables = null;
 try (Admin admin = master.getConnection().getAdmin()) {
   sysTables = master.isInitialized() ? admin.listTableDescriptorsByNamespace(
     NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR) : null;
 }

    // 348, 1
    if ((sysTables != null && sysTables.length > 0))
    {
      // 348, 51
      jamonWriter.write("\n<table class=\"table table-striped\">\n<tr>\n    <th>Table Name</th>\n    ");
      // 352, 5
      if ((frags != null) )
      {
        // 352, 28
        jamonWriter.write("\n        <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n    ");
      }
      // 354, 11
      jamonWriter.write("\n    <th>Description</th>\n</tr>\n");
      // 357, 1
      for (HTableDescriptor systemTable : sysTables)
      {
        // 357, 49
        jamonWriter.write("\n<tr>\n");
        // 359, 1
        TableName tableName = systemTable.getTableName();
        // 360, 5
        jamonWriter.write("<td><a href=\"table.jsp?name=");
        // 360, 33
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
        // 360, 48
        jamonWriter.write("\">");
        // 360, 50
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tableName), jamonWriter);
        // 360, 65
        jamonWriter.write("</a></td>\n    ");
        // 361, 5
        if ((frags != null))
        {
          // 361, 27
          jamonWriter.write("\n        <td align=\"center\">");
          // 362, 28
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(tableName.getNameAsString()) != null ? frags.get(tableName.getNameAsString())
        .intValue() + "%" : "n/a"), jamonWriter);
          // 363, 37
          jamonWriter.write("</td>\n    ");
        }
        // 364, 11
        jamonWriter.write("\n    ");
        // 365, 5
        String description = null;
        if (tableName.equals(TableName.META_TABLE_NAME)){
            description = "The hbase:meta table holds references to all User Table regions";
        } else if (tableName.equals(AccessControlLists.ACL_TABLE_NAME)){
            description = "The hbase:acl table holds information about acl";
	 } else if (tableName.equals(VisibilityConstants.LABELS_TABLE_NAME)){
	     description = "The hbase:labels table holds information about visibility labels";
        } else {
            description = "The .NAMESPACE. table holds information about namespaces.";
        }
    
        // 376, 5
        jamonWriter.write("<td>");
        // 376, 9
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(description), jamonWriter);
        // 376, 26
        jamonWriter.write("</td>\n</tr>\n");
      }
      // 378, 8
      jamonWriter.write("\n</table>\n");
    }
    // 380, 7
    jamonWriter.write("\n");
  }
  
  
  // 383, 1
  private void __jamon_innerUnit__userTables(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 384, 1
    
   HTableDescriptor[] tables = null; 
   try (Admin admin = master.getConnection().getAdmin()) {
     tables = master.isInitialized() ? admin.listTables() : null;
   }

    // 390, 1
    if ((tables != null && tables.length > 0))
    {
      // 390, 45
      jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Namespace</th>\n        <th>Table Name</th>\n        ");
      // 395, 9
      if ((frags != null) )
      {
        // 395, 32
        jamonWriter.write("\n            <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n        ");
      }
      // 397, 15
      jamonWriter.write("\n        <th>Online Regions</th>\n        <th>Offline Regions</th>\n        <th>Failed Regions</th>\n        <th>Split Regions</th>\n        <th>Other Regions</th>\n        <th>Description</th>\n    </tr>\n    ");
      // 405, 5
      for (HTableDescriptor htDesc : tables)
      {
        // 405, 45
        jamonWriter.write("\n    ");
        // 406, 5
        
      Map<RegionState.State, List<HRegionInfo>> tableRegions =
          master.getAssignmentManager().getRegionStates()
            .getRegionByStateOfTable(htDesc.getTableName());
      int openRegionsCount = tableRegions.get(RegionState.State.OPEN).size();
      int offlineRegionsCount = tableRegions.get(RegionState.State.OFFLINE).size();
      int splitRegionsCount = tableRegions.get(RegionState.State.SPLIT).size();
      int failedRegionsCount = tableRegions.get(RegionState.State.FAILED_OPEN).size()
             + tableRegions.get(RegionState.State.FAILED_CLOSE).size();
      int otherRegionsCount = 0;
      for (List<HRegionInfo> list: tableRegions.values()) {
         otherRegionsCount += list.size();
      }
      // now subtract known states
      otherRegionsCount = otherRegionsCount - openRegionsCount
                     - failedRegionsCount - offlineRegionsCount
                     - splitRegionsCount;
    
        // 424, 5
        jamonWriter.write("<tr>\n        <td>");
        // 425, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.getTableName().getNamespaceAsString()), jamonWriter);
        // 425, 63
        jamonWriter.write("</td>\n        <td><a href=table.jsp?name=");
        // 426, 36
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.getTableName().getNameAsString()), jamonWriter);
        // 426, 81
        jamonWriter.write(">");
        // 426, 82
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.getTableName().getQualifierAsString()), jamonWriter);
        // 426, 132
        jamonWriter.write("</a> </td>\n        ");
        // 427, 9
        if ((frags != null) )
        {
          // 427, 32
          jamonWriter.write("\n            <td align=\"center\">");
          // 428, 32
          org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(htDesc.getTableName().getNameAsString()) != null ? frags.get(htDesc.getTableName().getQualifierAsString()).intValue() + "%" : "n/a"), jamonWriter);
          // 428, 179
          jamonWriter.write("</td>\n        ");
        }
        // 429, 15
        jamonWriter.write("\n        <td>");
        // 430, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(openRegionsCount), jamonWriter);
        // 430, 35
        jamonWriter.write("</td>\n        <td>");
        // 431, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(offlineRegionsCount), jamonWriter);
        // 431, 38
        jamonWriter.write("</td>\n        <td>");
        // 432, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(failedRegionsCount), jamonWriter);
        // 432, 37
        jamonWriter.write("</td>\n        <td>");
        // 433, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(splitRegionsCount), jamonWriter);
        // 433, 36
        jamonWriter.write("</td>\n        <td>");
        // 434, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(otherRegionsCount), jamonWriter);
        // 434, 36
        jamonWriter.write("</td>\n        <td>");
        // 435, 13
        org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.toStringCustomizedValues()), jamonWriter);
        // 435, 52
        jamonWriter.write("</td>\n    </tr>\n    ");
      }
      // 437, 12
      jamonWriter.write("\n    <p>");
      // 438, 8
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(tables.length), jamonWriter);
      // 438, 27
      jamonWriter.write(" table(s) in set. [<a href=tablesDetailed.jsp>Details</a>]</p>\n</table>\n");
    }
    // 440, 7
    jamonWriter.write("\n");
  }
  
  
  // 474, 1
  private void __jamon_innerUnit__deadRegionServers(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 476, 1
    if ((deadServers != null && deadServers.size() > 0))
    {
      // 476, 55
      jamonWriter.write("\n<h2>Dead Region Servers</h2>\n<table class=\"table table-striped\">\n    <tr>\n        <th></th>\n        <th>ServerName</th>\n        <th>Stop time</th>\n    </tr>\n    ");
      // 484, 5
      
       DeadServer deadServerUtil = master.getServerManager().getDeadServers();
       ServerName [] deadServerNames = deadServers.toArray(new ServerName[deadServers.size()]);
         Arrays.sort(deadServerNames);
         for (ServerName deadServerName: deadServerNames) {
    
      // 490, 5
      jamonWriter.write("<tr>\n    \t<th></th>\n        <td>");
      // 492, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerName), jamonWriter);
      // 492, 33
      jamonWriter.write("</td>\n        <td>");
      // 493, 13
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServerUtil.getTimeOfDeath(deadServerName)), jamonWriter);
      // 493, 64
      jamonWriter.write("</td>\n    </tr>\n    ");
      // 495, 5
      
        }
    
      // 498, 5
      jamonWriter.write("<tr>\n        <th>Total: </th>\n        <td>servers: ");
      // 500, 22
      org.jamon.escaping.Escaping.NONE.write(org.jamon.emit.StandardEmitter.valueOf(deadServers.size()), jamonWriter);
      // 500, 46
      jamonWriter.write("</td>\n        <th></th>\n    </tr>\n</table>\n");
    }
    // 504, 7
    jamonWriter.write("\n");
  }
  
  
}
