/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionThroughputController;
import org.apache.hadoop.hbase.regionserver.compactions.NoLimitCompactionThroughputController;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class CompactionThroughputControllerFactory {
    private static final Log LOG = LogFactory.getLog(CompactionThroughputControllerFactory.class);
    public static final String HBASE_THROUGHPUT_CONTROLLER_KEY = "hbase.regionserver.throughput.controller";
    private static final Class<? extends CompactionThroughputController> DEFAULT_THROUGHPUT_CONTROLLER_CLASS = NoLimitCompactionThroughputController.class;

    public static CompactionThroughputController create(RegionServerServices server, Configuration conf) {
        Class<? extends CompactionThroughputController> clazz = CompactionThroughputControllerFactory.getThroughputControllerClass(conf);
        CompactionThroughputController controller = (CompactionThroughputController)ReflectionUtils.newInstance(clazz, (Configuration)conf);
        controller.setup(server);
        return controller;
    }

    public static Class<? extends CompactionThroughputController> getThroughputControllerClass(Configuration conf) {
        String className = conf.get(HBASE_THROUGHPUT_CONTROLLER_KEY, DEFAULT_THROUGHPUT_CONTROLLER_CLASS.getName());
        try {
            return Class.forName(className).asSubclass(CompactionThroughputController.class);
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to load configured throughput controller '" + className + "', load default throughput controller " + DEFAULT_THROUGHPUT_CONTROLLER_CLASS.getName() + " instead"), (Throwable)e);
            return DEFAULT_THROUGHPUT_CONTROLLER_CLASS;
        }
    }
}

