/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;

@InterfaceAudience.Private
public class HBaseSaslRpcServer {
    public static final Log LOG = LogFactory.getLog(HBaseSaslRpcServer.class);

    public static void init(Configuration conf) {
        SaslUtil.initSaslProperties((String)conf.get("hbase.rpc.protection", SaslUtil.QualityOfProtection.AUTHENTICATION.name().toLowerCase()));
    }

    public static <T extends TokenIdentifier> T getIdentifier(String id, SecretManager<T> secretManager) throws SecretManager.InvalidToken {
        byte[] tokenId = SaslUtil.decodeIdentifier((String)id);
        TokenIdentifier tokenIdentifier = secretManager.createIdentifier();
        try {
            tokenIdentifier.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(tokenId)));
        }
        catch (IOException e) {
            throw (SecretManager.InvalidToken)new SecretManager.InvalidToken("Can't de-serialize tokenIdentifier").initCause((Throwable)e);
        }
        return (T)tokenIdentifier;
    }

    public static class SaslGssCallbackHandler
    implements CallbackHandler {
        @Override
        public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (!(callback instanceof AuthorizeCallback)) {
                    throw new UnsupportedCallbackException(callback, "Unrecognized SASL GSSAPI Callback");
                }
                ac = (AuthorizeCallback)callback;
            }
            if (ac != null) {
                String authzid;
                String authid = ac.getAuthenticationID();
                if (authid.equals(authzid = ac.getAuthorizationID())) {
                    ac.setAuthorized(true);
                } else {
                    ac.setAuthorized(false);
                }
                if (ac.isAuthorized()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("SASL server GSSAPI callback: setting canonicalized client ID: " + authzid));
                    }
                    ac.setAuthorizedID(authzid);
                }
            }
        }
    }

    public static class SaslDigestCallbackHandler
    implements CallbackHandler {
        private SecretManager<TokenIdentifier> secretManager;
        private RpcServer.Connection connection;

        public SaslDigestCallbackHandler(SecretManager<TokenIdentifier> secretManager, RpcServer.Connection connection) {
            this.secretManager = secretManager;
            this.connection = connection;
        }

        private char[] getPassword(TokenIdentifier tokenid) throws SecretManager.InvalidToken {
            return SaslUtil.encodePassword((byte[])this.secretManager.retrievePassword(tokenid));
        }

        @Override
        public void handle(Callback[] callbacks) throws SecretManager.InvalidToken, UnsupportedCallbackException {
            NameCallback nc = null;
            PasswordCallback pc = null;
            AuthorizeCallback ac = null;
            for (Callback callback : callbacks) {
                if (callback instanceof AuthorizeCallback) {
                    ac = (AuthorizeCallback)callback;
                    continue;
                }
                if (callback instanceof NameCallback) {
                    nc = (NameCallback)callback;
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    pc = (PasswordCallback)callback;
                    continue;
                }
                if (callback instanceof RealmCallback) continue;
                throw new UnsupportedCallbackException(callback, "Unrecognized SASL DIGEST-MD5 Callback");
            }
            if (pc != null) {
                TokenIdentifier tokenIdentifier = HBaseSaslRpcServer.getIdentifier(nc.getDefaultName(), this.secretManager);
                char[] password = this.getPassword(tokenIdentifier);
                UserGroupInformation user = null;
                this.connection.attemptingUser = user = tokenIdentifier.getUser();
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("SASL server DIGEST-MD5 callback: setting password for client: " + tokenIdentifier.getUser()));
                }
                pc.setPassword(password);
            }
            if (ac != null) {
                String authzid;
                String authid = ac.getAuthenticationID();
                if (authid.equals(authzid = ac.getAuthorizationID())) {
                    ac.setAuthorized(true);
                } else {
                    ac.setAuthorized(false);
                }
                if (ac.isAuthorized()) {
                    if (LOG.isTraceEnabled()) {
                        String username = HBaseSaslRpcServer.getIdentifier(authzid, this.secretManager).getUser().getUserName();
                        LOG.trace((Object)("SASL server DIGEST-MD5 callback: setting canonicalized client ID: " + username));
                    }
                    ac.setAuthorizedID(authzid);
                }
            }
        }
    }
}

