/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, SmallTests.class})
public class TestSnapshotManifest {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private static final String TABLE_NAME_STR = "testSnapshotManifest";
    private static final TableName TABLE_NAME = TableName.valueOf((String)"testSnapshotManifest");
    private static final int TEST_NUM_REGIONS = 16000;
    private static HBaseTestingUtility TEST_UTIL;
    private Configuration conf;
    private FileSystem fs;
    private Path rootDir;
    private Path snapshotDir;
    private HBaseProtos.SnapshotDescription snapshotDesc;

    @Before
    public void setup() throws Exception {
        TEST_UTIL = HBaseTestingUtility.createLocalHTU();
        this.rootDir = TEST_UTIL.getDataTestDir(TABLE_NAME_STR);
        this.fs = TEST_UTIL.getTestFileSystem();
        this.conf = TEST_UTIL.getConfiguration();
        SnapshotTestingUtils.SnapshotMock snapshotMock = new SnapshotTestingUtils.SnapshotMock(this.conf, this.fs, this.rootDir);
        SnapshotTestingUtils.SnapshotMock.SnapshotBuilder builder = snapshotMock.createSnapshotV2("snapshot", TABLE_NAME_STR, 0);
        this.snapshotDir = builder.commit();
        this.snapshotDesc = builder.getSnapshotDescription();
        SnapshotProtos.SnapshotDataManifest.Builder dataManifestBuilder = SnapshotProtos.SnapshotDataManifest.newBuilder();
        byte[] startKey = null;
        byte[] stopKey = null;
        for (int i = 1; i <= 16000; ++i) {
            stopKey = Bytes.toBytes((String)String.format("%016d", i));
            HRegionInfo regionInfo = new HRegionInfo(TABLE_NAME, startKey, stopKey, false);
            SnapshotProtos.SnapshotRegionManifest.Builder dataRegionManifestBuilder = SnapshotProtos.SnapshotRegionManifest.newBuilder();
            for (HColumnDescriptor hcd : builder.getTableDescriptor().getFamilies()) {
                SnapshotProtos.SnapshotRegionManifest.FamilyFiles.Builder family = SnapshotProtos.SnapshotRegionManifest.FamilyFiles.newBuilder();
                family.setFamilyName(ByteStringer.wrap((byte[])hcd.getName()));
                for (int j = 0; j < 100; ++j) {
                    SnapshotProtos.SnapshotRegionManifest.StoreFile.Builder sfManifest = SnapshotProtos.SnapshotRegionManifest.StoreFile.newBuilder();
                    sfManifest.setName(String.format("%032d", i));
                    sfManifest.setFileSize((long)((1 + i) * (1 + i) * 1024));
                    family.addStoreFiles(sfManifest.build());
                }
                dataRegionManifestBuilder.addFamilyFiles(family.build());
            }
            dataRegionManifestBuilder.setRegionInfo(HRegionInfo.convert((HRegionInfo)regionInfo));
            dataManifestBuilder.addRegionManifests(dataRegionManifestBuilder.build());
            startKey = stopKey;
        }
        dataManifestBuilder.setTableSchema(builder.getTableDescriptor().convert());
        SnapshotProtos.SnapshotDataManifest dataManifest = dataManifestBuilder.build();
        this.writeDataManifest(dataManifest);
    }

    @After
    public void tearDown() throws Exception {
        this.fs.delete(this.rootDir, true);
    }

    @Test
    public void testReadSnapshotManifest() throws IOException {
        try {
            SnapshotManifest.open((Configuration)this.conf, (FileSystem)this.fs, (Path)this.snapshotDir, (HBaseProtos.SnapshotDescription)this.snapshotDesc);
            Assert.fail((String)"fail to test snapshot manifest because message size is too small.");
        }
        catch (CorruptedSnapshotException cse) {
            try {
                this.conf.setInt("snapshot.manifest.size.limit", 0x8000000);
                SnapshotManifest.open((Configuration)this.conf, (FileSystem)this.fs, (Path)this.snapshotDir, (HBaseProtos.SnapshotDescription)this.snapshotDesc);
                this.LOG.info((Object)"open snapshot manifest succeed.");
            }
            catch (CorruptedSnapshotException cse2) {
                Assert.fail((String)"fail to take snapshot because Manifest proto-message too large.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeDataManifest(SnapshotProtos.SnapshotDataManifest manifest) throws IOException {
        try (FSDataOutputStream stream = this.fs.create(new Path(this.snapshotDir, "data.manifest"));){
            manifest.writeTo((OutputStream)stream);
        }
    }
}

