/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Service;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.TagRewriteCell;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.replication.ReplicationEndpoint;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.WALEntryFilter;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelService;
import org.apache.hadoop.hbase.security.visibility.VisibilityUtils;
import org.apache.hadoop.hbase.wal.WAL;

@InterfaceAudience.Private
public class VisibilityReplicationEndpoint
implements ReplicationEndpoint {
    private static final Log LOG = LogFactory.getLog(VisibilityReplicationEndpoint.class);
    private ReplicationEndpoint delegator;
    private VisibilityLabelService visibilityLabelsService;

    public VisibilityReplicationEndpoint(ReplicationEndpoint endpoint, VisibilityLabelService visibilityLabelsService) {
        this.delegator = endpoint;
        this.visibilityLabelsService = visibilityLabelsService;
    }

    @Override
    public void init(ReplicationEndpoint.Context context) throws IOException {
        this.delegator.init(context);
    }

    @Override
    public boolean replicate(ReplicationEndpoint.ReplicateContext replicateContext) {
        if (!this.delegator.canReplicateToSameCluster()) {
            List<WAL.Entry> entries = replicateContext.getEntries();
            ArrayList<Tag> visTags = new ArrayList<Tag>();
            ArrayList<Tag> nonVisTags = new ArrayList<Tag>();
            ArrayList<WAL.Entry> newEntries = new ArrayList<WAL.Entry>(entries.size());
            for (WAL.Entry entry : entries) {
                WALEdit newEdit = new WALEdit();
                ArrayList<Cell> cells = entry.getEdit().getCells();
                for (Cell cell : cells) {
                    if (cell.getTagsLength() > 0) {
                        visTags.clear();
                        nonVisTags.clear();
                        Byte serializationFormat = VisibilityUtils.extractAndPartitionTags(cell, visTags, nonVisTags);
                        if (!visTags.isEmpty()) {
                            block7: {
                                try {
                                    byte[] modifiedVisExpression = this.visibilityLabelsService.encodeVisibilityForReplication(visTags, serializationFormat);
                                    if (modifiedVisExpression == null) break block7;
                                    nonVisTags.add(new Tag(7, modifiedVisExpression));
                                }
                                catch (Exception ioe) {
                                    LOG.error((Object)("Exception while reading the visibility labels from the cell. The replication would happen as per the existing format and not as string type for the cell " + cell + "."), (Throwable)ioe);
                                    newEdit.add(cell);
                                    continue;
                                }
                            }
                            TagRewriteCell newCell = new TagRewriteCell(cell, Tag.fromList(nonVisTags));
                            newEdit.add(newCell);
                            continue;
                        }
                        newEdit.add(cell);
                        continue;
                    }
                    newEdit.add(cell);
                }
                newEntries.add(new WAL.Entry(entry.getKey(), newEdit));
            }
            replicateContext.setEntries(newEntries);
            return this.delegator.replicate(replicateContext);
        }
        return this.delegator.replicate(replicateContext);
    }

    @Override
    public synchronized UUID getPeerUUID() {
        return this.delegator.getPeerUUID();
    }

    @Override
    public boolean canReplicateToSameCluster() {
        return this.delegator.canReplicateToSameCluster();
    }

    @Override
    public WALEntryFilter getWALEntryfilter() {
        return this.delegator.getWALEntryfilter();
    }

    public boolean isRunning() {
        return this.delegator.isRunning();
    }

    public ListenableFuture<Service.State> start() {
        return this.delegator.start();
    }

    public Service.State startAndWait() {
        return this.delegator.startAndWait();
    }

    public Service.State state() {
        return this.delegator.state();
    }

    public ListenableFuture<Service.State> stop() {
        return this.delegator.stop();
    }

    public Service.State stopAndWait() {
        return this.delegator.stopAndWait();
    }

    public void peerConfigUpdated(ReplicationPeerConfig rpc) {
    }
}

