/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.math.BigDecimal;
import java.util.List;
import java.util.NavigableMap;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.StoppableImplementation;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.util.StringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MediumTests.class})
public class TestMetaScanner {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Connection connection;

    public void setUp() throws Exception {
        TEST_UTIL.startMiniCluster(1);
        this.connection = TEST_UTIL.getConnection();
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMetaScanner() throws Exception {
        this.LOG.info((Object)"Starting testMetaScanner");
        this.setUp();
        TableName TABLENAME = TableName.valueOf((String)"testMetaScanner");
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[][] SPLIT_KEYS = new byte[][]{Bytes.toBytes((String)"region_a"), Bytes.toBytes((String)"region_b")};
        TEST_UTIL.createTable(TABLENAME, FAMILY, (byte[][])SPLIT_KEYS);
        HTable table = (HTable)this.connection.getTable(TABLENAME);
        TEST_UTIL.countRows((Table)table);
        MetaScanner.MetaScannerVisitor visitor = (MetaScanner.MetaScannerVisitor)Mockito.mock(MetaScanner.MetaScannerVisitor.class);
        ((MetaScanner.MetaScannerVisitor)Mockito.doReturn((Object)true).when((Object)visitor)).processRow((Result)Matchers.anyObject());
        MetaScanner.metaScan((Connection)this.connection, (MetaScanner.MetaScannerVisitor)visitor, (TableName)TABLENAME);
        ((MetaScanner.MetaScannerVisitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)3))).processRow((Result)Matchers.anyObject());
        Mockito.reset((Object[])new MetaScanner.MetaScannerVisitor[]{visitor});
        ((MetaScanner.MetaScannerVisitor)Mockito.doReturn((Object)true).when((Object)visitor)).processRow((Result)Matchers.anyObject());
        MetaScanner.metaScan((Connection)this.connection, (MetaScanner.MetaScannerVisitor)visitor, (TableName)TABLENAME, (byte[])HConstants.EMPTY_BYTE_ARRAY, (int)1000);
        ((MetaScanner.MetaScannerVisitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)3))).processRow((Result)Matchers.anyObject());
        Mockito.reset((Object[])new MetaScanner.MetaScannerVisitor[]{visitor});
        ((MetaScanner.MetaScannerVisitor)Mockito.doReturn((Object)true).when((Object)visitor)).processRow((Result)Matchers.anyObject());
        MetaScanner.metaScan((Connection)this.connection, (MetaScanner.MetaScannerVisitor)visitor, (TableName)TABLENAME, (byte[])Bytes.toBytes((String)"region_ac"), (int)1000);
        ((MetaScanner.MetaScannerVisitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)2))).processRow((Result)Matchers.anyObject());
        Mockito.reset((Object[])new MetaScanner.MetaScannerVisitor[]{visitor});
        ((MetaScanner.MetaScannerVisitor)Mockito.doReturn((Object)true).when((Object)visitor)).processRow((Result)Matchers.anyObject());
        MetaScanner.metaScan((Connection)this.connection, (MetaScanner.MetaScannerVisitor)visitor, (TableName)TABLENAME, (byte[])Bytes.toBytes((String)"region_ac"), (int)1);
        ((MetaScanner.MetaScannerVisitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)1))).processRow((Result)Matchers.anyObject());
        try {
            MetaScanner.metaScan((Connection)this.connection, (MetaScanner.MetaScannerVisitor)visitor, (TableName)TABLENAME, (byte[])Bytes.toBytes((String)"region_ac"), (int)1, (TableName)TableName.valueOf((String)"invalidMeta"));
            Assert.fail((String)"Passed invalid meta table name but it is not honored");
        }
        catch (TableNotFoundException tableNotFoundException) {
            // empty catch block
        }
        table.close();
    }

    @Test
    public void testConcurrentMetaScannerAndCatalogJanitor() throws Throwable {
        TEST_UTIL.getConfiguration().setLong("hbase.catalogjanitor.interval", 500L);
        this.setUp();
        long runtime = 30000L;
        this.LOG.info((Object)"Starting testConcurrentMetaScannerAndCatalogJanitor");
        final TableName TABLENAME = TableName.valueOf((String)"testConcurrentMetaScannerAndCatalogJanitor");
        byte[] FAMILY = Bytes.toBytes((String)"family");
        TEST_UTIL.createTable(TABLENAME, FAMILY);
        class RegionMetaSplitter
        extends StoppableImplementation
        implements Runnable {
            Random random = new Random();
            Throwable ex = null;

            RegionMetaSplitter() {
            }

            @Override
            public void run() {
                while (!this.isStopped()) {
                    try {
                        List regions = MetaScanner.listAllRegions((Configuration)TEST_UTIL.getConfiguration(), (Connection)TestMetaScanner.this.connection, (boolean)false);
                        HRegionInfo parent = (HRegionInfo)regions.get(this.random.nextInt(regions.size()));
                        if (parent == null || !TABLENAME.equals((Object)parent.getTable())) continue;
                        long startKey = 0L;
                        long endKey = Long.MAX_VALUE;
                        byte[] start = parent.getStartKey();
                        byte[] end = parent.getEndKey();
                        if (!Bytes.equals((byte[])HConstants.EMPTY_START_ROW, (byte[])parent.getStartKey())) {
                            startKey = Bytes.toLong((byte[])parent.getStartKey());
                        }
                        if (!Bytes.equals((byte[])HConstants.EMPTY_END_ROW, (byte[])parent.getEndKey())) {
                            endKey = Bytes.toLong((byte[])parent.getEndKey());
                        }
                        if (startKey == endKey) continue;
                        long midKey = BigDecimal.valueOf(startKey).add(BigDecimal.valueOf(endKey)).divideToIntegralValue(BigDecimal.valueOf(2L)).longValue();
                        HRegionInfo splita = new HRegionInfo(TABLENAME, start, Bytes.toBytes((long)midKey));
                        HRegionInfo splitb = new HRegionInfo(TABLENAME, Bytes.toBytes((long)midKey), end);
                        MetaTableAccessor.splitRegion((Connection)TestMetaScanner.this.connection, (HRegionInfo)parent, (HRegionInfo)splita, (HRegionInfo)splitb, (ServerName)ServerName.valueOf((String)"fooserver", (int)1, (long)0L), (int)1);
                        Threads.sleep((long)this.random.nextInt(200));
                    }
                    catch (Throwable e) {
                        this.ex = e;
                        Assert.fail((String)StringUtils.stringifyException((Throwable)e));
                    }
                }
            }

            void rethrowExceptionIfAny() throws Throwable {
                if (this.ex != null) {
                    throw this.ex;
                }
            }
        }
        RegionMetaSplitter regionMetaSplitter = new RegionMetaSplitter();
        class MetaScannerVerifier
        extends StoppableImplementation
        implements Runnable {
            Random random = new Random();
            Throwable ex = null;

            MetaScannerVerifier() {
            }

            @Override
            public void run() {
                while (!this.isStopped()) {
                    try {
                        NavigableMap regions = MetaScanner.allTableRegions((Connection)TestMetaScanner.this.connection, (TableName)TABLENAME);
                        TestMetaScanner.this.LOG.info((Object)"-------");
                        byte[] lastEndKey = HConstants.EMPTY_START_ROW;
                        for (HRegionInfo hri : regions.navigableKeySet()) {
                            long startKey = 0L;
                            long endKey = Long.MAX_VALUE;
                            if (!Bytes.equals((byte[])HConstants.EMPTY_START_ROW, (byte[])hri.getStartKey())) {
                                startKey = Bytes.toLong((byte[])hri.getStartKey());
                            }
                            if (!Bytes.equals((byte[])HConstants.EMPTY_END_ROW, (byte[])hri.getEndKey())) {
                                endKey = Bytes.toLong((byte[])hri.getEndKey());
                            }
                            TestMetaScanner.this.LOG.info((Object)("start:" + startKey + " end:" + endKey + " hri:" + hri));
                            Assert.assertTrue((String)("lastEndKey=" + Bytes.toString((byte[])lastEndKey) + ", startKey=" + Bytes.toString((byte[])hri.getStartKey())), (boolean)Bytes.equals((byte[])lastEndKey, (byte[])hri.getStartKey()));
                            lastEndKey = hri.getEndKey();
                        }
                        Assert.assertTrue((boolean)Bytes.equals((byte[])lastEndKey, (byte[])HConstants.EMPTY_END_ROW));
                        TestMetaScanner.this.LOG.info((Object)"-------");
                        Threads.sleep((long)(10 + this.random.nextInt(50)));
                    }
                    catch (Throwable e) {
                        this.ex = e;
                        Assert.fail((String)StringUtils.stringifyException((Throwable)e));
                    }
                }
            }

            void rethrowExceptionIfAny() throws Throwable {
                if (this.ex != null) {
                    throw this.ex;
                }
            }
        }
        MetaScannerVerifier metaScannerVerifier = new MetaScannerVerifier();
        Thread regionMetaSplitterThread = new Thread(regionMetaSplitter);
        Thread metaScannerVerifierThread = new Thread(metaScannerVerifier);
        regionMetaSplitterThread.start();
        metaScannerVerifierThread.start();
        Threads.sleep((long)30000L);
        regionMetaSplitter.stop("test finished");
        metaScannerVerifier.stop("test finished");
        regionMetaSplitterThread.join();
        metaScannerVerifierThread.join();
        regionMetaSplitter.rethrowExceptionIfAny();
        metaScannerVerifier.rethrowExceptionIfAny();
    }
}

