/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestBlocksRead
extends HBaseTestCase {
    private static final Log LOG = LogFactory.getLog(TestBlocksRead.class);
    static final BloomType[] BLOOM_TYPE = new BloomType[]{BloomType.ROWCOL, BloomType.ROW, BloomType.NONE};
    private static BlockCache blockCache;
    HRegion region = null;
    private HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private final String DIR = this.TEST_UTIL.getDataTestDir("TestBlocksRead").toString();

    private HBaseConfiguration getConf() {
        HBaseConfiguration conf = new HBaseConfiguration();
        conf.setInt("hbase.hstore.compactionThreshold", 10000);
        return conf;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        EnvironmentEdgeManagerTestHelper.reset();
    }

    private HRegion initHRegion(byte[] tableName, String callingMethod, HBaseConfiguration conf, String family) throws IOException {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((byte[])tableName));
        for (int i = 0; i < BLOOM_TYPE.length; ++i) {
            BloomType bloomType = BLOOM_TYPE[i];
            HColumnDescriptor familyDesc = new HColumnDescriptor(family + "_" + bloomType).setBlocksize(1).setBloomFilterType(BLOOM_TYPE[i]);
            htd.addFamily(familyDesc);
        }
        HRegionInfo info = new HRegionInfo(htd.getTableName(), null, null, false);
        Path path = new Path(this.DIR + callingMethod);
        HRegion r = HRegion.createHRegion((HRegionInfo)info, (Path)path, (Configuration)conf, (HTableDescriptor)htd);
        blockCache = new CacheConfig((Configuration)conf).getBlockCache();
        return r;
    }

    private void putData(String family, String row, String col, long version) throws IOException {
        for (int i = 0; i < BLOOM_TYPE.length; ++i) {
            this.putData(Bytes.toBytes((String)(family + "_" + BLOOM_TYPE[i])), row, col, version, version);
        }
    }

    private static byte[] genValue(String row, String col, long version) {
        return Bytes.toBytes((String)("Value:" + row + "#" + col + "#" + version));
    }

    private void putData(byte[] cf, String row, String col, long versionStart, long versionEnd) throws IOException {
        byte[] columnBytes = Bytes.toBytes((String)col);
        Put put = new Put(Bytes.toBytes((String)row));
        put.setDurability(Durability.SKIP_WAL);
        for (long version = versionStart; version <= versionEnd; ++version) {
            put.add(cf, columnBytes, version, TestBlocksRead.genValue(row, col, version));
        }
        this.region.put(put);
    }

    private Cell[] getData(String family, String row, List<String> columns, int expBlocks) throws IOException {
        return this.getData(family, row, columns, expBlocks, expBlocks, expBlocks);
    }

    private Cell[] getData(String family, String row, List<String> columns, int expBlocksRowCol, int expBlocksRow, int expBlocksNone) throws IOException {
        int[] expBlocks = new int[]{expBlocksRowCol, expBlocksRow, expBlocksNone};
        Cell[] kvs = null;
        for (int i = 0; i < BLOOM_TYPE.length; ++i) {
            BloomType bloomType = BLOOM_TYPE[i];
            byte[] cf = Bytes.toBytes((String)(family + "_" + bloomType));
            long blocksStart = TestBlocksRead.getBlkAccessCount(cf);
            Get get = new Get(Bytes.toBytes((String)row));
            for (String column : columns) {
                get.addColumn(cf, Bytes.toBytes((String)column));
            }
            kvs = this.region.get(get).rawCells();
            long blocksEnd = TestBlocksRead.getBlkAccessCount(cf);
            if (expBlocks[i] != -1) {
                TestBlocksRead.assertEquals((String)("Blocks Read Check for Bloom: " + bloomType), (long)expBlocks[i], (long)(blocksEnd - blocksStart));
            }
            System.out.println("Blocks Read for Bloom: " + bloomType + " = " + (blocksEnd - blocksStart) + "Expected = " + expBlocks[i]);
        }
        return kvs;
    }

    private Cell[] getData(String family, String row, String column, int expBlocks) throws IOException {
        return this.getData(family, row, Arrays.asList(column), expBlocks, expBlocks, expBlocks);
    }

    private Cell[] getData(String family, String row, String column, int expBlocksRowCol, int expBlocksRow, int expBlocksNone) throws IOException {
        return this.getData(family, row, Arrays.asList(column), expBlocksRowCol, expBlocksRow, expBlocksNone);
    }

    private void deleteFamily(String family, String row, long version) throws IOException {
        Delete del = new Delete(Bytes.toBytes((String)row));
        del.deleteFamily(Bytes.toBytes((String)(family + "_ROWCOL")), version);
        del.deleteFamily(Bytes.toBytes((String)(family + "_ROW")), version);
        del.deleteFamily(Bytes.toBytes((String)(family + "_NONE")), version);
        this.region.delete(del);
    }

    private static void verifyData(Cell kv, String expectedRow, String expectedCol, long expectedVersion) {
        TestBlocksRead.assertTrue((String)"RowCheck", (boolean)CellUtil.matchingRow((Cell)kv, (byte[])Bytes.toBytes((String)expectedRow)));
        TestBlocksRead.assertTrue((String)"ColumnCheck", (boolean)CellUtil.matchingQualifier((Cell)kv, (byte[])Bytes.toBytes((String)expectedCol)));
        TestBlocksRead.assertEquals((String)"TSCheck", (long)expectedVersion, (long)kv.getTimestamp());
        TestBlocksRead.assertTrue((String)"ValueCheck", (boolean)CellUtil.matchingValue((Cell)kv, (byte[])TestBlocksRead.genValue(expectedRow, expectedCol, expectedVersion)));
    }

    private static long getBlkAccessCount(byte[] cf) {
        return HFile.DATABLOCK_READ_COUNT.get();
    }

    private static long getBlkCount() {
        return blockCache.getBlockCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlocksRead() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testBlocksRead");
        String FAMILY = "cf1";
        HBaseConfiguration conf = this.getConf();
        this.region = this.initHRegion(TABLE, this.getName(), conf, FAMILY);
        try {
            this.putData(FAMILY, "row", "col1", 1L);
            this.putData(FAMILY, "row", "col2", 2L);
            this.putData(FAMILY, "row", "col3", 3L);
            this.putData(FAMILY, "row", "col4", 4L);
            this.putData(FAMILY, "row", "col5", 5L);
            this.putData(FAMILY, "row", "col6", 6L);
            this.putData(FAMILY, "row", "col7", 7L);
            this.region.flush(true);
            Cell[] kvs = this.getData(FAMILY, "row", "col1", 1);
            TestBlocksRead.assertEquals((int)1, (int)kvs.length);
            TestBlocksRead.verifyData(kvs[0], "row", "col1", 1L);
            kvs = this.getData(FAMILY, "row", Arrays.asList("col1", "col2"), 2);
            TestBlocksRead.assertEquals((int)2, (int)kvs.length);
            TestBlocksRead.verifyData(kvs[0], "row", "col1", 1L);
            TestBlocksRead.verifyData(kvs[1], "row", "col2", 2L);
            kvs = this.getData(FAMILY, "row", Arrays.asList("col2", "col3"), 2);
            TestBlocksRead.assertEquals((int)2, (int)kvs.length);
            TestBlocksRead.verifyData(kvs[0], "row", "col2", 2L);
            TestBlocksRead.verifyData(kvs[1], "row", "col3", 3L);
            kvs = this.getData(FAMILY, "row", Arrays.asList("col5"), 1);
            TestBlocksRead.assertEquals((int)1, (int)kvs.length);
            TestBlocksRead.verifyData(kvs[0], "row", "col5", 5L);
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLazySeekBlocksRead() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testLazySeekBlocksRead");
        String FAMILY = "cf1";
        HBaseConfiguration conf = this.getConf();
        this.region = this.initHRegion(TABLE, this.getName(), conf, FAMILY);
        try {
            this.putData(FAMILY, "row", "col1", 1L);
            this.putData(FAMILY, "row", "col2", 2L);
            this.region.flush(true);
            this.putData(FAMILY, "row", "col1", 3L);
            this.putData(FAMILY, "row", "col2", 4L);
            this.region.flush(true);
            Cell[] kvs = this.getData(FAMILY, "row", Arrays.asList("col1"), 1);
            TestBlocksRead.assertEquals((int)1, (int)kvs.length);
            TestBlocksRead.verifyData(kvs[0], "row", "col1", 3L);
            kvs = this.getData(FAMILY, "row", Arrays.asList("col1", "col2"), 2);
            TestBlocksRead.assertEquals((int)2, (int)kvs.length);
            TestBlocksRead.verifyData(kvs[0], "row", "col1", 3L);
            TestBlocksRead.verifyData(kvs[1], "row", "col2", 4L);
            this.putData(FAMILY, "row", "col3", 5L);
            this.region.flush(true);
            kvs = this.getData(FAMILY, "row", "col3", 1);
            TestBlocksRead.assertEquals((int)1, (int)kvs.length);
            TestBlocksRead.verifyData(kvs[0], "row", "col3", 5L);
            kvs = this.getData(FAMILY, "row", Arrays.asList("col1"), 1, 2, 2);
            TestBlocksRead.assertEquals((int)1, (int)kvs.length);
            TestBlocksRead.verifyData(kvs[0], "row", "col1", 3L);
            this.deleteFamily(FAMILY, "row", 6L);
            this.region.flush(true);
            kvs = this.getData(FAMILY, "row", "col1", 2, 3, 3);
            TestBlocksRead.assertEquals((int)0, (int)kvs.length);
            kvs = this.getData(FAMILY, "row", "col2", 2, 3, 3);
            TestBlocksRead.assertEquals((int)0, (int)kvs.length);
            kvs = this.getData(FAMILY, "row", "col3", 2);
            TestBlocksRead.assertEquals((int)0, (int)kvs.length);
            kvs = this.getData(FAMILY, "row", Arrays.asList("col1", "col2", "col3"), 4);
            TestBlocksRead.assertEquals((int)0, (int)kvs.length);
            this.deleteFamily(FAMILY, "row", 10L);
            this.region.flush(true);
            this.putData(FAMILY, "row", "col1", 7L);
            this.putData(FAMILY, "row", "col2", 8L);
            this.putData(FAMILY, "row", "col3", 9L);
            this.region.flush(true);
            kvs = this.getData(FAMILY, "row", Arrays.asList("col1", "col2", "col3"), 6, 7, 7);
            TestBlocksRead.assertEquals((int)0, (int)kvs.length);
            this.putData(FAMILY, "row", "col1", 11L);
            this.putData(FAMILY, "row", "col2", 12L);
            this.putData(FAMILY, "row", "col3", 13L);
            this.region.flush(true);
            kvs = this.getData(FAMILY, "row", Arrays.asList("col1", "col2", "col3"), 8, 9, 9);
            TestBlocksRead.assertEquals((int)3, (int)kvs.length);
            TestBlocksRead.verifyData(kvs[0], "row", "col1", 11L);
            TestBlocksRead.verifyData(kvs[1], "row", "col2", 12L);
            TestBlocksRead.verifyData(kvs[2], "row", "col3", 13L);
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBlocksStoredWhenCachingDisabled() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testBlocksReadWhenCachingDisabled");
        String FAMILY = "cf1";
        HBaseConfiguration conf = this.getConf();
        this.region = this.initHRegion(TABLE, this.getName(), conf, FAMILY);
        try {
            this.putData(FAMILY, "row", "col1", 1L);
            this.putData(FAMILY, "row", "col2", 2L);
            this.region.flush(true);
            long blocksStart = TestBlocksRead.getBlkCount();
            Scan scan = new Scan();
            scan.setCacheBlocks(false);
            RegionScanner rs = this.region.getScanner(scan);
            ArrayList result = new ArrayList(2);
            rs.next(result);
            TestBlocksRead.assertEquals((int)(2 * BLOOM_TYPE.length), (int)result.size());
            rs.close();
            long blocksEnd = TestBlocksRead.getBlkCount();
            TestBlocksRead.assertEquals((long)blocksStart, (long)blocksEnd);
            blocksStart = blocksEnd;
            scan.setCacheBlocks(true);
            rs = this.region.getScanner(scan);
            result = new ArrayList(2);
            rs.next(result);
            TestBlocksRead.assertEquals((int)(2 * BLOOM_TYPE.length), (int)result.size());
            rs.close();
            blocksEnd = TestBlocksRead.getBlkCount();
            TestBlocksRead.assertEquals((long)(2 * BLOOM_TYPE.length), (long)(blocksEnd - blocksStart));
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLazySeekBlocksReadWithDelete() throws Exception {
        byte[] TABLE = Bytes.toBytes((String)"testLazySeekBlocksReadWithDelete");
        String FAMILY = "cf1";
        HBaseConfiguration conf = this.getConf();
        this.region = this.initHRegion(TABLE, this.getName(), conf, FAMILY);
        try {
            this.deleteFamily(FAMILY, "row", 200L);
            for (int i = 0; i < 100; ++i) {
                this.putData(FAMILY, "row", "col" + i, i);
            }
            this.putData(FAMILY, "row", "col99", 201L);
            this.region.flush(true);
            Cell[] kvs = this.getData(FAMILY, "row", Arrays.asList("col0"), 2);
            TestBlocksRead.assertEquals((int)0, (int)kvs.length);
            kvs = this.getData(FAMILY, "row", Arrays.asList("col99"), 2);
            TestBlocksRead.assertEquals((int)1, (int)kvs.length);
            TestBlocksRead.verifyData(kvs[0], "row", "col99", 201L);
        }
        finally {
            HRegion.closeHRegion((HRegion)this.region);
            this.region = null;
        }
    }
}

