/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.metrics.BaseSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsTableAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsTableWrapperAggregate;
import org.apache.hadoop.hbase.regionserver.MetricsTableWrapperStub;
import org.apache.hadoop.hbase.test.MetricsAssertHelper;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestMetricsTableAggregate {
    public static MetricsAssertHelper HELPER = (MetricsAssertHelper)CompatibilityFactory.getInstance(MetricsAssertHelper.class);

    @Test
    public void testTableWrapperAggregateMetrics() throws IOException {
        String tableName = "testTableMetrics";
        MetricsTableWrapperStub tableWrapper = new MetricsTableWrapperStub(tableName);
        ((MetricsRegionServerSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class)).createTable(tableName, (MetricsTableWrapperAggregate)tableWrapper);
        MetricsTableAggregateSource agg = ((MetricsRegionServerSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class)).getTableAggregate();
        HELPER.assertCounter("Namespace_default_table_testTableMetrics_metric_readRequestCount", 10L, (BaseSource)agg);
        HELPER.assertCounter("Namespace_default_table_testTableMetrics_metric_writeRequestCount", 20L, (BaseSource)agg);
        HELPER.assertCounter("Namespace_default_table_testTableMetrics_metric_totalRequestCount", 30L, (BaseSource)agg);
        HELPER.assertGauge("Namespace_default_table_testTableMetrics_metric_memstoreSize", 1000L, (BaseSource)agg);
        HELPER.assertGauge("Namespace_default_table_testTableMetrics_metric_storeFileSize", 2000L, (BaseSource)agg);
        HELPER.assertGauge("Namespace_default_table_testTableMetrics_metric_tableSize", 3000L, (BaseSource)agg);
    }
}

