/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.TestTableName;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={LargeTests.class})
public class TestScannerRetriableFailure {
    private static final Log LOG = LogFactory.getLog(TestScannerRetriableFailure.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final String FAMILY_NAME_STR = "f";
    private static final byte[] FAMILY_NAME = Bytes.toBytes((String)"f");
    @Rule
    public TestTableName TEST_TABLE = new TestTableName();

    private static void setupConf(Configuration conf) {
        conf.setLong("hbase.hstore.compaction.min", 20L);
        conf.setLong("hbase.hstore.compaction.max", 39L);
        conf.setLong("hbase.hstore.blockingStoreFiles", 40L);
        conf.set("hbase.coprocessor.region.classes", FaultyScannerObserver.class.getName());
    }

    @BeforeClass
    public static void setup() throws Exception {
        TestScannerRetriableFailure.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn((Object)"failure shutting down cluster", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testFaultyScanner() throws Exception {
        TableName tableName = this.TEST_TABLE.getTableName();
        try (HTable table = UTIL.createTable(tableName, FAMILY_NAME);){
            int NUM_ROWS = 100;
            this.loadTable((Table)table, 100);
            this.checkTableRows((Table)table, 100);
        }
    }

    private FileSystem getFileSystem() {
        return UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getFileSystem();
    }

    private Path getRootDir() {
        return UTIL.getHBaseCluster().getMaster().getMasterFileSystem().getRootDir();
    }

    public void loadTable(Table table, int numRows) throws IOException {
        for (int i = 0; i < numRows; ++i) {
            byte[] row = Bytes.toBytes((String)String.format("%09d", i));
            Put put = new Put(row);
            put.setDurability(Durability.SKIP_WAL);
            put.add(FAMILY_NAME, null, row);
            table.put(put);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTableRows(Table table, int numRows) throws Exception {
        Scan scan = new Scan();
        scan.setCaching(1);
        scan.setCacheBlocks(false);
        try (ResultScanner scanner = table.getScanner(scan);){
            Result result;
            int count = 0;
            for (int i = 0; i < numRows; ++i) {
                byte[] row = Bytes.toBytes((String)String.format("%09d", i));
                Result result2 = scanner.next();
                Assert.assertTrue((result2 != null ? 1 : 0) != 0);
                Assert.assertTrue((boolean)Bytes.equals((byte[])row, (byte[])result2.getRow()));
                ++count;
            }
            while ((result = scanner.next()) != null) {
                ++count;
            }
            Assert.assertEquals((long)numRows, (long)count);
        }
    }

    public static class FaultyScannerObserver
    extends BaseRegionObserver {
        private int faults = 0;

        public boolean preScannerNext(ObserverContext<RegionCoprocessorEnvironment> e, InternalScanner s, List<Result> results, int limit, boolean hasMore) throws IOException {
            TableName tableName = ((RegionCoprocessorEnvironment)e.getEnvironment()).getRegionInfo().getTable();
            if (!tableName.isSystemTable() && this.faults++ % 2 == 0) {
                LOG.debug((Object)(" Injecting fault in table=" + tableName + " scanner"));
                throw new IOException("injected fault");
            }
            return hasMore;
        }
    }
}

