/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.LogRoller;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.wal.DamagedWALException;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestWALLockup {
    private static final Log LOG = LogFactory.getLog(TestWALLockup.class);
    @Rule
    public TestName name = new TestName();
    private static final String COLUMN_FAMILY = "MyCF";
    private static final byte[] COLUMN_FAMILY_BYTES = Bytes.toBytes((String)"MyCF");
    HRegion region = null;
    private static HBaseTestingUtility TEST_UTIL;
    private static Configuration CONF;
    private String dir;
    protected TableName tableName;

    @Before
    public void setup() throws IOException {
        TEST_UTIL = HBaseTestingUtility.createLocalHTU();
        CONF = TEST_UTIL.getConfiguration();
        CONF.setFloat("hfile.block.cache.size", 0.0f);
        this.dir = TEST_UTIL.getDataTestDir("TestHRegion").toString();
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentEdgeManagerTestHelper.reset();
        LOG.info((Object)("Cleaning test directory: " + TEST_UTIL.getDataTestDir()));
        TEST_UTIL.cleanupTestDir();
    }

    String getName() {
        return this.name.getMethodName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testLockupWhenSyncInMiddleOfZigZagSetup() throws IOException {
        Server server = (Server)Mockito.mock(Server.class);
        Mockito.when((Object)server.getConfiguration()).thenReturn((Object)CONF);
        Mockito.when((Object)server.isStopped()).thenReturn((Object)false);
        Mockito.when((Object)server.isAborted()).thenReturn((Object)false);
        RegionServerServices services = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        FileSystem fs = FileSystem.get((Configuration)CONF);
        Path rootDir = new Path(this.dir + this.getName());
        class DodgyFSLog
        extends FSHLog {
            volatile boolean throwException;
            CountDownLatch latch;

            public DodgyFSLog(FileSystem fs, Path root, String logDir, Configuration conf) throws IOException {
                super(fs, root, logDir, conf);
                this.throwException = false;
                this.latch = new CountDownLatch(1);
            }

            protected void afterCreatingZigZagLatch() {
                if (this.throwException) {
                    try {
                        LOG.info((Object)"LATCHED");
                        if (!this.latch.await(5L, TimeUnit.SECONDS)) {
                            LOG.warn((Object)"GIVE UP! Failed waiting on latch...Test is ABORTED!");
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }

            protected void beforeWaitOnSafePoint() {
                if (this.throwException) {
                    LOG.info((Object)"COUNTDOWN");
                    while (this.latch.getCount() <= 0L) {
                        Threads.sleep((long)1L);
                    }
                    this.latch.countDown();
                }
            }

            protected WALProvider.Writer createWriterInstance(Path path) throws IOException {
                final WALProvider.Writer w = super.createWriterInstance(path);
                return new WALProvider.Writer(){

                    public void close() throws IOException {
                        w.close();
                    }

                    public void sync() throws IOException {
                        if (throwException) {
                            throw new IOException("FAKE! Failed to replace a bad datanode...SYNC");
                        }
                        w.sync();
                    }

                    public void append(WAL.Entry entry) throws IOException {
                        if (throwException) {
                            throw new IOException("FAKE! Failed to replace a bad datanode...APPEND");
                        }
                        w.append(entry);
                    }

                    public long getLength() throws IOException {
                        return w.getLength();
                    }
                };
            }
        }
        DodgyFSLog dodgyWAL = new DodgyFSLog(fs, rootDir, this.getName(), CONF);
        Path originalWAL = dodgyWAL.getCurrentFileName();
        LogRoller logRoller = new LogRoller(server, services);
        logRoller.addWAL((WAL)dodgyWAL);
        logRoller.start();
        HTableDescriptor htd = new HTableDescriptor(TableName.META_TABLE_NAME);
        final HRegion region = this.initHRegion(this.tableName, null, null, (WAL)dodgyWAL);
        byte[] bytes = Bytes.toBytes((String)this.getName());
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        try {
            Put put = new Put(bytes);
            put.addColumn(COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"1"), bytes);
            WALKey key = new WALKey(region.getRegionInfo().getEncodedNameAsBytes(), htd.getTableName(), System.currentTimeMillis(), mvcc);
            WALEdit edit = new WALEdit();
            CellScanner CellScanner2 = put.cellScanner();
            Assert.assertTrue((boolean)CellScanner2.advance());
            edit.add(CellScanner2.current());
            for (int i = 0; i < 1000; ++i) {
                region.put(put);
            }
            LOG.info((Object)"SET throwing of exception on append");
            dodgyWAL.throwException = true;
            dodgyWAL.append(htd, region.getRegionInfo(), key, edit, true);
            boolean exception = false;
            try {
                dodgyWAL.sync();
            }
            catch (Exception e) {
                exception = true;
            }
            Assert.assertTrue((String)"Did not get sync exception", (boolean)exception);
            Thread t = new Thread("Flusher"){

                @Override
                public void run() {
                    try {
                        if (region.getMemstoreSize() <= 0L) {
                            throw new IOException("memstore size=" + region.getMemstoreSize());
                        }
                        region.flush(false);
                    }
                    catch (IOException e) {
                        LOG.info((Object)"In flush", (Throwable)e);
                    }
                    LOG.info((Object)"Exiting");
                }
            };
            t.setDaemon(true);
            t.start();
            while (dodgyWAL.latch.getCount() > 0L) {
                Threads.sleep((long)1L);
            }
            Assert.assertTrue((originalWAL != dodgyWAL.getCurrentFileName() ? 1 : 0) != 0);
            dodgyWAL.throwException = false;
            try {
                region.put(put);
            }
            catch (Exception e) {
                LOG.info((Object)"In the put", (Throwable)e);
            }
        }
        finally {
            Mockito.when((Object)server.isStopped()).thenReturn((Object)true);
            if (logRoller != null) {
                logRoller.interrupt();
            }
            try {
                if (region != null) {
                    region.close();
                }
                if (dodgyWAL != null) {
                    dodgyWAL.close();
                }
            }
            catch (Exception e) {
                LOG.info((Object)"On way out", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=20000L)
    public void testLockup16960() throws IOException {
        DummyServer server = new DummyServer(CONF, ServerName.valueOf((String)"hostname1.example.org", (int)1234, (long)1L).toString());
        RegionServerServices services = (RegionServerServices)Mockito.mock(RegionServerServices.class);
        CONF.setLong("hbase.regionserver.hlog.sync.timeout", 10000L);
        FileSystem fs = FileSystem.get((Configuration)CONF);
        Path rootDir = new Path(this.dir + this.getName());
        class DodgyFSLog
        extends FSHLog {
            volatile boolean throwException;

            public DodgyFSLog(FileSystem fs, Path root, String logDir, Configuration conf) throws IOException {
                super(fs, root, logDir, conf);
                this.throwException = false;
            }

            protected WALProvider.Writer createWriterInstance(Path path) throws IOException {
                final WALProvider.Writer w = super.createWriterInstance(path);
                return new WALProvider.Writer(){

                    public void close() throws IOException {
                        w.close();
                    }

                    public void sync() throws IOException {
                        if (throwException) {
                            throw new IOException("FAKE! Failed to replace a bad datanode...SYNC");
                        }
                        w.sync();
                    }

                    public void append(WAL.Entry entry) throws IOException {
                        if (throwException) {
                            throw new IOException("FAKE! Failed to replace a bad datanode...APPEND");
                        }
                        w.append(entry);
                    }

                    public long getLength() throws IOException {
                        return w.getLength();
                    }
                };
            }

            public byte[][] rollWriter(boolean force) throws FailedLogCloseException, IOException {
                if (this.throwException) {
                    throw new FailedLogCloseException("testLockup16960");
                }
                return super.rollWriter(force);
            }
        }
        DodgyFSLog dodgyWAL1 = new DodgyFSLog(fs, rootDir, this.getName(), CONF);
        Path rootDir2 = new Path(this.dir + this.getName() + "2");
        final DodgyFSLog dodgyWAL2 = new DodgyFSLog(fs, rootDir2, this.getName() + "2", CONF);
        dodgyWAL2.registerWALActionsListener((WALActionsListener)new DummyWALActionsListener());
        LogRoller logRoller = new LogRoller((Server)server, services);
        logRoller.addWAL((WAL)dodgyWAL1);
        logRoller.addWAL((WAL)dodgyWAL2);
        logRoller.start();
        HTableDescriptor htd = new HTableDescriptor(TableName.META_TABLE_NAME);
        HRegion region = this.initHRegion(this.tableName, null, null, (WAL)dodgyWAL1);
        byte[] bytes = Bytes.toBytes((String)this.getName());
        MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl();
        try {
            Put put = new Put(bytes);
            put.addColumn(COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"1"), bytes);
            WALKey key = new WALKey(region.getRegionInfo().getEncodedNameAsBytes(), htd.getTableName(), System.currentTimeMillis(), mvcc);
            WALEdit edit = new WALEdit();
            CellScanner CellScanner2 = put.cellScanner();
            Assert.assertTrue((boolean)CellScanner2.advance());
            edit.add(CellScanner2.current());
            LOG.info((Object)"SET throwing of exception on append");
            dodgyWAL1.throwException = true;
            dodgyWAL1.append(htd, region.getRegionInfo(), key, edit, true);
            boolean exception = false;
            try {
                dodgyWAL1.sync();
            }
            catch (Exception e) {
                exception = true;
            }
            Assert.assertTrue((String)"Did not get sync exception", (boolean)exception);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            final CountDownLatch latch = new CountDownLatch(1);
            key = new WALKey(region.getRegionInfo().getEncodedNameAsBytes(), TableName.valueOf((String)"sleep"), System.currentTimeMillis(), mvcc);
            dodgyWAL2.append(htd, region.getRegionInfo(), key, edit, true);
            Thread t = new Thread("Sync"){
                {
                    super(x0);
                }

                @Override
                public void run() {
                    try {
                        dodgyWAL2.sync();
                    }
                    catch (IOException e) {
                        LOG.info((Object)"In sync", (Throwable)e);
                    }
                    latch.countDown();
                    LOG.info((Object)"Sync exiting");
                }
            };
            t.setDaemon(true);
            t.start();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            key = new WALKey(region.getRegionInfo().getEncodedNameAsBytes(), TableName.valueOf((String)"DamagedWALException"), System.currentTimeMillis(), mvcc);
            dodgyWAL2.append(htd, region.getRegionInfo(), key, edit, true);
            while (latch.getCount() > 0L) {
                Threads.sleep((long)100L);
            }
            Assert.assertTrue((boolean)server.isAborted());
        }
        finally {
            if (logRoller != null) {
                logRoller.interrupt();
            }
            try {
                if (region != null) {
                    region.close();
                }
                if (dodgyWAL1 != null) {
                    dodgyWAL1.close();
                }
                if (dodgyWAL2 != null) {
                    dodgyWAL2.close();
                }
            }
            catch (Exception e) {
                LOG.info((Object)"On way out", (Throwable)e);
            }
        }
    }

    public HRegion initHRegion(TableName tableName, byte[] startKey, byte[] stopKey, WAL wal) throws IOException {
        return TEST_UTIL.createLocalHRegion(tableName.getName(), startKey, stopKey, this.getName(), CONF, false, Durability.SYNC_WAL, wal, new byte[][]{COLUMN_FAMILY_BYTES});
    }

    static class DummyWALActionsListener
    extends WALActionsListener.Base {
        DummyWALActionsListener() {
        }

        public void visitLogEntryBeforeWrite(HTableDescriptor htd, WALKey logKey, WALEdit logEdit) throws IOException {
            if (logKey.getTablename().getNameAsString().equalsIgnoreCase("sleep")) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (logKey.getTablename().getNameAsString().equalsIgnoreCase("DamagedWALException")) {
                throw new DamagedWALException("Failed appending");
            }
        }
    }

    static class DummyServer
    implements Server {
        private Configuration conf;
        private String serverName;
        private boolean isAborted = false;

        public DummyServer(Configuration conf, String serverName) {
            this.conf = conf;
            this.serverName = serverName;
        }

        public Configuration getConfiguration() {
            return this.conf;
        }

        public ZooKeeperWatcher getZooKeeper() {
            return null;
        }

        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        public ClusterConnection getConnection() {
            return null;
        }

        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        public ServerName getServerName() {
            return ServerName.valueOf((String)this.serverName);
        }

        public void abort(String why, Throwable e) {
            LOG.info((Object)("Aborting " + this.serverName));
            this.isAborted = true;
        }

        public boolean isAborted() {
            return this.isAborted;
        }

        public void stop(String why) {
            this.isAborted = true;
        }

        public boolean isStopped() {
            return this.isAborted;
        }

        public ChoreService getChoreService() {
            return null;
        }
    }
}

