/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestByteBufferUtils {
    private byte[] array;
    private static final int MAX_VLONG_LENGTH = 9;
    private static final Collection<Long> testNumbers;

    @Before
    public void setUp() {
        this.array = new byte[8];
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = (byte)(97 + i);
        }
    }

    private static void addNumber(Set<Long> a, long l) {
        if (l != Long.MIN_VALUE) {
            a.add(l - 1L);
        }
        a.add(l);
        if (l != Long.MAX_VALUE) {
            a.add(l + 1L);
        }
        for (long divisor = 3L; divisor <= 10L; ++divisor) {
            for (long delta = -1L; delta <= 1L; ++delta) {
                a.add(l / divisor + delta);
            }
        }
    }

    @Test
    public void testReadWriteVLong() {
        for (long l : testNumbers) {
            ByteBuffer b = ByteBuffer.allocate(9);
            ByteBufferUtils.writeVLong((ByteBuffer)b, (long)l);
            b.flip();
            Assert.assertEquals((long)l, (long)ByteBufferUtils.readVLong((ByteBuffer)b));
        }
    }

    @Test
    public void testConsistencyWithHadoopVLong() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        for (long l : testNumbers) {
            baos.reset();
            ByteBuffer b = ByteBuffer.allocate(9);
            ByteBufferUtils.writeVLong((ByteBuffer)b, (long)l);
            String bufStr = Bytes.toStringBinary((byte[])b.array(), (int)b.arrayOffset(), (int)b.position());
            WritableUtils.writeVLong((DataOutput)dos, (long)l);
            String baosStr = Bytes.toStringBinary((byte[])baos.toByteArray());
            Assert.assertEquals((Object)baosStr, (Object)bufStr);
        }
    }

    @Test
    public void testMoveBufferToStream() {
        int arrayOffset = 7;
        int initialPosition = 10;
        int endPadding = 5;
        byte[] arrayWrapper = new byte[17 + this.array.length + 5];
        System.arraycopy(this.array, 0, arrayWrapper, 17, this.array.length);
        ByteBuffer buffer = ByteBuffer.wrap(arrayWrapper, 7, 10 + this.array.length).slice();
        Assert.assertEquals((long)(10 + this.array.length), (long)buffer.limit());
        Assert.assertEquals((long)0L, (long)buffer.position());
        buffer.position(10);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ByteBufferUtils.moveBufferToStream((OutputStream)bos, (ByteBuffer)buffer, (int)this.array.length);
        }
        catch (IOException e) {
            Assert.fail((String)"IOException in testCopyToStream()");
        }
        Assert.assertArrayEquals((byte[])this.array, (byte[])bos.toByteArray());
        Assert.assertEquals((long)(10 + this.array.length), (long)buffer.position());
    }

    @Test
    public void testCopyToStreamWithOffset() throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(this.array);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteBufferUtils.copyBufferToStream((OutputStream)bos, (ByteBuffer)buffer, (int)(this.array.length / 2), (int)(this.array.length / 2));
        byte[] returnedArray = bos.toByteArray();
        for (int i = 0; i < this.array.length / 2; ++i) {
            int pos = this.array.length / 2 + i;
            Assert.assertEquals((long)returnedArray[i], (long)this.array[pos]);
        }
    }

    @Test
    public void testCopyFromStream() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(this.array.length);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.array);
        DataInputStream dis = new DataInputStream(bis);
        ByteBufferUtils.copyFromStreamToBuffer((ByteBuffer)buffer, (DataInputStream)dis, (int)(this.array.length / 2));
        ByteBufferUtils.copyFromStreamToBuffer((ByteBuffer)buffer, (DataInputStream)dis, (int)(this.array.length - this.array.length / 2));
        for (int i = 0; i < this.array.length; ++i) {
            Assert.assertEquals((long)this.array[i], (long)buffer.get(i));
        }
    }

    @Test
    public void testCopyFromBuffer() {
        ByteBuffer srcBuffer = ByteBuffer.allocate(this.array.length);
        ByteBuffer dstBuffer = ByteBuffer.allocate(this.array.length);
        srcBuffer.put(this.array);
        ByteBufferUtils.copyFromBufferToBuffer((ByteBuffer)dstBuffer, (ByteBuffer)srcBuffer, (int)(this.array.length / 2), (int)(this.array.length / 4));
        for (int i = 0; i < this.array.length / 4; ++i) {
            Assert.assertEquals((long)srcBuffer.get(i + this.array.length / 2), (long)dstBuffer.get(i));
        }
    }

    @Test
    public void testCompressedInt() throws IOException {
        int i;
        this.testCompressedInt(0);
        this.testCompressedInt(Integer.MAX_VALUE);
        this.testCompressedInt(Integer.MIN_VALUE);
        for (i = 0; i < 3; ++i) {
            this.testCompressedInt((128 << i) - 1);
        }
        for (i = 0; i < 3; ++i) {
            this.testCompressedInt(128 << i);
        }
    }

    @Test
    public void testIntFitsIn() {
        Assert.assertEquals((long)1L, (long)ByteBufferUtils.intFitsIn((int)0));
        Assert.assertEquals((long)1L, (long)ByteBufferUtils.intFitsIn((int)1));
        Assert.assertEquals((long)2L, (long)ByteBufferUtils.intFitsIn((int)256));
        Assert.assertEquals((long)3L, (long)ByteBufferUtils.intFitsIn((int)65536));
        Assert.assertEquals((long)4L, (long)ByteBufferUtils.intFitsIn((int)-1));
        Assert.assertEquals((long)4L, (long)ByteBufferUtils.intFitsIn((int)Integer.MAX_VALUE));
        Assert.assertEquals((long)4L, (long)ByteBufferUtils.intFitsIn((int)Integer.MIN_VALUE));
    }

    @Test
    public void testLongFitsIn() {
        Assert.assertEquals((long)1L, (long)ByteBufferUtils.longFitsIn((long)0L));
        Assert.assertEquals((long)1L, (long)ByteBufferUtils.longFitsIn((long)1L));
        Assert.assertEquals((long)3L, (long)ByteBufferUtils.longFitsIn((long)65536L));
        Assert.assertEquals((long)5L, (long)ByteBufferUtils.longFitsIn((long)0x100000000L));
        Assert.assertEquals((long)8L, (long)ByteBufferUtils.longFitsIn((long)-1L));
        Assert.assertEquals((long)8L, (long)ByteBufferUtils.longFitsIn((long)Long.MIN_VALUE));
        Assert.assertEquals((long)8L, (long)ByteBufferUtils.longFitsIn((long)Long.MAX_VALUE));
    }

    @Test
    public void testArePartEqual() {
        byte[] array = new byte[]{1, 2, 3, 4, 5, 1, 2, 3, 4};
        ByteBuffer buffer = ByteBuffer.wrap(array);
        Assert.assertTrue((boolean)ByteBufferUtils.arePartsEqual((ByteBuffer)buffer, (int)0, (int)4, (int)5, (int)4));
        Assert.assertTrue((boolean)ByteBufferUtils.arePartsEqual((ByteBuffer)buffer, (int)1, (int)2, (int)6, (int)2));
        Assert.assertFalse((boolean)ByteBufferUtils.arePartsEqual((ByteBuffer)buffer, (int)1, (int)2, (int)6, (int)3));
        Assert.assertFalse((boolean)ByteBufferUtils.arePartsEqual((ByteBuffer)buffer, (int)1, (int)3, (int)6, (int)2));
        Assert.assertFalse((boolean)ByteBufferUtils.arePartsEqual((ByteBuffer)buffer, (int)0, (int)3, (int)6, (int)3));
    }

    @Test
    public void testPutInt() {
        int i;
        this.testPutInt(0);
        this.testPutInt(Integer.MAX_VALUE);
        for (i = 0; i < 3; ++i) {
            this.testPutInt((128 << i) - 1);
        }
        for (i = 0; i < 3; ++i) {
            this.testPutInt(128 << i);
        }
    }

    private void testCompressedInt(int value) throws IOException {
        int parsedValue = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ByteBufferUtils.putCompressedInt((OutputStream)bos, (int)value);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        parsedValue = ByteBufferUtils.readCompressedInt((InputStream)bis);
        Assert.assertEquals((long)value, (long)parsedValue);
    }

    private void testPutInt(int value) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ByteBufferUtils.putInt((OutputStream)baos, (int)value);
        }
        catch (IOException e) {
            throw new RuntimeException("Bug in putIn()", e);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DataInputStream dis = new DataInputStream(bais);
        try {
            Assert.assertEquals((long)dis.readInt(), (long)value);
        }
        catch (IOException e) {
            throw new RuntimeException("Bug in test!", e);
        }
    }

    @Test
    public void testToBytes() {
        ByteBuffer buffer = ByteBuffer.allocate(5);
        buffer.put(new byte[]{0, 1, 2, 3, 4});
        Assert.assertEquals((long)5L, (long)buffer.position());
        Assert.assertEquals((long)5L, (long)buffer.limit());
        byte[] copy = ByteBufferUtils.toBytes((ByteBuffer)buffer, (int)2);
        Assert.assertArrayEquals((byte[])new byte[]{2, 3, 4}, (byte[])copy);
        Assert.assertEquals((long)5L, (long)buffer.position());
        Assert.assertEquals((long)5L, (long)buffer.limit());
    }

    static {
        TreeSet<Long> a = new TreeSet<Long>();
        for (int i = 0; i <= 63; ++i) {
            long v = -1L << i;
            Assert.assertTrue((v < 0L ? 1 : 0) != 0);
            TestByteBufferUtils.addNumber(a, v);
            v = (1L << i) - 1L;
            Assert.assertTrue((v >= 0L ? 1 : 0) != 0);
            TestByteBufferUtils.addNumber(a, v);
        }
        testNumbers = Collections.unmodifiableSet(a);
        System.err.println("Testing variable-length long serialization using: " + testNumbers + " (count: " + testNumbers.size() + ")");
        Assert.assertEquals((long)1753L, (long)testNumbers.size());
        Assert.assertEquals((long)Long.MIN_VALUE, (long)((Long)a.first()));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)((Long)a.last()));
    }
}

