/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.io.crypto.KeyProviderForTesting;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.regionserver.MultiVersionConcurrencyControl;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogReader;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.SecureProtobufLogReader;
import org.apache.hadoop.hbase.regionserver.wal.SecureProtobufLogWriter;
import org.apache.hadoop.hbase.regionserver.wal.SecureWALCellCodec;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALProvider;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.hbase.zookeeper.ZKSplitLog;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestWALReaderOnSecureWAL {
    static final HBaseTestingUtility TEST_UTIL;
    final byte[] value = Bytes.toBytes((String)"Test value");
    private static final String WAL_ENCRYPTION = "hbase.regionserver.wal.encryption";
    @Rule
    public TestName currentTest = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hbase.crypto.keyprovider", KeyProviderForTesting.class.getName());
        conf.set("hbase.crypto.master.key.name", "hbase");
        conf.setBoolean("hbase.hlog.split.skip.errors", true);
        conf.setBoolean(WAL_ENCRYPTION, true);
        FSUtils.setRootDir((Configuration)conf, (Path)TEST_UTIL.getDataTestDir());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path writeWAL(WALFactory wals, String tblName) throws IOException {
        Configuration conf = TEST_UTIL.getConfiguration();
        String clsName = conf.get("hbase.regionserver.wal.codec", WALCellCodec.class.getName());
        conf.setClass("hbase.regionserver.wal.codec", SecureWALCellCodec.class, WALCellCodec.class);
        try {
            TableName tableName = TableName.valueOf((String)tblName);
            HTableDescriptor htd = new HTableDescriptor(tableName);
            htd.addFamily(new HColumnDescriptor(tableName.getName()));
            HRegionInfo regioninfo = new HRegionInfo(tableName, HConstants.EMPTY_START_ROW, HConstants.EMPTY_END_ROW, false);
            int total = 10;
            byte[] row = Bytes.toBytes((String)"row");
            byte[] family = Bytes.toBytes((String)"family");
            MultiVersionConcurrencyControl mvcc = new MultiVersionConcurrencyControl(1L);
            WAL wal = wals.getWAL(regioninfo.getEncodedNameAsBytes(), regioninfo.getTable().getNamespace());
            for (int i = 0; i < 10; ++i) {
                WALEdit kvs = new WALEdit();
                kvs.add((Cell)new KeyValue(row, family, Bytes.toBytes((int)i), this.value));
                wal.append(htd, regioninfo, new WALKey(regioninfo.getEncodedNameAsBytes(), tableName, System.currentTimeMillis(), mvcc), kvs, true);
            }
            wal.sync();
            Path walPath = DefaultWALProvider.getCurrentFileName((WAL)wal);
            wal.shutdown();
            Path path = walPath;
            return path;
        }
        finally {
            conf.set("hbase.regionserver.wal.codec", clsName);
        }
    }

    @Test
    public void testWALReaderOnSecureWAL() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setClass("hbase.regionserver.hlog.reader.impl", ProtobufLogReader.class, WAL.Reader.class);
        conf.setClass("hbase.regionserver.hlog.writer.impl", SecureProtobufLogWriter.class, WALProvider.Writer.class);
        conf.setBoolean(WAL_ENCRYPTION, true);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        WALFactory wals = new WALFactory(conf, null, this.currentTest.getMethodName());
        Path walPath = this.writeWAL(wals, this.currentTest.getMethodName());
        long length = fs.getFileStatus(walPath).getLen();
        FSDataInputStream in = fs.open(walPath);
        byte[] fileData = new byte[(int)length];
        IOUtils.readFully((InputStream)in, (byte[])fileData);
        in.close();
        Assert.assertFalse((String)"Cells appear to be plaintext", (boolean)Bytes.contains((byte[])fileData, (byte[])this.value));
        try {
            wals.createReader(TEST_UTIL.getTestFileSystem(), walPath);
            Assert.assertFalse((boolean)true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileStatus[] listStatus = fs.listStatus(walPath.getParent());
        ZooKeeperProtos.SplitLogTask.RecoveryMode mode = conf.getBoolean("hbase.master.distributed.log.replay", false) ? ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_REPLAY : ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_SPLITTING;
        Path rootdir = FSUtils.getRootDir((Configuration)conf);
        try {
            WALSplitter s = new WALSplitter(wals, conf, rootdir, fs, null, null, mode);
            s.splitLogFile(listStatus[0], null);
            Path file = new Path(ZKSplitLog.getSplitLogDir((Path)rootdir, (String)listStatus[0].getPath().getName()), "corrupt");
            Assert.assertTrue((boolean)fs.exists(file));
        }
        catch (IOException ioe) {
            Assert.assertTrue((String)"WAL should have been sidelined", (boolean)false);
        }
        wals.close();
    }

    @Test
    public void testSecureWALReaderOnWAL() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setClass("hbase.regionserver.hlog.reader.impl", SecureProtobufLogReader.class, WAL.Reader.class);
        conf.setClass("hbase.regionserver.hlog.writer.impl", ProtobufLogWriter.class, WALProvider.Writer.class);
        conf.setBoolean(WAL_ENCRYPTION, false);
        FileSystem fs = TEST_UTIL.getTestFileSystem();
        WALFactory wals = new WALFactory(conf, null, this.currentTest.getMethodName());
        Path walPath = this.writeWAL(wals, this.currentTest.getMethodName());
        long length = fs.getFileStatus(walPath).getLen();
        FSDataInputStream in = fs.open(walPath);
        byte[] fileData = new byte[(int)length];
        IOUtils.readFully((InputStream)in, (byte[])fileData);
        in.close();
        Assert.assertTrue((String)"Cells should be plaintext", (boolean)Bytes.contains((byte[])fileData, (byte[])this.value));
        try {
            WAL.Reader reader = wals.createReader(TEST_UTIL.getTestFileSystem(), walPath);
            reader.close();
        }
        catch (IOException ioe) {
            Assert.assertFalse((boolean)true);
        }
        FileStatus[] listStatus = fs.listStatus(walPath.getParent());
        ZooKeeperProtos.SplitLogTask.RecoveryMode mode = conf.getBoolean("hbase.master.distributed.log.replay", false) ? ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_REPLAY : ZooKeeperProtos.SplitLogTask.RecoveryMode.LOG_SPLITTING;
        Path rootdir = FSUtils.getRootDir((Configuration)conf);
        try {
            WALSplitter s = new WALSplitter(wals, conf, rootdir, fs, null, null, mode);
            s.splitLogFile(listStatus[0], null);
            Path file = new Path(ZKSplitLog.getSplitLogDir((Path)rootdir, (String)listStatus[0].getPath().getName()), "corrupt");
            Assert.assertTrue((!fs.exists(file) ? 1 : 0) != 0);
        }
        catch (IOException ioe) {
            Assert.assertTrue((String)"WAL should have been processed", (boolean)false);
        }
        wals.close();
    }

    static {
        ((Log4JLogger)LogFactory.getLog((String)"org.apache.hadoop.hbase.regionserver.wal")).getLogger().setLevel(Level.ALL);
        TEST_UTIL = new HBaseTestingUtility();
    }
}

