/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
@SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="FindBugs seems confused; says limit and tlimit are mostly synchronized...but to me it looks like they are totally synchronized")
public abstract class RateLimiter {
    public static final String QUOTA_RATE_LIMITER_CONF_KEY = "hbase.quota.rate.limiter";
    private long tunit = 1000L;
    private long limit = Long.MAX_VALUE;
    private long avail = Long.MAX_VALUE;

    abstract long refill(long var1);

    abstract long getWaitInterval(long var1, long var3, long var5);

    public synchronized void set(long limit, TimeUnit timeUnit) {
        switch (timeUnit) {
            case MILLISECONDS: {
                this.tunit = 1L;
                break;
            }
            case SECONDS: {
                this.tunit = 1000L;
                break;
            }
            case MINUTES: {
                this.tunit = 60000L;
                break;
            }
            case HOURS: {
                this.tunit = 3600000L;
                break;
            }
            case DAYS: {
                this.tunit = 86400000L;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported " + timeUnit.name() + " TimeUnit.");
            }
        }
        this.limit = limit;
        this.avail = limit;
    }

    public String toString() {
        String rateLimiter = this.getClass().getSimpleName();
        if (this.getLimit() == Long.MAX_VALUE) {
            return rateLimiter + "(Bypass)";
        }
        return rateLimiter + "(avail=" + this.getAvailable() + " limit=" + this.getLimit() + " tunit=" + this.getTimeUnitInMillis() + ")";
    }

    public synchronized void update(RateLimiter other) {
        this.tunit = other.tunit;
        if (this.limit < other.limit) {
            long diff = other.limit - this.limit;
            if (this.avail <= Long.MAX_VALUE - diff) {
                this.avail += diff;
                this.avail = Math.min(this.avail, other.limit);
            } else {
                this.avail = other.limit;
            }
        }
        this.limit = other.limit;
    }

    public synchronized boolean isBypass() {
        return this.getLimit() == Long.MAX_VALUE;
    }

    public synchronized long getLimit() {
        return this.limit;
    }

    public synchronized long getAvailable() {
        return this.avail;
    }

    protected synchronized long getTimeUnitInMillis() {
        return this.tunit;
    }

    public boolean canExecute() {
        return this.canExecute(1L);
    }

    public synchronized boolean canExecute(long amount) {
        if (this.isBypass()) {
            return true;
        }
        long refillAmount = this.refill(this.limit);
        if (refillAmount == 0L && this.avail < amount) {
            return false;
        }
        this.avail = this.avail <= Long.MAX_VALUE - refillAmount ? Math.max(0L, Math.min(this.avail + refillAmount, this.limit)) : Math.max(0L, this.limit);
        return this.avail >= amount;
    }

    public void consume() {
        this.consume(1L);
    }

    public synchronized void consume(long amount) {
        if (this.isBypass()) {
            return;
        }
        if (amount >= 0L) {
            this.avail -= amount;
            if (this.avail < 0L) {
                this.avail = 0L;
            }
        } else if (this.avail <= Long.MAX_VALUE + amount) {
            this.avail -= amount;
            this.avail = Math.min(this.avail, this.limit);
        } else {
            this.avail = this.limit;
        }
    }

    public long waitInterval() {
        return this.waitInterval(1L);
    }

    public synchronized long waitInterval(long amount) {
        return amount <= this.avail ? 0L : this.getWaitInterval(this.getLimit(), this.avail, amount);
    }

    @VisibleForTesting
    public abstract void setNextRefillTime(long var1);

    @VisibleForTesting
    public abstract long getNextRefillTime();
}

