/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializer;
import org.apache.hadoop.hbase.io.hfile.bucket.IOEngine;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.util.ByteBufferAllocator;
import org.apache.hadoop.hbase.util.ByteBufferArray;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ByteBufferIOEngine
implements IOEngine {
    private ByteBufferArray bufferArray;
    private final long capacity;
    private final boolean direct;

    public ByteBufferIOEngine(long capacity, boolean direct) throws IOException {
        this.capacity = capacity;
        this.direct = direct;
        ByteBufferAllocator allocator = new ByteBufferAllocator(){

            public ByteBuffer allocate(long size, boolean directByteBuffer) throws IOException {
                if (directByteBuffer) {
                    return ByteBuffer.allocateDirect((int)size);
                }
                return ByteBuffer.allocate((int)size);
            }
        };
        this.bufferArray = new ByteBufferArray(capacity, direct, allocator);
    }

    public String toString() {
        return "ioengine=" + this.getClass().getSimpleName() + ", capacity=" + String.format("%,d", this.capacity) + ", direct=" + this.direct;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public Cacheable read(long offset, int length, CacheableDeserializer<Cacheable> deserializer) throws IOException {
        ByteBuff dstBuffer = this.bufferArray.asSubByteBuff(offset, length);
        return deserializer.deserialize(dstBuffer, true, Cacheable.MemoryType.SHARED);
    }

    @Override
    public void write(ByteBuffer srcBuffer, long offset) throws IOException {
        assert (srcBuffer.hasArray());
        this.bufferArray.putMultiple(offset, srcBuffer.remaining(), srcBuffer.array(), srcBuffer.arrayOffset());
    }

    @Override
    public void write(ByteBuff srcBuffer, long offset) throws IOException {
        assert (srcBuffer.hasArray());
        this.bufferArray.putMultiple(offset, srcBuffer.remaining(), srcBuffer.array(), srcBuffer.arrayOffset());
    }

    @Override
    public void sync() {
    }

    @Override
    public void shutdown() {
    }
}

