/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.protobuf.Service;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.MetaMutationAnnotation;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.BaseEnvironment;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.CoprocessorServiceBackwardCompatiblity;
import org.apache.hadoop.hbase.coprocessor.CoreCoprocessor;
import org.apache.hadoop.hbase.coprocessor.HasMasterServices;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessor;
import org.apache.hadoop.hbase.coprocessor.MasterCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.MasterObserver;
import org.apache.hadoop.hbase.coprocessor.MetricsCoprocessor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.locking.LockProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.procedure2.LockType;
import org.apache.hadoop.hbase.procedure2.LockedResource;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.quotas.GlobalQuotaSettings;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.security.User;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MasterCoprocessorHost
extends CoprocessorHost<MasterCoprocessor, MasterCoprocessorEnvironment> {
    private static final Log LOG = LogFactory.getLog(MasterCoprocessorHost.class);
    private MasterServices masterServices;
    private CoprocessorHost.ObserverGetter<MasterCoprocessor, MasterObserver> masterObserverGetter = MasterCoprocessor::getMasterObserver;

    public MasterCoprocessorHost(MasterServices services, Configuration conf) {
        super(services);
        this.conf = conf;
        this.masterServices = services;
        boolean coprocessorsEnabled = conf.getBoolean("hbase.coprocessor.enabled", true);
        LOG.info((Object)("System coprocessor loading is " + (coprocessorsEnabled ? "enabled" : "disabled")));
        this.loadSystemCoprocessors(conf, "hbase.coprocessor.master.classes");
    }

    @Override
    public MasterEnvironment createEnvironment(MasterCoprocessor instance, int priority, int seq, Configuration conf) {
        for (Service service : instance.getServices()) {
            this.masterServices.registerService(service);
        }
        return instance.getClass().isAnnotationPresent(CoreCoprocessor.class) ? new MasterEnvironmentForCoreCoprocessors(instance, priority, seq, conf, this.masterServices) : new MasterEnvironment(instance, priority, seq, conf, this.masterServices);
    }

    @Override
    public MasterCoprocessor checkAndGetInstance(Class<?> implClass) throws InstantiationException, IllegalAccessException {
        if (MasterCoprocessor.class.isAssignableFrom(implClass)) {
            return (MasterCoprocessor)implClass.newInstance();
        }
        if (CoprocessorService.class.isAssignableFrom(implClass)) {
            return new CoprocessorServiceBackwardCompatiblity.MasterCoprocessorService((CoprocessorService)implClass.newInstance());
        }
        LOG.error((Object)(implClass.getName() + " is not of type MasterCoprocessor. Check the configuration " + "hbase.coprocessor.master.classes"));
        return null;
    }

    public void preCreateNamespace(final NamespaceDescriptor ns) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preCreateNamespace(this, ns);
            }
        });
    }

    public void postCreateNamespace(final NamespaceDescriptor ns) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postCreateNamespace(this, ns);
            }
        });
    }

    public void preDeleteNamespace(final String namespaceName) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preDeleteNamespace(this, namespaceName);
            }
        });
    }

    public void postDeleteNamespace(final String namespaceName) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postDeleteNamespace(this, namespaceName);
            }
        });
    }

    public void preModifyNamespace(final NamespaceDescriptor ns) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preModifyNamespace(this, ns);
            }
        });
    }

    public void postModifyNamespace(final NamespaceDescriptor ns) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postModifyNamespace(this, ns);
            }
        });
    }

    public void preGetNamespaceDescriptor(final String namespaceName) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preGetNamespaceDescriptor(this, namespaceName);
            }
        });
    }

    public void postGetNamespaceDescriptor(final NamespaceDescriptor ns) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postGetNamespaceDescriptor(this, ns);
            }
        });
    }

    public void preListNamespaceDescriptors(final List<NamespaceDescriptor> descriptors) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preListNamespaceDescriptors(this, descriptors);
            }
        });
    }

    public void postListNamespaceDescriptors(final List<NamespaceDescriptor> descriptors) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postListNamespaceDescriptors(this, descriptors);
            }
        });
    }

    public void preCreateTable(final TableDescriptor htd, final RegionInfo[] regions) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preCreateTable(this, htd, regions);
            }
        });
    }

    public void postCreateTable(final TableDescriptor htd, final RegionInfo[] regions) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postCreateTable(this, htd, regions);
            }
        });
    }

    public void preCreateTableAction(final TableDescriptor htd, final RegionInfo[] regions, User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(user){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preCreateTableAction(this, htd, regions);
            }
        });
    }

    public void postCompletedCreateTableAction(final TableDescriptor htd, final RegionInfo[] regions, User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(user){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postCompletedCreateTableAction(this, htd, regions);
            }
        });
    }

    public void preDeleteTable(final TableName tableName) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preDeleteTable(this, tableName);
            }
        });
    }

    public void postDeleteTable(final TableName tableName) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postDeleteTable(this, tableName);
            }
        });
    }

    public void preDeleteTableAction(final TableName tableName, User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(user){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preDeleteTableAction(this, tableName);
            }
        });
    }

    public void postCompletedDeleteTableAction(final TableName tableName, User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(user){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postCompletedDeleteTableAction(this, tableName);
            }
        });
    }

    public void preTruncateTable(final TableName tableName) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preTruncateTable(this, tableName);
            }
        });
    }

    public void postTruncateTable(final TableName tableName) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postTruncateTable(this, tableName);
            }
        });
    }

    public void preTruncateTableAction(final TableName tableName, User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(user){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preTruncateTableAction(this, tableName);
            }
        });
    }

    public void postCompletedTruncateTableAction(final TableName tableName, User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(user){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postCompletedTruncateTableAction(this, tableName);
            }
        });
    }

    public void preModifyTable(final TableName tableName, final TableDescriptor htd) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preModifyTable(this, tableName, htd);
            }
        });
    }

    public void postModifyTable(final TableName tableName, final TableDescriptor htd) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postModifyTable(this, tableName, htd);
            }
        });
    }

    public void preModifyTableAction(final TableName tableName, final TableDescriptor htd, User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(user){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preModifyTableAction(this, tableName, htd);
            }
        });
    }

    public void postCompletedModifyTableAction(final TableName tableName, final TableDescriptor htd, User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(user){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postCompletedModifyTableAction(this, tableName, htd);
            }
        });
    }

    public void preEnableTable(final TableName tableName) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preEnableTable(this, tableName);
            }
        });
    }

    public void postEnableTable(final TableName tableName) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postEnableTable(this, tableName);
            }
        });
    }

    public void preEnableTableAction(final TableName tableName, User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(user){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preEnableTableAction(this, tableName);
            }
        });
    }

    public void postCompletedEnableTableAction(final TableName tableName, User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(user){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postCompletedEnableTableAction(this, tableName);
            }
        });
    }

    public void preDisableTable(final TableName tableName) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preDisableTable(this, tableName);
            }
        });
    }

    public void postDisableTable(final TableName tableName) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postDisableTable(this, tableName);
            }
        });
    }

    public void preDisableTableAction(final TableName tableName, User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(user){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preDisableTableAction(this, tableName);
            }
        });
    }

    public void postCompletedDisableTableAction(final TableName tableName, User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(user){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postCompletedDisableTableAction(this, tableName);
            }
        });
    }

    public void preAbortProcedure(ProcedureExecutor<MasterProcedureEnv> procEnv, final long procId) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preAbortProcedure(this, procId);
            }
        });
    }

    public void postAbortProcedure() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postAbortProcedure(this);
            }
        });
    }

    public void preGetProcedures() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preGetProcedures(this);
            }
        });
    }

    public void postGetProcedures(List<Procedure<?>> procInfoList) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postGetProcedures(this);
            }
        });
    }

    public void preGetLocks() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preGetLocks(this);
            }
        });
    }

    public void postGetLocks(List<LockedResource> lockedResources) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postGetLocks(this);
            }
        });
    }

    public void preMove(final RegionInfo region, final ServerName srcServer, final ServerName destServer) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preMove(this, region, srcServer, destServer);
            }
        });
    }

    public void postMove(final RegionInfo region, final ServerName srcServer, final ServerName destServer) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postMove(this, region, srcServer, destServer);
            }
        });
    }

    public void preAssign(final RegionInfo regionInfo) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preAssign(this, regionInfo);
            }
        });
    }

    public void postAssign(final RegionInfo regionInfo) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postAssign(this, regionInfo);
            }
        });
    }

    public void preUnassign(final RegionInfo regionInfo, final boolean force) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preUnassign(this, regionInfo, force);
            }
        });
    }

    public void postUnassign(final RegionInfo regionInfo, final boolean force) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postUnassign(this, regionInfo, force);
            }
        });
    }

    public void preRegionOffline(final RegionInfo regionInfo) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preRegionOffline(this, regionInfo);
            }
        });
    }

    public void postRegionOffline(final RegionInfo regionInfo) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postRegionOffline(this, regionInfo);
            }
        });
    }

    public void preMergeRegions(final RegionInfo[] regionsToMerge) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preMergeRegions(this, regionsToMerge);
            }
        });
    }

    public void postMergeRegions(final RegionInfo[] regionsToMerge) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postMergeRegions(this, regionsToMerge);
            }
        });
    }

    public boolean preBalance() throws IOException {
        return this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preBalance(this);
            }
        });
    }

    public void postBalance(final List<RegionPlan> plans) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postBalance(this, plans);
            }
        });
    }

    public void preSetSplitOrMergeEnabled(final boolean newValue, final MasterSwitchType switchType) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preSetSplitOrMergeEnabled(this, newValue, switchType);
            }
        });
    }

    public void postSetSplitOrMergeEnabled(final boolean newValue, final MasterSwitchType switchType) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postSetSplitOrMergeEnabled(this, newValue, switchType);
            }
        });
    }

    public void preSplitRegion(final TableName tableName, final byte[] splitRow) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preSplitRegion(this, tableName, splitRow);
            }
        });
    }

    public void preSplitRegionAction(final TableName tableName, final byte[] splitRow, User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(user){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preSplitRegionAction(this, tableName, splitRow);
            }
        });
    }

    public void postCompletedSplitRegionAction(final RegionInfo regionInfoA, final RegionInfo regionInfoB, User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(user){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postCompletedSplitRegionAction(this, regionInfoA, regionInfoB);
            }
        });
    }

    public void preSplitBeforeMETAAction(final byte[] splitKey, final List<Mutation> metaEntries, User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(user){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preSplitRegionBeforeMETAAction(this, splitKey, metaEntries);
            }
        });
    }

    public void preSplitAfterMETAAction(User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(user){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preSplitRegionAfterMETAAction(this);
            }
        });
    }

    public void postRollBackSplitRegionAction(User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(user){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postRollBackSplitRegionAction(this);
            }
        });
    }

    public void preMergeRegionsAction(final RegionInfo[] regionsToMerge, User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(user){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preMergeRegionsAction(this, regionsToMerge);
            }
        });
    }

    public void postCompletedMergeRegionsAction(final RegionInfo[] regionsToMerge, final RegionInfo mergedRegion, User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(user){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postCompletedMergeRegionsAction(this, regionsToMerge, mergedRegion);
            }
        });
    }

    public void preMergeRegionsCommit(final RegionInfo[] regionsToMerge, final @MetaMutationAnnotation List<Mutation> metaEntries, User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(user){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preMergeRegionsCommitAction(this, regionsToMerge, metaEntries);
            }
        });
    }

    public void postMergeRegionsCommit(final RegionInfo[] regionsToMerge, final RegionInfo mergedRegion, User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(user){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postMergeRegionsCommitAction(this, regionsToMerge, mergedRegion);
            }
        });
    }

    public void postRollBackMergeRegionsAction(final RegionInfo[] regionsToMerge, User user) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(user){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postRollBackMergeRegionsAction(this, regionsToMerge);
            }
        });
    }

    public void preBalanceSwitch(final boolean b) throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return;
        }
        this.execOperation(new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preBalanceSwitch(this, b);
            }
        });
    }

    public void postBalanceSwitch(final boolean oldValue, final boolean newValue) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postBalanceSwitch(this, oldValue, newValue);
            }
        });
    }

    public void preShutdown() throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return;
        }
        this.execShutdown(new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preShutdown(this);
            }

            @Override
            public void postEnvCall() {
                MasterCoprocessorHost.this.shutdown(this.getEnvironment());
            }
        });
    }

    public void preStopMaster() throws IOException {
        if (this.coprocEnvironments.isEmpty()) {
            return;
        }
        this.execShutdown(new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preStopMaster(this);
            }

            @Override
            public void postEnvCall() {
                MasterCoprocessorHost.this.shutdown(this.getEnvironment());
            }
        });
    }

    public void preMasterInitialization() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preMasterInitialization(this);
            }
        });
    }

    public void postStartMaster() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postStartMaster(this);
            }
        });
    }

    public void preSnapshot(final SnapshotDescription snapshot, final TableDescriptor hTableDescriptor) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preSnapshot(this, snapshot, hTableDescriptor);
            }
        });
    }

    public void postSnapshot(final SnapshotDescription snapshot, final TableDescriptor hTableDescriptor) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postSnapshot(this, snapshot, hTableDescriptor);
            }
        });
    }

    public void preListSnapshot(final SnapshotDescription snapshot) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preListSnapshot(this, snapshot);
            }
        });
    }

    public void postListSnapshot(final SnapshotDescription snapshot) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postListSnapshot(this, snapshot);
            }
        });
    }

    public void preCloneSnapshot(final SnapshotDescription snapshot, final TableDescriptor hTableDescriptor) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preCloneSnapshot(this, snapshot, hTableDescriptor);
            }
        });
    }

    public void postCloneSnapshot(final SnapshotDescription snapshot, final TableDescriptor hTableDescriptor) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postCloneSnapshot(this, snapshot, hTableDescriptor);
            }
        });
    }

    public void preRestoreSnapshot(final SnapshotDescription snapshot, final TableDescriptor hTableDescriptor) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preRestoreSnapshot(this, snapshot, hTableDescriptor);
            }
        });
    }

    public void postRestoreSnapshot(final SnapshotDescription snapshot, final TableDescriptor hTableDescriptor) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postRestoreSnapshot(this, snapshot, hTableDescriptor);
            }
        });
    }

    public void preDeleteSnapshot(final SnapshotDescription snapshot) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preDeleteSnapshot(this, snapshot);
            }
        });
    }

    public void postDeleteSnapshot(final SnapshotDescription snapshot) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postDeleteSnapshot(this, snapshot);
            }
        });
    }

    public void preGetTableDescriptors(final List<TableName> tableNamesList, final List<TableDescriptor> descriptors, final String regex) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preGetTableDescriptors(this, tableNamesList, descriptors, regex);
            }
        });
    }

    public void postGetTableDescriptors(final List<TableName> tableNamesList, final List<TableDescriptor> descriptors, final String regex) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postGetTableDescriptors(this, tableNamesList, descriptors, regex);
            }
        });
    }

    public void preGetTableNames(final List<TableDescriptor> descriptors, final String regex) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preGetTableNames(this, descriptors, regex);
            }
        });
    }

    public void postGetTableNames(final List<TableDescriptor> descriptors, final String regex) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postGetTableNames(this, descriptors, regex);
            }
        });
    }

    public void preTableFlush(final TableName tableName) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preTableFlush(this, tableName);
            }
        });
    }

    public void postTableFlush(final TableName tableName) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postTableFlush(this, tableName);
            }
        });
    }

    public void preSetUserQuota(final String user, final GlobalQuotaSettings quotas) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preSetUserQuota(this, user, quotas);
            }
        });
    }

    public void postSetUserQuota(final String user, final GlobalQuotaSettings quotas) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postSetUserQuota(this, user, quotas);
            }
        });
    }

    public void preSetUserQuota(final String user, final TableName table, final GlobalQuotaSettings quotas) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preSetUserQuota((ObserverContext<MasterCoprocessorEnvironment>)this, user, table, quotas);
            }
        });
    }

    public void postSetUserQuota(final String user, final TableName table, final GlobalQuotaSettings quotas) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postSetUserQuota((ObserverContext<MasterCoprocessorEnvironment>)this, user, table, quotas);
            }
        });
    }

    public void preSetUserQuota(final String user, final String namespace, final GlobalQuotaSettings quotas) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preSetUserQuota((ObserverContext<MasterCoprocessorEnvironment>)this, user, namespace, quotas);
            }
        });
    }

    public void postSetUserQuota(final String user, final String namespace, final GlobalQuotaSettings quotas) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postSetUserQuota((ObserverContext<MasterCoprocessorEnvironment>)this, user, namespace, quotas);
            }
        });
    }

    public void preSetTableQuota(final TableName table, final GlobalQuotaSettings quotas) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preSetTableQuota(this, table, quotas);
            }
        });
    }

    public void postSetTableQuota(final TableName table, final GlobalQuotaSettings quotas) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postSetTableQuota(this, table, quotas);
            }
        });
    }

    public void preSetNamespaceQuota(final String namespace, final GlobalQuotaSettings quotas) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preSetNamespaceQuota(this, namespace, quotas);
            }
        });
    }

    public void postSetNamespaceQuota(final String namespace, final GlobalQuotaSettings quotas) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postSetNamespaceQuota(this, namespace, quotas);
            }
        });
    }

    public void preMoveServersAndTables(final Set<Address> servers, final Set<TableName> tables, final String targetGroup) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                if (((MasterEnvironment)this.getEnvironment()).supportGroupCPs) {
                    observer.preMoveServersAndTables(this, servers, tables, targetGroup);
                }
            }
        });
    }

    public void postMoveServersAndTables(final Set<Address> servers, final Set<TableName> tables, final String targetGroup) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                if (((MasterEnvironment)this.getEnvironment()).supportGroupCPs) {
                    observer.postMoveServersAndTables(this, servers, tables, targetGroup);
                }
            }
        });
    }

    public void preMoveServers(final Set<Address> servers, final String targetGroup) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                if (((MasterEnvironment)this.getEnvironment()).supportGroupCPs) {
                    observer.preMoveServers(this, servers, targetGroup);
                }
            }
        });
    }

    public void postMoveServers(final Set<Address> servers, final String targetGroup) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                if (((MasterEnvironment)this.getEnvironment()).supportGroupCPs) {
                    observer.postMoveServers(this, servers, targetGroup);
                }
            }
        });
    }

    public void preMoveTables(final Set<TableName> tables, final String targetGroup) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                if (((MasterEnvironment)this.getEnvironment()).supportGroupCPs) {
                    observer.preMoveTables(this, tables, targetGroup);
                }
            }
        });
    }

    public void postMoveTables(final Set<TableName> tables, final String targetGroup) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                if (((MasterEnvironment)this.getEnvironment()).supportGroupCPs) {
                    observer.postMoveTables(this, tables, targetGroup);
                }
            }
        });
    }

    public void preAddRSGroup(final String name) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                if (((MasterEnvironment)this.getEnvironment()).supportGroupCPs) {
                    observer.preAddRSGroup(this, name);
                }
            }
        });
    }

    public void postAddRSGroup(final String name) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                if (((MasterEnvironment)this.getEnvironment()).supportGroupCPs) {
                    observer.postAddRSGroup(this, name);
                }
            }
        });
    }

    public void preRemoveRSGroup(final String name) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                if (((MasterEnvironment)this.getEnvironment()).supportGroupCPs) {
                    observer.preRemoveRSGroup(this, name);
                }
            }
        });
    }

    public void postRemoveRSGroup(final String name) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                if (((MasterEnvironment)this.getEnvironment()).supportGroupCPs) {
                    observer.postRemoveRSGroup(this, name);
                }
            }
        });
    }

    public void preBalanceRSGroup(final String name) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                if (((MasterEnvironment)this.getEnvironment()).supportGroupCPs) {
                    observer.preBalanceRSGroup(this, name);
                }
            }
        });
    }

    public void postBalanceRSGroup(final String name, final boolean balanceRan) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                if (((MasterEnvironment)this.getEnvironment()).supportGroupCPs) {
                    observer.postBalanceRSGroup(this, name, balanceRan);
                }
            }
        });
    }

    public void preAddReplicationPeer(final String peerId, final ReplicationPeerConfig peerConfig) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preAddReplicationPeer(this, peerId, peerConfig);
            }
        });
    }

    public void postAddReplicationPeer(final String peerId, final ReplicationPeerConfig peerConfig) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postAddReplicationPeer(this, peerId, peerConfig);
            }
        });
    }

    public void preRemoveReplicationPeer(final String peerId) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preRemoveReplicationPeer(this, peerId);
            }
        });
    }

    public void postRemoveReplicationPeer(final String peerId) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postRemoveReplicationPeer(this, peerId);
            }
        });
    }

    public void preEnableReplicationPeer(final String peerId) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preEnableReplicationPeer(this, peerId);
            }
        });
    }

    public void postEnableReplicationPeer(final String peerId) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postEnableReplicationPeer(this, peerId);
            }
        });
    }

    public void preDisableReplicationPeer(final String peerId) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preDisableReplicationPeer(this, peerId);
            }
        });
    }

    public void postDisableReplicationPeer(final String peerId) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postDisableReplicationPeer(this, peerId);
            }
        });
    }

    public void preGetReplicationPeerConfig(final String peerId) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preGetReplicationPeerConfig(this, peerId);
            }
        });
    }

    public void postGetReplicationPeerConfig(final String peerId) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postGetReplicationPeerConfig(this, peerId);
            }
        });
    }

    public void preUpdateReplicationPeerConfig(final String peerId, final ReplicationPeerConfig peerConfig) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preUpdateReplicationPeerConfig(this, peerId, peerConfig);
            }
        });
    }

    public void postUpdateReplicationPeerConfig(final String peerId, final ReplicationPeerConfig peerConfig) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postUpdateReplicationPeerConfig(this, peerId, peerConfig);
            }
        });
    }

    public void preListReplicationPeers(final String regex) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preListReplicationPeers(this, regex);
            }
        });
    }

    public void postListReplicationPeers(final String regex) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postListReplicationPeers(this, regex);
            }
        });
    }

    public void preRequestLock(final String namespace, final TableName tableName, final RegionInfo[] regionInfos, LockType type, final String description) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preRequestLock(this, namespace, tableName, regionInfos, description);
            }
        });
    }

    public void postRequestLock(final String namespace, final TableName tableName, final RegionInfo[] regionInfos, LockType type, final String description) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postRequestLock(this, namespace, tableName, regionInfos, description);
            }
        });
    }

    public void preLockHeartbeat(final LockProcedure proc, boolean keepAlive) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preLockHeartbeat(this, proc.getTableName(), proc.getDescription());
            }
        });
    }

    public void postLockHeartbeat(LockProcedure proc, boolean keepAlive) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postLockHeartbeat(this);
            }
        });
    }

    public void preListDeadServers() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preListDeadServers(this);
            }
        });
    }

    public void postListDeadServers() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postListDeadServers(this);
            }
        });
    }

    public void preClearDeadServers() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preClearDeadServers(this);
            }
        });
    }

    public void postClearDeadServers() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postClearDeadServers(this);
            }
        });
    }

    public void preDecommissionRegionServers(final List<ServerName> servers, final boolean offload) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preDecommissionRegionServers(this, servers, offload);
            }
        });
    }

    public void postDecommissionRegionServers(final List<ServerName> servers, final boolean offload) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postDecommissionRegionServers(this, servers, offload);
            }
        });
    }

    public void preListDecommissionedRegionServers() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preListDecommissionedRegionServers(this);
            }
        });
    }

    public void postListDecommissionedRegionServers() throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postListDecommissionedRegionServers(this);
            }
        });
    }

    public void preRecommissionRegionServer(final ServerName server, final List<byte[]> encodedRegionNames) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.preRecommissionRegionServer(this, server, encodedRegionNames);
            }
        });
    }

    public void postRecommissionRegionServer(final ServerName server, final List<byte[]> encodedRegionNames) throws IOException {
        this.execOperation(this.coprocEnvironments.isEmpty() ? null : new MasterObserverOperation(){

            @Override
            public void call(MasterObserver observer) throws IOException {
                observer.postRecommissionRegionServer(this, server, encodedRegionNames);
            }
        });
    }

    abstract class MasterObserverOperation
    extends CoprocessorHost.ObserverOperationWithoutResult<MasterObserver> {
        public MasterObserverOperation() {
            super(MasterCoprocessorHost.this, MasterCoprocessorHost.this.masterObserverGetter);
        }

        public MasterObserverOperation(boolean bypassable) {
            this(null, bypassable);
        }

        public MasterObserverOperation(User user) {
            super((CoprocessorHost)MasterCoprocessorHost.this, MasterCoprocessorHost.this.masterObserverGetter, user);
        }

        public MasterObserverOperation(User user, boolean bypassable) {
            super(MasterCoprocessorHost.this, MasterCoprocessorHost.this.masterObserverGetter, user, bypassable);
        }
    }

    private static class MasterEnvironmentForCoreCoprocessors
    extends MasterEnvironment
    implements HasMasterServices {
        private final MasterServices masterServices;

        public MasterEnvironmentForCoreCoprocessors(MasterCoprocessor impl, int priority, int seq, Configuration conf, MasterServices services) {
            super(impl, priority, seq, conf, services);
            this.masterServices = services;
        }

        @Override
        public MasterServices getMasterServices() {
            return this.masterServices;
        }
    }

    private static class MasterEnvironment
    extends BaseEnvironment<MasterCoprocessor>
    implements MasterCoprocessorEnvironment {
        private final Connection connection;
        private final ServerName serverName;
        private final boolean supportGroupCPs;
        private final MetricRegistry metricRegistry;

        public MasterEnvironment(MasterCoprocessor impl, int priority, int seq, Configuration conf, MasterServices services) {
            super(impl, priority, seq, conf);
            this.connection = services.getConnection();
            this.serverName = services.getServerName();
            this.supportGroupCPs = !MasterCoprocessorHost.useLegacyMethod(impl.getClass(), "preBalanceRSGroup", new Class[]{ObserverContext.class, String.class});
            this.metricRegistry = MetricsCoprocessor.createRegistryForMasterCoprocessor(impl.getClass().getName());
        }

        @Override
        public ServerName getServerName() {
            return this.serverName;
        }

        @Override
        public Connection getConnection() {
            return this.connection;
        }

        @Override
        public MetricRegistry getMetricRegistryForMaster() {
            return this.metricRegistry;
        }

        @Override
        public void shutdown() {
            super.shutdown();
            MetricsCoprocessor.removeRegistry(this.metricRegistry);
        }
    }
}

