/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.assignment.AssignProcedure;
import org.apache.hadoop.hbase.master.assignment.UnassignProcedure;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.Message;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MoveRegionProcedure
extends AbstractStateMachineRegionProcedure<MasterProcedureProtos.MoveRegionState> {
    private static final Log LOG = LogFactory.getLog(MoveRegionProcedure.class);
    private RegionPlan plan;

    public MoveRegionProcedure() {
    }

    public MoveRegionProcedure(MasterProcedureEnv env, RegionPlan plan) {
        super(env, plan.getRegionInfo());
        this.plan = plan;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.MoveRegionState state) throws InterruptedException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this + " execute state=" + state));
        }
        switch (state) {
            case MOVE_REGION_UNASSIGN: {
                this.addChildProcedure(new Procedure[]{new UnassignProcedure(this.plan.getRegionInfo(), this.plan.getSource(), true)});
                this.setNextState(MasterProcedureProtos.MoveRegionState.MOVE_REGION_ASSIGN);
                break;
            }
            case MOVE_REGION_ASSIGN: {
                AssignProcedure assignProcedure = this.plan.getDestination() == null ? new AssignProcedure(this.plan.getRegionInfo(), true) : new AssignProcedure(this.plan.getRegionInfo(), this.plan.getDestination());
                this.addChildProcedure(new Procedure[]{assignProcedure});
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            default: {
                throw new UnsupportedOperationException("unhandled state=" + state);
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.MoveRegionState state) throws IOException {
    }

    public boolean abort(MasterProcedureEnv env) {
        return false;
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" ");
        sb.append(this.plan);
    }

    protected MasterProcedureProtos.MoveRegionState getInitialState() {
        return MasterProcedureProtos.MoveRegionState.MOVE_REGION_UNASSIGN;
    }

    protected int getStateId(MasterProcedureProtos.MoveRegionState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.MoveRegionState getState(int stateId) {
        return MasterProcedureProtos.MoveRegionState.valueOf((int)stateId);
    }

    @Override
    public TableName getTableName() {
        return this.plan.getRegionInfo().getTable();
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.REGION_EDIT;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.MoveRegionStateData.Builder state = MasterProcedureProtos.MoveRegionStateData.newBuilder().setSourceServer(ProtobufUtil.toServerName((ServerName)this.plan.getSource()));
        if (this.plan.getDestination() != null) {
            state.setDestinationServer(ProtobufUtil.toServerName((ServerName)this.plan.getDestination()));
        }
        serializer.serialize((Message)state.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.MoveRegionStateData state = (MasterProcedureProtos.MoveRegionStateData)serializer.deserialize(MasterProcedureProtos.MoveRegionStateData.class);
        RegionInfo regionInfo = this.getRegion();
        ServerName sourceServer = ProtobufUtil.toServerName((HBaseProtos.ServerName)state.getSourceServer());
        ServerName destinationServer = state.hasDestinationServer() ? ProtobufUtil.toServerName((HBaseProtos.ServerName)state.getDestinationServer()) : null;
        this.plan = new RegionPlan(regionInfo, sourceServer, destinationServer);
    }
}

