/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class BalancerChore
extends ScheduledChore {
    private static final Log LOG = LogFactory.getLog(BalancerChore.class);
    private final HMaster master;

    public BalancerChore(HMaster master) {
        super(master.getServerName() + "-BalancerChore", (Stoppable)master, master.getConfiguration().getInt("hbase.balancer.period", 300000));
        this.master = master;
    }

    protected void chore() {
        try {
            this.master.balance();
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to balance.", (Throwable)e);
        }
    }
}

