/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.snapshot.SnapshotReferenceUtil;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class MasterSnapshotVerifier {
    private static final Log LOG = LogFactory.getLog(MasterSnapshotVerifier.class);
    private SnapshotProtos.SnapshotDescription snapshot;
    private FileSystem fs;
    private Path rootDir;
    private TableName tableName;
    private MasterServices services;

    public MasterSnapshotVerifier(MasterServices services, SnapshotProtos.SnapshotDescription snapshot, Path rootDir) {
        this.fs = services.getMasterFileSystem().getFileSystem();
        this.services = services;
        this.snapshot = snapshot;
        this.rootDir = rootDir;
        this.tableName = TableName.valueOf((String)snapshot.getTable());
    }

    public void verifySnapshot(Path snapshotDir, Set<String> snapshotServers) throws CorruptedSnapshotException, IOException {
        SnapshotManifest manifest = SnapshotManifest.open(this.services.getConfiguration(), this.fs, snapshotDir, this.snapshot);
        this.verifySnapshotDescription(snapshotDir);
        this.verifyTableInfo(manifest);
        this.verifyRegions(manifest);
    }

    private void verifySnapshotDescription(Path snapshotDir) throws CorruptedSnapshotException {
        SnapshotProtos.SnapshotDescription found = SnapshotDescriptionUtils.readSnapshotInfo(this.fs, snapshotDir);
        if (!this.snapshot.equals((Object)found)) {
            throw new CorruptedSnapshotException("Snapshot read (" + found + ") doesn't equal snapshot we ran (" + this.snapshot + ").", ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)this.snapshot));
        }
    }

    private void verifyTableInfo(SnapshotManifest manifest) throws IOException {
        TableDescriptor htd = manifest.getTableDescriptor();
        if (htd == null) {
            throw new CorruptedSnapshotException("Missing Table Descriptor", ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)this.snapshot));
        }
        if (!htd.getTableName().getNameAsString().equals(this.snapshot.getTable())) {
            throw new CorruptedSnapshotException("Invalid Table Descriptor. Expected " + this.snapshot.getTable() + " name, got " + htd.getTableName().getNameAsString(), ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)this.snapshot));
        }
    }

    private void verifyRegions(SnapshotManifest manifest) throws IOException {
        int realRegionCount;
        List regions = TableName.META_TABLE_NAME.equals((Object)this.tableName) ? new MetaTableLocator().getMetaRegions(this.services.getZooKeeper()) : MetaTableAccessor.getTableRegions((Connection)this.services.getConnection(), (TableName)this.tableName);
        RegionReplicaUtil.removeNonDefaultRegions((Collection)regions);
        Map<String, SnapshotProtos.SnapshotRegionManifest> regionManifests = manifest.getRegionManifestsMap();
        if (regionManifests == null) {
            String msg = "Snapshot " + ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)this.snapshot) + " looks empty";
            LOG.error((Object)msg);
            throw new CorruptedSnapshotException(msg);
        }
        String errorMsg = "";
        boolean hasMobStore = false;
        if (regionManifests.get(MobUtils.getMobRegionInfo(this.tableName).getEncodedName()) != null) {
            hasMobStore = true;
        }
        int n = realRegionCount = hasMobStore ? regionManifests.size() - 1 : regionManifests.size();
        if (realRegionCount != regions.size()) {
            errorMsg = "Regions moved during the snapshot '" + ClientSnapshotDescriptionUtils.toString((SnapshotProtos.SnapshotDescription)this.snapshot) + "'. expected=" + regions.size() + " snapshotted=" + realRegionCount + ".";
            LOG.error((Object)errorMsg);
        }
        for (RegionInfo region : regions) {
            SnapshotProtos.SnapshotRegionManifest regionManifest = regionManifests.get(region.getEncodedName());
            if (regionManifest == null) {
                String mesg = " No snapshot region directory found for region:" + region;
                if (errorMsg.isEmpty()) {
                    errorMsg = mesg;
                }
                LOG.error((Object)mesg);
                continue;
            }
            this.verifyRegionInfo(region, regionManifest);
        }
        if (!errorMsg.isEmpty()) {
            throw new CorruptedSnapshotException(errorMsg);
        }
        SnapshotReferenceUtil.verifySnapshot(this.services.getConfiguration(), this.fs, manifest);
    }

    private void verifyRegionInfo(RegionInfo region, SnapshotProtos.SnapshotRegionManifest manifest) throws IOException {
        RegionInfo manifestRegionInfo = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)manifest.getRegionInfo());
        if (RegionInfo.COMPARATOR.compare(region, manifestRegionInfo) != 0) {
            String msg = "Manifest region info " + manifestRegionInfo + "doesn't match expected region:" + region;
            throw new CorruptedSnapshotException(msg, ProtobufUtil.createSnapshotDesc((SnapshotProtos.SnapshotDescription)this.snapshot));
        }
    }
}

