/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.regionserver.ByteBufferChunkCell;
import org.apache.hadoop.hbase.regionserver.CellFlatMap;
import org.apache.hadoop.hbase.regionserver.Chunk;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CellChunkMap
extends CellFlatMap {
    private final Chunk[] chunks;
    public static final int NUM_OF_CELL_REPS_IN_CHUNK = (ChunkCreator.getInstance().getChunkSize() - 4) / ClassSize.CELL_CHUNK_MAP_ENTRY;

    public CellChunkMap(Comparator<? super Cell> comparator, Chunk[] chunks, int min, int max, boolean descending) {
        super(comparator, min, max, descending);
        this.chunks = chunks;
    }

    @Override
    protected CellFlatMap createSubCellFlatMap(int min, int max, boolean descending) {
        return new CellChunkMap(this.comparator(), this.chunks, min, max, descending);
    }

    @Override
    protected Cell getCell(int i) {
        int chunkIndex = i / NUM_OF_CELL_REPS_IN_CHUNK;
        ByteBuffer block = this.chunks[chunkIndex].getData();
        int j = i - chunkIndex * NUM_OF_CELL_REPS_IN_CHUNK;
        int offsetInBytes = 4 + j * ClassSize.CELL_CHUNK_MAP_ENTRY;
        int chunkId = ByteBufferUtils.toInt((ByteBuffer)block, (int)offsetInBytes);
        Chunk chunk = ChunkCreator.getInstance().getChunk(chunkId);
        if (chunk == null) {
            throw new IllegalArgumentException("In CellChunkMap, cell must be associated with chunk.. We were looking for a cell at index " + i);
        }
        int offsetOfCell = ByteBufferUtils.toInt((ByteBuffer)block, (int)(offsetInBytes + 4));
        int lengthOfCell = ByteBufferUtils.toInt((ByteBuffer)block, (int)(offsetInBytes + 8));
        long cellSeqID = ByteBufferUtils.toLong((ByteBuffer)block, (int)(offsetInBytes + 12));
        ByteBuffer buf = chunk.getData();
        if (buf == null) {
            throw new IllegalArgumentException("In CellChunkMap, chunk must be associated with ByteBuffer. Chunk: " + chunk + " Chunk ID: " + chunk.getId() + ", is from pool: " + chunk.isFromPool() + ". We were looking for a cell at index " + i);
        }
        return new ByteBufferChunkCell(buf, offsetOfCell, lengthOfCell, cellSeqID);
    }
}

