/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DroppedSnapshotException;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.regionserver.FlushLifeCycleTracker;
import org.apache.hadoop.hbase.regionserver.FlushRequestListener;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.FlushType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Preconditions;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.HasThread;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.StringUtils;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class MemStoreFlusher
implements FlushRequester {
    private static final Log LOG = LogFactory.getLog(MemStoreFlusher.class);
    private Configuration conf;
    private final BlockingQueue<FlushQueueEntry> flushQueue = new DelayQueue<FlushQueueEntry>();
    private final Map<Region, FlushRegionEntry> regionsInQueue = new HashMap<Region, FlushRegionEntry>();
    private AtomicBoolean wakeupPending = new AtomicBoolean();
    private final long threadWakeFrequency;
    private final HRegionServer server;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Object blockSignal = new Object();
    private long blockingWaitTime;
    private final LongAdder updatesBlockedMsHighWater = new LongAdder();
    private final FlushHandler[] flushHandlers;
    private List<FlushRequestListener> flushRequestListeners = new ArrayList<FlushRequestListener>(1);

    public MemStoreFlusher(Configuration conf, HRegionServer server) {
        this.conf = conf;
        this.server = server;
        this.threadWakeFrequency = conf.getLong("hbase.server.thread.wakefrequency", 10000L);
        this.blockingWaitTime = conf.getInt("hbase.hstore.blockingWaitTime", 90000);
        int handlerCount = conf.getInt("hbase.hstore.flusher.count", 2);
        this.flushHandlers = new FlushHandler[handlerCount];
        LOG.info((Object)("globalMemStoreLimit=" + StringUtils.TraditionalBinaryPrefix.long2String((long)this.server.getRegionServerAccounting().getGlobalMemStoreLimit(), (String)"", (int)1) + ", globalMemStoreLimitLowMark=" + StringUtils.TraditionalBinaryPrefix.long2String((long)this.server.getRegionServerAccounting().getGlobalMemStoreLimitLowMark(), (String)"", (int)1) + ", Offheap=" + this.server.getRegionServerAccounting().isOffheap()));
    }

    public LongAdder getUpdatesBlockedMsHighWater() {
        return this.updatesBlockedMsHighWater;
    }

    private boolean flushOneForGlobalPressure() {
        SortedMap<Long, HRegion> regionsBySize = this.server.getCopyOfOnlineRegionsSortedBySize();
        HashSet<HRegion> excludedRegions = new HashSet<HRegion>();
        double secondaryMultiplier = ServerRegionReplicaUtil.getRegionReplicaStoreFileRefreshMultiplier(this.conf);
        boolean flushedOne = false;
        while (!flushedOne) {
            HRegion regionToFlush;
            HRegion bestFlushableRegion = this.getBiggestMemStoreRegion(regionsBySize, excludedRegions, true);
            HRegion bestAnyRegion = this.getBiggestMemStoreRegion(regionsBySize, excludedRegions, false);
            HRegion bestRegionReplica = this.getBiggestMemStoreOfRegionReplica(regionsBySize, excludedRegions);
            if (bestAnyRegion == null && bestRegionReplica == null) {
                LOG.error((Object)"Above memory mark but there are no flushable regions!");
                return false;
            }
            if (bestFlushableRegion != null && bestAnyRegion.getMemStoreSize() > 2L * bestFlushableRegion.getMemStoreSize()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Under global heap pressure: Region " + bestAnyRegion.getRegionInfo().getRegionNameAsString() + " has too many store files, but is " + StringUtils.TraditionalBinaryPrefix.long2String((long)bestAnyRegion.getMemStoreSize(), (String)"", (int)1) + " vs best flushable region's " + StringUtils.TraditionalBinaryPrefix.long2String((long)bestFlushableRegion.getMemStoreSize(), (String)"", (int)1) + ". Choosing the bigger."));
                }
                regionToFlush = bestAnyRegion;
            } else {
                regionToFlush = bestFlushableRegion == null ? bestAnyRegion : bestFlushableRegion;
            }
            Preconditions.checkState((regionToFlush != null && regionToFlush.getMemStoreSize() > 0L || bestRegionReplica != null && bestRegionReplica.getMemStoreSize() > 0L ? 1 : 0) != 0);
            if (regionToFlush == null || bestRegionReplica != null && ServerRegionReplicaUtil.isRegionReplicaStoreFileRefreshEnabled(this.conf) && (double)bestRegionReplica.getMemStoreSize() > secondaryMultiplier * (double)regionToFlush.getMemStoreSize()) {
                LOG.info((Object)("Refreshing storefiles of region " + bestRegionReplica + " due to global heap pressure. Total memstore datasize=" + StringUtils.TraditionalBinaryPrefix.long2String((long)this.server.getRegionServerAccounting().getGlobalMemStoreDataSize(), (String)"", (int)1) + " memstore heap size=" + StringUtils.TraditionalBinaryPrefix.long2String((long)this.server.getRegionServerAccounting().getGlobalMemStoreHeapSize(), (String)"", (int)1)));
                flushedOne = this.refreshStoreFilesAndReclaimMemory(bestRegionReplica);
                if (flushedOne) continue;
                LOG.info((Object)("Excluding secondary region " + bestRegionReplica + " - trying to find a different region to refresh files."));
                excludedRegions.add(bestRegionReplica);
                continue;
            }
            LOG.info((Object)("Flush of region " + regionToFlush + " due to global heap pressure. Total Memstore size=" + StringUtils.TraditionalBinaryPrefix.long2String((long)this.server.getRegionServerAccounting().getGlobalMemStoreDataSize(), (String)"", (int)1) + ", Region memstore size=" + StringUtils.TraditionalBinaryPrefix.long2String((long)regionToFlush.getMemStoreSize(), (String)"", (int)1)));
            flushedOne = this.flushRegion(regionToFlush, true, false, FlushLifeCycleTracker.DUMMY);
            if (flushedOne) continue;
            LOG.info((Object)("Excluding unflushable region " + regionToFlush + " - trying to find a different region to flush."));
            excludedRegions.add(regionToFlush);
        }
        return true;
    }

    private void wakeupFlushThread() {
        if (this.wakeupPending.compareAndSet(false, true)) {
            this.flushQueue.add(new WakeupFlushThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HRegion getBiggestMemStoreRegion(SortedMap<Long, HRegion> regionsBySize, Set<HRegion> excludedRegions, boolean checkStoreFileCount) {
        Map<Region, FlushRegionEntry> map = this.regionsInQueue;
        synchronized (map) {
            for (HRegion region : regionsBySize.values()) {
                if (excludedRegions.contains(region) || region.writestate.flushing || !region.writestate.writesEnabled || checkStoreFileCount && this.isTooManyStoreFiles(region)) continue;
                return region;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HRegion getBiggestMemStoreOfRegionReplica(SortedMap<Long, HRegion> regionsBySize, Set<HRegion> excludedRegions) {
        Map<Region, FlushRegionEntry> map = this.regionsInQueue;
        synchronized (map) {
            for (HRegion region : regionsBySize.values()) {
                if (excludedRegions.contains(region) || RegionReplicaUtil.isDefaultReplica((RegionInfo)region.getRegionInfo())) continue;
                return region;
            }
        }
        return null;
    }

    private boolean refreshStoreFilesAndReclaimMemory(Region region) {
        try {
            return region.refreshStoreFiles();
        }
        catch (IOException e) {
            LOG.warn((Object)"Refreshing store files failed with exception", (Throwable)e);
            return false;
        }
    }

    private FlushType isAboveHighWaterMark() {
        return this.server.getRegionServerAccounting().isAboveHighWaterMark();
    }

    private FlushType isAboveLowWaterMark() {
        return this.server.getRegionServerAccounting().isAboveLowWaterMark();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestFlush(HRegion r, boolean forceFlushAllStores, FlushLifeCycleTracker tracker) {
        r.incrementFlushesQueuedCount();
        Map<Region, FlushRegionEntry> map = this.regionsInQueue;
        synchronized (map) {
            if (!this.regionsInQueue.containsKey(r)) {
                FlushRegionEntry fqe = new FlushRegionEntry(r, forceFlushAllStores, tracker);
                this.regionsInQueue.put(r, fqe);
                this.flushQueue.add(fqe);
            } else {
                tracker.notExecuted("Flush already requested on " + r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestDelayedFlush(HRegion r, long delay, boolean forceFlushAllStores) {
        r.incrementFlushesQueuedCount();
        Map<Region, FlushRegionEntry> map = this.regionsInQueue;
        synchronized (map) {
            if (!this.regionsInQueue.containsKey(r)) {
                FlushRegionEntry fqe = new FlushRegionEntry(r, forceFlushAllStores, FlushLifeCycleTracker.DUMMY);
                fqe.requeue(delay);
                this.regionsInQueue.put(r, fqe);
                this.flushQueue.add(fqe);
            }
        }
    }

    public int getFlushQueueSize() {
        return this.flushQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interruptIfNecessary() {
        this.lock.writeLock().lock();
        try {
            for (FlushHandler flushHander : this.flushHandlers) {
                if (flushHander == null) continue;
                flushHander.interrupt();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    synchronized void start(Thread.UncaughtExceptionHandler eh) {
        ThreadFactory flusherThreadFactory = Threads.newDaemonThreadFactory((String)(this.server.getServerName().toShortString() + "-MemStoreFlusher"), (Thread.UncaughtExceptionHandler)eh);
        for (int i = 0; i < this.flushHandlers.length; ++i) {
            this.flushHandlers[i] = new FlushHandler("MemStoreFlusher." + i);
            flusherThreadFactory.newThread((Runnable)((Object)this.flushHandlers[i]));
            this.flushHandlers[i].start();
        }
    }

    boolean isAlive() {
        for (FlushHandler flushHander : this.flushHandlers) {
            if (flushHander == null || !flushHander.isAlive()) continue;
            return true;
        }
        return false;
    }

    void join() {
        for (FlushHandler flushHander : this.flushHandlers) {
            if (flushHander == null) continue;
            Threads.shutdown((Thread)flushHander.getThread());
        }
    }

    private boolean flushRegion(FlushRegionEntry fqe) {
        HRegion region = fqe.region;
        if (!region.getRegionInfo().isMetaRegion() && this.isTooManyStoreFiles(region)) {
            if (fqe.isMaximumWait(this.blockingWaitTime)) {
                LOG.info((Object)("Waited " + (EnvironmentEdgeManager.currentTime() - fqe.createTime) + "ms on a compaction to clean up 'too many store files'; waited long enough... proceeding with flush of " + region.getRegionInfo().getRegionNameAsString()));
            } else {
                if (fqe.getRequeueCount() <= 0) {
                    LOG.warn((Object)("Region " + region.getRegionInfo().getRegionNameAsString() + " has too many store files; delaying flush up to " + this.blockingWaitTime + "ms"));
                    if (!this.server.compactSplitThread.requestSplit(region)) {
                        try {
                            this.server.compactSplitThread.requestSystemCompaction(region, Thread.currentThread().getName());
                        }
                        catch (IOException e) {
                            e = e instanceof RemoteException ? ((RemoteException)e).unwrapRemoteException() : e;
                            LOG.error((Object)("Cache flush failed for region " + Bytes.toStringBinary((byte[])region.getRegionInfo().getRegionName())), (Throwable)e);
                        }
                    }
                }
                this.flushQueue.add(fqe.requeue(this.blockingWaitTime / 100L));
                return true;
            }
        }
        return this.flushRegion(region, false, fqe.isForceFlushAllStores(), fqe.getTracker());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flushRegion(HRegion region, boolean emergencyFlush, boolean forceFlushAllStores, FlushLifeCycleTracker tracker) {
        Map<Region, FlushRegionEntry> map = this.regionsInQueue;
        synchronized (map) {
            FlushRegionEntry fqe = this.regionsInQueue.remove(region);
            if (fqe != null && emergencyFlush) {
                this.flushQueue.remove(fqe);
            }
        }
        tracker.beforeExecution();
        this.lock.readLock().lock();
        try {
            boolean shouldSplit;
            this.notifyFlushRequest(region, emergencyFlush);
            HRegion.FlushResultImpl flushResult = region.flushcache(forceFlushAllStores, false, tracker);
            boolean shouldCompact = flushResult.isCompactionNeeded();
            boolean bl = shouldSplit = region.checkSplit() != null;
            if (shouldSplit) {
                this.server.compactSplitThread.requestSplit(region);
            } else if (shouldCompact) {
                this.server.compactSplitThread.requestSystemCompaction(region, Thread.currentThread().getName());
            }
        }
        catch (DroppedSnapshotException ex) {
            this.server.abort("Replay of WAL required. Forcing server shutdown", ex);
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            ex = ex instanceof RemoteException ? ((RemoteException)ex).unwrapRemoteException() : ex;
            LOG.error((Object)("Cache flush failed" + (region != null ? " for region " + Bytes.toStringBinary((byte[])region.getRegionInfo().getRegionName()) : "")), (Throwable)ex);
            if (!this.server.checkFileSystem()) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.readLock().unlock();
            this.wakeUpIfBlocking();
            tracker.afterExecution();
        }
        return true;
    }

    private void notifyFlushRequest(Region region, boolean emergencyFlush) {
        FlushType type = null;
        if (emergencyFlush && (type = this.isAboveHighWaterMark()) == null) {
            type = this.isAboveLowWaterMark();
        }
        for (FlushRequestListener listener : this.flushRequestListeners) {
            listener.flushRequested(type, region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUpIfBlocking() {
        Object object = this.blockSignal;
        synchronized (object) {
            this.blockSignal.notifyAll();
        }
    }

    private boolean isTooManyStoreFiles(Region region) {
        if (!region.getTableDescriptor().isCompactionEnabled()) {
            return false;
        }
        for (Store store : region.getStores()) {
            if (!store.hasTooManyStoreFiles()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reclaimMemStoreMemory() {
        TraceScope scope = Trace.startSpan((String)"MemStoreFluser.reclaimMemStoreMemory");
        FlushType flushType = this.isAboveHighWaterMark();
        if (flushType != FlushType.NORMAL) {
            if (Trace.isTracing()) {
                scope.getSpan().addTimelineAnnotation("Force Flush. We're above high water mark.");
            }
            long start = EnvironmentEdgeManager.currentTime();
            Object object = this.blockSignal;
            synchronized (object) {
                boolean blocked = false;
                long startTime = 0L;
                boolean interrupted = false;
                try {
                    flushType = this.isAboveHighWaterMark();
                    while (flushType != FlushType.NORMAL && !this.server.isStopped()) {
                        if (!blocked) {
                            startTime = EnvironmentEdgeManager.currentTime();
                            if (!this.server.getRegionServerAccounting().isOffheap()) {
                                this.logMsg("global memstore heapsize", this.server.getRegionServerAccounting().getGlobalMemStoreHeapSize(), this.server.getRegionServerAccounting().getGlobalMemStoreLimit());
                            } else {
                                switch (flushType) {
                                    case ABOVE_OFFHEAP_HIGHER_MARK: {
                                        this.logMsg("the global offheap memstore datasize", this.server.getRegionServerAccounting().getGlobalMemStoreDataSize(), this.server.getRegionServerAccounting().getGlobalMemStoreLimit());
                                        break;
                                    }
                                    case ABOVE_ONHEAP_HIGHER_MARK: {
                                        this.logMsg("global memstore heapsize", this.server.getRegionServerAccounting().getGlobalMemStoreHeapSize(), this.server.getRegionServerAccounting().getGlobalOnHeapMemStoreLimit());
                                        break;
                                    }
                                }
                            }
                        }
                        blocked = true;
                        this.wakeupFlushThread();
                        try {
                            this.blockSignal.wait(5000L);
                        }
                        catch (InterruptedException ie) {
                            LOG.warn((Object)"Interrupted while waiting");
                            interrupted = true;
                        }
                        long took = EnvironmentEdgeManager.currentTime() - start;
                        LOG.warn((Object)("Memstore is above high water mark and block " + took + "ms"));
                        flushType = this.isAboveHighWaterMark();
                    }
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (blocked) {
                    long totalTime = EnvironmentEdgeManager.currentTime() - startTime;
                    if (totalTime > 0L) {
                        this.updatesBlockedMsHighWater.add(totalTime);
                    }
                    LOG.info((Object)("Unblocking updates for server " + this.server.toString()));
                }
            }
        }
        if (this.isAboveLowWaterMark() != FlushType.NORMAL) {
            this.wakeupFlushThread();
        }
        scope.close();
    }

    private void logMsg(String string1, long val, long max) {
        LOG.info((Object)("Blocking updates on " + this.server.toString() + ": " + string1 + " " + StringUtils.TraditionalBinaryPrefix.long2String((long)val, (String)"", (int)1) + " is >= than blocking " + StringUtils.TraditionalBinaryPrefix.long2String((long)max, (String)"", (int)1) + " size"));
    }

    public String toString() {
        return "flush_queue=" + this.flushQueue.size();
    }

    public String dumpQueue() {
        StringBuilder queueList = new StringBuilder();
        queueList.append("Flush Queue Queue dump:\n");
        queueList.append("  Flush Queue:\n");
        Iterator it = this.flushQueue.iterator();
        while (it.hasNext()) {
            queueList.append("    " + ((FlushQueueEntry)it.next()).toString());
            queueList.append("\n");
        }
        return queueList.toString();
    }

    @Override
    public void registerFlushRequestListener(FlushRequestListener listener) {
        this.flushRequestListeners.add(listener);
    }

    @Override
    public boolean unregisterFlushRequestListener(FlushRequestListener listener) {
        return this.flushRequestListeners.remove(listener);
    }

    @Override
    public void setGlobalMemStoreLimit(long globalMemStoreSize) {
        this.server.getRegionServerAccounting().setGlobalMemStoreLimits(globalMemStoreSize);
        this.reclaimMemStoreMemory();
    }

    static class FlushRegionEntry
    implements FlushQueueEntry {
        private final HRegion region;
        private final long createTime;
        private long whenToExpire;
        private int requeueCount = 0;
        private final boolean forceFlushAllStores;
        private final FlushLifeCycleTracker tracker;

        FlushRegionEntry(HRegion r, boolean forceFlushAllStores, FlushLifeCycleTracker tracker) {
            this.region = r;
            this.whenToExpire = this.createTime = EnvironmentEdgeManager.currentTime();
            this.forceFlushAllStores = forceFlushAllStores;
            this.tracker = tracker;
        }

        public boolean isMaximumWait(long maximumWait) {
            return EnvironmentEdgeManager.currentTime() - this.createTime > maximumWait;
        }

        public int getRequeueCount() {
            return this.requeueCount;
        }

        public boolean isForceFlushAllStores() {
            return this.forceFlushAllStores;
        }

        public FlushLifeCycleTracker getTracker() {
            return this.tracker;
        }

        public FlushRegionEntry requeue(long when) {
            this.whenToExpire = EnvironmentEdgeManager.currentTime() + when;
            ++this.requeueCount;
            return this;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.whenToExpire - EnvironmentEdgeManager.currentTime(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            int ret = Long.valueOf(this.getDelay(TimeUnit.MILLISECONDS) - other.getDelay(TimeUnit.MILLISECONDS)).intValue();
            if (ret != 0) {
                return ret;
            }
            FlushQueueEntry otherEntry = (FlushQueueEntry)other;
            return this.hashCode() - otherEntry.hashCode();
        }

        public String toString() {
            return "[flush region " + Bytes.toStringBinary((byte[])this.region.getRegionInfo().getRegionName()) + "]";
        }

        public int hashCode() {
            int hash = (int)this.getDelay(TimeUnit.MILLISECONDS);
            return hash ^ this.region.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FlushRegionEntry other = (FlushRegionEntry)obj;
            if (!Bytes.equals((byte[])this.region.getRegionInfo().getRegionName(), (byte[])other.region.getRegionInfo().getRegionName())) {
                return false;
            }
            return this.compareTo(other) == 0;
        }
    }

    static class WakeupFlushThread
    implements FlushQueueEntry {
        WakeupFlushThread() {
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return 0L;
        }

        @Override
        public int compareTo(Delayed o) {
            return -1;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }
    }

    static interface FlushQueueEntry
    extends Delayed {
    }

    private class FlushHandler
    extends HasThread {
        private FlushHandler(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!MemStoreFlusher.this.server.isStopped()) {
                FlushQueueEntry fqe = null;
                try {
                    MemStoreFlusher.this.wakeupPending.set(false);
                    fqe = (FlushQueueEntry)MemStoreFlusher.this.flushQueue.poll(MemStoreFlusher.this.threadWakeFrequency, TimeUnit.MILLISECONDS);
                    if (fqe == null || fqe instanceof WakeupFlushThread) {
                        FlushType type = MemStoreFlusher.this.isAboveLowWaterMark();
                        if (type == FlushType.NORMAL) continue;
                        LOG.debug((Object)("Flush thread woke up because memory above low water=" + StringUtils.TraditionalBinaryPrefix.long2String((long)MemStoreFlusher.this.server.getRegionServerAccounting().getGlobalMemStoreLimitLowMark(), (String)"", (int)1)));
                        if (!MemStoreFlusher.this.flushOneForGlobalPressure()) {
                            Thread.sleep(1000L);
                            MemStoreFlusher.this.wakeUpIfBlocking();
                        }
                        MemStoreFlusher.this.wakeupFlushThread();
                        continue;
                    }
                    FlushRegionEntry fre = (FlushRegionEntry)fqe;
                    if (MemStoreFlusher.this.flushRegion(fre)) continue;
                    break;
                }
                catch (InterruptedException ex) {
                }
                catch (ConcurrentModificationException ex) {
                }
                catch (Exception ex) {
                    LOG.error((Object)("Cache flusher failed for entry " + fqe), (Throwable)ex);
                    if (MemStoreFlusher.this.server.checkFileSystem()) continue;
                    break;
                }
            }
            Map map = MemStoreFlusher.this.regionsInQueue;
            synchronized (map) {
                MemStoreFlusher.this.regionsInQueue.clear();
                MemStoreFlusher.this.flushQueue.clear();
            }
            MemStoreFlusher.this.wakeUpIfBlocking();
            LOG.info((Object)(this.getName() + " exiting"));
        }
    }
}

