/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSourceFactory;
import org.apache.hadoop.hbase.regionserver.MetricsTableAggregateSource;
import org.apache.hadoop.hbase.regionserver.MetricsTableSource;
import org.apache.hadoop.hbase.regionserver.MetricsTableWrapperAggregate;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Sets;
import org.apache.hadoop.metrics2.MetricsExecutor;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsTableWrapperAggregateImpl
implements MetricsTableWrapperAggregate,
Closeable {
    private final HRegionServer regionServer;
    private ScheduledExecutorService executor;
    private Runnable runnable;
    private long period;
    private ScheduledFuture<?> tableMetricsUpdateTask;
    private ConcurrentHashMap<TableName, MetricsTableValues> metricsTableMap = new ConcurrentHashMap();

    public MetricsTableWrapperAggregateImpl(HRegionServer regionServer) {
        this.regionServer = regionServer;
        this.period = regionServer.conf.getLong("hbase.regionserver.metrics.period", 5000L) + 1000L;
        this.executor = ((MetricsExecutor)CompatibilitySingletonFactory.getInstance(MetricsExecutor.class)).getExecutor();
        this.runnable = new TableMetricsWrapperRunnable();
        this.tableMetricsUpdateTask = this.executor.scheduleWithFixedDelay(this.runnable, this.period, this.period, TimeUnit.MILLISECONDS);
    }

    public long getReadRequestsCount(String table) {
        MetricsTableValues metricsTable = this.metricsTableMap.get(TableName.valueOf((String)table));
        if (metricsTable == null) {
            return 0L;
        }
        return metricsTable.getReadRequestsCount();
    }

    public long getWriteRequestsCount(String table) {
        MetricsTableValues metricsTable = this.metricsTableMap.get(TableName.valueOf((String)table));
        if (metricsTable == null) {
            return 0L;
        }
        return metricsTable.getWriteRequestsCount();
    }

    public long getTotalRequestsCount(String table) {
        MetricsTableValues metricsTable = this.metricsTableMap.get(TableName.valueOf((String)table));
        if (metricsTable == null) {
            return 0L;
        }
        return metricsTable.getTotalRequestsCount();
    }

    public long getMemStoresSize(String table) {
        MetricsTableValues metricsTable = this.metricsTableMap.get(TableName.valueOf((String)table));
        if (metricsTable == null) {
            return 0L;
        }
        return metricsTable.getMemStoresSize();
    }

    public long getStoreFilesSize(String table) {
        MetricsTableValues metricsTable = this.metricsTableMap.get(TableName.valueOf((String)table));
        if (metricsTable == null) {
            return 0L;
        }
        return metricsTable.getStoreFilesSize();
    }

    public long getTableSize(String table) {
        MetricsTableValues metricsTable = this.metricsTableMap.get(TableName.valueOf((String)table));
        if (metricsTable == null) {
            return 0L;
        }
        return metricsTable.getTableSize();
    }

    @Override
    public void close() throws IOException {
        this.tableMetricsUpdateTask.cancel(true);
    }

    private static class MetricsTableValues {
        private long totalRequestsCount;
        private long readRequestsCount;
        private long writeRequestsCount;
        private long memstoresSize;
        private long storeFilesSize;
        private long tableSize;

        private MetricsTableValues() {
        }

        public long getTotalRequestsCount() {
            return this.totalRequestsCount;
        }

        public void setTotalRequestsCount(long totalRequestsCount) {
            this.totalRequestsCount = totalRequestsCount;
        }

        public long getReadRequestsCount() {
            return this.readRequestsCount;
        }

        public void setReadRequestsCount(long readRequestsCount) {
            this.readRequestsCount = readRequestsCount;
        }

        public long getWriteRequestsCount() {
            return this.writeRequestsCount;
        }

        public void setWriteRequestsCount(long writeRequestsCount) {
            this.writeRequestsCount = writeRequestsCount;
        }

        public long getMemStoresSize() {
            return this.memstoresSize;
        }

        public void setMemStoresSize(long memstoresSize) {
            this.memstoresSize = memstoresSize;
        }

        public long getStoreFilesSize() {
            return this.storeFilesSize;
        }

        public void setStoreFilesSize(long storeFilesSize) {
            this.storeFilesSize = storeFilesSize;
        }

        public long getTableSize() {
            return this.tableSize;
        }

        public void setTableSize(long tableSize) {
            this.tableSize = tableSize;
        }
    }

    public class TableMetricsWrapperRunnable
    implements Runnable {
        @Override
        public void run() {
            TableName tbl;
            HashMap<TableName, MetricsTableValues> localMetricsTableMap = new HashMap<TableName, MetricsTableValues>();
            for (Region region : MetricsTableWrapperAggregateImpl.this.regionServer.getOnlineRegionsLocalContext()) {
                tbl = region.getTableDescriptor().getTableName();
                MetricsTableValues metricsTable = (MetricsTableValues)localMetricsTableMap.get(tbl);
                if (metricsTable == null) {
                    metricsTable = new MetricsTableValues();
                    localMetricsTableMap.put(tbl, metricsTable);
                }
                long tempStorefilesSize = 0L;
                for (Store store : region.getStores()) {
                    tempStorefilesSize += store.getStorefilesSize();
                }
                metricsTable.setMemStoresSize(metricsTable.getMemStoresSize() + region.getMemStoreSize());
                metricsTable.setStoreFilesSize(metricsTable.getStoreFilesSize() + tempStorefilesSize);
                metricsTable.setTableSize(metricsTable.getMemStoresSize() + metricsTable.getStoreFilesSize());
                metricsTable.setReadRequestsCount(metricsTable.getReadRequestsCount() + region.getReadRequestsCount());
                metricsTable.setWriteRequestsCount(metricsTable.getWriteRequestsCount() + region.getWriteRequestsCount());
                metricsTable.setTotalRequestsCount(metricsTable.getReadRequestsCount() + metricsTable.getWriteRequestsCount());
            }
            for (Map.Entry entry : localMetricsTableMap.entrySet()) {
                tbl = (TableName)entry.getKey();
                if (MetricsTableWrapperAggregateImpl.this.metricsTableMap.get(tbl) == null) {
                    MetricsTableSource tableSource = ((MetricsRegionServerSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class)).createTable(tbl.getNameAsString(), (MetricsTableWrapperAggregate)MetricsTableWrapperAggregateImpl.this);
                    ((MetricsRegionServerSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class)).getTableAggregate().register(tbl.getNameAsString(), tableSource);
                }
                MetricsTableWrapperAggregateImpl.this.metricsTableMap.put(entry.getKey(), entry.getValue());
            }
            HashSet existingTableNames = Sets.newHashSet((Iterable)MetricsTableWrapperAggregateImpl.this.metricsTableMap.keySet());
            existingTableNames.removeAll(localMetricsTableMap.keySet());
            MetricsTableAggregateSource metricsTableAggregateSource = ((MetricsRegionServerSourceFactory)CompatibilitySingletonFactory.getInstance(MetricsRegionServerSourceFactory.class)).getTableAggregate();
            for (TableName table : existingTableNames) {
                metricsTableAggregateSource.deregister(table.getNameAsString());
                if (MetricsTableWrapperAggregateImpl.this.metricsTableMap.get(table) == null) continue;
                MetricsTableWrapperAggregateImpl.this.metricsTableMap.remove(table);
            }
        }
    }
}

