/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.throttle;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.throttle.NoLimitThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.PressureAwareCompactionThroughputController;
import org.apache.hadoop.hbase.regionserver.throttle.ThroughputController;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public final class CompactionThroughputControllerFactory {
    private static final Log LOG = LogFactory.getLog(CompactionThroughputControllerFactory.class);
    public static final String HBASE_THROUGHPUT_CONTROLLER_KEY = "hbase.regionserver.throughput.controller";
    private static final Class<? extends ThroughputController> DEFAULT_THROUGHPUT_CONTROLLER_CLASS = PressureAwareCompactionThroughputController.class;
    private static final String DEPRECATED_NAME_OF_PRESSURE_AWARE_THROUGHPUT_CONTROLLER_CLASS = "org.apache.hadoop.hbase.regionserver.compactions.PressureAwareCompactionThroughputController";
    private static final String DEPRECATED_NAME_OF_NO_LIMIT_THROUGHPUT_CONTROLLER_CLASS = "org.apache.hadoop.hbase.regionserver.compactions.NoLimitThroughputController";

    private CompactionThroughputControllerFactory() {
    }

    public static ThroughputController create(RegionServerServices server, Configuration conf) {
        Class<? extends ThroughputController> clazz = CompactionThroughputControllerFactory.getThroughputControllerClass(conf);
        ThroughputController controller = (ThroughputController)ReflectionUtils.newInstance(clazz, (Configuration)conf);
        controller.setup(server);
        return controller;
    }

    public static Class<? extends ThroughputController> getThroughputControllerClass(Configuration conf) {
        String className = conf.get(HBASE_THROUGHPUT_CONTROLLER_KEY, DEFAULT_THROUGHPUT_CONTROLLER_CLASS.getName());
        className = CompactionThroughputControllerFactory.resolveDeprecatedClassName(className);
        try {
            return Class.forName(className).asSubclass(ThroughputController.class);
        }
        catch (Exception e) {
            LOG.warn((Object)("Unable to load configured throughput controller '" + className + "', load default throughput controller " + DEFAULT_THROUGHPUT_CONTROLLER_CLASS.getName() + " instead"), (Throwable)e);
            return DEFAULT_THROUGHPUT_CONTROLLER_CLASS;
        }
    }

    private static String resolveDeprecatedClassName(String oldName) {
        String className = oldName.trim();
        if (className.equals(DEPRECATED_NAME_OF_PRESSURE_AWARE_THROUGHPUT_CONTROLLER_CLASS)) {
            className = PressureAwareCompactionThroughputController.class.getName();
        } else if (className.equals(DEPRECATED_NAME_OF_NO_LIMIT_THROUGHPUT_CONTROLLER_CLASS)) {
            className = NoLimitThroughputController.class.getName();
        }
        if (!className.equals(oldName)) {
            LOG.warn((Object)(oldName + " is deprecated, please use " + className + " instead"));
        }
        return className;
    }
}

