/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.replication.ReplicationQueueInfo;
import org.apache.hadoop.hbase.replication.regionserver.RecoveredReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceInterface;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ReplicationSourceFactory {
    private static final Log LOG = LogFactory.getLog(ReplicationSourceFactory.class);

    static ReplicationSourceInterface create(Configuration conf, String peerId) {
        ReplicationSourceInterface src;
        ReplicationQueueInfo replicationQueueInfo = new ReplicationQueueInfo(peerId);
        boolean isQueueRecovered = replicationQueueInfo.isQueueRecovered();
        try {
            String defaultReplicationSourceImpl = isQueueRecovered ? RecoveredReplicationSource.class.getCanonicalName() : ReplicationSource.class.getCanonicalName();
            Class<?> c = Class.forName(conf.get("replication.replicationsource.implementation", defaultReplicationSourceImpl));
            src = (ReplicationSourceInterface)c.newInstance();
        }
        catch (Exception e) {
            LOG.warn((Object)"Passed replication source implementation throws errors, defaulting to ReplicationSource", (Throwable)e);
            src = isQueueRecovered ? new RecoveredReplicationSource() : new ReplicationSource();
        }
        return src;
    }
}

