/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.security.GeneralSecurityException;
import java.util.Properties;
import org.apache.commons.crypto.random.CryptoRandom;
import org.apache.commons.crypto.random.CryptoRandomFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.VersionInfoUtil;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.io.ByteBufferOutputStream;
import org.apache.hadoop.hbase.io.crypto.aes.CryptoAES;
import org.apache.hadoop.hbase.ipc.BadAuthException;
import org.apache.hadoop.hbase.ipc.BufferChain;
import org.apache.hadoop.hbase.ipc.CallRunner;
import org.apache.hadoop.hbase.ipc.EmptyServiceNameException;
import org.apache.hadoop.hbase.ipc.FatalConnectionException;
import org.apache.hadoop.hbase.ipc.RpcResponse;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.ServerCall;
import org.apache.hadoop.hbase.ipc.SimpleRpcServer;
import org.apache.hadoop.hbase.ipc.UnknownServiceException;
import org.apache.hadoop.hbase.ipc.UnsupportedCellCodecException;
import org.apache.hadoop.hbase.ipc.UnsupportedCompressionCodecException;
import org.apache.hadoop.hbase.ipc.UnsupportedCryptoException;
import org.apache.hadoop.hbase.ipc.WrongVersionException;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hadoop.hbase.security.AccessDeniedException;
import org.apache.hadoop.hbase.security.AuthMethod;
import org.apache.hadoop.hbase.security.HBaseSaslRpcServer;
import org.apache.hadoop.hbase.security.SaslStatus;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hbase.thirdparty.com.google.protobuf.BlockingService;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteInput;
import org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hbase.thirdparty.com.google.protobuf.CodedInputStream;
import org.apache.hbase.thirdparty.com.google.protobuf.Descriptors;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.hbase.thirdparty.com.google.protobuf.MessageOrBuilder;
import org.apache.hbase.thirdparty.com.google.protobuf.TextFormat;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
@SuppressWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="False positive according to http://sourceforge.net/p/findbugs/bugs/1032/")
abstract class ServerRpcConnection
implements Closeable {
    protected final RpcServer rpcServer;
    protected boolean connectionHeaderRead = false;
    protected RpcServer.CallCleanup callCleanup;
    protected String hostAddress;
    protected int remotePort;
    protected InetAddress addr;
    protected RPCProtos.ConnectionHeader connectionHeader;
    protected Codec codec;
    protected CompressionCodec compressionCodec;
    protected BlockingService service;
    protected AuthMethod authMethod;
    protected boolean saslContextEstablished;
    protected boolean skipInitialSaslHandshake;
    private ByteBuffer unwrappedData;
    private ByteBuffer unwrappedDataLengthBuffer = ByteBuffer.allocate(4);
    protected boolean useSasl;
    protected HBaseSaslRpcServer saslServer;
    protected CryptoAES cryptoAES;
    protected boolean useWrap = false;
    protected boolean useCryptoAesWrap = false;
    protected boolean authenticatedWithFallback;
    protected boolean retryImmediatelySupported = false;
    protected User user = null;
    protected UserGroupInformation ugi = null;

    public ServerRpcConnection(RpcServer rpcServer) {
        this.rpcServer = rpcServer;
        this.callCleanup = null;
    }

    public String toString() {
        return this.getHostAddress() + ":" + this.remotePort;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public InetAddress getHostInetAddress() {
        return this.addr;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public HBaseProtos.VersionInfo getVersionInfo() {
        if (this.connectionHeader.hasVersionInfo()) {
            return this.connectionHeader.getVersionInfo();
        }
        return null;
    }

    private String getFatalConnectionString(int version, byte authByte) {
        return "serverVersion=0, clientVersion=" + version + ", authMethod=" + authByte + ", authSupported=" + (this.authMethod != null) + " from " + this.toString();
    }

    private UserGroupInformation getAuthorizedUgi(String authorizedId) throws IOException {
        UserGroupInformation authorizedUgi;
        if (this.authMethod == AuthMethod.DIGEST) {
            TokenIdentifier tokenId = HBaseSaslRpcServer.getIdentifier(authorizedId, this.rpcServer.secretManager);
            authorizedUgi = tokenId.getUser();
            if (authorizedUgi == null) {
                throw new AccessDeniedException("Can't retrieve username from tokenIdentifier.");
            }
            authorizedUgi.addTokenIdentifier(tokenId);
        } else {
            authorizedUgi = UserGroupInformation.createRemoteUser((String)authorizedId);
        }
        authorizedUgi.setAuthenticationMethod(this.authMethod.authenticationMethod.getAuthMethod());
        return authorizedUgi;
    }

    private void setupCellBlockCodecs(RPCProtos.ConnectionHeader header) throws FatalConnectionException {
        if (!header.hasCellBlockCodecClass()) {
            return;
        }
        String className = header.getCellBlockCodecClass();
        if (className == null || className.length() == 0) {
            return;
        }
        try {
            this.codec = (Codec)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new UnsupportedCellCodecException(className, (Throwable)e);
        }
        if (!header.hasCellBlockCompressorClass()) {
            return;
        }
        className = header.getCellBlockCompressorClass();
        try {
            this.compressionCodec = (CompressionCodec)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new UnsupportedCompressionCodecException(className, (Throwable)e);
        }
    }

    private void setupCryptoCipher(RPCProtos.ConnectionHeader header, RPCProtos.ConnectionHeaderResponse.Builder chrBuilder) throws FatalConnectionException {
        boolean isCryptoAesEncryption;
        if (this.saslServer == null) {
            return;
        }
        String qop = this.saslServer.getNegotiatedQop();
        boolean isEncryption = SaslUtil.QualityOfProtection.PRIVACY.getSaslQop().equalsIgnoreCase(qop);
        boolean bl = isCryptoAesEncryption = isEncryption && this.rpcServer.conf.getBoolean("hbase.rpc.crypto.encryption.aes.enabled", false);
        if (!isCryptoAesEncryption) {
            return;
        }
        if (!header.hasRpcCryptoCipherTransformation()) {
            return;
        }
        String transformation = header.getRpcCryptoCipherTransformation();
        if (transformation == null || transformation.length() == 0) {
            return;
        }
        Properties properties = new Properties();
        properties.setProperty("commons.crypto.secure.random.classes", this.rpcServer.conf.get("hbase.crypto.sasl.encryption.aes.crypto.random", "org.apache.commons.crypto.random.JavaCryptoRandom"));
        properties.setProperty("commons.crypto.cipher.classes", this.rpcServer.conf.get("hbase.rpc.crypto.encryption.aes.cipher.class", "org.apache.commons.crypto.cipher.JceCipher"));
        int cipherKeyBits = this.rpcServer.conf.getInt("hbase.rpc.crypto.encryption.aes.cipher.keySizeBits", 128);
        if (cipherKeyBits % 8 != 0) {
            throw new IllegalArgumentException("The AES cipher key size in bits should be a multiple of byte");
        }
        int len = cipherKeyBits / 8;
        byte[] inKey = new byte[len];
        byte[] outKey = new byte[len];
        byte[] inIv = new byte[len];
        byte[] outIv = new byte[len];
        try {
            CryptoRandom secureRandom = CryptoRandomFactory.getCryptoRandom((Properties)properties);
            secureRandom.nextBytes(inKey);
            secureRandom.nextBytes(outKey);
            secureRandom.nextBytes(inIv);
            secureRandom.nextBytes(outIv);
            this.cryptoAES = new CryptoAES(transformation, properties, inKey, outKey, inIv, outIv);
            RPCProtos.CryptoCipherMeta.Builder ccmBuilder = RPCProtos.CryptoCipherMeta.newBuilder();
            ccmBuilder.setTransformation(transformation);
            ccmBuilder.setInIv(this.getByteString(outIv));
            ccmBuilder.setInKey(this.getByteString(outKey));
            ccmBuilder.setOutIv(this.getByteString(inIv));
            ccmBuilder.setOutKey(this.getByteString(inKey));
            chrBuilder.setCryptoCipherMeta(ccmBuilder);
            this.useCryptoAesWrap = true;
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new UnsupportedCryptoException(ex.getMessage(), (Throwable)ex);
        }
    }

    private ByteString getByteString(byte[] bytes) {
        return bytes.length == 0 ? ByteString.EMPTY : ByteString.copyFrom((byte[])bytes);
    }

    private UserGroupInformation createUser(RPCProtos.ConnectionHeader head) {
        UserGroupInformation ugi = null;
        if (!head.hasUserInfo()) {
            return null;
        }
        RPCProtos.UserInformation userInfoProto = head.getUserInfo();
        String effectiveUser = null;
        if (userInfoProto.hasEffectiveUser()) {
            effectiveUser = userInfoProto.getEffectiveUser();
        }
        String realUser = null;
        if (userInfoProto.hasRealUser()) {
            realUser = userInfoProto.getRealUser();
        }
        if (effectiveUser != null) {
            if (realUser != null) {
                UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)realUser);
                ugi = UserGroupInformation.createProxyUser((String)effectiveUser, (UserGroupInformation)realUserUgi);
            } else {
                ugi = UserGroupInformation.createRemoteUser((String)effectiveUser);
            }
        }
        return ugi;
    }

    protected final void disposeSasl() {
        if (this.saslServer != null) {
            this.saslServer.dispose();
            this.saslServer = null;
        }
    }

    protected final void doRawSaslReply(SaslStatus status, Writable rv, String errorClass, String error) throws IOException {
        BufferChain bc;
        try (ByteBufferOutputStream saslResponse = new ByteBufferOutputStream(256);
             DataOutputStream out = new DataOutputStream((OutputStream)saslResponse);){
            out.writeInt(status.state);
            if (status == SaslStatus.SUCCESS) {
                rv.write((DataOutput)out);
            } else {
                WritableUtils.writeString((DataOutput)out, (String)errorClass);
                WritableUtils.writeString((DataOutput)out, (String)error);
            }
            bc = new BufferChain(saslResponse.getByteBuffer());
        }
        this.doRespond(() -> bc);
    }

    public void saslReadAndProcess(ByteBuff saslToken) throws IOException, InterruptedException {
        if (this.saslContextEstablished) {
            if (RpcServer.LOG.isTraceEnabled()) {
                RpcServer.LOG.trace("Have read input token of size " + saslToken.limit() + " for processing by saslServer.unwrap()");
            }
            if (!this.useWrap) {
                this.processOneRpc(saslToken);
            } else {
                byte[] b = saslToken.hasArray() ? saslToken.array() : saslToken.toBytes();
                byte[] plaintextData = this.useCryptoAesWrap ? this.cryptoAES.unwrap(b, 0, b.length) : this.saslServer.unwrap(b, 0, b.length);
                this.processUnwrappedData(plaintextData);
            }
        } else {
            byte[] replyToken;
            try {
                if (this.saslServer == null) {
                    this.saslServer = new HBaseSaslRpcServer(this.authMethod, this.rpcServer.saslProps, this.rpcServer.secretManager);
                    if (RpcServer.LOG.isDebugEnabled()) {
                        RpcServer.LOG.debug("Created SASL server with mechanism = " + this.authMethod.getMechanismName());
                    }
                }
                if (RpcServer.LOG.isDebugEnabled()) {
                    RpcServer.LOG.debug("Have read input token of size " + saslToken.limit() + " for processing by saslServer.evaluateResponse()");
                }
                replyToken = this.saslServer.evaluateResponse(saslToken.hasArray() ? saslToken.array() : saslToken.toBytes());
            }
            catch (IOException e) {
                IOException sendToClient = e;
                for (Throwable cause = e; cause != null; cause = cause.getCause()) {
                    if (!(cause instanceof SecretManager.InvalidToken)) continue;
                    sendToClient = (SecretManager.InvalidToken)cause;
                    break;
                }
                this.doRawSaslReply(SaslStatus.ERROR, null, sendToClient.getClass().getName(), sendToClient.getLocalizedMessage());
                this.rpcServer.metrics.authenticationFailure();
                String clientIP = this.toString();
                RpcServer.AUDITLOG.warn("Auth failed for " + clientIP + ":" + this.saslServer.getAttemptingUser());
                throw e;
            }
            if (replyToken != null) {
                if (RpcServer.LOG.isDebugEnabled()) {
                    RpcServer.LOG.debug("Will send token of size " + replyToken.length + " from saslServer.");
                }
                this.doRawSaslReply(SaslStatus.SUCCESS, (Writable)new BytesWritable(replyToken), null, null);
            }
            if (this.saslServer.isComplete()) {
                String qop = this.saslServer.getNegotiatedQop();
                this.useWrap = qop != null && !"auth".equalsIgnoreCase(qop);
                this.ugi = this.getAuthorizedUgi(this.saslServer.getAuthorizationID());
                if (RpcServer.LOG.isDebugEnabled()) {
                    RpcServer.LOG.debug("SASL server context established. Authenticated client: " + this.ugi + ". Negotiated QoP is " + qop);
                }
                this.rpcServer.metrics.authenticationSuccess();
                RpcServer.AUDITLOG.info("Auth successful for " + this.ugi);
                this.saslContextEstablished = true;
            }
        }
    }

    private void processUnwrappedData(byte[] inBuf) throws IOException, InterruptedException {
        ReadableByteChannel ch = Channels.newChannel(new ByteArrayInputStream(inBuf));
        int count;
        while (this.unwrappedDataLengthBuffer.remaining() <= 0 || (count = this.rpcServer.channelRead(ch, this.unwrappedDataLengthBuffer)) > 0 && this.unwrappedDataLengthBuffer.remaining() <= 0) {
            if (this.unwrappedData == null) {
                this.unwrappedDataLengthBuffer.flip();
                int unwrappedDataLength = this.unwrappedDataLengthBuffer.getInt();
                if (unwrappedDataLength == -1) {
                    if (RpcServer.LOG.isDebugEnabled()) {
                        RpcServer.LOG.debug("Received ping message");
                    }
                    this.unwrappedDataLengthBuffer.clear();
                    continue;
                }
                this.unwrappedData = ByteBuffer.allocate(unwrappedDataLength);
            }
            if ((count = this.rpcServer.channelRead(ch, this.unwrappedData)) <= 0 || this.unwrappedData.remaining() > 0) {
                return;
            }
            if (this.unwrappedData.remaining() != 0) continue;
            this.unwrappedDataLengthBuffer.clear();
            this.unwrappedData.flip();
            this.processOneRpc((ByteBuff)new SingleByteBuff(this.unwrappedData));
            this.unwrappedData = null;
        }
        return;
    }

    public void processOneRpc(ByteBuff buf) throws IOException, InterruptedException {
        if (this.connectionHeaderRead) {
            this.processRequest(buf);
        } else {
            this.processConnectionHeader(buf);
            this.connectionHeaderRead = true;
            if (!this.authorizeConnection()) {
                throw new AccessDeniedException("Connection from " + this + " for service " + this.connectionHeader.getServiceName() + " is unauthorized for user: " + this.ugi);
            }
            this.user = this.rpcServer.userProvider.create(this.ugi);
        }
    }

    private boolean authorizeConnection() throws IOException {
        try {
            if (this.ugi != null && this.ugi.getRealUser() != null && this.authMethod != AuthMethod.DIGEST) {
                ProxyUsers.authorize((UserGroupInformation)this.ugi, (String)this.getHostAddress(), (Configuration)this.rpcServer.conf);
            }
            this.rpcServer.authorize(this.ugi, this.connectionHeader, this.getHostInetAddress());
            this.rpcServer.metrics.authorizationSuccess();
        }
        catch (AuthorizationException ae) {
            if (RpcServer.LOG.isDebugEnabled()) {
                RpcServer.LOG.debug("Connection authorization failed: " + ae.getMessage(), (Throwable)ae);
            }
            this.rpcServer.metrics.authorizationFailure();
            this.doRespond(this.getErrorResponse(ae.getMessage(), (Exception)((Object)new AccessDeniedException((Throwable)ae))));
            return false;
        }
        return true;
    }

    private void processConnectionHeader(ByteBuff buf) throws IOException {
        if (buf.hasArray()) {
            this.connectionHeader = RPCProtos.ConnectionHeader.parseFrom((byte[])buf.array());
        } else {
            CodedInputStream cis = UnsafeByteOperations.unsafeWrap((ByteInput)new ByteBuffByteInput(buf, 0, buf.limit()), (int)0, (int)buf.limit()).newCodedInput();
            cis.enableAliasing(true);
            this.connectionHeader = RPCProtos.ConnectionHeader.parseFrom((CodedInputStream)cis);
        }
        String serviceName = this.connectionHeader.getServiceName();
        if (serviceName == null) {
            throw new EmptyServiceNameException();
        }
        this.service = RpcServer.getService(this.rpcServer.services, serviceName);
        if (this.service == null) {
            throw new UnknownServiceException(serviceName);
        }
        this.setupCellBlockCodecs(this.connectionHeader);
        RPCProtos.ConnectionHeaderResponse.Builder chrBuilder = RPCProtos.ConnectionHeaderResponse.newBuilder();
        this.setupCryptoCipher(this.connectionHeader, chrBuilder);
        this.responseConnectionHeader(chrBuilder);
        UserGroupInformation protocolUser = this.createUser(this.connectionHeader);
        if (!this.useSasl) {
            this.ugi = protocolUser;
            if (this.ugi != null) {
                this.ugi.setAuthenticationMethod(AuthMethod.SIMPLE.authenticationMethod);
            }
            if (this.authenticatedWithFallback) {
                RpcServer.LOG.warn("Allowed fallback to SIMPLE auth for " + this.ugi + " connecting from " + this.getHostAddress());
            }
            RpcServer.AUDITLOG.info("Auth successful for " + this.ugi);
        } else {
            this.ugi.setAuthenticationMethod(this.authMethod.authenticationMethod);
            if (protocolUser != null && !protocolUser.getUserName().equals(this.ugi.getUserName())) {
                if (this.authMethod == AuthMethod.DIGEST) {
                    throw new AccessDeniedException("Authenticated user (" + this.ugi + ") doesn't match what the client claims to be (" + protocolUser + ")");
                }
                UserGroupInformation realUser = this.ugi;
                this.ugi = UserGroupInformation.createProxyUser((String)protocolUser.getUserName(), (UserGroupInformation)realUser);
                this.ugi.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.PROXY);
            }
        }
        if (this.connectionHeader.hasVersionInfo()) {
            this.retryImmediatelySupported = VersionInfoUtil.hasMinimumVersion(this.getVersionInfo(), 1, 2);
            RpcServer.AUDITLOG.info("Connection from " + this.hostAddress + " port: " + this.remotePort + " with version info: " + TextFormat.shortDebugString((MessageOrBuilder)this.connectionHeader.getVersionInfo()));
        } else {
            RpcServer.AUDITLOG.info("Connection from " + this.hostAddress + " port: " + this.remotePort + " with unknown version info");
        }
    }

    private void responseConnectionHeader(RPCProtos.ConnectionHeaderResponse.Builder chrBuilder) throws FatalConnectionException {
        if (!chrBuilder.hasCryptoCipherMeta()) {
            return;
        }
        try {
            BufferChain bc;
            byte[] connectionHeaderResBytes = chrBuilder.build().toByteArray();
            byte[] unwrapped = new byte[connectionHeaderResBytes.length + 4];
            Bytes.putBytes((byte[])unwrapped, (int)0, (byte[])Bytes.toBytes((int)connectionHeaderResBytes.length), (int)0, (int)4);
            Bytes.putBytes((byte[])unwrapped, (int)4, (byte[])connectionHeaderResBytes, (int)0, (int)connectionHeaderResBytes.length);
            byte[] wrapped = this.saslServer.wrap(unwrapped, 0, unwrapped.length);
            try (ByteBufferOutputStream response = new ByteBufferOutputStream(wrapped.length + 4);
                 DataOutputStream out = new DataOutputStream((OutputStream)response);){
                out.writeInt(wrapped.length);
                out.write(wrapped);
                bc = new BufferChain(response.getByteBuffer());
            }
            this.doRespond(() -> bc);
        }
        catch (IOException ex) {
            throw new UnsupportedCryptoException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected abstract void doRespond(RpcResponse var1) throws IOException;

    protected void processRequest(ByteBuff buf) throws IOException, InterruptedException {
        ServerCall<?> call;
        long totalRequestSize = buf.limit();
        int offset = 0;
        CodedInputStream cis = buf.hasArray() ? UnsafeByteOperations.unsafeWrap((byte[])buf.array(), (int)0, (int)buf.limit()).newCodedInput() : UnsafeByteOperations.unsafeWrap((ByteInput)new ByteBuffByteInput(buf, 0, buf.limit()), (int)0, (int)buf.limit()).newCodedInput();
        cis.enableAliasing(true);
        int headerSize = cis.readRawVarint32();
        offset = cis.getTotalBytesRead();
        RPCProtos.RequestHeader.Builder builder = RPCProtos.RequestHeader.newBuilder();
        ProtobufUtil.mergeFrom((Message.Builder)builder, (CodedInputStream)cis, (int)headerSize);
        RPCProtos.RequestHeader header = (RPCProtos.RequestHeader)builder.build();
        offset += headerSize;
        int id = header.getCallId();
        if (RpcServer.LOG.isTraceEnabled()) {
            RpcServer.LOG.trace("RequestHeader " + TextFormat.shortDebugString((MessageOrBuilder)header) + " totalRequestSize: " + totalRequestSize + " bytes");
        }
        if (totalRequestSize + this.rpcServer.callQueueSizeInBytes.sum() > this.rpcServer.maxQueueSizeInBytes) {
            ServerCall<?> callTooBig = this.createCall(id, this.service, null, null, null, null, totalRequestSize, null, 0, this.callCleanup);
            this.rpcServer.metrics.exception((Throwable)RpcServer.CALL_QUEUE_TOO_BIG_EXCEPTION);
            callTooBig.setResponse(null, null, (Throwable)RpcServer.CALL_QUEUE_TOO_BIG_EXCEPTION, "Call queue is full on " + this.rpcServer.server.getServerName() + ", is hbase.ipc.server.max.callqueue.size too small?");
            callTooBig.sendResponseIfReady();
            return;
        }
        Descriptors.MethodDescriptor md = null;
        Message param = null;
        CellScanner cellScanner = null;
        try {
            if (header.hasRequestParam() && header.getRequestParam()) {
                md = this.service.getDescriptorForType().findMethodByName(header.getMethodName());
                if (md == null) {
                    throw new UnsupportedOperationException(header.getMethodName());
                }
                builder = this.service.getRequestPrototype(md).newBuilderForType();
                cis.resetSizeCounter();
                int paramSize = cis.readRawVarint32();
                offset += cis.getTotalBytesRead();
                if (builder != null) {
                    ProtobufUtil.mergeFrom((Message.Builder)builder, (CodedInputStream)cis, (int)paramSize);
                    param = builder.build();
                }
                offset += paramSize;
            } else {
                String msg = "Invalid request header: " + TextFormat.shortDebugString((MessageOrBuilder)header) + ", should have param set in it";
                RpcServer.LOG.warn(msg);
                throw new DoNotRetryIOException(msg);
            }
            if (header.hasCellBlockMeta()) {
                buf.position(offset);
                ByteBuff dup = buf.duplicate();
                dup.limit(offset + header.getCellBlockMeta().getLength());
                cellScanner = this.rpcServer.cellBlockBuilder.createCellScannerReusingBuffers(this.codec, this.compressionCodec, dup);
            }
        }
        catch (Throwable t2) {
            DoNotRetryIOException t2;
            InetSocketAddress address = this.rpcServer.getListenerAddress();
            String msg = (address != null ? address : "(channel closed)") + " is unable to read call parameter from client " + this.getHostAddress();
            RpcServer.LOG.warn(msg, t2);
            this.rpcServer.metrics.exception(t2);
            if (t2 instanceof LinkageError) {
                t2 = new DoNotRetryIOException(t2);
            }
            if (t2 instanceof UnsupportedOperationException) {
                t2 = new DoNotRetryIOException((Throwable)t2);
            }
            ServerCall<?> readParamsFailedCall = this.createCall(id, this.service, null, null, null, null, totalRequestSize, null, 0, this.callCleanup);
            readParamsFailedCall.setResponse(null, null, t2, msg + "; " + t2.getMessage());
            readParamsFailedCall.sendResponseIfReady();
            return;
        }
        int timeout = 0;
        if (header.hasTimeout() && header.getTimeout() > 0) {
            timeout = Math.max(this.rpcServer.minClientRequestTimeout, header.getTimeout());
        }
        if (!this.rpcServer.scheduler.dispatch(new CallRunner(this.rpcServer, call = this.createCall(id, this.service, md, header, param, cellScanner, totalRequestSize, this.addr, timeout, this.callCleanup)))) {
            this.rpcServer.callQueueSizeInBytes.add(-1L * call.getSize());
            this.rpcServer.metrics.exception((Throwable)RpcServer.CALL_QUEUE_TOO_BIG_EXCEPTION);
            call.setResponse(null, null, (Throwable)RpcServer.CALL_QUEUE_TOO_BIG_EXCEPTION, "Call queue is full on " + this.rpcServer.server.getServerName() + ", too many items queued ?");
            call.sendResponseIfReady();
        }
    }

    protected final RpcResponse getErrorResponse(String msg, Exception e) throws IOException {
        RPCProtos.ResponseHeader.Builder headerBuilder = RPCProtos.ResponseHeader.newBuilder().setCallId(-1);
        ServerCall.setExceptionResponse(e, msg, headerBuilder);
        ByteBuffer headerBuf = ServerCall.createHeaderAndMessageBytes(null, (Message)headerBuilder.build(), 0, null);
        BufferChain buf = new BufferChain(headerBuf);
        return () -> buf;
    }

    private void doBadPreambleHandling(String msg) throws IOException {
        this.doBadPreambleHandling(msg, (Exception)new FatalConnectionException(msg));
    }

    private void doBadPreambleHandling(String msg, Exception e) throws IOException {
        SimpleRpcServer.LOG.warn(msg);
        this.doRespond(this.getErrorResponse(msg, e));
    }

    protected final boolean processPreamble(ByteBuffer preambleBuffer) throws IOException {
        assert (preambleBuffer.remaining() == 6);
        for (int i = 0; i < HConstants.RPC_HEADER.length; ++i) {
            if (HConstants.RPC_HEADER[i] == preambleBuffer.get()) continue;
            this.doBadPreambleHandling("Expected HEADER=" + Bytes.toStringBinary((byte[])HConstants.RPC_HEADER) + " but received HEADER=" + Bytes.toStringBinary((byte[])preambleBuffer.array(), (int)0, (int)HConstants.RPC_HEADER.length) + " from " + this.toString());
            return false;
        }
        int version = preambleBuffer.get() & 0xFF;
        byte authbyte = preambleBuffer.get();
        this.authMethod = AuthMethod.valueOf((byte)authbyte);
        if (version != 0) {
            String msg = this.getFatalConnectionString(version, authbyte);
            this.doBadPreambleHandling(msg, (Exception)new WrongVersionException(msg));
            return false;
        }
        if (this.authMethod == null) {
            String msg = this.getFatalConnectionString(version, authbyte);
            this.doBadPreambleHandling(msg, (Exception)new BadAuthException(msg));
            return false;
        }
        if (this.rpcServer.isSecurityEnabled && this.authMethod == AuthMethod.SIMPLE) {
            if (this.rpcServer.allowFallbackToSimpleAuth) {
                this.rpcServer.metrics.authenticationFallback();
                this.authenticatedWithFallback = true;
            } else {
                AccessDeniedException ae = new AccessDeniedException("Authentication is required");
                this.doRespond(this.getErrorResponse(ae.getMessage(), (Exception)((Object)ae)));
                return false;
            }
        }
        if (!this.rpcServer.isSecurityEnabled && this.authMethod != AuthMethod.SIMPLE) {
            this.doRawSaslReply(SaslStatus.SUCCESS, (Writable)new IntWritable(-88), null, null);
            this.authMethod = AuthMethod.SIMPLE;
            this.skipInitialSaslHandshake = true;
        }
        if (this.authMethod != AuthMethod.SIMPLE) {
            this.useSasl = true;
        }
        return true;
    }

    public abstract boolean isConnectionOpen();

    public abstract ServerCall<?> createCall(int var1, BlockingService var2, Descriptors.MethodDescriptor var3, RPCProtos.RequestHeader var4, Message var5, CellScanner var6, long var7, InetAddress var9, int var10, RpcServer.CallCleanup var11);

    private static class ByteBuffByteInput
    extends ByteInput {
        private ByteBuff buf;
        private int offset;
        private int length;

        ByteBuffByteInput(ByteBuff buf, int offset, int length) {
            this.buf = buf;
            this.offset = offset;
            this.length = length;
        }

        public byte read(int offset) {
            return this.buf.get(this.getAbsoluteOffset(offset));
        }

        private int getAbsoluteOffset(int offset) {
            return this.offset + offset;
        }

        public int read(int offset, byte[] out, int outOffset, int len) {
            this.buf.get(this.getAbsoluteOffset(offset), out, outOffset, len);
            return len;
        }

        public int read(int offset, ByteBuffer out) {
            int len = out.remaining();
            this.buf.get(out, this.getAbsoluteOffset(offset), len);
            return len;
        }

        public int size() {
            return this.length;
        }
    }
}

