/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.Closeable;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, MediumTests.class})
public class TestClientOperationTimeout {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestClientOperationTimeout.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static int DELAY_GET;
    private static int DELAY_SCAN;
    private static int DELAY_MUTATE;
    private static final TableName TABLE_NAME;
    private static final byte[] FAMILY;
    private static final byte[] ROW;
    private static final byte[] QUALIFIER;
    private static final byte[] VALUE;
    private static Connection CONN;
    private static Table TABLE;

    @BeforeClass
    public static void setUpClass() throws Exception {
        UTIL.startMiniCluster(1, 1, null, null, DelayedRegionServer.class);
        UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)TABLE_NAME).setColumnFamily(ColumnFamilyDescriptorBuilder.of((byte[])FAMILY)).build());
        Configuration conf = new Configuration(UTIL.getConfiguration());
        conf.setLong("hbase.client.operation.timeout", 500L);
        conf.setLong("hbase.client.meta.operation.timeout", 500L);
        conf.setLong("hbase.client.scanner.timeout.period", 500L);
        conf.setLong("hbase.client.retries.number", 1L);
        CONN = ConnectionFactory.createConnection((Configuration)conf);
        TABLE = CONN.getTable(TABLE_NAME);
    }

    @Before
    public void setUp() throws Exception {
        DELAY_GET = 0;
        DELAY_SCAN = 0;
        DELAY_MUTATE = 0;
    }

    @AfterClass
    public static void tearDown() throws Exception {
        Closeables.close((Closeable)TABLE, (boolean)true);
        Closeables.close((Closeable)CONN, (boolean)true);
        UTIL.shutdownMiniCluster();
    }

    @Test(expected=SocketTimeoutException.class)
    public void testGetTimeout() throws Exception {
        DELAY_GET = 600;
        TABLE.get(new Get(ROW));
    }

    @Test(expected=SocketTimeoutException.class)
    public void testPutTimeout() throws Exception {
        DELAY_MUTATE = 600;
        Put put = new Put(ROW);
        put.addColumn(FAMILY, QUALIFIER, VALUE);
        TABLE.put(put);
    }

    @Test(expected=RetriesExhaustedException.class)
    public void testScanTimeout() throws Exception {
        DELAY_SCAN = 600;
        ResultScanner scanner = TABLE.getScanner(new Scan());
        scanner.next();
    }

    static {
        TABLE_NAME = TableName.valueOf((String)"Timeout");
        FAMILY = Bytes.toBytes((String)"family");
        ROW = Bytes.toBytes((String)"row");
        QUALIFIER = Bytes.toBytes((String)"qualifier");
        VALUE = Bytes.toBytes((String)"value");
    }

    public static class DelayedRSRpcServices
    extends RSRpcServices {
        DelayedRSRpcServices(HRegionServer rs) throws IOException {
            super(rs);
        }

        public ClientProtos.GetResponse get(RpcController controller, ClientProtos.GetRequest request) throws ServiceException {
            try {
                Thread.sleep(DELAY_GET);
            }
            catch (InterruptedException e) {
                LOG.error("Sleep interrupted during get operation", (Throwable)e);
            }
            return super.get(controller, request);
        }

        public ClientProtos.MutateResponse mutate(RpcController rpcc, ClientProtos.MutateRequest request) throws ServiceException {
            try {
                Thread.sleep(DELAY_MUTATE);
            }
            catch (InterruptedException e) {
                LOG.error("Sleep interrupted during mutate operation", (Throwable)e);
            }
            return super.mutate(rpcc, request);
        }

        public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
            try {
                Thread.sleep(DELAY_SCAN);
            }
            catch (InterruptedException e) {
                LOG.error("Sleep interrupted during scan operation", (Throwable)e);
            }
            return super.scan(controller, request);
        }
    }

    private static class DelayedRegionServer
    extends MiniHBaseCluster.MiniHBaseClusterRegionServer {
        public DelayedRegionServer(Configuration conf) throws IOException, InterruptedException {
            super(conf);
        }

        protected RSRpcServices createRpcServices() throws IOException {
            return new DelayedRSRpcServices(this);
        }
    }
}

