/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestUpdateConfiguration {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestUpdateConfiguration.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestUpdateConfiguration.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setup() throws Exception {
        TEST_UTIL.startMiniCluster(2, 1);
    }

    @Test
    public void testOnlineConfigChange() throws IOException {
        LOG.debug("Starting the test");
        Admin admin = TEST_UTIL.getAdmin();
        ServerName server = TEST_UTIL.getHBaseCluster().getRegionServer(0).getServerName();
        admin.updateConfiguration(server);
    }

    @Test
    public void testMasterOnlineConfigChange() throws IOException {
        LOG.debug("Starting the test");
        Path cnfPath = FileSystems.getDefault().getPath("target/test-classes/hbase-site.xml", new String[0]);
        Path cnf2Path = FileSystems.getDefault().getPath("target/test-classes/hbase-site2.xml", new String[0]);
        Path cnf3Path = FileSystems.getDefault().getPath("target/test-classes/hbase-site3.xml", new String[0]);
        Files.copy(cnfPath, cnf3Path, StandardCopyOption.REPLACE_EXISTING);
        Files.copy(cnf2Path, cnfPath, StandardCopyOption.REPLACE_EXISTING);
        Admin admin = TEST_UTIL.getAdmin();
        ServerName server = TEST_UTIL.getHBaseCluster().getMaster().getServerName();
        admin.updateConfiguration(server);
        Configuration conf = TEST_UTIL.getMiniHBaseCluster().getMaster().getConfiguration();
        int custom = conf.getInt("hbase.custom.config", 0);
        Assert.assertEquals((long)1000L, (long)custom);
        Files.copy(cnf3Path, cnfPath, StandardCopyOption.REPLACE_EXISTING);
    }

    @Test
    public void testAllOnlineConfigChange() throws IOException {
        LOG.debug("Starting the test");
        Admin admin = TEST_UTIL.getAdmin();
        admin.updateConfiguration();
    }

    @Test
    public void testAllCustomOnlineConfigChange() throws IOException {
        LOG.debug("Starting the test");
        Path cnfPath = FileSystems.getDefault().getPath("target/test-classes/hbase-site.xml", new String[0]);
        Path cnf2Path = FileSystems.getDefault().getPath("target/test-classes/hbase-site2.xml", new String[0]);
        Path cnf3Path = FileSystems.getDefault().getPath("target/test-classes/hbase-site3.xml", new String[0]);
        Files.copy(cnfPath, cnf3Path, StandardCopyOption.REPLACE_EXISTING);
        Files.copy(cnf2Path, cnfPath, StandardCopyOption.REPLACE_EXISTING);
        Admin admin = TEST_UTIL.getAdmin();
        admin.updateConfiguration();
        Configuration masterConfiguration = TEST_UTIL.getMiniHBaseCluster().getMaster(0).getConfiguration();
        int custom = masterConfiguration.getInt("hbase.custom.config", 0);
        Assert.assertEquals((long)1000L, (long)custom);
        Configuration backupMasterConfiguration = TEST_UTIL.getMiniHBaseCluster().getMaster(1).getConfiguration();
        custom = backupMasterConfiguration.getInt("hbase.custom.config", 0);
        Assert.assertEquals((long)1000L, (long)custom);
        Configuration regionServerConfiguration = TEST_UTIL.getMiniHBaseCluster().getRegionServer(0).getConfiguration();
        custom = regionServerConfiguration.getInt("hbase.custom.config", 0);
        Assert.assertEquals((long)1000L, (long)custom);
        Files.copy(cnf3Path, cnfPath, StandardCopyOption.REPLACE_EXISTING);
    }
}

