/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializer;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializerIdManager;
import org.apache.hadoop.hbase.io.hfile.CombinedBlockCache;
import org.apache.hadoop.hbase.io.hfile.LruBlockCache;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.io.util.MemorySizeUtil;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IOTests.class, LargeTests.class})
public class TestCacheConfig {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCacheConfig.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestCacheConfig.class);
    private Configuration conf;

    @Before
    public void setUp() throws Exception {
        CacheConfig.clearGlobalInstances();
        this.conf = HBaseConfiguration.create();
    }

    @After
    public void tearDown() throws Exception {
        CacheConfig.clearGlobalInstances();
    }

    void basicBlockCacheOps(CacheConfig cc, boolean doubling, boolean sizing) {
        Assert.assertTrue((boolean)cc.isBlockCacheEnabled());
        Assert.assertTrue((false == cc.isInMemory() ? 1 : 0) != 0);
        BlockCache bc = cc.getBlockCache();
        BlockCacheKey bck = new BlockCacheKey("f", 0L);
        DataCacheEntry c = new DataCacheEntry();
        long initialBlockCount = bc.getBlockCount();
        bc.cacheBlock(bck, (Cacheable)c, cc.isInMemory());
        Assert.assertEquals((long)(doubling ? 2L : 1L), (long)(bc.getBlockCount() - initialBlockCount));
        bc.evictBlock(bck);
        Assert.assertEquals((long)initialBlockCount, (long)bc.getBlockCount());
        if (sizing) {
            long originalSize = bc.getCurrentSize();
            bc.cacheBlock(bck, (Cacheable)c, cc.isInMemory());
            Assert.assertTrue((bc.getCurrentSize() > originalSize ? 1 : 0) != 0);
            bc.evictBlock(bck);
            long size = bc.getCurrentSize();
            Assert.assertEquals((long)originalSize, (long)size);
        }
    }

    @Test
    public void testDisableCacheDataBlock() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        CacheConfig.instantiateBlockCache((Configuration)conf);
        CacheConfig cacheConfig = new CacheConfig(conf);
        Assert.assertTrue((boolean)cacheConfig.shouldCacheBlockOnRead(BlockType.BlockCategory.DATA));
        Assert.assertFalse((boolean)cacheConfig.shouldCacheCompressed(BlockType.BlockCategory.DATA));
        Assert.assertFalse((boolean)cacheConfig.shouldCacheDataCompressed());
        Assert.assertFalse((boolean)cacheConfig.shouldCacheDataOnWrite());
        Assert.assertTrue((boolean)cacheConfig.shouldCacheDataOnRead());
        Assert.assertTrue((boolean)cacheConfig.shouldCacheBlockOnRead(BlockType.BlockCategory.INDEX));
        Assert.assertTrue((boolean)cacheConfig.shouldCacheBlockOnRead(BlockType.BlockCategory.META));
        Assert.assertTrue((boolean)cacheConfig.shouldCacheBlockOnRead(BlockType.BlockCategory.BLOOM));
        Assert.assertFalse((boolean)cacheConfig.shouldCacheBloomsOnWrite());
        Assert.assertFalse((boolean)cacheConfig.shouldCacheIndexesOnWrite());
        conf.setBoolean("hbase.rs.cacheblocksonwrite", true);
        conf.setBoolean("hbase.block.data.cachecompressed", true);
        conf.setBoolean("hfile.block.bloom.cacheonwrite", true);
        conf.setBoolean("hfile.block.index.cacheonwrite", true);
        cacheConfig = new CacheConfig(conf);
        Assert.assertTrue((boolean)cacheConfig.shouldCacheBlockOnRead(BlockType.BlockCategory.DATA));
        Assert.assertTrue((boolean)cacheConfig.shouldCacheCompressed(BlockType.BlockCategory.DATA));
        Assert.assertTrue((boolean)cacheConfig.shouldCacheDataCompressed());
        Assert.assertTrue((boolean)cacheConfig.shouldCacheDataOnWrite());
        Assert.assertTrue((boolean)cacheConfig.shouldCacheDataOnRead());
        Assert.assertTrue((boolean)cacheConfig.shouldCacheBlockOnRead(BlockType.BlockCategory.INDEX));
        Assert.assertTrue((boolean)cacheConfig.shouldCacheBlockOnRead(BlockType.BlockCategory.META));
        Assert.assertTrue((boolean)cacheConfig.shouldCacheBlockOnRead(BlockType.BlockCategory.BLOOM));
        Assert.assertTrue((boolean)cacheConfig.shouldCacheBloomsOnWrite());
        Assert.assertTrue((boolean)cacheConfig.shouldCacheIndexesOnWrite());
        conf.setBoolean("hbase.block.data.cacheonread", false);
        conf.setBoolean("hbase.rs.cacheblocksonwrite", false);
        cacheConfig = new CacheConfig(conf);
        Assert.assertFalse((boolean)cacheConfig.shouldCacheBlockOnRead(BlockType.BlockCategory.DATA));
        Assert.assertFalse((boolean)cacheConfig.shouldCacheCompressed(BlockType.BlockCategory.DATA));
        Assert.assertFalse((boolean)cacheConfig.shouldCacheDataCompressed());
        Assert.assertFalse((boolean)cacheConfig.shouldCacheDataOnWrite());
        Assert.assertFalse((boolean)cacheConfig.shouldCacheDataOnRead());
        Assert.assertTrue((boolean)cacheConfig.shouldCacheBlockOnRead(BlockType.BlockCategory.INDEX));
        Assert.assertFalse((boolean)cacheConfig.shouldCacheBlockOnRead(BlockType.BlockCategory.META));
        Assert.assertTrue((boolean)cacheConfig.shouldCacheBlockOnRead(BlockType.BlockCategory.BLOOM));
        Assert.assertTrue((boolean)cacheConfig.shouldCacheBloomsOnWrite());
        Assert.assertTrue((boolean)cacheConfig.shouldCacheIndexesOnWrite());
        conf.setBoolean("hbase.block.data.cacheonread", true);
        conf.setBoolean("hbase.rs.cacheblocksonwrite", false);
        HColumnDescriptor family = new HColumnDescriptor("testDisableCacheDataBlock");
        family.setBlockCacheEnabled(false);
        cacheConfig = new CacheConfig(conf, (ColumnFamilyDescriptor)family);
        Assert.assertFalse((boolean)cacheConfig.shouldCacheBlockOnRead(BlockType.BlockCategory.DATA));
        Assert.assertFalse((boolean)cacheConfig.shouldCacheCompressed(BlockType.BlockCategory.DATA));
        Assert.assertFalse((boolean)cacheConfig.shouldCacheDataCompressed());
        Assert.assertFalse((boolean)cacheConfig.shouldCacheDataOnWrite());
        Assert.assertFalse((boolean)cacheConfig.shouldCacheDataOnRead());
        Assert.assertTrue((boolean)cacheConfig.shouldCacheBlockOnRead(BlockType.BlockCategory.INDEX));
        Assert.assertFalse((boolean)cacheConfig.shouldCacheBlockOnRead(BlockType.BlockCategory.META));
        Assert.assertTrue((boolean)cacheConfig.shouldCacheBlockOnRead(BlockType.BlockCategory.BLOOM));
        Assert.assertTrue((boolean)cacheConfig.shouldCacheBloomsOnWrite());
        Assert.assertTrue((boolean)cacheConfig.shouldCacheIndexesOnWrite());
    }

    @Test
    public void testCacheConfigDefaultLRUBlockCache() {
        CacheConfig.instantiateBlockCache((Configuration)this.conf);
        CacheConfig cc = new CacheConfig(this.conf);
        Assert.assertTrue((boolean)cc.isBlockCacheEnabled());
        Assert.assertTrue((false == cc.isInMemory() ? 1 : 0) != 0);
        this.basicBlockCacheOps(cc, false, true);
        Assert.assertTrue((boolean)(cc.getBlockCache() instanceof LruBlockCache));
    }

    @Test
    public void testOffHeapBucketCacheConfig() {
        this.conf.set("hbase.bucketcache.ioengine", "offheap");
        this.doBucketCacheConfigTest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileBucketCacheConfig() throws IOException {
        HBaseTestingUtility htu = new HBaseTestingUtility(this.conf);
        try {
            Path p = new Path(htu.getDataTestDir(), "bc.txt");
            FileSystem fs = FileSystem.get((Configuration)this.conf);
            fs.create(p).close();
            this.conf.set("hbase.bucketcache.ioengine", "file:" + p);
            this.doBucketCacheConfigTest();
        }
        finally {
            htu.cleanupTestDir();
        }
    }

    private void doBucketCacheConfigTest() {
        int bcSize = 100;
        this.conf.setInt("hbase.bucketcache.size", 100);
        CacheConfig.instantiateBlockCache((Configuration)this.conf);
        CacheConfig cc = new CacheConfig(this.conf);
        this.basicBlockCacheOps(cc, false, false);
        Assert.assertTrue((boolean)(cc.getBlockCache() instanceof CombinedBlockCache));
        CombinedBlockCache cbc = (CombinedBlockCache)cc.getBlockCache();
        BlockCache[] bcs = cbc.getBlockCaches();
        Assert.assertTrue((boolean)(bcs[0] instanceof LruBlockCache));
        LruBlockCache lbc = (LruBlockCache)bcs[0];
        Assert.assertEquals((long)MemorySizeUtil.getOnHeapCacheSize((Configuration)this.conf), (long)lbc.getMaxSize());
        Assert.assertTrue((boolean)(bcs[1] instanceof BucketCache));
        BucketCache bc = (BucketCache)bcs[1];
        Assert.assertEquals((long)100L, (long)(bc.getMaxSize() / 0x100000L));
    }

    @Test
    public void testBucketCacheConfigL1L2Setup() {
        this.conf.set("hbase.bucketcache.ioengine", "offheap");
        this.conf.setFloat("hfile.block.cache.size", 0.001f);
        MemoryUsage mu = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        long lruExpectedSize = MemorySizeUtil.getOnHeapCacheSize((Configuration)this.conf);
        int bcSize = 100;
        long bcExpectedSize = 0x6400000L;
        Assert.assertTrue((lruExpectedSize < bcExpectedSize ? 1 : 0) != 0);
        this.conf.setInt("hbase.bucketcache.size", 100);
        CacheConfig.instantiateBlockCache((Configuration)this.conf);
        CacheConfig cc = new CacheConfig(this.conf);
        this.basicBlockCacheOps(cc, false, false);
        Assert.assertTrue((boolean)(cc.getBlockCache() instanceof CombinedBlockCache));
        CombinedBlockCache cbc = (CombinedBlockCache)cc.getBlockCache();
        LruBlockCache lbc = cbc.onHeapCache;
        Assert.assertEquals((long)lruExpectedSize, (long)lbc.getMaxSize());
        BlockCache bc = cbc.l2Cache;
        Assert.assertEquals((long)bcExpectedSize, (long)((BucketCache)bc).getMaxSize());
        long initialL1BlockCount = lbc.getBlockCount();
        long initialL2BlockCount = bc.getBlockCount();
        DataCacheEntry c = new DataCacheEntry();
        BlockCacheKey bck = new BlockCacheKey("bck", 0L);
        lbc.cacheBlock(bck, (Cacheable)c, false);
        Assert.assertEquals((long)(initialL1BlockCount + 1L), (long)lbc.getBlockCount());
        Assert.assertEquals((long)initialL2BlockCount, (long)bc.getBlockCount());
        final long justTooBigSize = lbc.acceptableSize() + 1L;
        lbc.cacheBlock(new BlockCacheKey("bck2", 0L), (Cacheable)new DataCacheEntry(){

            @Override
            public long heapSize() {
                return justTooBigSize;
            }

            @Override
            public int getSerializedLength() {
                return (int)this.heapSize();
            }
        });
        while (initialL1BlockCount != lbc.getBlockCount()) {
            Threads.sleep((long)10L);
        }
        Assert.assertEquals((long)initialL1BlockCount, (long)lbc.getBlockCount());
    }

    @Test
    public void testL2CacheWithInvalidBucketSize() {
        Configuration c = new Configuration(this.conf);
        c.set("hbase.bucketcache.ioengine", "offheap");
        c.set("hbase.bucketcache.bucket.sizes", "256,512,1024,2048,4000,4096");
        c.setFloat("hbase.bucketcache.size", 1024.0f);
        try {
            CacheConfig.getBucketCache((Configuration)c);
            Assert.fail((String)"Should throw IllegalArgumentException when passing illegal value for bucket size");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    static class MetaCacheEntry
    extends DataCacheEntry {
        MetaCacheEntry() {
        }

        @Override
        public BlockType getBlockType() {
            return BlockType.INTERMEDIATE_INDEX;
        }
    }

    static class DataCacheEntry
    implements Cacheable {
        private static final int SIZE = 1;
        private static DataCacheEntry SINGLETON = new DataCacheEntry();
        final CacheableDeserializer<Cacheable> deserializer;

        DataCacheEntry() {
            this(SINGLETON);
        }

        DataCacheEntry(Cacheable c) {
            this.deserializer = new Deserializer(c);
        }

        public String toString() {
            return "size=1, type=" + this.getBlockType();
        }

        public long heapSize() {
            return 1L;
        }

        public int getSerializedLength() {
            return 1;
        }

        public void serialize(ByteBuffer destination, boolean includeNextBlockMetadata) {
            LOG.info("Serialized " + this + " to " + destination);
        }

        public CacheableDeserializer<Cacheable> getDeserializer() {
            return this.deserializer;
        }

        public BlockType getBlockType() {
            return BlockType.DATA;
        }

        public Cacheable.MemoryType getMemoryType() {
            return Cacheable.MemoryType.EXCLUSIVE;
        }
    }

    static class IndexCacheEntry
    extends DataCacheEntry {
        private static IndexCacheEntry SINGLETON = new IndexCacheEntry();

        public IndexCacheEntry() {
            super(SINGLETON);
        }

        @Override
        public BlockType getBlockType() {
            return BlockType.ROOT_INDEX;
        }
    }

    static class Deserializer
    implements CacheableDeserializer<Cacheable> {
        private final Cacheable cacheable;
        private int deserializedIdentifier = CacheableDeserializerIdManager.registerDeserializer((CacheableDeserializer)this);

        Deserializer(Cacheable c) {
            this.cacheable = c;
        }

        public int getDeserialiserIdentifier() {
            return this.deserializedIdentifier;
        }

        public Cacheable deserialize(ByteBuff b, boolean reuse, Cacheable.MemoryType memType) throws IOException {
            LOG.info("Deserialized " + b + ", reuse=" + reuse);
            return this.cacheable;
        }

        public Cacheable deserialize(ByteBuff b) throws IOException {
            LOG.info("Deserialized " + b);
            return this.cacheable;
        }
    }
}

