/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.locking;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.locking.LockServiceClient;
import org.apache.hadoop.hbase.master.MasterRpcServices;
import org.apache.hadoop.hbase.master.locking.LockProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.LockType;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.shaded.protobuf.generated.LockServiceProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.StringStartsWith;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestLockProcedure {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLockProcedure.class);
    @Rule
    public final ExpectedException exception = ExpectedException.none();
    @Rule
    public TestName testName = new TestName();
    private static final int HEARTBEAT_TIMEOUT = 2000;
    private static final int LOCAL_LOCKS_TIMEOUT = 4000;
    private static final Logger LOG = LoggerFactory.getLogger(TestLockProcedure.class);
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static MasterRpcServices masterRpcService;
    private static ProcedureExecutor<MasterProcedureEnv> procExec;
    private static String namespace;
    private static TableName tableName1;
    private static List<RegionInfo> tableRegions1;
    private static TableName tableName2;
    private static List<RegionInfo> tableRegions2;
    private String testMethodName;

    private static void setupConf(Configuration conf) {
        conf.setInt("hbase.master.procedure.threads", 1);
        conf.setInt("hbase.master.urgent.procedure.threads", 0);
        conf.setBoolean("hbase.procedure.check.owner.set", false);
        conf.setInt("hbase.master.procedure.remote.locks.timeout.ms", 2000);
        conf.setInt("hbase.master.procedure.local.master.locks.timeout.ms", 4000);
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        TestLockProcedure.setupConf(UTIL.getConfiguration());
        UTIL.startMiniCluster(1);
        UTIL.getAdmin().createNamespace(NamespaceDescriptor.create((String)namespace).build());
        UTIL.createTable(tableName1, (byte[][])new byte[][]{Bytes.toBytes((String)"fam")}, (byte[][])new byte[][]{Bytes.toBytes((String)"1")});
        UTIL.createTable(tableName2, (byte[][])new byte[][]{Bytes.toBytes((String)"fam")}, (byte[][])new byte[][]{Bytes.toBytes((String)"1")});
        masterRpcService = UTIL.getHBaseCluster().getMaster().getMasterRpcServices();
        procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        tableRegions1 = UTIL.getAdmin().getRegions(tableName1);
        tableRegions2 = UTIL.getAdmin().getRegions(tableName2);
        assert (tableRegions1.size() > 0);
        assert (tableRegions2.size() > 0);
    }

    @AfterClass
    public static void cleanupTest() throws Exception {
        try {
            UTIL.shutdownMiniCluster();
        }
        catch (Exception e) {
            LOG.warn("failure shutting down cluster", (Throwable)e);
        }
    }

    @Before
    public void setup() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        this.testMethodName = this.testName.getMethodName();
    }

    @After
    public void tearDown() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        for (Procedure proc : procExec.getProcedures()) {
            procExec.abort(proc.getProcId());
            ProcedureTestingUtility.waitProcedure(procExec, (Procedure)proc);
        }
        Assert.assertEquals((long)0L, (long)((MasterProcedureEnv)procExec.getEnvironment()).getProcedureScheduler().size());
    }

    private LockServiceProtos.LockRequest getNamespaceLock(String namespace, String description) {
        return LockServiceClient.buildLockRequest((LockServiceProtos.LockType)LockServiceProtos.LockType.EXCLUSIVE, (String)namespace, null, null, (String)description, (long)0L, (long)0L);
    }

    private LockServiceProtos.LockRequest getTableExclusiveLock(TableName tableName, String description) {
        return LockServiceClient.buildLockRequest((LockServiceProtos.LockType)LockServiceProtos.LockType.EXCLUSIVE, null, (TableName)tableName, null, (String)description, (long)0L, (long)0L);
    }

    private LockServiceProtos.LockRequest getRegionLock(List<RegionInfo> regionInfos, String description) {
        return LockServiceClient.buildLockRequest((LockServiceProtos.LockType)LockServiceProtos.LockType.EXCLUSIVE, null, null, regionInfos, (String)description, (long)0L, (long)0L);
    }

    private void validateLockRequestException(LockServiceProtos.LockRequest lockRequest, String message) throws Exception {
        this.exception.expect(ServiceException.class);
        this.exception.expectCause(IsInstanceOf.instanceOf(DoNotRetryIOException.class));
        this.exception.expectMessage(StringStartsWith.startsWith((String)("org.apache.hadoop.hbase.DoNotRetryIOException: java.lang.IllegalArgumentException: " + message)));
        masterRpcService.requestLock(null, lockRequest);
    }

    @Test
    public void testLockRequestValidationEmptyDescription() throws Exception {
        this.validateLockRequestException(this.getNamespaceLock("", ""), "Empty description");
    }

    @Test
    public void testLockRequestValidationEmptyNamespaceName() throws Exception {
        this.validateLockRequestException(this.getNamespaceLock("", "desc"), "Empty namespace");
    }

    @Test
    public void testLockRequestValidationRegionsFromDifferentTable() throws Exception {
        ArrayList<RegionInfo> regions = new ArrayList<RegionInfo>();
        regions.addAll(tableRegions1);
        regions.addAll(tableRegions2);
        this.validateLockRequestException(this.getRegionLock(regions, "desc"), "All regions should be from same table");
    }

    private boolean awaitForLocked(long procId, long timeoutInMs) throws Exception {
        long deadline = System.currentTimeMillis() + timeoutInMs;
        while (System.currentTimeMillis() < deadline) {
            LockServiceProtos.LockHeartbeatResponse response = masterRpcService.lockHeartbeat(null, LockServiceProtos.LockHeartbeatRequest.newBuilder().setProcId(procId).build());
            if (response.getLockStatus() == LockServiceProtos.LockHeartbeatResponse.LockStatus.LOCKED) {
                Assert.assertEquals((long)2000L, (long)response.getTimeoutMs());
                LOG.debug(String.format("Proc id %s acquired lock.", procId));
                return true;
            }
            Thread.sleep(100L);
        }
        return false;
    }

    private long queueLock(LockServiceProtos.LockRequest lockRequest) throws ServiceException {
        LockServiceProtos.LockResponse response = masterRpcService.requestLock(null, lockRequest);
        return response.getProcId();
    }

    private void sendHeartbeatAndCheckLocked(long procId, boolean isLocked) throws ServiceException {
        LockServiceProtos.LockHeartbeatResponse response = masterRpcService.lockHeartbeat(null, LockServiceProtos.LockHeartbeatRequest.newBuilder().setProcId(procId).build());
        if (isLocked) {
            Assert.assertEquals((Object)LockServiceProtos.LockHeartbeatResponse.LockStatus.LOCKED, (Object)response.getLockStatus());
        } else {
            Assert.assertEquals((Object)LockServiceProtos.LockHeartbeatResponse.LockStatus.UNLOCKED, (Object)response.getLockStatus());
        }
        LOG.debug(String.format("Proc id %s : %s.", procId, response.getLockStatus()));
    }

    private void releaseLock(long procId) throws ServiceException {
        masterRpcService.lockHeartbeat(null, LockServiceProtos.LockHeartbeatRequest.newBuilder().setProcId(procId).setKeepAlive(false).build());
    }

    @Test
    public void testUpdateHeartbeatAndUnlockForTable() throws Exception {
        LockServiceProtos.LockRequest lock = this.getTableExclusiveLock(tableName1, this.testMethodName);
        long procId = this.queueLock(lock);
        Assert.assertTrue((boolean)this.awaitForLocked(procId, 2000L));
        Thread.sleep(1000L);
        this.sendHeartbeatAndCheckLocked(procId, true);
        Thread.sleep(1000L);
        this.sendHeartbeatAndCheckLocked(procId, true);
        Thread.sleep(1000L);
        this.sendHeartbeatAndCheckLocked(procId, true);
        this.releaseLock(procId);
        this.sendHeartbeatAndCheckLocked(procId, false);
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
    }

    @Test
    public void testAbort() throws Exception {
        LockServiceProtos.LockRequest lock = this.getTableExclusiveLock(tableName1, this.testMethodName);
        long procId = this.queueLock(lock);
        Assert.assertTrue((boolean)this.awaitForLocked(procId, 2000L));
        Assert.assertTrue((boolean)procExec.abort(procId));
        this.sendHeartbeatAndCheckLocked(procId, false);
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
    }

    @Test
    public void testUpdateHeartbeatAndUnlockForNamespace() throws Exception {
        LockServiceProtos.LockRequest lock = this.getNamespaceLock(namespace, this.testMethodName);
        long procId = this.queueLock(lock);
        Assert.assertTrue((boolean)this.awaitForLocked(procId, 2000L));
        Thread.sleep(1000L);
        this.sendHeartbeatAndCheckLocked(procId, true);
        Thread.sleep(1000L);
        this.sendHeartbeatAndCheckLocked(procId, true);
        Thread.sleep(1000L);
        this.sendHeartbeatAndCheckLocked(procId, true);
        this.releaseLock(procId);
        this.sendHeartbeatAndCheckLocked(procId, false);
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
    }

    @Test
    public void testTimeout() throws Exception {
        LockServiceProtos.LockRequest lock = this.getNamespaceLock(namespace, this.testMethodName);
        long procId = this.queueLock(lock);
        Assert.assertTrue((boolean)this.awaitForLocked(procId, 2000L));
        Thread.sleep(1000L);
        this.sendHeartbeatAndCheckLocked(procId, true);
        Thread.sleep(1000L);
        this.sendHeartbeatAndCheckLocked(procId, true);
        Thread.sleep(8000L);
        this.sendHeartbeatAndCheckLocked(procId, false);
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
    }

    @Test
    public void testMultipleLocks() throws Exception {
        LockServiceProtos.LockRequest nsLock = this.getNamespaceLock(namespace, this.testMethodName);
        LockServiceProtos.LockRequest tableLock1 = this.getTableExclusiveLock(tableName1, this.testMethodName);
        LockServiceProtos.LockRequest tableLock2 = this.getTableExclusiveLock(tableName2, this.testMethodName);
        LockServiceProtos.LockRequest regionsLock1 = this.getRegionLock(tableRegions1, this.testMethodName);
        LockServiceProtos.LockRequest regionsLock2 = this.getRegionLock(tableRegions2, this.testMethodName);
        long nsProcId = this.queueLock(nsLock);
        Assert.assertTrue((boolean)this.awaitForLocked(nsProcId, 2000L));
        long start = System.currentTimeMillis();
        this.sendHeartbeatAndCheckLocked(nsProcId, true);
        long table1ProcId = this.queueLock(tableLock1);
        long table2ProcId = this.queueLock(tableLock2);
        long regions1ProcId = this.queueLock(regionsLock1);
        long regions2ProcId = this.queueLock(regionsLock2);
        long now = System.currentTimeMillis();
        Thread.sleep(Math.min(1000L, Math.max(2000L - (now - start) - 10L, 0L)));
        this.sendHeartbeatAndCheckLocked(nsProcId, true);
        this.sendHeartbeatAndCheckLocked(table1ProcId, false);
        this.sendHeartbeatAndCheckLocked(table2ProcId, false);
        this.sendHeartbeatAndCheckLocked(regions1ProcId, false);
        this.sendHeartbeatAndCheckLocked(regions2ProcId, false);
        this.releaseLock(nsProcId);
        Assert.assertTrue((boolean)this.awaitForLocked(table1ProcId, 2000L));
        Assert.assertTrue((boolean)this.awaitForLocked(table2ProcId, 2000L));
        this.sendHeartbeatAndCheckLocked(regions1ProcId, false);
        this.sendHeartbeatAndCheckLocked(regions2ProcId, false);
        this.releaseLock(table1ProcId);
        this.sendHeartbeatAndCheckLocked(table1ProcId, false);
        Assert.assertTrue((boolean)this.awaitForLocked(regions1ProcId, 2000L));
        this.sendHeartbeatAndCheckLocked(table2ProcId, true);
        this.sendHeartbeatAndCheckLocked(regions2ProcId, false);
        this.releaseLock(table2ProcId);
        this.sendHeartbeatAndCheckLocked(table2ProcId, false);
        Assert.assertTrue((boolean)this.awaitForLocked(regions2ProcId, 2000L));
        this.sendHeartbeatAndCheckLocked(regions1ProcId, true);
        this.sendHeartbeatAndCheckLocked(regions2ProcId, true);
        this.releaseLock(regions1ProcId);
        this.releaseLock(regions2ProcId);
        this.sendHeartbeatAndCheckLocked(regions1ProcId, false);
        this.sendHeartbeatAndCheckLocked(regions2ProcId, false);
        ProcedureTestingUtility.waitAllProcedures(procExec);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)nsProcId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)table1ProcId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)table2ProcId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)regions1ProcId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)regions2ProcId);
    }

    @Test
    public void testLatch() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        LockProcedure lockProc = new LockProcedure(UTIL.getConfiguration(), TableName.valueOf((String)"table"), LockType.EXCLUSIVE, "desc", latch);
        procExec.submitProcedure((Procedure)lockProc);
        Assert.assertTrue((boolean)latch.await(2000L, TimeUnit.MILLISECONDS));
        this.releaseLock(lockProc.getProcId());
        ProcedureTestingUtility.waitProcedure(procExec, (long)lockProc.getProcId());
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)lockProc.getProcId());
    }

    @Test
    public void testLocalLockTimeout() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        LockProcedure lockProc = new LockProcedure(UTIL.getConfiguration(), TableName.valueOf((String)"table"), LockType.EXCLUSIVE, "desc", latch);
        procExec.submitProcedure((Procedure)lockProc);
        Assert.assertTrue((boolean)this.awaitForLocked(lockProc.getProcId(), 2000L));
        Thread.sleep(2000L);
        Assert.assertTrue((boolean)lockProc.isLocked());
        Thread.sleep(8000L);
        Assert.assertFalse((boolean)lockProc.isLocked());
        this.releaseLock(lockProc.getProcId());
        ProcedureTestingUtility.waitProcedure(procExec, (long)lockProc.getProcId());
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)lockProc.getProcId());
    }

    private void testRemoteLockRecovery(LockServiceProtos.LockRequest lock) throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        long procId = this.queueLock(lock);
        Assert.assertTrue((boolean)this.awaitForLocked(procId, 2000L));
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        Assert.assertEquals((Object)false, (Object)procExec.isRunning());
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        ProcedureTestingUtility.restart(procExec);
        while (!procExec.isStarted(procId)) {
            Thread.sleep(250L);
        }
        Assert.assertEquals((Object)true, (Object)procExec.isRunning());
        Assert.assertTrue((boolean)this.awaitForLocked(procId, 2000L));
        Thread.sleep(1000L);
        this.sendHeartbeatAndCheckLocked(procId, true);
        Thread.sleep(1000L);
        this.sendHeartbeatAndCheckLocked(procId, true);
        Thread.sleep(5000L);
        this.sendHeartbeatAndCheckLocked(procId, false);
        ProcedureTestingUtility.waitProcedure(procExec, (long)procId);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)procId);
    }

    @Test
    public void testRemoteTableLockRecovery() throws Exception {
        LockServiceProtos.LockRequest lock = this.getTableExclusiveLock(tableName1, this.testMethodName);
        this.testRemoteLockRecovery(lock);
    }

    @Test
    public void testRemoteNamespaceLockRecovery() throws Exception {
        LockServiceProtos.LockRequest lock = this.getNamespaceLock(namespace, this.testMethodName);
        this.testRemoteLockRecovery(lock);
    }

    @Test
    public void testRemoteRegionLockRecovery() throws Exception {
        LockServiceProtos.LockRequest lock = this.getRegionLock(tableRegions1, this.testMethodName);
        this.testRemoteLockRecovery(lock);
    }

    @Test
    public void testLocalMasterLockRecovery() throws Exception {
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)true);
        CountDownLatch latch = new CountDownLatch(1);
        LockProcedure lockProc = new LockProcedure(UTIL.getConfiguration(), TableName.valueOf((String)"table"), LockType.EXCLUSIVE, "desc", latch);
        procExec.submitProcedure((Procedure)lockProc);
        Assert.assertTrue((boolean)latch.await(2000L, TimeUnit.MILLISECONDS));
        ProcedureTestingUtility.waitProcedure(procExec, (long)lockProc.getProcId());
        Assert.assertEquals((Object)false, (Object)procExec.isRunning());
        ProcedureTestingUtility.setKillAndToggleBeforeStoreUpdate(procExec, (boolean)false);
        ProcedureTestingUtility.restart(procExec);
        while (!procExec.isStarted(lockProc.getProcId())) {
            Thread.sleep(250L);
        }
        Assert.assertEquals((Object)true, (Object)procExec.isRunning());
        ProcedureTestingUtility.waitProcedure(procExec, (long)lockProc.getProcId());
        Procedure result = procExec.getResultOrProcedure(lockProc.getProcId());
        Assert.assertTrue((result != null && !result.isFailed() ? 1 : 0) != 0);
        ProcedureTestingUtility.assertProcNotFailed(procExec, (long)lockProc.getProcId());
    }

    static {
        namespace = "namespace";
        tableName1 = TableName.valueOf((String)namespace, (String)"table1");
        tableName2 = TableName.valueOf((String)namespace, (String)"table2");
    }
}

