/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.master.DummyRegionProcedure;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestMasterProcedureSchedulerOnRestart {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterProcedureSchedulerOnRestart.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterProcedureSchedulerOnRestart.class);
    private static final int PROCEDURE_EXECUTOR_SLOTS = 1;
    private static final TableName tablename = TableName.valueOf((String)"test:TestProcedureScheduler");
    private static RegionInfo regionInfo = RegionInfoBuilder.newBuilder((TableName)tablename).build();
    protected static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static WALProcedureStore procStore;
    private static ProcedureExecutor<MasterProcedureEnv> procExecutor;
    private static HBaseCommonTestingUtility htu;
    private static MasterProcedureEnv masterProcedureEnv;
    private static FileSystem fs;
    private static Path testDir;
    private static Path logDir;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.startMiniCluster(1);
        procExecutor = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
    }

    @Test
    public void testScheduler() throws Exception {
        long regionProc = procExecutor.submitProcedure((Procedure)new DummyRegionProcedure((MasterProcedureEnv)UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().getEnvironment(), regionInfo));
        WALProcedureStore walProcedureStore = (WALProcedureStore)procExecutor.getStore();
        walProcedureStore.rollWriterForTesting();
        Thread.sleep(500L);
        procExecutor.submitProcedure((Procedure)new DummyTableProcedure((MasterProcedureEnv)UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor().getEnvironment(), tablename));
        ProcedureTestingUtility.restart(procExecutor);
        while (procExecutor.getProcedure(regionProc) == null) {
            Thread.sleep(500L);
        }
        DummyRegionProcedure dummyRegionProcedure = (DummyRegionProcedure)procExecutor.getProcedure(regionProc);
        dummyRegionProcedure.resume();
        UTIL.waitFor(5000L, () -> dummyRegionProcedure.isFinished());
    }

    public static enum DummyRegionTableState {
        STATE;

    }

    public static class DummyTableProcedure
    extends AbstractStateMachineTableProcedure<DummyRegionTableState> {
        private TableName tableName;

        public DummyTableProcedure() {
        }

        public DummyTableProcedure(MasterProcedureEnv env, TableName tableName) {
            super(null, null);
            this.tableName = tableName;
        }

        public TableName getTableName() {
            return this.tableName;
        }

        public TableProcedureInterface.TableOperationType getTableOperationType() {
            return TableProcedureInterface.TableOperationType.CREATE;
        }

        protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, DummyRegionTableState dummyRegionTableState) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
            return null;
        }

        protected void rollbackState(MasterProcedureEnv env, DummyRegionTableState dummyRegionTableState) throws IOException, InterruptedException {
        }

        protected DummyRegionTableState getState(int stateId) {
            return DummyRegionTableState.STATE;
        }

        protected int getStateId(DummyRegionTableState dummyRegionTableState) {
            return 0;
        }

        protected DummyRegionTableState getInitialState() {
            return DummyRegionTableState.STATE;
        }

        protected Procedure[] execute(MasterProcedureEnv env) throws ProcedureSuspendedException {
            LOG.info("Finished execute");
            return null;
        }

        protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
            super.serializeStateData(serializer);
            serializer.serialize((Message)ProtobufUtil.toProtoTableName((TableName)this.tableName));
        }

        protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
            super.deserializeStateData(serializer);
            this.tableName = ProtobufUtil.toTableName((HBaseProtos.TableName)((HBaseProtos.TableName)serializer.deserialize(HBaseProtos.TableName.class)));
        }

        protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
            return super.acquireLock(env);
        }

        protected void releaseLock(MasterProcedureEnv env) {
            super.releaseLock(env);
        }
    }
}

