/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hadoop.hbase.client.SnapshotType;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.quotas.QuotaSettingsFactory;
import org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hadoop.hbase.quotas.SnapshotQuotaObserverChore;
import org.apache.hadoop.hbase.quotas.SpaceQuotaHelperForTests;
import org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hbase.thirdparty.com.google.common.collect.HashMultimap;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.hbase.thirdparty.com.google.common.collect.Multimap;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestSnapshotQuotaObserverChore {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSnapshotQuotaObserverChore.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestSnapshotQuotaObserverChore.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final AtomicLong COUNTER = new AtomicLong();
    @Rule
    public TestName testName = new TestName();
    private Connection conn;
    private Admin admin;
    private SpaceQuotaHelperForTests helper;
    private HMaster master;
    private SnapshotQuotaObserverChore testChore;

    @BeforeClass
    public static void setUp() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        SpaceQuotaHelperForTests.updateConfigForQuotas(conf);
        conf.setInt("hbase.hfile.compaction.discharger.interval", 15000);
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws Exception {
        this.conn = TEST_UTIL.getConnection();
        this.admin = TEST_UTIL.getAdmin();
        this.helper = new SpaceQuotaHelperForTests(TEST_UTIL, this.testName, COUNTER);
        this.master = TEST_UTIL.getHBaseCluster().getMaster();
        this.helper.removeAllQuotas(this.conn);
        this.testChore = new SnapshotQuotaObserverChore(TEST_UTIL.getConnection(), TEST_UTIL.getConfiguration(), this.master.getFileSystem(), (Stoppable)this.master, null);
    }

    @Test
    public void testSnapshotSizePersistence() throws IOException {
        TableName tn;
        Admin admin = TEST_UTIL.getAdmin();
        if (admin.tableExists(tn = TableName.valueOf((String)"quota_snapshotSizePersistence"))) {
            admin.disableTable(tn);
            admin.deleteTable(tn);
        }
        HTableDescriptor desc = new HTableDescriptor(tn);
        desc.addFamily(new HColumnDescriptor(QuotaTableUtil.QUOTA_FAMILY_USAGE));
        admin.createTable((TableDescriptor)desc);
        HashMultimap snapshotsWithSizes = HashMultimap.create();
        try (Table table = this.conn.getTable(tn);){
            this.verify(table, () -> this.lambda$testSnapshotSizePersistence$0(table, (Multimap)snapshotsWithSizes));
            this.verify(table, () -> this.lambda$testSnapshotSizePersistence$1((Multimap)snapshotsWithSizes, table));
            snapshotsWithSizes.clear();
            this.verify(table, () -> this.lambda$testSnapshotSizePersistence$2((Multimap)snapshotsWithSizes, table));
        }
    }

    @Test
    public void testSnapshotsFromTables() throws Exception {
        TableName tn1 = this.helper.createTableWithRegions(1);
        TableName tn2 = this.helper.createTableWithRegions(1);
        TableName tn3 = this.helper.createTableWithRegions(1);
        this.admin.setQuota(QuotaSettingsFactory.limitTableSpace((TableName)tn1, (long)0x40000000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS));
        this.admin.setQuota(QuotaSettingsFactory.limitTableSpace((TableName)tn2, (long)0x40000000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS));
        this.admin.snapshot(new SnapshotDescription(tn1 + "snapshot", tn1, SnapshotType.SKIPFLUSH));
        this.admin.snapshot(new SnapshotDescription(tn2 + "snapshot", tn2, SnapshotType.SKIPFLUSH));
        this.admin.snapshot(new SnapshotDescription(tn3 + "snapshot", tn3, SnapshotType.SKIPFLUSH));
        Multimap mapping = this.testChore.getSnapshotsToComputeSize();
        Assert.assertEquals((long)2L, (long)mapping.size());
        Assert.assertEquals((long)1L, (long)mapping.get((Object)tn1).size());
        Assert.assertEquals((Object)(tn1 + "snapshot"), mapping.get((Object)tn1).iterator().next());
        Assert.assertEquals((long)1L, (long)mapping.get((Object)tn2).size());
        Assert.assertEquals((Object)(tn2 + "snapshot"), mapping.get((Object)tn2).iterator().next());
        this.admin.snapshot(new SnapshotDescription(tn2 + "snapshot1", tn2, SnapshotType.SKIPFLUSH));
        this.admin.snapshot(new SnapshotDescription(tn3 + "snapshot1", tn3, SnapshotType.SKIPFLUSH));
        mapping = this.testChore.getSnapshotsToComputeSize();
        Assert.assertEquals((long)3L, (long)mapping.size());
        Assert.assertEquals((long)1L, (long)mapping.get((Object)tn1).size());
        Assert.assertEquals((Object)(tn1 + "snapshot"), mapping.get((Object)tn1).iterator().next());
        Assert.assertEquals((long)2L, (long)mapping.get((Object)tn2).size());
        Assert.assertEquals(new HashSet<String>(Arrays.asList(tn2 + "snapshot", tn2 + "snapshot1")), (Object)mapping.get((Object)tn2));
    }

    @Test
    public void testSnapshotsFromNamespaces() throws Exception {
        NamespaceDescriptor ns = NamespaceDescriptor.create((String)"snapshots_from_namespaces").build();
        this.admin.createNamespace(ns);
        TableName tn1 = this.helper.createTableWithRegions(ns.getName(), 1);
        TableName tn2 = this.helper.createTableWithRegions(ns.getName(), 1);
        TableName tn3 = this.helper.createTableWithRegions(1);
        this.admin.setQuota(QuotaSettingsFactory.limitNamespaceSpace((String)ns.getName(), (long)0x40000000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS));
        this.admin.snapshot(new SnapshotDescription(tn1.getQualifierAsString() + "snapshot", tn1, SnapshotType.SKIPFLUSH));
        this.admin.snapshot(new SnapshotDescription(tn2.getQualifierAsString() + "snapshot", tn2, SnapshotType.SKIPFLUSH));
        this.admin.snapshot(new SnapshotDescription(tn3.getQualifierAsString() + "snapshot", tn3, SnapshotType.SKIPFLUSH));
        Multimap mapping = this.testChore.getSnapshotsToComputeSize();
        Assert.assertEquals((long)2L, (long)mapping.size());
        Assert.assertEquals((long)1L, (long)mapping.get((Object)tn1).size());
        Assert.assertEquals((Object)(tn1.getQualifierAsString() + "snapshot"), mapping.get((Object)tn1).iterator().next());
        Assert.assertEquals((long)1L, (long)mapping.get((Object)tn2).size());
        Assert.assertEquals((Object)(tn2.getQualifierAsString() + "snapshot"), mapping.get((Object)tn2).iterator().next());
        this.admin.snapshot(new SnapshotDescription(tn2.getQualifierAsString() + "snapshot1", tn2, SnapshotType.SKIPFLUSH));
        this.admin.snapshot(new SnapshotDescription(tn3.getQualifierAsString() + "snapshot2", tn3, SnapshotType.SKIPFLUSH));
        mapping = this.testChore.getSnapshotsToComputeSize();
        Assert.assertEquals((long)3L, (long)mapping.size());
        Assert.assertEquals((long)1L, (long)mapping.get((Object)tn1).size());
        Assert.assertEquals((Object)(tn1.getQualifierAsString() + "snapshot"), mapping.get((Object)tn1).iterator().next());
        Assert.assertEquals((long)2L, (long)mapping.get((Object)tn2).size());
        Assert.assertEquals(new HashSet<String>(Arrays.asList(tn2.getQualifierAsString() + "snapshot", tn2.getQualifierAsString() + "snapshot1")), (Object)mapping.get((Object)tn2));
    }

    @Test
    public void testSnapshotSize() throws Exception {
        final TableName tn1 = this.helper.createTableWithRegions(5);
        this.admin.setQuota(QuotaSettingsFactory.limitTableSpace((TableName)tn1, (long)0x40000000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS));
        this.helper.writeData(tn1, 262144L);
        this.admin.flush(tn1);
        final long snapshotSize = TEST_UTIL.getMiniHBaseCluster().getRegions(tn1).stream().flatMap(r -> r.getStores().stream()).mapToLong(HStore::getHFilesSize).sum();
        TEST_UTIL.waitFor(30000L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn1){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                return snapshot.getUsage() == snapshotSize;
            }
        });
        String snapshotName = tn1 + "snapshot";
        this.admin.snapshot(new SnapshotDescription(snapshotName, tn1, SnapshotType.SKIPFLUSH));
        Multimap snapshotsToCompute = this.testChore.getSnapshotsToComputeSize();
        Assert.assertEquals((String)("Expected to see the single snapshot: " + snapshotsToCompute), (long)1L, (long)snapshotsToCompute.size());
        Multimap snapshotsWithSize = this.testChore.computeSnapshotSizes(snapshotsToCompute);
        Assert.assertEquals((long)1L, (long)snapshotsWithSize.size());
        SnapshotQuotaObserverChore.SnapshotWithSize sws = (SnapshotQuotaObserverChore.SnapshotWithSize)Iterables.getOnlyElement((Iterable)snapshotsWithSize.get((Object)tn1));
        Assert.assertEquals((Object)snapshotName, (Object)sws.getName());
        Assert.assertEquals((long)0L, (long)sws.getSize());
        this.helper.writeData(tn1, 262144L);
        this.admin.flush(tn1);
        TEST_UTIL.compact(tn1, true);
        TEST_UTIL.waitFor(30000L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn1){
            private final long regionSize;
            {
                super(conn, tn);
                this.regionSize = TEST_UTIL.getMiniHBaseCluster().getRegions(tn1).stream().flatMap(r -> r.getStores().stream()).mapToLong(HStore::getHFilesSize).sum();
            }

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                LOG.debug("Current usage=" + snapshot.getUsage() + " snapshotSize=" + snapshotSize);
                return TestSnapshotQuotaObserverChore.this.closeInSize(snapshot.getUsage(), snapshotSize + this.regionSize, 1024L);
            }
        });
        TEST_UTIL.waitFor(30000L, new SpaceQuotaHelperForTests.NoFilesToDischarge(TEST_UTIL.getMiniHBaseCluster(), tn1));
        snapshotsToCompute = this.testChore.getSnapshotsToComputeSize();
        Assert.assertEquals((String)("Expected to see the single snapshot: " + snapshotsToCompute), (long)1L, (long)snapshotsToCompute.size());
        snapshotsWithSize = this.testChore.computeSnapshotSizes(snapshotsToCompute);
        Assert.assertEquals((long)1L, (long)snapshotsWithSize.size());
        sws = (SnapshotQuotaObserverChore.SnapshotWithSize)Iterables.getOnlyElement((Iterable)snapshotsWithSize.get((Object)tn1));
        Assert.assertEquals((Object)snapshotName, (Object)sws.getName());
        Assert.assertEquals((long)snapshotSize, (long)sws.getSize());
    }

    @Test
    public void testPersistingSnapshotsForNamespaces() throws Exception {
        HashMultimap snapshotsWithSizes = HashMultimap.create();
        TableName tn1 = TableName.valueOf((String)"ns1:tn1");
        TableName tn2 = TableName.valueOf((String)"ns1:tn2");
        TableName tn3 = TableName.valueOf((String)"ns2:tn1");
        TableName tn4 = TableName.valueOf((String)"ns2:tn2");
        TableName tn5 = TableName.valueOf((String)"tn1");
        snapshotsWithSizes.put((Object)tn1, (Object)new SnapshotQuotaObserverChore.SnapshotWithSize("", 1024L));
        snapshotsWithSizes.put((Object)tn2, (Object)new SnapshotQuotaObserverChore.SnapshotWithSize("", 1024L));
        snapshotsWithSizes.put((Object)tn3, (Object)new SnapshotQuotaObserverChore.SnapshotWithSize("", 512L));
        snapshotsWithSizes.put((Object)tn4, (Object)new SnapshotQuotaObserverChore.SnapshotWithSize("", 1024L));
        snapshotsWithSizes.put((Object)tn5, (Object)new SnapshotQuotaObserverChore.SnapshotWithSize("", 3072L));
        Map nsSizes = this.testChore.groupSnapshotSizesByNamespace((Multimap)snapshotsWithSizes);
        Assert.assertEquals((long)3L, (long)nsSizes.size());
        Assert.assertEquals((long)2048L, (long)((Long)nsSizes.get("ns1")));
        Assert.assertEquals((long)1536L, (long)((Long)nsSizes.get("ns2")));
        Assert.assertEquals((long)3072L, (long)((Long)nsSizes.get(NamespaceDescriptor.DEFAULT_NAMESPACE_NAME_STR)));
    }

    @Test
    public void testRemovedSnapshots() throws Exception {
        final TableName tn1 = this.helper.createTableWithRegions(1);
        this.admin.setQuota(QuotaSettingsFactory.limitTableSpace((TableName)tn1, (long)0x40000000L, (SpaceViolationPolicy)SpaceViolationPolicy.NO_INSERTS));
        this.helper.writeData(tn1, 262144L);
        final AtomicReference lastSeenSize = new AtomicReference();
        TEST_UTIL.waitFor(30000L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn1){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                lastSeenSize.set(snapshot.getUsage());
                return snapshot.getUsage() > 235520L;
            }
        });
        final String snapshotName1 = tn1 + "snapshot1";
        this.admin.snapshot(new SnapshotDescription(snapshotName1, tn1, SnapshotType.SKIPFLUSH));
        final Table quotaTable = this.conn.getTable(QuotaUtil.QUOTA_TABLE_NAME);
        TEST_UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                Get g = QuotaTableUtil.makeGetForSnapshotSize((TableName)tn1, (String)snapshotName1);
                Result r = quotaTable.get(g);
                if (r == null || r.isEmpty()) {
                    return false;
                }
                r.advance();
                Cell c = r.current();
                return QuotaTableUtil.parseSnapshotSize((Cell)c) == 0L;
            }
        });
        TEST_UTIL.waitFor(30000L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn1){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                return snapshot.getUsage() == ((Long)lastSeenSize.get()).longValue();
            }
        });
        TEST_UTIL.compact(tn1, true);
        TEST_UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                Get g = QuotaTableUtil.makeGetForSnapshotSize((TableName)tn1, (String)snapshotName1);
                Result r = quotaTable.get(g);
                if (r == null || r.isEmpty()) {
                    return false;
                }
                r.advance();
                Cell c = r.current();
                return (Long)lastSeenSize.get() == QuotaTableUtil.parseSnapshotSize((Cell)c);
            }
        });
        final AtomicReference sizeAfterCompaction = new AtomicReference();
        TEST_UTIL.waitFor(30000L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn1){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                sizeAfterCompaction.set(snapshot.getUsage());
                return snapshot.getUsage() >= 2L * (Long)lastSeenSize.get();
            }
        });
        this.admin.deleteSnapshot(snapshotName1);
        TEST_UTIL.waitFor(30000L, new SpaceQuotaHelperForTests.SpaceQuotaSnapshotPredicate(this.conn, tn1){

            @Override
            boolean evaluate(SpaceQuotaSnapshot snapshot) throws Exception {
                return snapshot.getUsage() == (Long)sizeAfterCompaction.get() - (Long)lastSeenSize.get();
            }
        });
    }

    private long count(Table t) throws IOException {
        try (ResultScanner rs = t.getScanner(new Scan());){
            long sum = 0L;
            for (Result r : rs) {
                while (r.advance()) {
                    ++sum;
                }
            }
            long l = sum;
            return l;
        }
    }

    private long extractSnapshotSize(Table quotaTable, TableName tn, String snapshot) throws IOException {
        Get g = QuotaTableUtil.makeGetForSnapshotSize((TableName)tn, (String)snapshot);
        Result r = quotaTable.get(g);
        Assert.assertNotNull((Object)r);
        CellScanner cs = r.cellScanner();
        cs.advance();
        Cell c = cs.current();
        Assert.assertNotNull((Object)c);
        return QuotaTableUtil.extractSnapshotSize((byte[])c.getValueArray(), (int)c.getValueOffset(), (int)c.getValueLength());
    }

    private void verify(Table t, IOThrowingRunnable test) throws IOException {
        this.admin.disableTable(t.getName());
        this.admin.truncateTable(t.getName(), false);
        test.run();
    }

    boolean closeInSize(long size1, long size2, long delta) {
        long lower = size1 - delta;
        long upper = size1 + delta;
        return lower <= size2 && size2 <= upper;
    }

    private /* synthetic */ void lambda$testSnapshotSizePersistence$2(Multimap snapshotsWithSizes, Table table) throws IOException {
        snapshotsWithSizes.put((Object)TableName.valueOf((String)"t1"), (Object)new SnapshotQuotaObserverChore.SnapshotWithSize("ss1", 1024L));
        snapshotsWithSizes.put((Object)TableName.valueOf((String)"t2"), (Object)new SnapshotQuotaObserverChore.SnapshotWithSize("ss2", 4096L));
        snapshotsWithSizes.put((Object)TableName.valueOf((String)"t3"), (Object)new SnapshotQuotaObserverChore.SnapshotWithSize("ss3", 8192L));
        this.testChore.persistSnapshotSizes(table, snapshotsWithSizes);
        Assert.assertEquals((long)3L, (long)this.count(table));
        Assert.assertEquals((long)1024L, (long)this.extractSnapshotSize(table, TableName.valueOf((String)"t1"), "ss1"));
        Assert.assertEquals((long)4096L, (long)this.extractSnapshotSize(table, TableName.valueOf((String)"t2"), "ss2"));
        Assert.assertEquals((long)8192L, (long)this.extractSnapshotSize(table, TableName.valueOf((String)"t3"), "ss3"));
    }

    private /* synthetic */ void lambda$testSnapshotSizePersistence$1(Multimap snapshotsWithSizes, Table table) throws IOException {
        TableName originatingTable = TableName.valueOf((String)"t1");
        snapshotsWithSizes.put((Object)originatingTable, (Object)new SnapshotQuotaObserverChore.SnapshotWithSize("ss1", 1024L));
        snapshotsWithSizes.put((Object)originatingTable, (Object)new SnapshotQuotaObserverChore.SnapshotWithSize("ss2", 4096L));
        this.testChore.persistSnapshotSizes(table, snapshotsWithSizes);
        Assert.assertEquals((long)2L, (long)this.count(table));
        Assert.assertEquals((long)1024L, (long)this.extractSnapshotSize(table, originatingTable, "ss1"));
        Assert.assertEquals((long)4096L, (long)this.extractSnapshotSize(table, originatingTable, "ss2"));
    }

    private /* synthetic */ void lambda$testSnapshotSizePersistence$0(Table table, Multimap snapshotsWithSizes) throws IOException {
        this.testChore.persistSnapshotSizes(table, snapshotsWithSizes);
        Assert.assertEquals((long)0L, (long)this.count(table));
    }

    @FunctionalInterface
    private static interface IOThrowingRunnable {
        public void run() throws IOException;
    }
}

