/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.HFileLink;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.CacheStats;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoderImpl;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileComparators;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Joiner;
import org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestHStoreFile
extends HBaseTestCase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHStoreFile.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHStoreFile.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private CacheConfig cacheConf = new CacheConfig(TEST_UTIL.getConfiguration());
    private static String ROOT_DIR = TEST_UTIL.getDataTestDir("TestStoreFile").toString();
    private static final ChecksumType CKTYPE = ChecksumType.CRC32C;
    private static final int CKBYTES = 512;
    private static String TEST_FAMILY = "cf";
    byte[] SPLITKEY = new byte[]{109, 97};
    private static final String localFormatter = "%010d";
    private static final int BLOCKSIZE_SMALL = 8192;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testBasicHalfMapFile() throws Exception {
        HRegionInfo hri = new HRegionInfo(TableName.valueOf((String)"testBasicHalfMapFileTb"));
        HRegionFileSystem regionFs = HRegionFileSystem.createRegionOnFileSystem((Configuration)this.conf, (FileSystem)this.fs, (Path)new Path(testDir, hri.getTable().getNameAsString()), (RegionInfo)hri);
        HFileContext meta = new HFileContextBuilder().withBlockSize(2048).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withFilePath(regionFs.createTempName()).withFileContext(meta).build();
        this.writeStoreFile(writer);
        Path sfPath = regionFs.commitStoreFile(TEST_FAMILY, writer.getPath());
        HStoreFile sf = new HStoreFile(this.fs, sfPath, this.conf, this.cacheConf, BloomType.NONE, true);
        this.checkHalfHFile(regionFs, sf);
    }

    private void writeStoreFile(StoreFileWriter writer) throws IOException {
        TestHStoreFile.writeStoreFile(writer, Bytes.toBytes((String)this.getName()), Bytes.toBytes((String)this.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStoreFile(StoreFileWriter writer, byte[] fam, byte[] qualifier) throws IOException {
        long now = System.currentTimeMillis();
        try {
            for (int d = 97; d <= 122; d = (int)((char)(d + 1))) {
                for (int e = 97; e <= 122; e = (int)((char)(e + 1))) {
                    byte[] b = new byte[]{(byte)d, (byte)e};
                    writer.append((Cell)new KeyValue(b, fam, qualifier, now, b));
                }
            }
        }
        finally {
            writer.close();
        }
    }

    @Test
    public void testReference() throws IOException {
        HRegionInfo hri = new HRegionInfo(TableName.valueOf((String)"testReferenceTb"));
        HRegionFileSystem regionFs = HRegionFileSystem.createRegionOnFileSystem((Configuration)this.conf, (FileSystem)this.fs, (Path)new Path(testDir, hri.getTable().getNameAsString()), (RegionInfo)hri);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withFilePath(regionFs.createTempName()).withFileContext(meta).build();
        this.writeStoreFile(writer);
        Path hsfPath = regionFs.commitStoreFile(TEST_FAMILY, writer.getPath());
        HStoreFile hsf = new HStoreFile(this.fs, hsfPath, this.conf, this.cacheConf, BloomType.NONE, true);
        hsf.initReader();
        StoreFileReader reader = hsf.getReader();
        byte[] midRow = CellUtil.cloneRow((Cell)((Cell)reader.midKey().get()));
        byte[] finalRow = CellUtil.cloneRow((Cell)((Cell)reader.getLastKey().get()));
        hsf.closeStoreFile(true);
        HRegionInfo splitHri = new HRegionInfo(hri.getTable(), null, midRow);
        Path refPath = this.splitStoreFile(regionFs, splitHri, TEST_FAMILY, hsf, midRow, true);
        HStoreFile refHsf = new HStoreFile(this.fs, refPath, this.conf, this.cacheConf, BloomType.NONE, true);
        refHsf.initReader();
        HFileScanner s = refHsf.getReader().getScanner(false, false);
        KeyValue kv = null;
        boolean first = true;
        while (!s.isSeeked() && s.seekTo() || s.next()) {
            ByteBuffer bb = ByteBuffer.wrap(((KeyValue)s.getKey()).getKey());
            kv = KeyValueUtil.createKeyValueFromKey((ByteBuffer)bb);
            if (!first) continue;
            TestHStoreFile.assertTrue((boolean)Bytes.equals((byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength(), (byte[])midRow, (int)0, (int)midRow.length));
            first = false;
        }
        TestHStoreFile.assertTrue((boolean)Bytes.equals((byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength(), (byte[])finalRow, (int)0, (int)finalRow.length));
    }

    @Test
    public void testStoreFileReference() throws Exception {
        RegionInfo hri = RegionInfoBuilder.newBuilder((TableName)TableName.valueOf((String)"testStoreFileReference")).build();
        HRegionFileSystem regionFs = HRegionFileSystem.createRegionOnFileSystem((Configuration)this.conf, (FileSystem)this.fs, (Path)new Path(testDir, hri.getTable().getNameAsString()), (RegionInfo)hri);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withFilePath(regionFs.createTempName()).withFileContext(meta).build();
        this.writeStoreFile(writer);
        Path hsfPath = regionFs.commitStoreFile(TEST_FAMILY, writer.getPath());
        writer.close();
        HStoreFile file = new HStoreFile(this.fs, hsfPath, this.conf, this.cacheConf, BloomType.NONE, true);
        file.initReader();
        StoreFileReader r = file.getReader();
        TestHStoreFile.assertNotNull((Object)r);
        StoreFileScanner scanner = new StoreFileScanner(r, (HFileScanner)Mockito.mock(HFileScanner.class), false, false, 0L, 0L, false);
        TestHStoreFile.assertTrue((String)"Verify file is being referenced", (boolean)file.isReferencedInReads());
        scanner.close();
        TestHStoreFile.assertFalse((String)"Verify file is not being referenced", (boolean)file.isReferencedInReads());
    }

    @Test
    public void testEmptyStoreFileRestrictKeyRanges() throws Exception {
        StoreFileReader reader = (StoreFileReader)Mockito.mock(StoreFileReader.class);
        HStore store = (HStore)Mockito.mock(HStore.class);
        byte[] cf = Bytes.toBytes((String)"ty");
        ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.of((byte[])cf);
        Mockito.when((Object)store.getColumnFamilyDescriptor()).thenReturn((Object)cfd);
        StoreFileScanner scanner = new StoreFileScanner(reader, (HFileScanner)Mockito.mock(HFileScanner.class), false, false, 0L, 0L, true);
        Scan scan = new Scan();
        scan.setColumnFamilyTimeRange(cf, 0L, 1L);
        TestHStoreFile.assertFalse((boolean)scanner.shouldUseScanner(scan, store, 0L));
    }

    @Test
    public void testHFileLink() throws IOException {
        HRegionInfo hri = new HRegionInfo(TableName.valueOf((String)"testHFileLinkTb"));
        Configuration testConf = new Configuration(this.conf);
        FSUtils.setRootDir((Configuration)testConf, (Path)testDir);
        HRegionFileSystem regionFs = HRegionFileSystem.createRegionOnFileSystem((Configuration)testConf, (FileSystem)this.fs, (Path)FSUtils.getTableDir((Path)testDir, (TableName)hri.getTable()), (RegionInfo)hri);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withFilePath(regionFs.createTempName()).withFileContext(meta).build();
        this.writeStoreFile(writer);
        Path storeFilePath = regionFs.commitStoreFile(TEST_FAMILY, writer.getPath());
        Path dstPath = new Path(regionFs.getTableDir(), new Path("test-region", TEST_FAMILY));
        HFileLink.create((Configuration)testConf, (FileSystem)this.fs, (Path)dstPath, (RegionInfo)hri, (String)storeFilePath.getName());
        Path linkFilePath = new Path(dstPath, HFileLink.createHFileLinkName((RegionInfo)hri, (String)storeFilePath.getName()));
        StoreFileInfo storeFileInfo = new StoreFileInfo(testConf, this.fs, linkFilePath);
        HStoreFile hsf = new HStoreFile(this.fs, storeFileInfo, testConf, this.cacheConf, BloomType.NONE, true);
        TestHStoreFile.assertTrue((boolean)storeFileInfo.isLink());
        hsf.initReader();
        int count = 1;
        HFileScanner s = hsf.getReader().getScanner(false, false);
        s.seekTo();
        while (s.next()) {
            ++count;
        }
        TestHStoreFile.assertEquals((int)676, (int)count);
    }

    @Test
    public void testReferenceToHFileLink() throws IOException {
        Configuration testConf = new Configuration(this.conf);
        FSUtils.setRootDir((Configuration)testConf, (Path)testDir);
        HRegionInfo hri = new HRegionInfo(TableName.valueOf((String)"_original-evil-name"));
        HRegionFileSystem regionFs = HRegionFileSystem.createRegionOnFileSystem((Configuration)testConf, (FileSystem)this.fs, (Path)FSUtils.getTableDir((Path)testDir, (TableName)hri.getTable()), (RegionInfo)hri);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(testConf, this.cacheConf, this.fs).withFilePath(regionFs.createTempName()).withFileContext(meta).build();
        this.writeStoreFile(writer);
        Path storeFilePath = regionFs.commitStoreFile(TEST_FAMILY, writer.getPath());
        HRegionInfo hriClone = new HRegionInfo(TableName.valueOf((String)"clone"));
        HRegionFileSystem cloneRegionFs = HRegionFileSystem.createRegionOnFileSystem((Configuration)testConf, (FileSystem)this.fs, (Path)FSUtils.getTableDir((Path)testDir, (TableName)hri.getTable()), (RegionInfo)hriClone);
        Path dstPath = cloneRegionFs.getStoreDir(TEST_FAMILY);
        HFileLink.create((Configuration)testConf, (FileSystem)this.fs, (Path)dstPath, (RegionInfo)hri, (String)storeFilePath.getName());
        Path linkFilePath = new Path(dstPath, HFileLink.createHFileLinkName((RegionInfo)hri, (String)storeFilePath.getName()));
        HRegionInfo splitHriA = new HRegionInfo(hri.getTable(), null, this.SPLITKEY);
        HRegionInfo splitHriB = new HRegionInfo(hri.getTable(), this.SPLITKEY, null);
        HStoreFile f = new HStoreFile(this.fs, linkFilePath, testConf, this.cacheConf, BloomType.NONE, true);
        f.initReader();
        Path pathA = this.splitStoreFile(cloneRegionFs, splitHriA, TEST_FAMILY, f, this.SPLITKEY, true);
        Path pathB = this.splitStoreFile(cloneRegionFs, splitHriB, TEST_FAMILY, f, this.SPLITKEY, false);
        f.closeStoreFile(true);
        FSUtils.logFileSystemState((FileSystem)this.fs, (Path)testDir, (Logger)LOG);
        HStoreFile hsfA = new HStoreFile(this.fs, pathA, testConf, this.cacheConf, BloomType.NONE, true);
        hsfA.initReader();
        int count = 1;
        HFileScanner s = hsfA.getReader().getScanner(false, false);
        s.seekTo();
        while (s.next()) {
            ++count;
        }
        TestHStoreFile.assertTrue((count > 0 ? 1 : 0) != 0);
        HStoreFile hsfB = new HStoreFile(this.fs, pathB, testConf, this.cacheConf, BloomType.NONE, true);
        hsfB.initReader();
        HFileScanner sB = hsfB.getReader().getScanner(false, false);
        sB.seekTo();
        ++count;
        while (sB.next()) {
            ++count;
        }
        TestHStoreFile.assertEquals((int)676, (int)count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHalfHFile(HRegionFileSystem regionFs, HStoreFile f) throws IOException {
        f.initReader();
        Cell midkey = (Cell)f.getReader().midKey().get();
        KeyValue midKV = (KeyValue)midkey;
        byte[] midRow = CellUtil.cloneRow((Cell)midKV);
        HRegionInfo topHri = new HRegionInfo(regionFs.getRegionInfo().getTable(), null, midRow);
        Path topPath = this.splitStoreFile(regionFs, topHri, TEST_FAMILY, f, midRow, true);
        HRegionInfo bottomHri = new HRegionInfo(regionFs.getRegionInfo().getTable(), midRow, null);
        Path bottomPath = this.splitStoreFile(regionFs, bottomHri, TEST_FAMILY, f, midRow, false);
        HStoreFile topF = new HStoreFile(this.fs, topPath, this.conf, this.cacheConf, BloomType.NONE, true);
        topF.initReader();
        StoreFileReader top = topF.getReader();
        HStoreFile bottomF = new HStoreFile(this.fs, bottomPath, this.conf, this.cacheConf, BloomType.NONE, true);
        bottomF.initReader();
        StoreFileReader bottom = bottomF.getReader();
        ByteBuffer previous = null;
        LOG.info("Midkey: " + midKV.toString());
        ByteBuffer bbMidkeyBytes = ByteBuffer.wrap(midKV.getKey());
        try {
            int i;
            String tmp;
            KeyValue keyKV;
            boolean first = true;
            ByteBuffer key = null;
            HFileScanner topScanner = top.getScanner(false, false);
            while (!topScanner.isSeeked() && topScanner.seekTo() || topScanner.isSeeked() && topScanner.next()) {
                key = ByteBuffer.wrap(((KeyValue)topScanner.getKey()).getKey());
                if (PrivateCellUtil.compare((CellComparator)topScanner.getReader().getComparator(), (Cell)midKV, (byte[])key.array(), (int)key.arrayOffset(), (int)key.limit()) > 0) {
                    TestHStoreFile.fail((String)("key=" + Bytes.toStringBinary((ByteBuffer)key) + " < midkey=" + midkey));
                }
                if (!first) continue;
                first = false;
                LOG.info("First in top: " + Bytes.toString((byte[])Bytes.toBytes((ByteBuffer)key)));
            }
            LOG.info("Last in top: " + Bytes.toString((byte[])Bytes.toBytes((ByteBuffer)key)));
            first = true;
            HFileScanner bottomScanner = bottom.getScanner(false, false);
            while (!bottomScanner.isSeeked() && bottomScanner.seekTo() || bottomScanner.next()) {
                previous = ByteBuffer.wrap(((KeyValue)bottomScanner.getKey()).getKey());
                key = ByteBuffer.wrap(((KeyValue)bottomScanner.getKey()).getKey());
                if (first) {
                    first = false;
                    LOG.info("First in bottom: " + Bytes.toString((byte[])Bytes.toBytes((ByteBuffer)previous)));
                }
                TestHStoreFile.assertTrue((key.compareTo(bbMidkeyBytes) < 0 ? 1 : 0) != 0);
            }
            if (previous != null) {
                LOG.info("Last in bottom: " + Bytes.toString((byte[])Bytes.toBytes((ByteBuffer)previous)));
            }
            regionFs.cleanupDaughterRegion((RegionInfo)topHri);
            regionFs.cleanupDaughterRegion((RegionInfo)bottomHri);
            byte[] badmidkey = Bytes.toBytes((String)"  .");
            TestHStoreFile.assertTrue((boolean)this.fs.exists(f.getPath()));
            topPath = this.splitStoreFile(regionFs, topHri, TEST_FAMILY, f, badmidkey, true);
            bottomPath = this.splitStoreFile(regionFs, bottomHri, TEST_FAMILY, f, badmidkey, false);
            TestHStoreFile.assertNull((Object)bottomPath);
            topF = new HStoreFile(this.fs, topPath, this.conf, this.cacheConf, BloomType.NONE, true);
            topF.initReader();
            top = topF.getReader();
            first = true;
            topScanner = top.getScanner(false, false);
            KeyValue.KeyOnlyKeyValue keyOnlyKV = new KeyValue.KeyOnlyKeyValue();
            while (!topScanner.isSeeked() && topScanner.seekTo() || topScanner.next()) {
                key = ByteBuffer.wrap(((KeyValue)topScanner.getKey()).getKey());
                keyOnlyKV.setKey(key.array(), 0 + key.arrayOffset(), key.limit());
                TestHStoreFile.assertTrue((PrivateCellUtil.compare((CellComparator)topScanner.getReader().getComparator(), (Cell)keyOnlyKV, (byte[])badmidkey, (int)0, (int)badmidkey.length) >= 0 ? 1 : 0) != 0);
                if (!first) continue;
                first = false;
                keyKV = KeyValueUtil.createKeyValueFromKey((ByteBuffer)key);
                LOG.info("First top when key < bottom: " + keyKV);
                tmp = Bytes.toString((byte[])keyKV.getRowArray(), (int)keyKV.getRowOffset(), (int)keyKV.getRowLength());
                for (i = 0; i < tmp.length(); ++i) {
                    TestHStoreFile.assertTrue((tmp.charAt(i) == 'a' ? 1 : 0) != 0);
                }
            }
            keyKV = KeyValueUtil.createKeyValueFromKey((ByteBuffer)key);
            LOG.info("Last top when key < bottom: " + keyKV);
            tmp = Bytes.toString((byte[])keyKV.getRowArray(), (int)keyKV.getRowOffset(), (int)keyKV.getRowLength());
            for (i = 0; i < tmp.length(); ++i) {
                TestHStoreFile.assertTrue((tmp.charAt(i) == 'z' ? 1 : 0) != 0);
            }
            regionFs.cleanupDaughterRegion((RegionInfo)topHri);
            regionFs.cleanupDaughterRegion((RegionInfo)bottomHri);
            badmidkey = Bytes.toBytes((String)"|||");
            topPath = this.splitStoreFile(regionFs, topHri, TEST_FAMILY, f, badmidkey, true);
            bottomPath = this.splitStoreFile(regionFs, bottomHri, TEST_FAMILY, f, badmidkey, false);
            TestHStoreFile.assertNull((Object)topPath);
            bottomF = new HStoreFile(this.fs, bottomPath, this.conf, this.cacheConf, BloomType.NONE, true);
            bottomF.initReader();
            bottom = bottomF.getReader();
            first = true;
            bottomScanner = bottom.getScanner(false, false);
            while (!bottomScanner.isSeeked() && bottomScanner.seekTo() || bottomScanner.next()) {
                key = ByteBuffer.wrap(((KeyValue)bottomScanner.getKey()).getKey());
                if (!first) continue;
                first = false;
                keyKV = KeyValueUtil.createKeyValueFromKey((ByteBuffer)key);
                LOG.info("First bottom when key > top: " + keyKV);
                tmp = Bytes.toString((byte[])keyKV.getRowArray(), (int)keyKV.getRowOffset(), (int)keyKV.getRowLength());
                for (i = 0; i < tmp.length(); ++i) {
                    TestHStoreFile.assertTrue((tmp.charAt(i) == 'a' ? 1 : 0) != 0);
                }
            }
            keyKV = KeyValueUtil.createKeyValueFromKey((ByteBuffer)key);
            LOG.info("Last bottom when key > top: " + keyKV);
            for (i = 0; i < tmp.length(); ++i) {
                TestHStoreFile.assertTrue((Bytes.toString((byte[])keyKV.getRowArray(), (int)keyKV.getRowOffset(), (int)keyKV.getRowLength()).charAt(i) == 'z' ? 1 : 0) != 0);
            }
        }
        finally {
            if (top != null) {
                top.close(true);
            }
            if (bottom != null) {
                bottom.close(true);
            }
            this.fs.delete(f.getPath(), true);
        }
    }

    private static StoreFileScanner getStoreFileScanner(StoreFileReader reader, boolean cacheBlocks, boolean pread) {
        return reader.getStoreFileScanner(cacheBlocks, pread, false, 0L, 0L, false);
    }

    private void bloomWriteRead(StoreFileWriter writer, FileSystem fs) throws Exception {
        float err = this.conf.getFloat("io.storefile.bloom.error.rate", 0.0f);
        Path f = writer.getPath();
        long now = System.currentTimeMillis();
        for (int i = 0; i < 2000; i += 2) {
            String row = String.format(localFormatter, i);
            KeyValue kv = new KeyValue(Bytes.toBytes((String)row), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"col"), now, Bytes.toBytes((String)"value"));
            writer.append((Cell)kv);
        }
        writer.close();
        StoreFileReader reader = new StoreFileReader(fs, f, this.cacheConf, true, new AtomicInteger(0), true, this.conf);
        reader.loadFileInfo();
        reader.loadBloomfilter();
        StoreFileScanner scanner = TestHStoreFile.getStoreFileScanner(reader, false, false);
        int falsePos = 0;
        int falseNeg = 0;
        for (int i = 0; i < 2000; ++i) {
            String row = String.format(localFormatter, i);
            TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            columns.add(Bytes.toBytes((String)"family:col"));
            Scan scan = new Scan(Bytes.toBytes((String)row), Bytes.toBytes((String)row));
            scan.addColumn(Bytes.toBytes((String)"family"), Bytes.toBytes((String)"family:col"));
            HStore store = (HStore)Mockito.mock(HStore.class);
            Mockito.when((Object)store.getColumnFamilyDescriptor()).thenReturn((Object)ColumnFamilyDescriptorBuilder.of((String)"family"));
            boolean exists = scanner.shouldUseScanner(scan, store, Long.MIN_VALUE);
            if (i % 2 == 0) {
                if (exists) continue;
                ++falseNeg;
                continue;
            }
            if (!exists) continue;
            ++falsePos;
        }
        reader.close(true);
        fs.delete(f, true);
        TestHStoreFile.assertEquals((String)("False negatives: " + falseNeg), (int)0, (int)falseNeg);
        int maxFalsePos = (int)(4000.0f * err);
        TestHStoreFile.assertTrue((String)("Too many false positives: " + falsePos + " (err=" + err + ", expected no more than " + maxFalsePos + ")"), (falsePos <= maxFalsePos ? 1 : 0) != 0);
    }

    @Test
    public void testBloomFilter() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        this.conf.setFloat("io.storefile.bloom.error.rate", 0.01f);
        this.conf.setBoolean("io.storefile.bloom.enabled", true);
        Path f = new Path(ROOT_DIR, this.getName());
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).withChecksumType(CKTYPE).withBytesPerCheckSum(512).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withFilePath(f).withBloomType(BloomType.ROW).withMaxKeyCount(2000L).withFileContext(meta).build();
        this.bloomWriteRead(writer, (FileSystem)fs);
    }

    @Test
    public void testDeleteFamilyBloomFilter() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        this.conf.setFloat("io.storefile.bloom.error.rate", 0.01f);
        this.conf.setBoolean("io.storefile.bloom.enabled", true);
        float err = this.conf.getFloat("io.storefile.bloom.error.rate", 0.0f);
        Path f = new Path(ROOT_DIR, this.getName());
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).withChecksumType(CKTYPE).withBytesPerCheckSum(512).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withFilePath(f).withMaxKeyCount(2000L).withFileContext(meta).build();
        long now = System.currentTimeMillis();
        for (int i = 0; i < 2000; i += 2) {
            String row = String.format(localFormatter, i);
            KeyValue kv = new KeyValue(Bytes.toBytes((String)row), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"col"), now, KeyValue.Type.DeleteFamily, Bytes.toBytes((String)"value"));
            writer.append((Cell)kv);
        }
        writer.close();
        StoreFileReader reader = new StoreFileReader((FileSystem)fs, f, this.cacheConf, true, new AtomicInteger(0), true, this.conf);
        reader.loadFileInfo();
        reader.loadBloomfilter();
        int falsePos = 0;
        int falseNeg = 0;
        for (int i = 0; i < 2000; ++i) {
            String row = String.format(localFormatter, i);
            byte[] rowKey = Bytes.toBytes((String)row);
            boolean exists = reader.passesDeleteFamilyBloomFilter(rowKey, 0, rowKey.length);
            if (i % 2 == 0) {
                if (exists) continue;
                ++falseNeg;
                continue;
            }
            if (!exists) continue;
            ++falsePos;
        }
        TestHStoreFile.assertEquals((long)1000L, (long)reader.getDeleteFamilyCnt());
        reader.close(true);
        fs.delete(f, true);
        TestHStoreFile.assertEquals((String)("False negatives: " + falseNeg), (int)0, (int)falseNeg);
        int maxFalsePos = (int)(4000.0f * err);
        TestHStoreFile.assertTrue((String)("Too many false positives: " + falsePos + " (err=" + err + ", expected no more than " + maxFalsePos), (falsePos <= maxFalsePos ? 1 : 0) != 0);
    }

    @Test
    public void testReseek() throws Exception {
        Path f = new Path(ROOT_DIR, this.getName());
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withFilePath(f).withFileContext(meta).build();
        this.writeStoreFile(writer);
        writer.close();
        StoreFileReader reader = new StoreFileReader(this.fs, f, this.cacheConf, true, new AtomicInteger(0), true, this.conf);
        KeyValue k = KeyValueUtil.createFirstOnRow((byte[])HConstants.EMPTY_BYTE_ARRAY);
        StoreFileScanner s = TestHStoreFile.getStoreFileScanner(reader, false, false);
        s.reseek((Cell)k);
        TestHStoreFile.assertNotNull((String)"Intial reseek should position at the beginning of the file", (Object)s.peek());
    }

    @Test
    public void testBloomTypes() throws Exception {
        float err = 0.01f;
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.conf);
        this.conf.setFloat("io.storefile.bloom.error.rate", err);
        this.conf.setBoolean("io.storefile.bloom.enabled", true);
        int rowCount = 50;
        int colCount = 10;
        int versions = 2;
        BloomType[] bt = new BloomType[]{BloomType.ROWCOL, BloomType.ROW};
        int[] expKeys = new int[]{rowCount * colCount, rowCount};
        float[] expErr = new float[]{(float)(2 * rowCount * colCount) * err, (float)(2 * rowCount * 2 * colCount) * err};
        for (int x : new int[]{0, 1}) {
            Path f = new Path(ROOT_DIR, this.getName() + x);
            HFileContext meta = new HFileContextBuilder().withBlockSize(8192).withChecksumType(CKTYPE).withBytesPerCheckSum(512).build();
            StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withFilePath(f).withBloomType(bt[x]).withMaxKeyCount((long)expKeys[x]).withFileContext(meta).build();
            long now = System.currentTimeMillis();
            for (int i = 0; i < rowCount * 2; i += 2) {
                for (int j = 0; j < colCount * 2; j += 2) {
                    String row = String.format(localFormatter, i);
                    String col = String.format(localFormatter, j);
                    for (int k = 0; k < versions; ++k) {
                        KeyValue kv = new KeyValue(Bytes.toBytes((String)row), Bytes.toBytes((String)"family"), Bytes.toBytes((String)("col" + col)), now - (long)k, Bytes.toBytes((long)-1L));
                        writer.append((Cell)kv);
                    }
                }
            }
            writer.close();
            StoreFileReader reader = new StoreFileReader((FileSystem)fs, f, this.cacheConf, true, new AtomicInteger(0), true, this.conf);
            reader.loadFileInfo();
            reader.loadBloomfilter();
            StoreFileScanner scanner = TestHStoreFile.getStoreFileScanner(reader, false, false);
            TestHStoreFile.assertEquals((long)expKeys[x], (long)reader.generalBloomFilter.getKeyCount());
            HStore store = (HStore)Mockito.mock(HStore.class);
            Mockito.when((Object)store.getColumnFamilyDescriptor()).thenReturn((Object)ColumnFamilyDescriptorBuilder.of((String)"family"));
            int falsePos = 0;
            int falseNeg = 0;
            for (int i = 0; i < rowCount * 2; ++i) {
                for (int j = 0; j < colCount * 2; ++j) {
                    String row = String.format(localFormatter, i);
                    String col = String.format(localFormatter, j);
                    TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
                    columns.add(Bytes.toBytes((String)("col" + col)));
                    Scan scan = new Scan(Bytes.toBytes((String)row), Bytes.toBytes((String)row));
                    scan.addColumn(Bytes.toBytes((String)"family"), Bytes.toBytes((String)("col" + col)));
                    boolean exists = scanner.shouldUseScanner(scan, store, Long.MIN_VALUE);
                    boolean shouldRowExist = i % 2 == 0;
                    boolean shouldColExist = j % 2 == 0;
                    boolean bl = shouldColExist = shouldColExist || bt[x] == BloomType.ROW;
                    if (shouldRowExist && shouldColExist) {
                        if (exists) continue;
                        ++falseNeg;
                        continue;
                    }
                    if (!exists) continue;
                    ++falsePos;
                }
            }
            reader.close(true);
            fs.delete(f, true);
            System.out.println(bt[x].toString());
            System.out.println("  False negatives: " + falseNeg);
            System.out.println("  False positives: " + falsePos);
            TestHStoreFile.assertEquals((int)0, (int)falseNeg);
            TestHStoreFile.assertTrue(((float)falsePos < 2.0f * expErr[x] ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSeqIdComparator() {
        this.assertOrdering(StoreFileComparators.SEQ_ID, this.mockStoreFile(true, 100L, 1000L, -1L, "/foo/123"), this.mockStoreFile(true, 100L, 1000L, -1L, "/foo/124"), this.mockStoreFile(true, 99L, 1000L, -1L, "/foo/126"), this.mockStoreFile(true, 98L, 2000L, -1L, "/foo/126"), this.mockStoreFile(false, 3453L, -1L, 1L, "/foo/1"), this.mockStoreFile(false, 2L, -1L, 3L, "/foo/2"), this.mockStoreFile(false, 1000L, -1L, 5L, "/foo/2"), this.mockStoreFile(false, 76L, -1L, 5L, "/foo/3"));
    }

    private void assertOrdering(Comparator<? super HStoreFile> comparator, HStoreFile ... sfs) {
        ArrayList sorted = Lists.newArrayList((Object[])sfs);
        Collections.shuffle(sorted);
        Collections.sort(sorted, comparator);
        LOG.debug("sfs: " + Joiner.on((String)",").join((Object[])sfs));
        LOG.debug("sorted: " + Joiner.on((String)",").join((Iterable)sorted));
        TestHStoreFile.assertTrue((boolean)Iterables.elementsEqual(Arrays.asList(sfs), (Iterable)sorted));
    }

    private HStoreFile mockStoreFile(boolean bulkLoad, long size, long bulkTimestamp, long seqId, String path) {
        HStoreFile mock = (HStoreFile)Mockito.mock(HStoreFile.class);
        StoreFileReader reader = (StoreFileReader)Mockito.mock(StoreFileReader.class);
        ((StoreFileReader)Mockito.doReturn((Object)size).when((Object)reader)).length();
        ((HStoreFile)Mockito.doReturn((Object)reader).when((Object)mock)).getReader();
        ((HStoreFile)Mockito.doReturn((Object)bulkLoad).when((Object)mock)).isBulkLoadResult();
        ((HStoreFile)Mockito.doReturn((Object)OptionalLong.of(bulkTimestamp)).when((Object)mock)).getBulkLoadTimestamp();
        ((HStoreFile)Mockito.doReturn((Object)seqId).when((Object)mock)).getMaxSequenceId();
        ((HStoreFile)Mockito.doReturn((Object)new Path(path)).when((Object)mock)).getPath();
        String name = "mock storefile, bulkLoad=" + bulkLoad + " bulkTimestamp=" + bulkTimestamp + " seqId=" + seqId + " path=" + path;
        ((HStoreFile)Mockito.doReturn((Object)name).when((Object)mock)).toString();
        return mock;
    }

    List<KeyValue> getKeyValueSet(long[] timestamps, int numRows, byte[] qualifier, byte[] family) {
        ArrayList<KeyValue> kvList = new ArrayList<KeyValue>();
        for (int i = 1; i <= numRows; ++i) {
            byte[] b = Bytes.toBytes((int)i);
            LOG.info(Bytes.toString((byte[])b));
            LOG.info(Bytes.toString((byte[])b));
            for (long timestamp : timestamps) {
                kvList.add(new KeyValue(b, family, qualifier, timestamp, b));
            }
        }
        return kvList;
    }

    @Test
    public void testMultipleTimestamps() throws IOException {
        byte[] family = Bytes.toBytes((String)"familyname");
        byte[] qualifier = Bytes.toBytes((String)"qualifier");
        int numRows = 10;
        long[] timestamps = new long[]{20L, 10L, 5L, 1L};
        Scan scan = new Scan();
        Path storedir = new Path(new Path(testDir, "7e0102"), Bytes.toString((byte[])family));
        Path dir = new Path(storedir, "1234567890");
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withOutputDir(dir).withFileContext(meta).build();
        List<KeyValue> kvList = this.getKeyValueSet(timestamps, numRows, qualifier, family);
        for (KeyValue kv : kvList) {
            writer.append((Cell)kv);
        }
        writer.appendMetadata(0L, false);
        writer.close();
        HStoreFile hsf = new HStoreFile(this.fs, writer.getPath(), this.conf, this.cacheConf, BloomType.NONE, true);
        HStore store = (HStore)Mockito.mock(HStore.class);
        Mockito.when((Object)store.getColumnFamilyDescriptor()).thenReturn((Object)ColumnFamilyDescriptorBuilder.of((byte[])family));
        hsf.initReader();
        StoreFileReader reader = hsf.getReader();
        StoreFileScanner scanner = TestHStoreFile.getStoreFileScanner(reader, false, false);
        TreeSet<byte[]> columns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        columns.add(qualifier);
        scan.setTimeRange(20L, 100L);
        TestHStoreFile.assertTrue((boolean)scanner.shouldUseScanner(scan, store, Long.MIN_VALUE));
        scan.setTimeRange(1L, 2L);
        TestHStoreFile.assertTrue((boolean)scanner.shouldUseScanner(scan, store, Long.MIN_VALUE));
        scan.setTimeRange(8L, 10L);
        TestHStoreFile.assertTrue((boolean)scanner.shouldUseScanner(scan, store, Long.MIN_VALUE));
        scan.setColumnFamilyTimeRange(family, 7L, 50L);
        TestHStoreFile.assertTrue((boolean)scanner.shouldUseScanner(scan, store, Long.MIN_VALUE));
        scan = new Scan();
        scan.setTimeRange(27L, 50L);
        TestHStoreFile.assertTrue((!scanner.shouldUseScanner(scan, store, Long.MIN_VALUE) ? 1 : 0) != 0);
        scan = new Scan();
        scan.setTimeRange(27L, 50L);
        scan.setColumnFamilyTimeRange(family, 7L, 50L);
        TestHStoreFile.assertTrue((boolean)scanner.shouldUseScanner(scan, store, Long.MIN_VALUE));
    }

    @Test
    public void testCacheOnWriteEvictOnClose() throws Exception {
        Configuration conf = this.conf;
        Path baseDir = new Path(new Path(testDir, "7e0102"), "twoCOWEOC");
        CacheConfig.instantiateBlockCache((Configuration)conf);
        BlockCache bc = new CacheConfig(conf).getBlockCache();
        TestHStoreFile.assertNotNull((Object)bc);
        CacheStats cs = bc.getStats();
        long startHit = cs.getHitCount();
        long startMiss = cs.getMissCount();
        long startEvicted = cs.getEvictedCount();
        conf.setBoolean("hbase.rs.cacheblocksonwrite", false);
        CacheConfig cacheConf = new CacheConfig(conf);
        Path pathCowOff = new Path(baseDir, "123456789");
        StoreFileWriter writer = this.writeStoreFile(conf, cacheConf, pathCowOff, 3);
        HStoreFile hsf = new HStoreFile(this.fs, writer.getPath(), conf, cacheConf, BloomType.NONE, true);
        LOG.debug(hsf.getPath().toString());
        hsf.initReader();
        StoreFileReader reader = hsf.getReader();
        reader.loadFileInfo();
        StoreFileScanner scanner = TestHStoreFile.getStoreFileScanner(reader, true, true);
        scanner.seek((Cell)KeyValue.LOWESTKEY);
        while (scanner.next() != null) {
        }
        TestHStoreFile.assertEquals((long)startHit, (long)cs.getHitCount());
        TestHStoreFile.assertEquals((long)(startMiss + 3L), (long)cs.getMissCount());
        TestHStoreFile.assertEquals((long)startEvicted, (long)cs.getEvictedCount());
        startMiss += 3L;
        scanner.close();
        reader.close(cacheConf.shouldEvictOnClose());
        conf.setBoolean("hbase.rs.cacheblocksonwrite", true);
        cacheConf = new CacheConfig(conf);
        Path pathCowOn = new Path(baseDir, "123456788");
        writer = this.writeStoreFile(conf, cacheConf, pathCowOn, 3);
        hsf = new HStoreFile(this.fs, writer.getPath(), conf, cacheConf, BloomType.NONE, true);
        hsf.initReader();
        reader = hsf.getReader();
        scanner = TestHStoreFile.getStoreFileScanner(reader, true, true);
        scanner.seek((Cell)KeyValue.LOWESTKEY);
        while (scanner.next() != null) {
        }
        TestHStoreFile.assertEquals((long)(startHit + 3L), (long)cs.getHitCount());
        TestHStoreFile.assertEquals((long)startMiss, (long)cs.getMissCount());
        TestHStoreFile.assertEquals((long)startEvicted, (long)cs.getEvictedCount());
        startHit += 3L;
        scanner.close();
        reader.close(cacheConf.shouldEvictOnClose());
        hsf = new HStoreFile(this.fs, pathCowOff, conf, cacheConf, BloomType.NONE, true);
        hsf.initReader();
        StoreFileReader readerOne = hsf.getReader();
        readerOne.loadFileInfo();
        StoreFileScanner scannerOne = TestHStoreFile.getStoreFileScanner(readerOne, true, true);
        scannerOne.seek((Cell)KeyValue.LOWESTKEY);
        hsf = new HStoreFile(this.fs, pathCowOn, conf, cacheConf, BloomType.NONE, true);
        hsf.initReader();
        StoreFileReader readerTwo = hsf.getReader();
        readerTwo.loadFileInfo();
        StoreFileScanner scannerTwo = TestHStoreFile.getStoreFileScanner(readerTwo, true, true);
        scannerTwo.seek((Cell)KeyValue.LOWESTKEY);
        Cell kv1 = null;
        Cell kv2 = null;
        while ((kv1 = scannerOne.next()) != null) {
            kv2 = scannerTwo.next();
            TestHStoreFile.assertTrue((boolean)kv1.equals(kv2));
            KeyValue keyv1 = KeyValueUtil.ensureKeyValue((Cell)kv1);
            KeyValue keyv2 = KeyValueUtil.ensureKeyValue((Cell)kv2);
            TestHStoreFile.assertTrue((Bytes.compareTo((byte[])keyv1.getBuffer(), (int)keyv1.getKeyOffset(), (int)keyv1.getKeyLength(), (byte[])keyv2.getBuffer(), (int)keyv2.getKeyOffset(), (int)keyv2.getKeyLength()) == 0 ? 1 : 0) != 0);
            TestHStoreFile.assertTrue((Bytes.compareTo((byte[])kv1.getValueArray(), (int)kv1.getValueOffset(), (int)kv1.getValueLength(), (byte[])kv2.getValueArray(), (int)kv2.getValueOffset(), (int)kv2.getValueLength()) == 0 ? 1 : 0) != 0);
        }
        TestHStoreFile.assertNull((Object)scannerTwo.next());
        TestHStoreFile.assertEquals((long)(startHit + 6L), (long)cs.getHitCount());
        TestHStoreFile.assertEquals((long)startMiss, (long)cs.getMissCount());
        TestHStoreFile.assertEquals((long)startEvicted, (long)cs.getEvictedCount());
        startHit += 6L;
        scannerOne.close();
        readerOne.close(cacheConf.shouldEvictOnClose());
        scannerTwo.close();
        readerTwo.close(cacheConf.shouldEvictOnClose());
        conf.setBoolean("hbase.rs.evictblocksonclose", true);
        cacheConf = new CacheConfig(conf);
        hsf = new HStoreFile(this.fs, pathCowOff, conf, cacheConf, BloomType.NONE, true);
        hsf.initReader();
        reader = hsf.getReader();
        reader.close(cacheConf.shouldEvictOnClose());
        TestHStoreFile.assertEquals((long)startHit, (long)cs.getHitCount());
        TestHStoreFile.assertEquals((long)startMiss, (long)cs.getMissCount());
        TestHStoreFile.assertEquals((long)startEvicted, (long)cs.getEvictedCount());
        conf.setBoolean("hbase.rs.evictblocksonclose", false);
        cacheConf = new CacheConfig(conf);
        hsf = new HStoreFile(this.fs, pathCowOn, conf, cacheConf, BloomType.NONE, true);
        hsf.initReader();
        reader = hsf.getReader();
        reader.close(cacheConf.shouldEvictOnClose());
        TestHStoreFile.assertEquals((long)startHit, (long)cs.getHitCount());
        TestHStoreFile.assertEquals((long)startMiss, (long)cs.getMissCount());
        TestHStoreFile.assertEquals((long)startEvicted, (long)cs.getEvictedCount());
    }

    private Path splitStoreFile(HRegionFileSystem regionFs, HRegionInfo hri, String family, HStoreFile sf, byte[] splitKey, boolean isTopRef) throws IOException {
        FileSystem fs = regionFs.getFileSystem();
        Path path = regionFs.splitStoreFile((RegionInfo)hri, family, sf, splitKey, isTopRef, null);
        if (null == path) {
            return null;
        }
        Path regionDir = regionFs.commitDaughterRegion((RegionInfo)hri);
        return new Path(new Path(regionDir, family), path.getName());
    }

    private StoreFileWriter writeStoreFile(Configuration conf, CacheConfig cacheConf, Path path, int numBlocks) throws IOException {
        int numKVs = 5 * numBlocks;
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>(numKVs);
        byte[] b = Bytes.toBytes((String)"x");
        int totalSize = 0;
        for (int i = numKVs; i > 0; --i) {
            KeyValue kv = new KeyValue(b, b, b, (long)i, b);
            kvs.add(kv);
            totalSize += kv.getLength() + 1;
        }
        int blockSize = totalSize / numBlocks;
        HFileContext meta = new HFileContextBuilder().withBlockSize(blockSize).withChecksumType(CKTYPE).withBytesPerCheckSum(512).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(conf, cacheConf, this.fs).withFilePath(path).withMaxKeyCount(2000L).withFileContext(meta).build();
        kvs.remove(kvs.size() - 1);
        for (KeyValue kv : kvs) {
            writer.append((Cell)kv);
        }
        writer.appendMetadata(0L, false);
        writer.close();
        return writer;
    }

    @Test
    public void testDataBlockEncodingMetaData() throws IOException {
        Path dir = new Path(new Path(testDir, "7e0102"), "familyname");
        Path path = new Path(dir, "1234567890");
        DataBlockEncoding dataBlockEncoderAlgo = DataBlockEncoding.FAST_DIFF;
        HFileDataBlockEncoderImpl dataBlockEncoder = new HFileDataBlockEncoderImpl(dataBlockEncoderAlgo);
        this.cacheConf = new CacheConfig(this.conf);
        HFileContext meta = new HFileContextBuilder().withBlockSize(8192).withChecksumType(CKTYPE).withBytesPerCheckSum(512).withDataBlockEncoding(dataBlockEncoderAlgo).build();
        StoreFileWriter writer = new StoreFileWriter.Builder(this.conf, this.cacheConf, this.fs).withFilePath(path).withMaxKeyCount(2000L).withFileContext(meta).build();
        writer.close();
        HStoreFile storeFile = new HStoreFile(this.fs, writer.getPath(), this.conf, this.cacheConf, BloomType.NONE, true);
        storeFile.initReader();
        StoreFileReader reader = storeFile.getReader();
        Map fileInfo = reader.loadFileInfo();
        byte[] value = (byte[])fileInfo.get(HFileDataBlockEncoder.DATA_BLOCK_ENCODING);
        TestHStoreFile.assertEquals(dataBlockEncoderAlgo.getNameInBytes(), value);
    }
}

