/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKeyImpl;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MediumTests.class})
public class TestRecoveredEdits {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRecoveredEdits.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Logger LOG = LoggerFactory.getLogger(TestRecoveredEdits.class);
    @Rule
    public TestName testName = new TestName();

    @Test
    public void testReplayWorksThoughLotsOfFlushing() throws IOException {
        CacheConfig.instantiateBlockCache((Configuration)TEST_UTIL.getConfiguration());
        for (MemoryCompactionPolicy policy : MemoryCompactionPolicy.values()) {
            this.testReplayWorksWithMemoryCompactionPolicy(policy);
        }
    }

    private void testReplayWorksWithMemoryCompactionPolicy(MemoryCompactionPolicy policy) throws IOException {
        Configuration conf = new Configuration(TEST_UTIL.getConfiguration());
        conf.setInt("hbase.hregion.memstore.flush.size", 0x100000);
        conf.set("hbase.hregion.compacting.memstore.type", String.valueOf(policy));
        String encodedRegionName = "4823016d8fca70b25503ee07f4c6d79f";
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)this.testName.getMethodName()));
        String columnFamily = "meta";
        byte[][] columnFamilyAsByteArray = new byte[][]{Bytes.toBytes((String)"meta")};
        htd.addFamily(new HColumnDescriptor("meta"));
        HRegionInfo hri = new HRegionInfo(htd.getTableName()){
            private byte[] encodedRegionNameAsBytes;
            {
                this.encodedRegionNameAsBytes = null;
            }

            public synchronized String getEncodedName() {
                return "4823016d8fca70b25503ee07f4c6d79f";
            }

            public synchronized byte[] getEncodedNameAsBytes() {
                if (this.encodedRegionNameAsBytes == null) {
                    this.encodedRegionNameAsBytes = Bytes.toBytes((String)this.getEncodedName());
                }
                return this.encodedRegionNameAsBytes;
            }
        };
        Path hbaseRootDir = TEST_UTIL.getDataTestDir();
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null);
        FileSystem fs = FileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        Path tableDir = FSUtils.getTableDir((Path)hbaseRootDir, (TableName)htd.getTableName());
        HRegionFileSystem hrfs = new HRegionFileSystem(TEST_UTIL.getConfiguration(), fs, tableDir, (RegionInfo)hri);
        if (fs.exists(hrfs.getRegionDir())) {
            LOG.info("Region directory already exists. Deleting.");
            fs.delete(hrfs.getRegionDir(), true);
        }
        HRegion region = HRegion.createHRegion((RegionInfo)hri, (Path)hbaseRootDir, (Configuration)conf, (TableDescriptor)htd, null);
        Assert.assertEquals((Object)"4823016d8fca70b25503ee07f4c6d79f", (Object)region.getRegionInfo().getEncodedName());
        List storeFiles = region.getStoreFileList((byte[][])columnFamilyAsByteArray);
        Assert.assertTrue((boolean)storeFiles.isEmpty());
        region.close();
        Path regionDir = FSUtils.getRegionDirFromRootDir((Path)hbaseRootDir, (RegionInfo)hri);
        Path recoveredEditsDir = WALSplitter.getRegionDirRecoveredEditsDir((Path)regionDir);
        Path recoveredEditsFile = new Path(System.getProperty("test.build.classes", "target/test-classes"), "0000000000000016310");
        Path destination = new Path(recoveredEditsDir, recoveredEditsFile.getName());
        fs.copyToLocalFile(recoveredEditsFile, destination);
        Assert.assertTrue((boolean)fs.exists(destination));
        region = HRegion.openHRegion((HRegion)region, null);
        Assert.assertEquals((Object)"4823016d8fca70b25503ee07f4c6d79f", (Object)region.getRegionInfo().getEncodedName());
        storeFiles = region.getStoreFileList((byte[][])columnFamilyAsByteArray);
        if (policy == MemoryCompactionPolicy.EAGER || policy == MemoryCompactionPolicy.ADAPTIVE) {
            Assert.assertTrue((String)("Files count=" + storeFiles.size()), (storeFiles.size() >= 1 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)("Files count=" + storeFiles.size()), (storeFiles.size() > 10 ? 1 : 0) != 0);
        }
        int count = this.verifyAllEditsMadeItIn(fs, conf, recoveredEditsFile, region);
        LOG.info("Checked " + count + " edits made it in");
    }

    private int verifyAllEditsMadeItIn(FileSystem fs, Configuration conf, Path edits, HRegion region) throws IOException {
        Object entry;
        int count = 0;
        ArrayList<Cell> walCells = new ArrayList<Cell>();
        try (WAL.Reader reader = WALFactory.createReader((FileSystem)fs, (Path)edits, (Configuration)conf);){
            while ((entry = reader.next()) != null) {
                WALKeyImpl key = entry.getKey();
                WALEdit val = entry.getEdit();
                ++count;
                if (!Bytes.equals((byte[])key.getEncodedRegionName(), (byte[])region.getRegionInfo().getEncodedNameAsBytes())) continue;
                Cell previous = null;
                for (Cell cell : val.getCells()) {
                    if (CellUtil.matchingFamily((Cell)cell, (byte[])WALEdit.METAFAMILY) || previous != null && CellComparatorImpl.COMPARATOR.compareRows(previous, cell) == 0) continue;
                    previous = cell;
                    walCells.add(cell);
                }
            }
        }
        ArrayList regionCells = new ArrayList();
        HRegion.RegionScannerImpl scanner = region.getScanner(new Scan());
        entry = null;
        try {
            ArrayList tmpCells;
            do {
                tmpCells = new ArrayList();
                scanner.nextRaw(tmpCells);
                regionCells.addAll(tmpCells);
            } while (!tmpCells.isEmpty());
        }
        catch (Throwable tmpCells) {
            entry = tmpCells;
            throw tmpCells;
        }
        finally {
            if (scanner != null) {
                if (entry != null) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable tmpCells) {
                        ((Throwable)entry).addSuppressed(tmpCells);
                    }
                } else {
                    scanner.close();
                }
            }
        }
        Collections.sort(walCells, CellComparatorImpl.COMPARATOR);
        int found = 0;
        int i = 0;
        int j = 0;
        while (i < walCells.size() && j < regionCells.size()) {
            int compareResult = PrivateCellUtil.compareKeyIgnoresMvcc((CellComparator)CellComparatorImpl.COMPARATOR, (Cell)((Cell)walCells.get(i)), (Cell)((Cell)regionCells.get(j)));
            if (compareResult == 0) {
                ++i;
                ++j;
                ++found;
                continue;
            }
            if (compareResult > 0) {
                ++j;
                continue;
            }
            ++i;
        }
        Assert.assertEquals((String)("Only found " + found + " cells in region, but there are " + walCells.size() + " cells in recover edits"), (long)found, (long)walCells.size());
        return count;
    }
}

