/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestTags {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTags.class);
    static boolean useFilter = false;
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    @Rule
    public final TestName TEST_NAME = new TestName();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setInt("hfile.format.version", 3);
        conf.setStrings("hbase.coprocessor.user.region.classes", new String[]{TestCoprocessorForTags.class.getName()});
        TEST_UTIL.startMiniCluster(1, 2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @After
    public void tearDown() {
        useFilter = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTags() throws Exception {
        try (Table table = null;){
            TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
            byte[] fam = Bytes.toBytes((String)"info");
            byte[] row = Bytes.toBytes((String)"rowa");
            byte[] qual = Bytes.toBytes((String)"qual");
            byte[] row1 = Bytes.toBytes((String)"rowb");
            byte[] row2 = Bytes.toBytes((String)"rowc");
            HTableDescriptor desc = new HTableDescriptor(tableName);
            HColumnDescriptor colDesc = new HColumnDescriptor(fam);
            colDesc.setBlockCacheEnabled(true);
            colDesc.setDataBlockEncoding(DataBlockEncoding.NONE);
            desc.addFamily(colDesc);
            Admin admin = TEST_UTIL.getAdmin();
            admin.createTable((TableDescriptor)desc);
            byte[] value = Bytes.toBytes((String)"value");
            table = TEST_UTIL.getConnection().getTable(tableName);
            Put put = new Put(row);
            put.addColumn(fam, qual, Long.MAX_VALUE, value);
            put.setAttribute("visibility", Bytes.toBytes((String)"myTag"));
            table.put(put);
            admin.flush(tableName);
            Thread.sleep(1000L);
            Put put1 = new Put(row1);
            byte[] value1 = Bytes.toBytes((String)"1000dfsdf");
            put1.addColumn(fam, qual, Long.MAX_VALUE, value1);
            table.put(put1);
            admin.flush(tableName);
            Thread.sleep(1000L);
            Put put2 = new Put(row2);
            byte[] value2 = Bytes.toBytes((String)"1000dfsdf");
            put2.addColumn(fam, qual, Long.MAX_VALUE, value2);
            put2.setAttribute("visibility", Bytes.toBytes((String)"myTag3"));
            table.put(put2);
            admin.flush(tableName);
            Thread.sleep(1000L);
            this.result(fam, row, qual, row2, table, value, value2, row1, value1);
            admin.compact(tableName);
            while (admin.getCompactionState(tableName) != CompactionState.NONE) {
                Thread.sleep(10L);
            }
            this.result(fam, row, qual, row2, table, value, value2, row1, value1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushAndCompactionWithoutTags() throws Exception {
        try (Table table = null;){
            Cell current;
            CellScanner cellScanner;
            Result[] next;
            TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
            byte[] fam = Bytes.toBytes((String)"info");
            byte[] row = Bytes.toBytes((String)"rowa");
            byte[] qual = Bytes.toBytes((String)"qual");
            byte[] row1 = Bytes.toBytes((String)"rowb");
            byte[] row2 = Bytes.toBytes((String)"rowc");
            HTableDescriptor desc = new HTableDescriptor(tableName);
            HColumnDescriptor colDesc = new HColumnDescriptor(fam);
            colDesc.setBlockCacheEnabled(true);
            desc.addFamily(colDesc);
            Admin admin = TEST_UTIL.getAdmin();
            admin.createTable((TableDescriptor)desc);
            table = TEST_UTIL.getConnection().getTable(tableName);
            Put put = new Put(row);
            byte[] value = Bytes.toBytes((String)"value");
            put.addColumn(fam, qual, Long.MAX_VALUE, value);
            table.put(put);
            admin.flush(tableName);
            Thread.sleep(1000L);
            Put put1 = new Put(row1);
            byte[] value1 = Bytes.toBytes((String)"1000dfsdf");
            put1.addColumn(fam, qual, Long.MAX_VALUE, value1);
            table.put(put1);
            admin.flush(tableName);
            Thread.sleep(1000L);
            Put put2 = new Put(row2);
            byte[] value2 = Bytes.toBytes((String)"1000dfsdf");
            put2.addColumn(fam, qual, Long.MAX_VALUE, value2);
            table.put(put2);
            admin.flush(tableName);
            Thread.sleep(1000L);
            Scan s = new Scan(row);
            try (ResultScanner scanner = table.getScanner(s);){
                for (Result result : next = scanner.next(3)) {
                    cellScanner = result.cellScanner();
                    cellScanner.advance();
                    current = cellScanner.current();
                    Assert.assertEquals((long)0L, (long)current.getTagsLength());
                }
            }
            admin.compact(tableName);
            while (admin.getCompactionState(tableName) != CompactionState.NONE) {
                Thread.sleep(10L);
            }
            s = new Scan(row);
            scanner = table.getScanner(s);
            try {
                for (Result result : next = scanner.next(3)) {
                    cellScanner = result.cellScanner();
                    cellScanner.advance();
                    current = cellScanner.current();
                    Assert.assertEquals((long)0L, (long)current.getTagsLength());
                }
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFlushAndCompactionwithCombinations() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        byte[] fam = Bytes.toBytes((String)"info");
        byte[] row = Bytes.toBytes((String)"rowa");
        byte[] qual = Bytes.toBytes((String)"qual");
        byte[] row1 = Bytes.toBytes((String)"rowb");
        byte[] row2 = Bytes.toBytes((String)"rowc");
        byte[] rowd = Bytes.toBytes((String)"rowd");
        byte[] rowe = Bytes.toBytes((String)"rowe");
        Table table = null;
        for (DataBlockEncoding encoding : DataBlockEncoding.values()) {
            HTableDescriptor desc = new HTableDescriptor(tableName);
            HColumnDescriptor colDesc = new HColumnDescriptor(fam);
            colDesc.setBlockCacheEnabled(true);
            colDesc.setDataBlockEncoding(encoding);
            desc.addFamily(colDesc);
            Admin admin = TEST_UTIL.getAdmin();
            admin.createTable((TableDescriptor)desc);
            try {
                Tag tag;
                Cell current;
                CellScanner cellScanner;
                Result next;
                table = TEST_UTIL.getConnection().getTable(tableName);
                Put put = new Put(row);
                byte[] value = Bytes.toBytes((String)"value");
                put.addColumn(fam, qual, Long.MAX_VALUE, value);
                int bigTagLen = 32762;
                put.setAttribute("visibility", new byte[bigTagLen]);
                table.put(put);
                Put put1 = new Put(row1);
                byte[] value1 = Bytes.toBytes((String)"1000dfsdf");
                put1.addColumn(fam, qual, Long.MAX_VALUE, value1);
                table.put(put1);
                admin.flush(tableName);
                Thread.sleep(1000L);
                put1 = new Put(row2);
                value1 = Bytes.toBytes((String)"1000dfsdf");
                put1.addColumn(fam, qual, Long.MAX_VALUE, value1);
                table.put(put1);
                admin.flush(tableName);
                Thread.sleep(1000L);
                Put put2 = new Put(rowd);
                byte[] value2 = Bytes.toBytes((String)"1000dfsdf");
                put2.addColumn(fam, qual, Long.MAX_VALUE, value2);
                table.put(put2);
                put2 = new Put(rowe);
                value2 = Bytes.toBytes((String)"1000dfsddfdf");
                put2.addColumn(fam, qual, Long.MAX_VALUE, value2);
                put.setAttribute("visibility", Bytes.toBytes((String)"ram"));
                table.put(put2);
                admin.flush(tableName);
                Thread.sleep(1000L);
                TestCoprocessorForTags.checkTagPresence = true;
                Scan s = new Scan(row);
                s.setCaching(1);
                ResultScanner scanner = table.getScanner(s);
                try {
                    next = null;
                    while ((next = scanner.next()) != null) {
                        cellScanner = next.cellScanner();
                        cellScanner.advance();
                        current = cellScanner.current();
                        if (CellUtil.matchingRows((Cell)current, (byte[])row)) {
                            Assert.assertEquals((long)1L, (long)TestCoprocessorForTags.tags.size());
                            tag = TestCoprocessorForTags.tags.get(0);
                            Assert.assertEquals((long)bigTagLen, (long)tag.getValueLength());
                            continue;
                        }
                        Assert.assertEquals((long)0L, (long)TestCoprocessorForTags.tags.size());
                    }
                }
                finally {
                    if (scanner != null) {
                        scanner.close();
                    }
                    TestCoprocessorForTags.checkTagPresence = false;
                }
                while (admin.getCompactionState(tableName) != CompactionState.NONE) {
                    Thread.sleep(10L);
                }
                TestCoprocessorForTags.checkTagPresence = true;
                scanner = table.getScanner(s);
                try {
                    next = null;
                    while ((next = scanner.next()) != null) {
                        cellScanner = next.cellScanner();
                        cellScanner.advance();
                        current = cellScanner.current();
                        if (CellUtil.matchingRows((Cell)current, (byte[])row)) {
                            Assert.assertEquals((long)1L, (long)TestCoprocessorForTags.tags.size());
                            tag = TestCoprocessorForTags.tags.get(0);
                            Assert.assertEquals((long)bigTagLen, (long)tag.getValueLength());
                            continue;
                        }
                        Assert.assertEquals((long)0L, (long)TestCoprocessorForTags.tags.size());
                    }
                }
                finally {
                    if (scanner != null) {
                        scanner.close();
                    }
                    TestCoprocessorForTags.checkTagPresence = false;
                }
            }
            finally {
                if (table != null) {
                    table.close();
                }
                admin.disableTable(tableName);
                admin.deleteTable(tableName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTagsWithAppendAndIncrement() throws Exception {
        TableName tableName = TableName.valueOf((String)this.TEST_NAME.getMethodName());
        byte[] f = Bytes.toBytes((String)"f");
        byte[] q = Bytes.toBytes((String)"q");
        byte[] row1 = Bytes.toBytes((String)"r1");
        byte[] row2 = Bytes.toBytes((String)"r2");
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor colDesc = new HColumnDescriptor(f);
        desc.addFamily(colDesc);
        TEST_UTIL.getAdmin().createTable((TableDescriptor)desc);
        Table table = null;
        try {
            table = TEST_UTIL.getConnection().getTable(tableName);
            Put put = new Put(row1);
            byte[] v = Bytes.toBytes((long)2L);
            put.addColumn(f, q, v);
            put.setAttribute("visibility", Bytes.toBytes((String)"tag1"));
            table.put(put);
            Increment increment = new Increment(row1);
            increment.addColumn(f, q, 1L);
            table.increment(increment);
            TestCoprocessorForTags.checkTagPresence = true;
            ResultScanner scanner = table.getScanner(new Scan());
            Result result = scanner.next();
            KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)result.getColumnLatestCell(f, q));
            List<Tag> tags = TestCoprocessorForTags.tags;
            Assert.assertEquals((long)3L, (long)Bytes.toLong((byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength()));
            Assert.assertEquals((long)1L, (long)tags.size());
            Assert.assertEquals((Object)"tag1", (Object)Bytes.toString((byte[])Tag.cloneValue((Tag)tags.get(0))));
            TestCoprocessorForTags.checkTagPresence = false;
            TestCoprocessorForTags.tags = null;
            increment = new Increment(row1);
            increment.add((Cell)new KeyValue(row1, f, q, 1234L, v));
            increment.setAttribute("visibility", Bytes.toBytes((String)"tag2"));
            table.increment(increment);
            TestCoprocessorForTags.checkTagPresence = true;
            scanner = table.getScanner(new Scan());
            result = scanner.next();
            kv = KeyValueUtil.ensureKeyValue((Cell)result.getColumnLatestCell(f, q));
            tags = TestCoprocessorForTags.tags;
            Assert.assertEquals((long)5L, (long)Bytes.toLong((byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength()));
            Assert.assertEquals((long)2L, (long)tags.size());
            ArrayList<String> tagValues = new ArrayList<String>();
            for (Tag tag : tags) {
                tagValues.add(Bytes.toString((byte[])Tag.cloneValue((Tag)tag)));
            }
            Assert.assertTrue((boolean)tagValues.contains("tag1"));
            Assert.assertTrue((boolean)tagValues.contains("tag2"));
            TestCoprocessorForTags.checkTagPresence = false;
            TestCoprocessorForTags.tags = null;
            put = new Put(row2);
            v = Bytes.toBytes((long)2L);
            put.addColumn(f, q, v);
            table.put(put);
            increment = new Increment(row2);
            increment.add((Cell)new KeyValue(row2, f, q, 1234L, v));
            increment.setAttribute("visibility", Bytes.toBytes((String)"tag2"));
            table.increment(increment);
            TestCoprocessorForTags.checkTagPresence = true;
            scanner = table.getScanner(new Scan().setStartRow(row2));
            result = scanner.next();
            kv = KeyValueUtil.ensureKeyValue((Cell)result.getColumnLatestCell(f, q));
            tags = TestCoprocessorForTags.tags;
            Assert.assertEquals((long)4L, (long)Bytes.toLong((byte[])kv.getValueArray(), (int)kv.getValueOffset(), (int)kv.getValueLength()));
            Assert.assertEquals((long)1L, (long)tags.size());
            Assert.assertEquals((Object)"tag2", (Object)Bytes.toString((byte[])Tag.cloneValue((Tag)tags.get(0))));
            TestCoprocessorForTags.checkTagPresence = false;
            TestCoprocessorForTags.tags = null;
            byte[] row3 = Bytes.toBytes((String)"r3");
            put = new Put(row3);
            put.addColumn(f, q, Bytes.toBytes((String)"a"));
            put.setAttribute("visibility", Bytes.toBytes((String)"tag1"));
            table.put(put);
            Append append = new Append(row3);
            append.addColumn(f, q, Bytes.toBytes((String)"b"));
            table.append(append);
            TestCoprocessorForTags.checkTagPresence = true;
            scanner = table.getScanner(new Scan().setStartRow(row3));
            result = scanner.next();
            kv = KeyValueUtil.ensureKeyValue((Cell)result.getColumnLatestCell(f, q));
            tags = TestCoprocessorForTags.tags;
            Assert.assertEquals((long)1L, (long)tags.size());
            Assert.assertEquals((Object)"tag1", (Object)Bytes.toString((byte[])Tag.cloneValue((Tag)tags.get(0))));
            TestCoprocessorForTags.checkTagPresence = false;
            TestCoprocessorForTags.tags = null;
            append = new Append(row3);
            append.add((Cell)new KeyValue(row3, f, q, 1234L, v));
            append.setAttribute("visibility", Bytes.toBytes((String)"tag2"));
            table.append(append);
            TestCoprocessorForTags.checkTagPresence = true;
            scanner = table.getScanner(new Scan().setStartRow(row3));
            result = scanner.next();
            kv = KeyValueUtil.ensureKeyValue((Cell)result.getColumnLatestCell(f, q));
            tags = TestCoprocessorForTags.tags;
            Assert.assertEquals((long)2L, (long)tags.size());
            tagValues.clear();
            for (Tag tag : tags) {
                tagValues.add(Bytes.toString((byte[])Tag.cloneValue((Tag)tag)));
            }
            Assert.assertTrue((boolean)tagValues.contains("tag1"));
            Assert.assertTrue((boolean)tagValues.contains("tag2"));
            TestCoprocessorForTags.checkTagPresence = false;
            TestCoprocessorForTags.tags = null;
            byte[] row4 = Bytes.toBytes((String)"r4");
            put = new Put(row4);
            put.addColumn(f, q, Bytes.toBytes((String)"a"));
            table.put(put);
            append = new Append(row4);
            append.add((Cell)new KeyValue(row4, f, q, 1234L, v));
            append.setAttribute("visibility", Bytes.toBytes((String)"tag2"));
            table.append(append);
            TestCoprocessorForTags.checkTagPresence = true;
            scanner = table.getScanner(new Scan().setStartRow(row4));
            result = scanner.next();
            kv = KeyValueUtil.ensureKeyValue((Cell)result.getColumnLatestCell(f, q));
            tags = TestCoprocessorForTags.tags;
            Assert.assertEquals((long)1L, (long)tags.size());
            Assert.assertEquals((Object)"tag2", (Object)Bytes.toString((byte[])Tag.cloneValue((Tag)tags.get(0))));
        }
        finally {
            TestCoprocessorForTags.checkTagPresence = false;
            TestCoprocessorForTags.tags = null;
            if (table != null) {
                table.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void result(byte[] fam, byte[] row, byte[] qual, byte[] row2, Table table, byte[] value, byte[] value2, byte[] row1, byte[] value1) throws IOException {
        Scan s = new Scan(row);
        s.setAttribute("visibility", Bytes.toBytes((String)"myTag"));
        try (ResultScanner scanner = null;){
            scanner = table.getScanner(s);
            Result next = scanner.next();
            Assert.assertTrue((boolean)Bytes.equals((byte[])next.getRow(), (byte[])row));
            Assert.assertTrue((boolean)Bytes.equals((byte[])next.getValue(fam, qual), (byte[])value));
            Result next2 = scanner.next();
            Assert.assertTrue((next2 != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])next2.getRow(), (byte[])row1));
            Assert.assertTrue((boolean)Bytes.equals((byte[])next2.getValue(fam, qual), (byte[])value1));
            next2 = scanner.next();
            Assert.assertTrue((next2 != null ? 1 : 0) != 0);
            Assert.assertTrue((boolean)Bytes.equals((byte[])next2.getRow(), (byte[])row2));
            Assert.assertTrue((boolean)Bytes.equals((byte[])next2.getValue(fam, qual), (byte[])value2));
        }
    }

    public static class TestCoprocessorForTags
    implements RegionCoprocessor,
    RegionObserver {
        public static volatile boolean checkTagPresence = false;
        public static List<Tag> tags = null;

        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
            this.updateMutationAddingTags((Mutation)put);
        }

        private void updateMutationAddingTags(Mutation m) {
            byte[] attribute = m.getAttribute("visibility");
            byte[] cf = null;
            ArrayList<KeyValue> updatedCells = new ArrayList<KeyValue>();
            if (attribute != null) {
                for (List edits : m.getFamilyCellMap().values()) {
                    for (Cell cell : edits) {
                        KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                        if (cf == null) {
                            cf = CellUtil.cloneFamily((Cell)kv);
                        }
                        ArrayBackedTag tag = new ArrayBackedTag(1, attribute);
                        ArrayList<ArrayBackedTag> tagList = new ArrayList<ArrayBackedTag>();
                        tagList.add(tag);
                        KeyValue newKV = new KeyValue(CellUtil.cloneRow((Cell)kv), 0, (int)kv.getRowLength(), CellUtil.cloneFamily((Cell)kv), 0, (int)kv.getFamilyLength(), CellUtil.cloneQualifier((Cell)kv), 0, kv.getQualifierLength(), kv.getTimestamp(), KeyValue.Type.codeToType((byte)kv.getTypeByte()), CellUtil.cloneValue((Cell)kv), 0, kv.getValueLength(), tagList);
                        updatedCells.add(newKV);
                    }
                }
                m.getFamilyCellMap().remove(cf);
                m.getFamilyCellMap().put(cf, updatedCells);
            }
        }

        public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> e, Increment increment) throws IOException {
            this.updateMutationAddingTags((Mutation)increment);
            return null;
        }

        public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> e, Append append) throws IOException {
            this.updateMutationAddingTags((Mutation)append);
            return null;
        }

        public boolean postScannerNext(ObserverContext<RegionCoprocessorEnvironment> e, InternalScanner s, List<Result> results, int limit, boolean hasMore) throws IOException {
            Result result;
            CellScanner cellScanner;
            if (checkTagPresence && results.size() > 0 && (cellScanner = (result = results.get(0)).cellScanner()).advance()) {
                Cell cell = cellScanner.current();
                tags = PrivateCellUtil.getTags((Cell)cell);
            }
            return hasMore;
        }
    }
}

