/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.ChunkCreator;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.wal.FSHLog;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestWALDurability {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALDurability.class);
    private static final String COLUMN_FAMILY = "MyCF";
    private static final byte[] COLUMN_FAMILY_BYTES = Bytes.toBytes((String)"MyCF");
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Configuration conf;
    private String dir;
    @Rule
    public TestName name = new TestName();
    protected TableName tableName;

    @Before
    public void setup() throws IOException {
        this.conf = TEST_UTIL.getConfiguration();
        this.dir = TEST_UTIL.getDataTestDir("TestHRegion").toString();
        this.tableName = TableName.valueOf((String)this.name.getMethodName());
    }

    @Test
    public void testWALDurability() throws IOException {
        this.conf.set("hbase.wal.hsync", "false");
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Path rootDir = new Path(this.dir + this.getName());
        class CustomFSLog
        extends FSHLog {
            private Boolean syncFlag;

            public CustomFSLog(FileSystem fs, Path root, String logDir, Configuration conf) throws IOException {
                super(fs, root, logDir, conf);
            }

            public void sync(boolean forceSync) throws IOException {
                this.syncFlag = forceSync;
                super.sync(forceSync);
            }

            public void sync(long txid, boolean forceSync) throws IOException {
                this.syncFlag = forceSync;
                super.sync(txid, forceSync);
            }

            private void resetSyncFlag() {
                this.syncFlag = null;
            }
        }
        CustomFSLog customFSLog = new CustomFSLog(fs, rootDir, this.getName(), this.conf);
        customFSLog.init();
        HRegion region = TestWALDurability.initHRegion(this.tableName, null, null, (WAL)customFSLog);
        byte[] bytes = Bytes.toBytes((String)this.getName());
        Put put = new Put(bytes);
        put.addColumn(COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"1"), bytes);
        customFSLog.resetSyncFlag();
        Assert.assertNull((Object)customFSLog.syncFlag);
        region.put(put);
        Assert.assertEquals((Object)customFSLog.syncFlag, (Object)false);
        this.conf.set("hbase.wal.hsync", "true");
        fs = FileSystem.get((Configuration)this.conf);
        customFSLog = new CustomFSLog(fs, rootDir, this.getName(), this.conf);
        customFSLog.init();
        region = TestWALDurability.initHRegion(this.tableName, null, null, (WAL)customFSLog);
        customFSLog.resetSyncFlag();
        Assert.assertNull((Object)customFSLog.syncFlag);
        region.put(put);
        Assert.assertEquals((Object)customFSLog.syncFlag, (Object)true);
        put.setDurability(Durability.FSYNC_WAL);
        customFSLog.resetSyncFlag();
        Assert.assertNull((Object)customFSLog.syncFlag);
        region.put(put);
        Assert.assertEquals((Object)customFSLog.syncFlag, (Object)true);
        put = new Put(bytes);
        put.addColumn(COLUMN_FAMILY_BYTES, Bytes.toBytes((String)"1"), bytes);
        put.setDurability(Durability.SYNC_WAL);
        customFSLog.resetSyncFlag();
        Assert.assertNull((Object)customFSLog.syncFlag);
        region.put(put);
        Assert.assertEquals((Object)customFSLog.syncFlag, (Object)false);
        HBaseTestingUtility.closeRegionAndWAL(region);
    }

    private String getName() {
        return this.name.getMethodName();
    }

    public static HRegion initHRegion(TableName tableName, byte[] startKey, byte[] stopKey, WAL wal) throws IOException {
        ChunkCreator.initialize((int)0x200000, (boolean)false, (long)0L, (float)0.0f, (float)0.0f, null);
        return TEST_UTIL.createLocalHRegion(tableName, startKey, stopKey, false, Durability.USE_DEFAULT, wal, new byte[][]{COLUMN_FAMILY_BYTES});
    }
}

