/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.trace;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.trace.HBaseHTraceConfiguration;
import org.apache.hadoop.hbase.trace.TraceTree;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.htrace.core.HTraceConfiguration;
import org.apache.htrace.core.POJOSpanReceiver;
import org.apache.htrace.core.Sampler;
import org.apache.htrace.core.Span;
import org.apache.htrace.core.SpanReceiver;
import org.apache.htrace.core.TraceScope;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Ignore
@Category(value={MiscTests.class, MediumTests.class})
public class TestHTraceHooks {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHTraceHooks.class);
    private static final byte[] FAMILY_BYTES = "family".getBytes();
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static POJOSpanReceiver rcvr;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void before() throws Exception {
        TEST_UTIL.startMiniCluster(2, 3);
        rcvr = new POJOSpanReceiver((HTraceConfiguration)new HBaseHTraceConfiguration(TEST_UTIL.getConfiguration()));
        TraceUtil.addReceiver((SpanReceiver)rcvr);
        TraceUtil.addSampler((Sampler)new Sampler(){

            public boolean next() {
                return true;
            }
        });
    }

    @AfterClass
    public static void after() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        TraceUtil.removeReceiver((SpanReceiver)rcvr);
        rcvr = null;
    }

    @Test
    public void testTraceCreateTable() throws Exception {
        Span putSpan;
        Table table;
        Span createTableSpan;
        try (TraceScope scope = TraceUtil.createTrace((String)"creating table");){
            createTableSpan = scope.getSpan();
            table = TEST_UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), FAMILY_BYTES);
        }
        TEST_UTIL.waitFor(10000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                return rcvr == null ? true : rcvr.getSpans().size() >= 5;
            }
        });
        Collection spans = Sets.newHashSet((Iterable)rcvr.getSpans());
        LinkedList<Span> roots = new LinkedList<Span>();
        TraceTree traceTree = new TraceTree(spans);
        roots.addAll(traceTree.getSpansByParent().find(createTableSpan.getSpanId()));
        Assert.assertEquals((long)1L, (long)roots.size());
        Assert.assertEquals((Object)"creating table", (Object)createTableSpan.getDescription());
        if (spans != null) {
            Assert.assertTrue((spans.size() > 5 ? 1 : 0) != 0);
        }
        Put put = new Put("row".getBytes());
        put.addColumn(FAMILY_BYTES, "col".getBytes(), "value".getBytes());
        try (TraceScope scope = TraceUtil.createTrace((String)"doing put");){
            putSpan = scope.getSpan();
            table.put(put);
        }
        spans = rcvr.getSpans();
        traceTree = new TraceTree(spans);
        roots.clear();
        roots.addAll(traceTree.getSpansByParent().find(putSpan.getSpanId()));
        Assert.assertEquals((long)1L, (long)roots.size());
    }
}

