/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.wal.AbstractFSWAL;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={RegionServerTests.class, LargeTests.class})
public class TestWALOpenAfterDNRollingStart {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestWALOpenAfterDNRollingStart.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static long DN_RESTART_INTERVAL = 15000L;
    private static long CHECK_LOW_REPLICATION_INTERVAL = 10000L;
    @Parameterized.Parameter
    public String walProvider;

    @Parameterized.Parameters(name="{index}: wal={0}")
    public static List<Object[]> data() {
        return Arrays.asList({"asyncfs"}, {"filesystem"});
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.getConfiguration().setBoolean("dfs.client.block.write.replace-datanode-on-failure.enable", false);
        TEST_UTIL.getConfiguration().setLong("hbase.regionserver.hlog.check.lowreplication.interval", CHECK_LOW_REPLICATION_INTERVAL);
        TEST_UTIL.startMiniDFSCluster(3);
        TEST_UTIL.startMiniZKCluster();
    }

    @Before
    public void setUp() throws IOException, InterruptedException {
        TEST_UTIL.getConfiguration().set("hbase.wal.provider", this.walProvider);
        TEST_UTIL.startMiniHBaseCluster(1, 1);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniHBaseCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        HRegionServer server = TEST_UTIL.getHBaseCluster().getRegionServer(0);
        AbstractFSWAL wal = (AbstractFSWAL)server.getWAL(null);
        Path currentFile = wal.getCurrentFileName();
        int n = TEST_UTIL.getDFSCluster().getDataNodes().size();
        for (int i = 0; i < n; ++i) {
            TEST_UTIL.getDFSCluster().restartDataNode(0);
            Thread.sleep(DN_RESTART_INTERVAL);
        }
        if (!server.getFileSystem().exists(currentFile)) {
            Path walRootDir = FSUtils.getWALRootDir((Configuration)TEST_UTIL.getConfiguration());
            Path oldLogDir = new Path(walRootDir, "oldWALs");
            currentFile = new Path(oldLogDir, currentFile.getName());
        }
        try (WAL.Reader reader = WALFactory.createReader((FileSystem)TEST_UTIL.getTestFileSystem(), (Path)currentFile, (Configuration)TEST_UTIL.getConfiguration());){
            reader.next();
        }
    }
}

