/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.DoNotRetryRegionException;
import org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.exceptions.MergeRegionException;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.master.CatalogJanitor;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.AssignProcedure;
import org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hadoop.hbase.master.assignment.SplitTableRegionProcedure;
import org.apache.hadoop.hbase.master.assignment.UnassignProcedure;
import org.apache.hadoop.hbase.master.assignment.Util;
import org.apache.hadoop.hbase.master.normalizer.NormalizationPlan;
import org.apache.hadoop.hbase.master.procedure.AbstractStateMachineTableProcedure;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hadoop.hbase.master.procedure.TableQueue;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureMetrics;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.quotas.QuotaExceededException;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CollectionUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MergeTableRegionsProcedure
extends AbstractStateMachineTableProcedure<MasterProcedureProtos.MergeTableRegionsState> {
    private static final Logger LOG = LoggerFactory.getLogger(MergeTableRegionsProcedure.class);
    private ServerName regionLocation;
    private RegionInfo[] regionsToMerge;
    private RegionInfo mergedRegion;
    private boolean force;

    public MergeTableRegionsProcedure() {
    }

    public MergeTableRegionsProcedure(MasterProcedureEnv env, RegionInfo[] regionsToMerge, boolean force) throws IOException {
        super(env);
        MergeTableRegionsProcedure.checkRegionsToMerge(env, regionsToMerge, force);
        Arrays.sort(regionsToMerge);
        this.regionsToMerge = regionsToMerge;
        this.mergedRegion = MergeTableRegionsProcedure.createMergedRegionInfo(regionsToMerge);
        this.preflightChecks(env, true);
        this.force = force;
    }

    private static void checkRegionsToMerge(MasterProcedureEnv env, RegionInfo[] regions, boolean force) throws MergeRegionException {
        long count = Arrays.stream(regions).distinct().count();
        if ((long)regions.length != count) {
            throw new MergeRegionException("Duplicate regions specified; cannot merge a region to itself. Passed in " + regions.length + " but only " + count + " unique.");
        }
        if (count < 2L) {
            throw new MergeRegionException("Need two Regions at least to run a Merge");
        }
        RegionInfo previous = null;
        for (RegionInfo ri : regions) {
            if (previous != null) {
                if (!previous.getTable().equals((Object)ri.getTable())) {
                    String msg = "Can't merge regions from different tables: " + previous + ", " + ri;
                    LOG.warn(msg);
                    throw new MergeRegionException(msg);
                }
                if (!(force || ri.isAdjacent(previous) || ri.isOverlap(previous))) {
                    String msg = "Unable to merge non-adjacent or non-overlapping regions " + previous.getShortNameToLog() + ", " + ri.getShortNameToLog() + " when force=false";
                    LOG.warn(msg);
                    throw new MergeRegionException(msg);
                }
            }
            if (ri.getReplicaId() != 0) {
                throw new MergeRegionException("Can't merge non-default replicas; " + ri);
            }
            try {
                MergeTableRegionsProcedure.checkOnline(env, ri);
            }
            catch (DoNotRetryRegionException dnrre) {
                throw new MergeRegionException((Throwable)dnrre);
            }
            previous = ri;
        }
    }

    private static RegionInfo createMergedRegionInfo(RegionInfo[] regionsToMerge) {
        byte[] lowestStartKey = null;
        byte[] highestEndKey = null;
        long highestRegionId = -1L;
        for (RegionInfo ri : regionsToMerge) {
            if (lowestStartKey == null) {
                lowestStartKey = ri.getStartKey();
            } else if (Bytes.compareTo((byte[])ri.getStartKey(), (byte[])lowestStartKey) < 0) {
                lowestStartKey = ri.getStartKey();
            }
            if (highestEndKey == null) {
                highestEndKey = ri.getEndKey();
            } else if (ri.isLast() || Bytes.compareTo((byte[])ri.getEndKey(), (byte[])highestEndKey) > 0) {
                highestEndKey = ri.getEndKey();
            }
            highestRegionId = ri.getRegionId() > highestRegionId ? ri.getRegionId() : highestRegionId;
        }
        return RegionInfoBuilder.newBuilder((TableName)regionsToMerge[0].getTable()).setStartKey(lowestStartKey).setEndKey(highestEndKey).setSplit(false).setRegionId(highestRegionId + 1L).build();
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.MergeTableRegionsState state) {
        LOG.trace("{} execute state={}", (Object)this, (Object)state);
        try {
            switch (state) {
                case MERGE_TABLE_REGIONS_PREPARE: {
                    if (!this.prepareMergeRegion(env)) {
                        assert (this.isFailed()) : "Merge region should have an exception here";
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_PRE_MERGE_OPERATION);
                    break;
                }
                case MERGE_TABLE_REGIONS_PRE_MERGE_OPERATION: {
                    this.preMergeRegions(env);
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_CLOSE_REGIONS);
                    break;
                }
                case MERGE_TABLE_REGIONS_CLOSE_REGIONS: {
                    this.addChildProcedure(this.createUnassignProcedures(env, this.getRegionReplication(env)));
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_CHECK_CLOSED_REGIONS);
                    break;
                }
                case MERGE_TABLE_REGIONS_CHECK_CLOSED_REGIONS: {
                    List<RegionInfo> ris = this.hasRecoveredEdits(env);
                    if (ris.isEmpty()) {
                        this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_CREATE_MERGED_REGION);
                        break;
                    }
                    for (RegionInfo ri : ris) {
                        LOG.info("Found recovered.edits under {}, reopen to pickup missed edits!", (Object)ri);
                        this.addChildProcedure(new AssignProcedure[]{env.getAssignmentManager().createAssignProcedure(ri)});
                    }
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_CLOSE_REGIONS);
                    break;
                }
                case MERGE_TABLE_REGIONS_CREATE_MERGED_REGION: {
                    this.createMergedRegion(env);
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_WRITE_MAX_SEQUENCE_ID_FILE);
                    break;
                }
                case MERGE_TABLE_REGIONS_WRITE_MAX_SEQUENCE_ID_FILE: {
                    this.writeMaxSequenceIdFile(env);
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_PRE_MERGE_COMMIT_OPERATION);
                    break;
                }
                case MERGE_TABLE_REGIONS_PRE_MERGE_COMMIT_OPERATION: {
                    this.preMergeRegionsCommit(env);
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_UPDATE_META);
                    break;
                }
                case MERGE_TABLE_REGIONS_UPDATE_META: {
                    this.updateMetaForMergedRegions(env);
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_POST_MERGE_COMMIT_OPERATION);
                    break;
                }
                case MERGE_TABLE_REGIONS_POST_MERGE_COMMIT_OPERATION: {
                    this.postMergeRegionsCommit(env);
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_OPEN_MERGED_REGION);
                    break;
                }
                case MERGE_TABLE_REGIONS_OPEN_MERGED_REGION: {
                    this.addChildProcedure(this.createAssignProcedures(env, this.getRegionReplication(env)));
                    this.setNextState(MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_POST_OPERATION);
                    break;
                }
                case MERGE_TABLE_REGIONS_POST_OPERATION: {
                    this.postCompletedMergeRegions(env);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            String msg = "Error trying to merge " + RegionInfo.getShortNameToLog((RegionInfo[])this.regionsToMerge) + " in " + this.getTableName() + " (in state=" + state + ")";
            if (!this.isRollbackSupported(state)) {
                LOG.warn(msg, (Throwable)e);
            }
            LOG.error(msg, (Throwable)e);
            this.setFailure("master-merge-regions", e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.MergeTableRegionsState state) throws IOException {
        LOG.trace("{} rollback state={}", (Object)this, (Object)state);
        try {
            switch (state) {
                case MERGE_TABLE_REGIONS_UPDATE_META: 
                case MERGE_TABLE_REGIONS_POST_MERGE_COMMIT_OPERATION: 
                case MERGE_TABLE_REGIONS_OPEN_MERGED_REGION: 
                case MERGE_TABLE_REGIONS_POST_OPERATION: {
                    String msg = this + " We are in the " + state + " state. It is complicated to rollback the merge operation that region server is working on. Rollback is not supported and we should let the merge operation to complete";
                    LOG.warn(msg);
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
                case MERGE_TABLE_REGIONS_PRE_MERGE_COMMIT_OPERATION: {
                    break;
                }
                case MERGE_TABLE_REGIONS_CREATE_MERGED_REGION: 
                case MERGE_TABLE_REGIONS_WRITE_MAX_SEQUENCE_ID_FILE: {
                    this.cleanupMergedRegion(env);
                    break;
                }
                case MERGE_TABLE_REGIONS_CHECK_CLOSED_REGIONS: {
                    break;
                }
                case MERGE_TABLE_REGIONS_CLOSE_REGIONS: {
                    this.rollbackCloseRegionsForMerge(env);
                    break;
                }
                case MERGE_TABLE_REGIONS_PRE_MERGE_OPERATION: {
                    this.postRollBackMergeRegions(env);
                    break;
                }
                case MERGE_TABLE_REGIONS_PREPARE: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Failed rollback attempt step " + state + " for merging the regions " + RegionInfo.getShortNameToLog((RegionInfo[])this.regionsToMerge) + " in table " + this.getTableName(), (Throwable)e);
            throw e;
        }
    }

    protected boolean isRollbackSupported(MasterProcedureProtos.MergeTableRegionsState state) {
        switch (state) {
            case MERGE_TABLE_REGIONS_UPDATE_META: 
            case MERGE_TABLE_REGIONS_POST_MERGE_COMMIT_OPERATION: 
            case MERGE_TABLE_REGIONS_OPEN_MERGED_REGION: 
            case MERGE_TABLE_REGIONS_POST_OPERATION: {
                return false;
            }
        }
        return true;
    }

    protected MasterProcedureProtos.MergeTableRegionsState getState(int stateId) {
        return MasterProcedureProtos.MergeTableRegionsState.forNumber((int)stateId);
    }

    protected int getStateId(MasterProcedureProtos.MergeTableRegionsState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.MergeTableRegionsState getInitialState() {
        return MasterProcedureProtos.MergeTableRegionsState.MERGE_TABLE_REGIONS_PREPARE;
    }

    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.MergeTableRegionsStateData.Builder mergeTableRegionsMsg = MasterProcedureProtos.MergeTableRegionsStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.getUser())).setMergedRegionInfo(ProtobufUtil.toRegionInfo((RegionInfo)this.mergedRegion)).setForcible(this.force);
        for (RegionInfo ri : this.regionsToMerge) {
            mergeTableRegionsMsg.addRegionInfo(ProtobufUtil.toRegionInfo((RegionInfo)ri));
        }
        serializer.serialize((Message)mergeTableRegionsMsg.build());
    }

    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.MergeTableRegionsStateData mergeTableRegionsMsg = (MasterProcedureProtos.MergeTableRegionsStateData)serializer.deserialize(MasterProcedureProtos.MergeTableRegionsStateData.class);
        this.setUser(MasterProcedureUtil.toUserInfo(mergeTableRegionsMsg.getUserInfo()));
        assert (mergeTableRegionsMsg.getRegionInfoCount() == 2);
        this.regionsToMerge = new RegionInfo[mergeTableRegionsMsg.getRegionInfoCount()];
        for (int i = 0; i < this.regionsToMerge.length; ++i) {
            this.regionsToMerge[i] = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)mergeTableRegionsMsg.getRegionInfo(i));
        }
        this.mergedRegion = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)mergeTableRegionsMsg.getMergedRegionInfo());
    }

    @Override
    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" table=");
        sb.append(this.getTableName());
        sb.append(", regions=");
        sb.append(RegionInfo.getShortNameToLog((RegionInfo[])this.regionsToMerge));
        sb.append(", force=");
        sb.append(this.force);
    }

    @Override
    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (env.getProcedureScheduler().waitRegions((Procedure<?>)this, this.getTableName(), this.mergedRegion, this.regionsToMerge[0], this.regionsToMerge[1])) {
            try {
                LOG.debug(Procedure.LockState.LOCK_EVENT_WAIT + " " + env.getProcedureScheduler().dumpLocks());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    @Override
    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureScheduler().wakeRegions((Procedure<?>)this, this.getTableName(), this.mergedRegion, this.regionsToMerge[0], this.regionsToMerge[1]);
    }

    protected boolean holdLock(MasterProcedureEnv env) {
        return true;
    }

    @Override
    public TableName getTableName() {
        return this.mergedRegion.getTable();
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.REGION_MERGE;
    }

    protected ProcedureMetrics getProcedureMetrics(MasterProcedureEnv env) {
        return env.getAssignmentManager().getAssignmentManagerMetrics().getMergeProcMetrics();
    }

    private List<RegionInfo> hasRecoveredEdits(MasterProcedureEnv env) throws IOException {
        ArrayList<RegionInfo> ris = new ArrayList<RegionInfo>(this.regionsToMerge.length);
        for (int i = 0; i < this.regionsToMerge.length; ++i) {
            RegionInfo ri = this.regionsToMerge[i];
            if (!SplitTableRegionProcedure.hasRecoveredEdits(env, ri)) continue;
            ris.add(ri);
        }
        return ris;
    }

    private boolean prepareMergeRegion(MasterProcedureEnv env) throws IOException {
        TableName tn = this.regionsToMerge[0].getTable();
        if (env.getMasterServices().getSnapshotManager().isTakingSnapshot(tn)) {
            throw new MergeRegionException("Skip merging regions " + RegionInfo.getShortNameToLog((RegionInfo[])this.regionsToMerge) + ", because we are snapshotting " + tn);
        }
        if (!env.getMasterServices().isSplitOrMergeEnabled(MasterSwitchType.MERGE)) {
            String regionsStr = Arrays.deepToString(this.regionsToMerge);
            LOG.warn("Merge switch is off! skip merge of " + regionsStr);
            super.setFailure(this.getClass().getSimpleName(), (Throwable)new IOException("Merge of " + regionsStr + " failed because merge switch is off"));
            return false;
        }
        List tableProcedures = env.getMasterServices().getProcedures().stream().filter(p -> p instanceof AbstractStateMachineTableProcedure).map(p -> (AbstractStateMachineTableProcedure)p).filter(p -> p.getProcId() != this.getProcId() && p.getTableName().equals((Object)this.regionsToMerge[0].getTable()) && !p.isFinished() && TableQueue.requireTableExclusiveLock(p)).collect(Collectors.toList());
        if (tableProcedures != null && tableProcedures.size() > 0) {
            throw new MergeRegionException(((AbstractStateMachineTableProcedure)tableProcedures.get(0)).toString() + " is going on against the same table, abort the merge of " + this.toString());
        }
        CatalogJanitor catalogJanitor = env.getMasterServices().getCatalogJanitor();
        RegionStates regionStates = env.getAssignmentManager().getRegionStates();
        for (RegionInfo ri : this.regionsToMerge) {
            if (!catalogJanitor.cleanMergeQualifier(ri)) {
                String msg = "Skip merging " + RegionInfo.getShortNameToLog((RegionInfo[])this.regionsToMerge) + ", because parent " + RegionInfo.getShortNameToLog((RegionInfo[])new RegionInfo[]{ri}) + " has a merge qualifier";
                LOG.warn(msg);
                throw new MergeRegionException(msg);
            }
            RegionState state = regionStates.getRegionState(ri.getEncodedName());
            if (state == null) {
                throw new UnknownRegionException("No state for " + RegionInfo.getShortNameToLog((RegionInfo[])new RegionInfo[]{ri}));
            }
            if (!state.isOpened()) {
                throw new MergeRegionException("Unable to merge regions that are not online: " + ri);
            }
            try {
                if (this.isMergeable(env, state)) continue;
                return false;
            }
            catch (IOException e) {
                IOException ioe = new IOException(RegionInfo.getShortNameToLog((RegionInfo[])new RegionInfo[]{ri}) + " NOT mergeable", e);
                super.setFailure(this.getClass().getSimpleName(), (Throwable)ioe);
                return false;
            }
        }
        this.setRegionStateToMerging(env);
        return true;
    }

    private boolean isMergeable(MasterProcedureEnv env, RegionState rs) throws IOException {
        AdminProtos.GetRegionInfoResponse response = Util.getRegionInfoResponse(env, rs.getServerName(), rs.getRegion());
        return response.hasMergeable() && response.getMergeable();
    }

    private void preMergeRegions(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preMergeRegionsAction(this.regionsToMerge, this.getUser());
        }
        try {
            env.getMasterServices().getMasterQuotaManager().onRegionMerged(this.mergedRegion);
        }
        catch (QuotaExceededException e) {
            env.getMasterServices().getRegionNormalizer().planSkipped(this.mergedRegion, NormalizationPlan.PlanType.MERGE);
            throw e;
        }
    }

    private void postRollBackMergeRegions(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.postRollBackMergeRegionsAction(this.regionsToMerge, this.getUser());
        }
    }

    public void setRegionStateToMerging(MasterProcedureEnv env) {
        RegionStates regionStates = env.getAssignmentManager().getRegionStates();
        for (RegionInfo ri : this.regionsToMerge) {
            regionStates.getRegionStateNode(ri).setState(RegionState.State.MERGING, new RegionState.State[0]);
        }
    }

    private void createMergedRegion(MasterProcedureEnv env) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        Path tabledir = FSUtils.getTableDir((Path)mfs.getRootDir(), (TableName)this.regionsToMerge[0].getTable());
        FileSystem fs = mfs.getFileSystem();
        HRegionFileSystem mergeRegionFs = null;
        for (RegionInfo ri : this.regionsToMerge) {
            HRegionFileSystem regionFs = HRegionFileSystem.openRegionFromFileSystem(env.getMasterConfiguration(), fs, tabledir, ri, false);
            if (mergeRegionFs == null) {
                mergeRegionFs = regionFs;
                mergeRegionFs.createMergesDir();
            }
            this.mergeStoreFiles(env, regionFs, mergeRegionFs.getMergesDir());
        }
        assert (mergeRegionFs != null);
        mergeRegionFs.commitMergedRegion(this.mergedRegion);
        env.getAssignmentManager().getRegionStates().getOrCreateRegionStateNode(this.mergedRegion).setState(RegionState.State.MERGING_NEW, new RegionState.State[0]);
    }

    private void mergeStoreFiles(MasterProcedureEnv env, HRegionFileSystem regionFs, Path mergeDir) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        Configuration conf = env.getMasterConfiguration();
        TableDescriptor htd = env.getMasterServices().getTableDescriptors().get(this.getTableName());
        for (ColumnFamilyDescriptor hcd : htd.getColumnFamilies()) {
            String family = hcd.getNameAsString();
            Collection<StoreFileInfo> storeFiles = regionFs.getStoreFiles(family);
            if (storeFiles == null || storeFiles.size() <= 0) continue;
            for (StoreFileInfo storeFileInfo : storeFiles) {
                regionFs.mergeStoreFile(this.mergedRegion, family, new HStoreFile(mfs.getFileSystem(), storeFileInfo, conf, CacheConfig.DISABLED, hcd.getBloomFilterType(), true), mergeDir);
            }
        }
    }

    private void cleanupMergedRegion(MasterProcedureEnv env) throws IOException {
        MasterFileSystem mfs = env.getMasterServices().getMasterFileSystem();
        TableName tn = this.regionsToMerge[0].getTable();
        Path tabledir = FSUtils.getTableDir((Path)mfs.getRootDir(), (TableName)tn);
        FileSystem fs = mfs.getFileSystem();
        HRegionFileSystem regionFs = HRegionFileSystem.openRegionFromFileSystem(env.getMasterConfiguration(), fs, tabledir, this.regionsToMerge[0], false);
        regionFs.cleanupMergedRegion(this.mergedRegion);
    }

    private void rollbackCloseRegionsForMerge(MasterProcedureEnv env) throws IOException {
        int regionReplication = this.getRegionReplication(env);
        ServerName serverName = this.getServerName(env);
        Procedure[] procs = this.createAssignProcedures(regionReplication, env, Arrays.asList(this.regionsToMerge), serverName);
        env.getMasterServices().getMasterProcedureExecutor().submitProcedures(procs);
    }

    private AssignProcedure[] createAssignProcedures(int regionReplication, MasterProcedureEnv env, List<RegionInfo> hris, ServerName serverName) {
        AssignProcedure[] procs = new AssignProcedure[hris.size() * regionReplication];
        int procsIdx = 0;
        for (int i = 0; i < hris.size(); ++i) {
            RegionInfo hri = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)hris.get(i), (int)0);
            procs[procsIdx++] = env.getAssignmentManager().createAssignProcedure(hri, serverName);
        }
        if (regionReplication > 1) {
            AssignProcedure[] replicaAssignProcs;
            ArrayList<RegionInfo> regionReplicas = new ArrayList<RegionInfo>(hris.size() * (regionReplication - 1));
            for (int i = 0; i < hris.size(); ++i) {
                for (int j = 1; j < regionReplication; ++j) {
                    regionReplicas.add(RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)hris.get(i), (int)j));
                }
            }
            for (AssignProcedure proc : replicaAssignProcs = env.getAssignmentManager().createRoundRobinAssignProcedures(regionReplicas, Collections.singletonList(serverName))) {
                procs[procsIdx++] = proc;
            }
        }
        return procs;
    }

    private UnassignProcedure[] createUnassignProcedures(MasterProcedureEnv env, int regionReplication) {
        UnassignProcedure[] procs = new UnassignProcedure[this.regionsToMerge.length * regionReplication];
        int procsIdx = 0;
        for (int i = 0; i < this.regionsToMerge.length; ++i) {
            for (int j = 0; j < regionReplication; ++j) {
                RegionInfo hri = RegionReplicaUtil.getRegionInfoForReplica((RegionInfo)this.regionsToMerge[i], (int)j);
                procs[procsIdx++] = env.getAssignmentManager().createUnassignProcedure(hri, null, true, !RegionReplicaUtil.isDefaultReplica((RegionInfo)hri));
            }
        }
        return procs;
    }

    private AssignProcedure[] createAssignProcedures(MasterProcedureEnv env, int regionReplication) {
        ServerName targetServer = this.getServerName(env);
        return this.createAssignProcedures(regionReplication, env, Collections.singletonList(this.mergedRegion), targetServer);
    }

    private int getRegionReplication(MasterProcedureEnv env) throws IOException {
        return env.getMasterServices().getTableDescriptors().get(this.getTableName()).getRegionReplication();
    }

    private void preMergeRegionsCommit(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            ArrayList<Mutation> metaEntries = new ArrayList<Mutation>();
            cpHost.preMergeRegionsCommit(this.regionsToMerge, metaEntries, this.getUser());
            try {
                for (Mutation p : metaEntries) {
                    RegionInfo.parseRegionName((byte[])p.getRow());
                }
            }
            catch (IOException e) {
                LOG.error("Row key of mutation from coprocessor is not parsable as region name. Mutations from coprocessor should only be for hbase:meta table.", (Throwable)e);
                throw e;
            }
        }
    }

    private void updateMetaForMergedRegions(MasterProcedureEnv env) throws IOException {
        env.getAssignmentManager().markRegionAsMerged(this.mergedRegion, this.getServerName(env), this.regionsToMerge);
    }

    private void postMergeRegionsCommit(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.postMergeRegionsCommit(this.regionsToMerge, this.mergedRegion, this.getUser());
        }
    }

    private void postCompletedMergeRegions(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.postCompletedMergeRegionsAction(this.regionsToMerge, this.mergedRegion, this.getUser());
        }
    }

    private ServerName getServerName(MasterProcedureEnv env) {
        if (this.regionLocation == null) {
            this.regionLocation = env.getAssignmentManager().getRegionStates().getRegionServerOfRegion(this.regionsToMerge[0]);
        }
        return this.regionLocation;
    }

    private void writeMaxSequenceIdFile(MasterProcedureEnv env) throws IOException {
        MasterFileSystem fs = env.getMasterFileSystem();
        long maxSequenceId = -1L;
        for (RegionInfo region : this.regionsToMerge) {
            maxSequenceId = Math.max(maxSequenceId, WALSplitter.getMaxRegionSequenceId(env.getMasterConfiguration(), region, (CollectionUtils.IOExceptionSupplier<FileSystem>)((CollectionUtils.IOExceptionSupplier)fs::getFileSystem), (CollectionUtils.IOExceptionSupplier<FileSystem>)((CollectionUtils.IOExceptionSupplier)fs::getWALFileSystem)));
        }
        if (maxSequenceId > 0L) {
            WALSplitter.writeRegionSequenceIdFile(fs.getWALFileSystem(), this.getWALRegionDir(env, this.mergedRegion), maxSequenceId);
        }
    }

    @VisibleForTesting
    RegionInfo getMergedRegion() {
        return this.mergedRegion;
    }

    protected boolean abort(MasterProcedureEnv env) {
        return this.isRollbackSupported((MasterProcedureProtos.MergeTableRegionsState)this.getCurrentState()) && super.abort((Object)env);
    }
}

