/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.http;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.security.token.TokenProvider;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.KerberosCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, SmallTests.class})
public class TestInfoServersACL {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestInfoServersACL.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestInfoServersACL.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static Configuration conf;
    protected static String USERNAME;
    private static LocalHBaseCluster CLUSTER;
    private static final File KEYTAB_FILE;
    private static MiniKdc KDC;
    private static String HOST;
    private static String PRINCIPAL;
    private static String HTTP_PRINCIPAL;
    @Rule
    public TestName name = new TestName();
    private static final String USER_ADMIN_STR = "admin";
    private static final String USER_NONE_STR = "none";

    @BeforeClass
    public static void beforeClass() throws Exception {
        conf = UTIL.getConfiguration();
        KDC = UTIL.setupMiniKdc(KEYTAB_FILE);
        USERNAME = UserGroupInformation.getLoginUser().getShortUserName();
        PRINCIPAL = USERNAME + "/" + HOST;
        HTTP_PRINCIPAL = "HTTP/" + HOST;
        KDC.createPrincipal(KEYTAB_FILE, new String[]{PRINCIPAL, HTTP_PRINCIPAL, USER_ADMIN_STR, USER_NONE_STR});
        UTIL.startMiniZKCluster();
        HBaseKerberosUtils.setSecuredConfiguration(conf, PRINCIPAL + "@" + KDC.getRealm(), HTTP_PRINCIPAL + "@" + KDC.getRealm());
        HBaseKerberosUtils.setSSLConfiguration(UTIL, TestInfoServersACL.class);
        conf.setStrings("hbase.coprocessor.region.classes", new String[]{TokenProvider.class.getName()});
        UTIL.startMiniDFSCluster(1);
        Path rootdir = UTIL.getDataTestDirOnTestFS("TestInfoServersACL");
        FSUtils.setRootDir((Configuration)conf, (Path)rootdir);
        conf.setInt("hbase.master.info.port", 0);
        conf.setInt("hbase.regionserver.info.port", 0);
        conf.set("hbase.security.authentication.ui", "kerberos");
        conf.set("hbase.security.authentication.spnego.kerberos.principal", HTTP_PRINCIPAL);
        conf.set("hbase.security.authentication.spnego.kerberos.keytab", KEYTAB_FILE.getAbsolutePath());
        conf.setBoolean("hadoop.security.authorization", true);
        conf.set("hbase.security.authentication.spnego.admin.users", USER_ADMIN_STR);
        CLUSTER = new LocalHBaseCluster(conf, 1);
        CLUSTER.startup();
    }

    @AfterClass
    public static void shutDownMiniCluster() throws Exception {
        if (CLUSTER != null) {
            CLUSTER.shutdown();
            CLUSTER.join();
        }
        if (KDC != null) {
            KDC.stop();
        }
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testAuthorizedUser() throws Exception {
        UserGroupInformation admin = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)USER_ADMIN_STR, (String)KEYTAB_FILE.getAbsolutePath());
        admin.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                String expectedContent = "Get Log Level";
                Pair pair = TestInfoServersACL.this.getLogLevelPage();
                Assert.assertEquals((long)200L, (long)((Integer)pair.getFirst()).intValue());
                Assert.assertTrue((String)("expected=" + expectedContent + ", content=" + (String)pair.getSecond()), (boolean)((String)pair.getSecond()).contains(expectedContent));
                return null;
            }
        });
    }

    @Test
    public void testUnauthorizedUser() throws Exception {
        UserGroupInformation nonAdmin = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)USER_NONE_STR, (String)KEYTAB_FILE.getAbsolutePath());
        nonAdmin.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Pair pair = TestInfoServersACL.this.getLogLevelPage();
                Assert.assertEquals((long)403L, (long)((Integer)pair.getFirst()).intValue());
                return null;
            }
        });
    }

    @Test
    public void testTableActionsAvailableForAdmins() throws Exception {
        String expectedAuthorizedContent = "Actions:";
        UserGroupInformation admin = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)USER_ADMIN_STR, (String)KEYTAB_FILE.getAbsolutePath());
        admin.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Pair pair = TestInfoServersACL.this.getTablePage(TableName.META_TABLE_NAME);
                Assert.assertEquals((long)200L, (long)((Integer)pair.getFirst()).intValue());
                Assert.assertTrue((String)("expected=Actions:, content=" + (String)pair.getSecond()), (boolean)((String)pair.getSecond()).contains("Actions:"));
                return null;
            }
        });
        UserGroupInformation nonAdmin = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)USER_NONE_STR, (String)KEYTAB_FILE.getAbsolutePath());
        nonAdmin.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Pair pair = TestInfoServersACL.this.getTablePage(TableName.META_TABLE_NAME);
                Assert.assertEquals((long)200L, (long)((Integer)pair.getFirst()).intValue());
                Assert.assertFalse((String)("should not find=Actions:, content=" + (String)pair.getSecond()), (boolean)((String)pair.getSecond()).contains("Actions:"));
                return null;
            }
        });
    }

    @Test
    public void testLogsAvailableForAdmins() throws Exception {
        String expectedAuthorizedContent = "Directory: /logs/";
        UserGroupInformation admin = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)USER_ADMIN_STR, (String)KEYTAB_FILE.getAbsolutePath());
        admin.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Pair pair = TestInfoServersACL.this.getLogsPage();
                Assert.assertEquals((long)200L, (long)((Integer)pair.getFirst()).intValue());
                Assert.assertTrue((String)("expected=Directory: /logs/, content=" + (String)pair.getSecond()), (boolean)((String)pair.getSecond()).contains("Directory: /logs/"));
                return null;
            }
        });
        UserGroupInformation nonAdmin = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)USER_NONE_STR, (String)KEYTAB_FILE.getAbsolutePath());
        nonAdmin.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Pair pair = TestInfoServersACL.this.getLogsPage();
                Assert.assertEquals((long)403L, (long)((Integer)pair.getFirst()).intValue());
                return null;
            }
        });
    }

    @Test
    public void testDumpActionsAvailableForAdmins() throws Exception {
        String expectedAuthorizedContent = "Master status for";
        UserGroupInformation admin = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)USER_ADMIN_STR, (String)KEYTAB_FILE.getAbsolutePath());
        admin.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Pair pair = TestInfoServersACL.this.getMasterDumpPage();
                Assert.assertEquals((long)200L, (long)((Integer)pair.getFirst()).intValue());
                Assert.assertTrue((String)("expected=Master status for, content=" + (String)pair.getSecond()), (boolean)((String)pair.getSecond()).contains("Master status for"));
                return null;
            }
        });
        UserGroupInformation nonAdmin = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)USER_NONE_STR, (String)KEYTAB_FILE.getAbsolutePath());
        nonAdmin.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Pair pair = TestInfoServersACL.this.getMasterDumpPage();
                Assert.assertEquals((long)403L, (long)((Integer)pair.getFirst()).intValue());
                return null;
            }
        });
    }

    @Test
    public void testStackActionsAvailableForAdmins() throws Exception {
        String expectedAuthorizedContent = "Process Thread Dump";
        UserGroupInformation admin = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)USER_ADMIN_STR, (String)KEYTAB_FILE.getAbsolutePath());
        admin.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Pair pair = TestInfoServersACL.this.getStacksPage();
                Assert.assertEquals((long)200L, (long)((Integer)pair.getFirst()).intValue());
                Assert.assertTrue((String)("expected=Process Thread Dump, content=" + (String)pair.getSecond()), (boolean)((String)pair.getSecond()).contains("Process Thread Dump"));
                return null;
            }
        });
        UserGroupInformation nonAdmin = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)USER_NONE_STR, (String)KEYTAB_FILE.getAbsolutePath());
        nonAdmin.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Pair pair = TestInfoServersACL.this.getStacksPage();
                Assert.assertEquals((long)403L, (long)((Integer)pair.getFirst()).intValue());
                return null;
            }
        });
    }

    @Test
    public void testJmxAvailableForAdmins() throws Exception {
        String expectedAuthorizedContent = "Hadoop:service=HBase";
        UTIL.waitFor(30000L, (Waiter.Predicate)new Waiter.Predicate<Exception>(){

            public boolean evaluate() throws Exception {
                for (ObjectName name : ManagementFactory.getPlatformMBeanServer().queryNames(new ObjectName("*:*"), null)) {
                    if (!name.toString().contains("Hadoop:service=HBase")) continue;
                    LOG.info("{}", (Object)name);
                    return true;
                }
                return false;
            }
        });
        UserGroupInformation admin = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)USER_ADMIN_STR, (String)KEYTAB_FILE.getAbsolutePath());
        admin.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Pair pair = TestInfoServersACL.this.getJmxPage();
                Assert.assertEquals((long)200L, (long)((Integer)pair.getFirst()).intValue());
                Assert.assertTrue((String)("expected=Hadoop:service=HBase, content=" + (String)pair.getSecond()), (boolean)((String)pair.getSecond()).contains("Hadoop:service=HBase"));
                return null;
            }
        });
        UserGroupInformation nonAdmin = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)USER_NONE_STR, (String)KEYTAB_FILE.getAbsolutePath());
        nonAdmin.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Pair pair = TestInfoServersACL.this.getJmxPage();
                Assert.assertEquals((long)403L, (long)((Integer)pair.getFirst()).intValue());
                return null;
            }
        });
    }

    @Test
    public void testMetricsAvailableForAdmins() throws Exception {
        String expectedAuthorizedContent = "";
        UserGroupInformation admin = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)USER_ADMIN_STR, (String)KEYTAB_FILE.getAbsolutePath());
        admin.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Pair pair = TestInfoServersACL.this.getMetricsPage();
                if (404 == (Integer)pair.getFirst()) {
                    return null;
                }
                Assert.assertEquals((long)200L, (long)((Integer)pair.getFirst()).intValue());
                Assert.assertTrue((String)("expected=, content=" + (String)pair.getSecond()), (boolean)((String)pair.getSecond()).contains(""));
                return null;
            }
        });
        UserGroupInformation nonAdmin = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)USER_NONE_STR, (String)KEYTAB_FILE.getAbsolutePath());
        nonAdmin.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                Pair pair = TestInfoServersACL.this.getMetricsPage();
                if (404 == (Integer)pair.getFirst()) {
                    return null;
                }
                Assert.assertEquals((long)403L, (long)((Integer)pair.getFirst()).intValue());
                return null;
            }
        });
    }

    private String getInfoServerHostAndPort() {
        return "http://localhost:" + CLUSTER.getActiveMaster().getInfoServer().getPort();
    }

    private Pair<Integer, String> getLogLevelPage() throws Exception {
        URL url = new URL(this.getInfoServerHostAndPort() + "/logLevel");
        return this.getUrlContent(url);
    }

    private Pair<Integer, String> getTablePage(TableName tn) throws Exception {
        URL url = new URL(this.getInfoServerHostAndPort() + "/table.jsp?name=" + tn.getNameAsString());
        return this.getUrlContent(url);
    }

    private Pair<Integer, String> getLogsPage() throws Exception {
        URL url = new URL(this.getInfoServerHostAndPort() + "/logs/");
        return this.getUrlContent(url);
    }

    private Pair<Integer, String> getMasterDumpPage() throws Exception {
        URL url = new URL(this.getInfoServerHostAndPort() + "/dump");
        return this.getUrlContent(url);
    }

    private Pair<Integer, String> getStacksPage() throws Exception {
        URL url = new URL(this.getInfoServerHostAndPort() + "/stacks");
        return this.getUrlContent(url);
    }

    private Pair<Integer, String> getJmxPage() throws Exception {
        URL url = new URL(this.getInfoServerHostAndPort() + "/jmx");
        return this.getUrlContent(url);
    }

    private Pair<Integer, String> getMetricsPage() throws Exception {
        URL url = new URL(this.getInfoServerHostAndPort() + "/metrics");
        return this.getUrlContent(url);
    }

    private Pair<Integer, String> getUrlContent(URL url) throws Exception {
        try (CloseableHttpClient client = this.createHttpClient(UserGroupInformation.getCurrentUser().getUserName());){
            CloseableHttpResponse resp = client.execute((HttpUriRequest)new HttpGet(url.toURI()));
            int code = resp.getStatusLine().getStatusCode();
            if (code == 200) {
                Pair pair = new Pair((Object)code, (Object)EntityUtils.toString((HttpEntity)resp.getEntity()));
                return pair;
            }
            Pair pair = new Pair((Object)code, null);
            return pair;
        }
    }

    private CloseableHttpClient createHttpClient(String clientPrincipal) throws Exception {
        GSSManager gssManager = GSSManager.getInstance();
        Oid oid = new Oid("1.2.840.113554.1.2.2");
        GSSName gssClient = gssManager.createName(clientPrincipal, GSSName.NT_USER_NAME);
        GSSCredential credential = gssManager.createCredential(gssClient, 0, oid, 1);
        Registry authRegistry = RegistryBuilder.create().register("Negotiate", (Object)new SPNegoSchemeFactory(true, true)).build();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new KerberosCredentials(credential));
        return HttpClients.custom().setDefaultAuthSchemeRegistry((Lookup)authRegistry).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
    }

    static {
        KEYTAB_FILE = new File(UTIL.getDataTestDir("keytab").toUri().getPath());
        HOST = "localhost";
    }
}

