/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.LossyCounting;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MiscTests.class, SmallTests.class})
public class TestLossyCounting {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLossyCounting.class);
    private final Configuration conf = HBaseConfiguration.create();

    @Test
    public void testBucketSize() {
        LossyCounting lossyCounting = new LossyCounting("testBucketSize", 0.01);
        Assert.assertEquals((long)100L, (long)lossyCounting.getBucketSize());
        LossyCounting lossyCounting2 = new LossyCounting("testBucketSize2", this.conf);
        Assert.assertEquals((long)50L, (long)lossyCounting2.getBucketSize());
    }

    @Test
    public void testAddByOne() {
        String key;
        int i;
        LossyCounting lossyCounting = new LossyCounting("testAddByOne", 0.01);
        for (i = 0; i < 100; ++i) {
            key = "" + i;
            lossyCounting.add(key);
        }
        Assert.assertEquals((long)100L, (long)lossyCounting.getDataSize());
        for (i = 0; i < 100; ++i) {
            key = "" + i;
            Assert.assertTrue((boolean)lossyCounting.contains(key));
        }
    }

    @Test
    public void testSweep1() throws Exception {
        LossyCounting lossyCounting = new LossyCounting("testSweep1", 0.01);
        for (int i = 0; i < 400; ++i) {
            String key = "" + i;
            lossyCounting.add(key);
        }
        Assert.assertEquals((long)4L, (long)lossyCounting.getCurrentTerm());
        Assert.assertEquals((long)(lossyCounting.getBucketSize() - 1L), (long)lossyCounting.getDataSize());
    }

    @Test
    public void testSweep2() throws Exception {
        String key;
        int i;
        LossyCounting lossyCounting = new LossyCounting("testSweep2", 0.1);
        for (i = 0; i < 10; ++i) {
            key = "" + i;
            lossyCounting.add(key);
        }
        Assert.assertEquals((long)10L, (long)lossyCounting.getDataSize());
        for (i = 0; i < 10; ++i) {
            key = "1";
            lossyCounting.add(key);
        }
        Assert.assertEquals((long)1L, (long)lossyCounting.getDataSize());
    }
}

