/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.exec.ListSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.StringUtils;

public class FetchTask
extends Task<FetchWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int maxRows = 100;
    private FetchOperator fetch;
    private ListSinkOperator sink;
    private int totalRows;
    private static final transient Log LOG = LogFactory.getLog(FetchTask.class);

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan, DriverContext ctx) {
        super.initialize(conf, queryPlan, ctx);
        ((FetchWork)this.work).initializeForFetch();
        try {
            JobConf job = new JobConf((Configuration)conf);
            Operator<?> source = ((FetchWork)this.work).getSource();
            if (source instanceof TableScanOperator) {
                TableScanOperator ts = (TableScanOperator)source;
                HiveInputFormat.pushFilters(job, ts);
                ColumnProjectionUtils.appendReadColumnIDs((Configuration)job, ts.getNeededColumnIDs());
            }
            this.sink = ((FetchWork)this.work).getSink();
            this.fetch = new FetchOperator((FetchWork)this.work, job, source, this.getVirtualColumns(source));
            source.initialize(conf, new ObjectInspector[]{this.fetch.getOutputObjectInspector()});
        }
        catch (Exception e) {
            LOG.error((Object)StringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    private List<VirtualColumn> getVirtualColumns(Operator<?> ts) {
        if (ts instanceof TableScanOperator && ts.getConf() != null) {
            return ((TableScanDesc)((TableScanOperator)ts).getConf()).getVirtualCols();
        }
        return null;
    }

    @Override
    public int execute(DriverContext driverContext) {
        assert (false);
        return 0;
    }

    public TableDesc getTblDesc() {
        return ((FetchWork)this.work).getTblDesc();
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public boolean fetch(ArrayList<String> res) throws IOException, CommandNeedRetryException {
        this.sink.reset(res);
        try {
            int rowsRet = ((FetchWork)this.work).getLeastNumRows();
            if (rowsRet <= 0) {
                int n = rowsRet = ((FetchWork)this.work).getLimit() >= 0 ? Math.min(((FetchWork)this.work).getLimit() - this.totalRows, this.maxRows) : this.maxRows;
            }
            if (rowsRet <= 0) {
                this.fetch.clearFetchContext();
                boolean bl = false;
                return bl;
            }
            boolean fetched = false;
            while (this.sink.getNumRows() < rowsRet) {
                if (!this.fetch.pushRow()) {
                    if (((FetchWork)this.work).getLeastNumRows() > 0) {
                        throw new CommandNeedRetryException();
                    }
                    boolean bl = fetched;
                    return bl;
                }
                fetched = true;
            }
            boolean bl = true;
            return bl;
        }
        catch (CommandNeedRetryException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.totalRows += this.sink.getNumRows();
        }
    }

    @Override
    public StageType getType() {
        return StageType.FETCH;
    }

    @Override
    public String getName() {
        return "FETCH";
    }

    public void clearFetch() throws HiveException {
        if (this.fetch != null) {
            this.fetch.clearFetchContext();
        }
    }
}

