/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluator;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.TerminalOperator;
import org.apache.hadoop.hive.ql.exec.TopNHash;
import org.apache.hadoop.hive.ql.io.HiveKey;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StandardUnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;

public class ReduceSinkOperator
extends TerminalOperator<ReduceSinkDesc>
implements Serializable,
TopNHash.BinaryCollector {
    private static final long serialVersionUID = 1L;
    protected transient ExprNodeEvaluator[] keyEval;
    protected transient ExprNodeEvaluator[] valueEval;
    protected transient ExprNodeEvaluator[] partitionEval;
    transient Serializer keySerializer;
    transient boolean keyIsText;
    transient Serializer valueSerializer;
    transient int tag;
    transient byte[] tagByte = new byte[1];
    protected transient int numDistributionKeys;
    protected transient int numDistinctExprs;
    transient String inputAlias;
    private transient TopNHash reducerHash;
    transient InspectableObject tempInspectableObject = new InspectableObject();
    transient HiveKey keyWritable = new HiveKey();
    transient StructObjectInspector keyObjectInspector;
    transient StructObjectInspector valueObjectInspector;
    transient ObjectInspector[] partitionObjectInspectors;
    transient Object[][] cachedKeys;
    transient Object[] cachedValues;
    transient List<List<Integer>> distinctColIndices;
    boolean firstRow;
    transient Random random;

    public void setInputAlias(String inputAlias) {
        this.inputAlias = inputAlias;
    }

    public String getInputAlias() {
        return this.inputAlias;
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        try {
            this.keyEval = new ExprNodeEvaluator[((ReduceSinkDesc)this.conf).getKeyCols().size()];
            int i = 0;
            for (ExprNodeDesc e : ((ReduceSinkDesc)this.conf).getKeyCols()) {
                this.keyEval[i++] = ExprNodeEvaluatorFactory.get(e);
            }
            this.numDistributionKeys = ((ReduceSinkDesc)this.conf).getNumDistributionKeys();
            this.distinctColIndices = ((ReduceSinkDesc)this.conf).getDistinctColumnIndices();
            this.numDistinctExprs = this.distinctColIndices.size();
            this.valueEval = new ExprNodeEvaluator[((ReduceSinkDesc)this.conf).getValueCols().size()];
            i = 0;
            for (ExprNodeDesc e : ((ReduceSinkDesc)this.conf).getValueCols()) {
                this.valueEval[i++] = ExprNodeEvaluatorFactory.get(e);
            }
            this.partitionEval = new ExprNodeEvaluator[((ReduceSinkDesc)this.conf).getPartitionCols().size()];
            i = 0;
            for (ExprNodeDesc e : ((ReduceSinkDesc)this.conf).getPartitionCols()) {
                this.partitionEval[i++] = ExprNodeEvaluatorFactory.get(e);
            }
            this.tag = ((ReduceSinkDesc)this.conf).getTag();
            this.tagByte[0] = (byte)this.tag;
            this.LOG.info((Object)("Using tag = " + this.tag));
            TableDesc keyTableDesc = ((ReduceSinkDesc)this.conf).getKeySerializeInfo();
            this.keySerializer = (Serializer)((Object)keyTableDesc.getDeserializerClass().newInstance());
            this.keySerializer.initialize(null, keyTableDesc.getProperties());
            this.keyIsText = this.keySerializer.getSerializedClass().equals(Text.class);
            TableDesc valueTableDesc = ((ReduceSinkDesc)this.conf).getValueSerializeInfo();
            this.valueSerializer = (Serializer)((Object)valueTableDesc.getDeserializerClass().newInstance());
            this.valueSerializer.initialize(null, valueTableDesc.getProperties());
            this.reducerHash = this.createTopKHash();
            this.firstRow = true;
            this.initializeChildren(hconf);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private TopNHash createTopKHash() {
        int limit = ((ReduceSinkDesc)this.conf).getTopN();
        float percent = ((ReduceSinkDesc)this.conf).getTopNMemoryUsage();
        if (limit < 0 || percent <= 0.0f) {
            return null;
        }
        if (limit == 0) {
            return TopNHash.create0();
        }
        long threshold = (long)(percent * (float)Runtime.getRuntime().maxMemory()) - (long)(limit * 64);
        if (threshold < 0L) {
            return null;
        }
        return TopNHash.create(((ReduceSinkDesc)this.conf).isMapGroupBy(), limit, threshold, this);
    }

    protected static StructObjectInspector initEvaluatorsAndReturnStruct(ExprNodeEvaluator[] evals, List<List<Integer>> distinctColIndices, List<String> outputColNames, int length, ObjectInspector rowInspector) throws HiveException {
        int inspectorLen = evals.length > length ? length + 1 : evals.length;
        ArrayList<ObjectInspector> sois = new ArrayList<ObjectInspector>(inspectorLen);
        ObjectInspector[] fieldObjectInspectors = ReduceSinkOperator.initEvaluators(evals, 0, length, rowInspector);
        sois.addAll(Arrays.asList(fieldObjectInspectors));
        if (outputColNames.size() > length) {
            ArrayList<ObjectInspector> uois = new ArrayList<ObjectInspector>();
            for (List<Integer> distinctCols : distinctColIndices) {
                ArrayList<String> names = new ArrayList<String>();
                ArrayList<ObjectInspector> eois = new ArrayList<ObjectInspector>();
                int numExprs = 0;
                for (int i : distinctCols) {
                    names.add(HiveConf.getColumnInternalName(numExprs));
                    eois.add(evals[i].initialize(rowInspector));
                    ++numExprs;
                }
                uois.add(ObjectInspectorFactory.getStandardStructObjectInspector(names, eois));
            }
            StandardUnionObjectInspector uoi = ObjectInspectorFactory.getStandardUnionObjectInspector(uois);
            sois.add(uoi);
        }
        return ObjectInspectorFactory.getStandardStructObjectInspector(outputColNames, sois);
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        try {
            int i;
            int i2;
            ObjectInspector rowInspector = this.inputObjInspectors[tag];
            if (this.firstRow) {
                this.firstRow = false;
                this.keyObjectInspector = ReduceSinkOperator.initEvaluatorsAndReturnStruct(this.keyEval, this.distinctColIndices, ((ReduceSinkDesc)this.conf).getOutputKeyColumnNames(), this.numDistributionKeys, rowInspector);
                this.valueObjectInspector = ReduceSinkOperator.initEvaluatorsAndReturnStruct(this.valueEval, ((ReduceSinkDesc)this.conf).getOutputValueColumnNames(), rowInspector);
                this.partitionObjectInspectors = ReduceSinkOperator.initEvaluators(this.partitionEval, rowInspector);
                int numKeys = this.numDistinctExprs > 0 ? this.numDistinctExprs : 1;
                int keyLen = this.numDistinctExprs > 0 ? this.numDistributionKeys + 1 : this.numDistributionKeys;
                this.cachedKeys = new Object[numKeys][keyLen];
                this.cachedValues = new Object[this.valueEval.length];
            }
            int keyHashCode = 0;
            if (this.partitionEval.length == 0) {
                if (this.random == null) {
                    this.random = new Random(12345L);
                }
                keyHashCode = this.random.nextInt();
            } else {
                for (i2 = 0; i2 < this.partitionEval.length; ++i2) {
                    Object o = this.partitionEval[i2].evaluate(row);
                    keyHashCode = keyHashCode * 31 + ObjectInspectorUtils.hashCode(o, this.partitionObjectInspectors[i2]);
                }
            }
            for (i2 = 0; i2 < this.valueEval.length; ++i2) {
                this.cachedValues[i2] = this.valueEval[i2].evaluate(row);
            }
            Object[] distributionKeys = new Object[this.numDistributionKeys];
            for (i = 0; i < this.numDistributionKeys; ++i) {
                distributionKeys[i] = this.keyEval[i].evaluate(row);
            }
            if (this.numDistinctExprs > 0) {
                for (i = 0; i < this.numDistinctExprs; ++i) {
                    System.arraycopy(distributionKeys, 0, this.cachedKeys[i], 0, this.numDistributionKeys);
                    Object[] distinctParameters = new Object[this.distinctColIndices.get(i).size()];
                    for (int j = 0; j < distinctParameters.length; ++j) {
                        distinctParameters[j] = this.keyEval[this.distinctColIndices.get(i).get(j)].evaluate(row);
                    }
                    this.cachedKeys[i][this.numDistributionKeys] = new StandardUnionObjectInspector.StandardUnion((byte)i, distinctParameters);
                }
            } else {
                System.arraycopy(distributionKeys, 0, this.cachedKeys[0], 0, this.numDistributionKeys);
            }
            BytesWritable value = null;
            for (int i3 = 0; i3 < this.cachedKeys.length; ++i3) {
                int keyLength;
                Text key;
                if (this.keyIsText) {
                    key = (Text)this.keySerializer.serialize(this.cachedKeys[i3], this.keyObjectInspector);
                    if (tag == -1) {
                        this.keyWritable.set(key.getBytes(), 0, key.getLength());
                    } else {
                        keyLength = key.getLength();
                        this.keyWritable.setSize(keyLength + 1);
                        System.arraycopy(key.getBytes(), 0, this.keyWritable.get(), 0, keyLength);
                        this.keyWritable.get()[keyLength] = this.tagByte[0];
                    }
                } else {
                    key = (BytesWritable)this.keySerializer.serialize(this.cachedKeys[i3], this.keyObjectInspector);
                    if (tag == -1) {
                        this.keyWritable.set(key.getBytes(), 0, key.getLength());
                    } else {
                        keyLength = key.getLength();
                        this.keyWritable.setSize(keyLength + 1);
                        System.arraycopy(key.getBytes(), 0, this.keyWritable.get(), 0, keyLength);
                        this.keyWritable.get()[keyLength] = this.tagByte[0];
                    }
                }
                this.keyWritable.setHashCode(keyHashCode);
                if (this.reducerHash == null) {
                    if (null == this.out) continue;
                    value = this.getValue(row, value);
                    this.collect(this.keyWritable, value);
                    continue;
                }
                int index = this.reducerHash.indexOf(this.keyWritable);
                if (index == -2) continue;
                value = this.getValue(row, value);
                if (index >= 0) {
                    this.reducerHash.set(index, value);
                    continue;
                }
                if (index == -1) {
                    this.collect(this.keyWritable, value);
                    continue;
                }
                if (index == -3) {
                    this.LOG.info((Object)"Top-N hash is flushed");
                    this.reducerHash.flush();
                    this.collect(this.keyWritable, value);
                    continue;
                }
                if (index != -4) continue;
                this.LOG.info((Object)"Top-N hash is disabled");
                this.reducerHash.flush();
                this.collect(this.keyWritable, value);
                this.reducerHash = null;
            }
        }
        catch (HiveException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HiveException(e);
        }
    }

    public void collect(BytesWritable key, BytesWritable value) throws IOException {
        this.out.collect((Object)key, (Object)value);
        if (++this.outputRows % 1000L == 0L) {
            if (this.counterNameToEnum != null) {
                this.incrCounter(numOutputRowsCntr, this.outputRows);
            }
            this.increaseForward(this.outputRows);
            this.outputRows = 0L;
        }
    }

    private BytesWritable getValue(Object row, BytesWritable value) throws Exception {
        if (value != null) {
            return value;
        }
        for (int i = 0; i < this.valueEval.length; ++i) {
            this.cachedValues[i] = this.valueEval[i].evaluate(row);
        }
        return (BytesWritable)this.valueSerializer.serialize(this.cachedValues, this.valueObjectInspector);
    }

    @Override
    protected void closeOp(boolean abort) throws HiveException {
        if (!abort && this.reducerHash != null) {
            try {
                this.reducerHash.flush();
            }
            catch (IOException e) {
                throw new HiveException(e);
            }
            finally {
                this.reducerHash = null;
            }
        }
        this.reducerHash = null;
        super.closeOp(abort);
    }

    @Override
    public String getName() {
        return ReduceSinkOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "RS";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.REDUCESINK;
    }

    @Override
    public boolean opAllowedBeforeMapJoin() {
        return false;
    }
}

